/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.pool;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.AnnotationElement;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.Field;
import com.android.tools.smali.dexlib2.iface.reference.CallSiteReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodHandleReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodProtoReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.iface.value.AnnotationEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ArrayEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.BooleanEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ByteEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.CharEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.DoubleEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EnumEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.FieldEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.FloatEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.IntEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.LongEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodHandleEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.MethodTypeEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ShortEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.StringEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.TypeEncodedValue;
import com.android.tools.smali.dexlib2.writer.DexWriter;
import com.android.tools.smali.dexlib2.writer.io.DexDataStore;
import com.android.tools.smali.dexlib2.writer.io.FileDataStore;
import com.android.tools.smali.dexlib2.writer.pool.AnnotationPool;
import com.android.tools.smali.dexlib2.writer.pool.AnnotationSetPool;
import com.android.tools.smali.dexlib2.writer.pool.BasePool;
import com.android.tools.smali.dexlib2.writer.pool.CallSitePool;
import com.android.tools.smali.dexlib2.writer.pool.ClassPool;
import com.android.tools.smali.dexlib2.writer.pool.EncodedArrayPool;
import com.android.tools.smali.dexlib2.writer.pool.FieldPool;
import com.android.tools.smali.dexlib2.writer.pool.MethodHandlePool;
import com.android.tools.smali.dexlib2.writer.pool.MethodPool;
import com.android.tools.smali.dexlib2.writer.pool.PoolClassDef;
import com.android.tools.smali.dexlib2.writer.pool.PoolMethod;
import com.android.tools.smali.dexlib2.writer.pool.ProtoPool;
import com.android.tools.smali.dexlib2.writer.pool.StringPool;
import com.android.tools.smali.dexlib2.writer.pool.TypeListPool;
import com.android.tools.smali.dexlib2.writer.pool.TypePool;
import com.android.tools.smali.util.ExceptionWithContext;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public class DexPool
extends DexWriter<CharSequence, StringReference, CharSequence, TypeReference, MethodProtoReference, FieldReference, MethodReference, PoolClassDef, CallSiteReference, MethodHandleReference, Annotation, Set<? extends Annotation>, TypeListPool.Key<? extends Collection<? extends CharSequence>>, Field, PoolMethod, ArrayEncodedValue, EncodedValue, AnnotationElement, StringPool, TypePool, ProtoPool, FieldPool, MethodPool, ClassPool, CallSitePool, MethodHandlePool, TypeListPool, AnnotationPool, AnnotationSetPool, EncodedArrayPool> {
    private final BasePool<?, ?>[] sections;

    public DexPool(Opcodes opcodes) {
        super(opcodes);
        this.sections = new BasePool[]{(BasePool)((Object)this.stringSection), (BasePool)((Object)this.typeSection), (BasePool)((Object)this.protoSection), (BasePool)((Object)this.fieldSection), (BasePool)((Object)this.methodSection), (BasePool)((Object)this.classSection), (BasePool)((Object)this.callSiteSection), (BasePool)((Object)this.methodHandleSection), (BasePool)((Object)this.typeListSection), (BasePool)((Object)this.annotationSection), (BasePool)((Object)this.annotationSetSection), (BasePool)((Object)this.encodedArraySection)};
    }

    @Override
    @Nonnull
    protected DexWriter.SectionProvider getSectionProvider() {
        return new DexPoolSectionProvider();
    }

    public static void writeTo(@Nonnull DexDataStore dataStore, @Nonnull DexFile input) throws IOException {
        DexPool dexPool = new DexPool(input.getOpcodes());
        for (ClassDef classDef : input.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(dataStore);
    }

    public static void writeTo(@Nonnull String path, @Nonnull DexFile input) throws IOException {
        DexPool dexPool = new DexPool(input.getOpcodes());
        for (ClassDef classDef : input.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(new FileDataStore(new File(path)));
    }

    public void internClass(ClassDef classDef) {
        ((ClassPool)this.classSection).intern(classDef);
    }

    public void mark() {
        for (BasePool<?, ?> section : this.sections) {
            section.mark();
        }
    }

    public void reset() {
        for (BasePool<?, ?> section : this.sections) {
            section.reset();
        }
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.getType(), annotationEncodedValue.getElements());
                break;
            }
            case 28: {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.getValue());
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)encodedValue).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)encodedValue).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)encodedValue).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)encodedValue).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)encodedValue).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)encodedValue).getValue());
                break;
            }
            case 23: {
                writer.writeString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                writer.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                writer.writeMethodType(((MethodTypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                writer.writeMethodHandle(((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    void internEncodedValue(@Nonnull EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                ((TypePool)this.typeSection).intern(annotationEncodedValue.getType());
                for (AnnotationElement annotationElement : annotationEncodedValue.getElements()) {
                    ((StringPool)this.stringSection).intern(annotationElement.getName());
                    this.internEncodedValue(annotationElement.getValue());
                }
                break;
            }
            case 28: {
                for (EncodedValue encodedValue2 : ((ArrayEncodedValue)encodedValue).getValue()) {
                    this.internEncodedValue(encodedValue2);
                }
                break;
            }
            case 23: {
                ((StringPool)this.stringSection).intern(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                ((TypePool)this.typeSection).intern(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                ((FieldPool)this.fieldSection).intern(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                ((FieldPool)this.fieldSection).intern(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                ((MethodPool)this.methodSection).intern(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                ((MethodHandlePool)this.methodHandleSection).intern(((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                ((ProtoPool)this.protoSection).intern(((MethodTypeEncodedValue)encodedValue).getValue());
            }
        }
    }

    protected class DexPoolSectionProvider
    extends DexWriter.SectionProvider {
        protected DexPoolSectionProvider() {
            super(DexPool.this);
        }

        @Nonnull
        public StringPool getStringSection() {
            return new StringPool(DexPool.this);
        }

        @Nonnull
        public TypePool getTypeSection() {
            return new TypePool(DexPool.this);
        }

        @Nonnull
        public ProtoPool getProtoSection() {
            return new ProtoPool(DexPool.this);
        }

        @Nonnull
        public FieldPool getFieldSection() {
            return new FieldPool(DexPool.this);
        }

        @Nonnull
        public MethodPool getMethodSection() {
            return new MethodPool(DexPool.this);
        }

        @Nonnull
        public ClassPool getClassSection() {
            return new ClassPool(DexPool.this);
        }

        @Nonnull
        public CallSitePool getCallSiteSection() {
            return new CallSitePool(DexPool.this);
        }

        @Nonnull
        public MethodHandlePool getMethodHandleSection() {
            return new MethodHandlePool(DexPool.this);
        }

        @Nonnull
        public TypeListPool getTypeListSection() {
            return new TypeListPool(DexPool.this);
        }

        @Nonnull
        public AnnotationPool getAnnotationSection() {
            return new AnnotationPool(DexPool.this);
        }

        @Nonnull
        public AnnotationSetPool getAnnotationSetSection() {
            return new AnnotationSetPool(DexPool.this);
        }

        @Nonnull
        public EncodedArrayPool getEncodedArraySection() {
            return new EncodedArrayPool(DexPool.this);
        }
    }
}

