/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer.builder;

import com.android.tools.smali.dexlib2.writer.TypeListSection;
import com.android.tools.smali.dexlib2.writer.builder.BaseBuilderPool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderMapEntryCollection;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeList;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypePool;
import com.android.tools.smali.dexlib2.writer.builder.BuilderTypeReference;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BuilderTypeListPool
extends BaseBuilderPool
implements TypeListSection<BuilderTypeReference, BuilderTypeList> {
    @Nonnull
    private final ConcurrentMap<List<? extends CharSequence>, BuilderTypeList> internedItems = Maps.newConcurrentMap();

    public BuilderTypeListPool(@Nonnull DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    @Nonnull
    public BuilderTypeList internTypeList(@Nullable List<? extends CharSequence> types) {
        if (types == null || types.size() == 0) {
            return BuilderTypeList.EMPTY;
        }
        BuilderTypeList ret = (BuilderTypeList)this.internedItems.get(types);
        if (ret != null) {
            return ret;
        }
        BuilderTypeList typeList = new BuilderTypeList((List<? extends BuilderTypeReference>)ImmutableList.copyOf((Iterable)Iterables.transform(types, (Function)new Function<CharSequence, BuilderTypeReference>(){

            @Nonnull
            public BuilderTypeReference apply(CharSequence input) {
                return ((BuilderTypePool)BuilderTypeListPool.this.dexBuilder.typeSection).internType(input.toString());
            }
        })));
        ret = this.internedItems.putIfAbsent(typeList, typeList);
        return ret == null ? typeList : ret;
    }

    @Override
    public int getNullableItemOffset(@Nullable BuilderTypeList key) {
        return key == null || key.size() == 0 ? 0 : key.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderTypeReference> getTypes(@Nullable BuilderTypeList key) {
        return key == null ? BuilderTypeList.EMPTY : key.types;
    }

    @Override
    public int getItemOffset(@Nonnull BuilderTypeList key) {
        return key.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderTypeList, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderTypeList>(this, this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderTypeList key) {
                return key.offset;
            }

            @Override
            protected int setValue(@Nonnull BuilderTypeList key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

