/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.rewriter;

import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction20bc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction21c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction22c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35c;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction3rc;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction45cc;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.rewriter.Rewriter;
import com.android.tools.smali.dexlib2.rewriter.RewriterUtils;
import com.android.tools.smali.dexlib2.rewriter.Rewriters;
import javax.annotation.Nonnull;

public class InstructionRewriter
implements Rewriter<Instruction> {
    @Nonnull
    protected final Rewriters rewriters;

    public InstructionRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public Instruction rewrite(@Nonnull Instruction instruction) {
        if (instruction instanceof ReferenceInstruction) {
            switch (instruction.getOpcode().format) {
                case Format20bc: {
                    return new RewrittenInstruction20bc(this, (Instruction20bc)instruction);
                }
                case Format21c: {
                    return new RewrittenInstruction21c(this, (Instruction21c)instruction);
                }
                case Format22c: {
                    return new RewrittenInstruction22c(this, (Instruction22c)instruction);
                }
                case Format31c: {
                    return new RewrittenInstruction31c(this, (Instruction31c)instruction);
                }
                case Format35c: {
                    return new RewrittenInstruction35c(this, (Instruction35c)instruction);
                }
                case Format3rc: {
                    return new RewrittenInstruction3rc(this, (Instruction3rc)instruction);
                }
                case Format45cc: {
                    return new RewrittenInstruction45cc((Instruction45cc)instruction);
                }
            }
            throw new IllegalArgumentException();
        }
        return instruction;
    }

    protected class RewrittenInstruction45cc
    extends BaseRewrittenReferenceInstruction<Instruction45cc>
    implements Instruction45cc {
        public RewrittenInstruction45cc(Instruction45cc instruction) {
            super(InstructionRewriter.this, (ReferenceInstruction)instruction);
        }

        @Override
        @Nonnull
        public Reference getReference2() {
            switch (((Instruction45cc)this.instruction).getReferenceType2()) {
                case 1: {
                    return RewriterUtils.rewriteTypeReference(InstructionRewriter.this.rewriters.getTypeRewriter(), (TypeReference)((Instruction45cc)this.instruction).getReference2());
                }
                case 2: {
                    return InstructionRewriter.this.rewriters.getFieldReferenceRewriter().rewrite((FieldReference)((Instruction45cc)this.instruction).getReference2());
                }
                case 3: {
                    return InstructionRewriter.this.rewriters.getMethodReferenceRewriter().rewrite((MethodReference)((Instruction45cc)this.instruction).getReference2());
                }
                case 0: {
                    return ((Instruction45cc)this.instruction).getReference2();
                }
                case 4: {
                    return ((Instruction45cc)this.instruction).getReference2();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getReferenceType2() {
            return ((Instruction45cc)this.instruction).getReferenceType2();
        }

        @Override
        public int getRegisterC() {
            return ((Instruction45cc)this.instruction).getRegisterC();
        }

        @Override
        public int getRegisterE() {
            return ((Instruction45cc)this.instruction).getRegisterE();
        }

        @Override
        public int getRegisterG() {
            return ((Instruction45cc)this.instruction).getRegisterG();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction45cc)this.instruction).getRegisterCount();
        }

        @Override
        public int getRegisterD() {
            return ((Instruction45cc)this.instruction).getRegisterD();
        }

        @Override
        public int getRegisterF() {
            return ((Instruction45cc)this.instruction).getRegisterF();
        }
    }

    protected class RewrittenInstruction3rc
    extends BaseRewrittenReferenceInstruction<Instruction3rc>
    implements Instruction3rc {
        public RewrittenInstruction3rc(@Nonnull InstructionRewriter this$0, Instruction3rc instruction) {
            super(this$0, (ReferenceInstruction)instruction);
        }

        @Override
        public int getStartRegister() {
            return ((Instruction3rc)this.instruction).getStartRegister();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction3rc)this.instruction).getRegisterCount();
        }
    }

    protected class RewrittenInstruction35c
    extends BaseRewrittenReferenceInstruction<Instruction35c>
    implements Instruction35c {
        public RewrittenInstruction35c(@Nonnull InstructionRewriter this$0, Instruction35c instruction) {
            super(this$0, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterC() {
            return ((Instruction35c)this.instruction).getRegisterC();
        }

        @Override
        public int getRegisterE() {
            return ((Instruction35c)this.instruction).getRegisterE();
        }

        @Override
        public int getRegisterG() {
            return ((Instruction35c)this.instruction).getRegisterG();
        }

        @Override
        public int getRegisterCount() {
            return ((Instruction35c)this.instruction).getRegisterCount();
        }

        @Override
        public int getRegisterD() {
            return ((Instruction35c)this.instruction).getRegisterD();
        }

        @Override
        public int getRegisterF() {
            return ((Instruction35c)this.instruction).getRegisterF();
        }
    }

    protected class RewrittenInstruction31c
    extends BaseRewrittenReferenceInstruction<Instruction31c>
    implements Instruction31c {
        public RewrittenInstruction31c(@Nonnull InstructionRewriter this$0, Instruction31c instruction) {
            super(this$0, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction31c)this.instruction).getRegisterA();
        }
    }

    protected class RewrittenInstruction22c
    extends BaseRewrittenReferenceInstruction<Instruction22c>
    implements Instruction22c {
        public RewrittenInstruction22c(@Nonnull InstructionRewriter this$0, Instruction22c instruction) {
            super(this$0, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction22c)this.instruction).getRegisterA();
        }

        @Override
        public int getRegisterB() {
            return ((Instruction22c)this.instruction).getRegisterB();
        }
    }

    protected class RewrittenInstruction21c
    extends BaseRewrittenReferenceInstruction<Instruction21c>
    implements Instruction21c {
        public RewrittenInstruction21c(@Nonnull InstructionRewriter this$0, Instruction21c instruction) {
            super(this$0, (ReferenceInstruction)instruction);
        }

        @Override
        public int getRegisterA() {
            return ((Instruction21c)this.instruction).getRegisterA();
        }
    }

    protected class RewrittenInstruction20bc
    extends BaseRewrittenReferenceInstruction<Instruction20bc>
    implements Instruction20bc {
        public RewrittenInstruction20bc(@Nonnull InstructionRewriter this$0, Instruction20bc instruction) {
            super(this$0, (ReferenceInstruction)instruction);
        }

        @Override
        public int getVerificationError() {
            return ((Instruction20bc)this.instruction).getVerificationError();
        }
    }

    protected static class BaseRewrittenReferenceInstruction<T extends ReferenceInstruction>
    implements ReferenceInstruction {
        @Nonnull
        protected T instruction;
        final /* synthetic */ InstructionRewriter this$0;

        protected BaseRewrittenReferenceInstruction(T instruction) {
            this.this$0 = this$0;
            this.instruction = instruction;
        }

        @Override
        @Nonnull
        public Reference getReference() {
            switch (this.instruction.getReferenceType()) {
                case 1: {
                    return RewriterUtils.rewriteTypeReference(this.this$0.rewriters.getTypeRewriter(), (TypeReference)this.instruction.getReference());
                }
                case 2: {
                    return this.this$0.rewriters.getFieldReferenceRewriter().rewrite((FieldReference)this.instruction.getReference());
                }
                case 3: {
                    return this.this$0.rewriters.getMethodReferenceRewriter().rewrite((MethodReference)this.instruction.getReference());
                }
                case 0: {
                    return this.instruction.getReference();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getReferenceType() {
            return this.instruction.getReferenceType();
        }

        @Override
        public Opcode getOpcode() {
            return this.instruction.getOpcode();
        }

        @Override
        public int getCodeUnits() {
            return this.instruction.getCodeUnits();
        }
    }
}

