/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine;

import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="1.0")
public interface ConfigurationParameters {
    public static final String CONFIG_FILE_NAME = "junit-platform.properties";

    public Optional<String> get(String var1);

    public Optional<Boolean> getBoolean(String var1);

    @API(status=API.Status.STABLE, since="1.3")
    default public <T> Optional<T> get(String key, Function<String, T> transformer) {
        Preconditions.notNull(transformer, "transformer must not be null");
        return this.get(key).map(input -> {
            try {
                return transformer.apply((String)input);
            }
            catch (Exception ex) {
                String message = String.format("Failed to transform configuration parameter with key '%s' and initial value '%s'", key, input);
                throw new JUnitException(message, ex);
            }
        });
    }

    public int size();
}

