/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint.analyzers;

import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintAnalyzer;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintErrorType;
import com.android.tools.idea.uibuilder.visual.visuallint.analyzers.LongTextAnalyzerInspection;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/uibuilder/visual/visuallint/analyzers/LongTextAnalyzer;", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer;", "()V", "backgroundEnabled", "", "getBackgroundEnabled", "()Z", "type", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintErrorType;", "createIssueContent", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "findIssues", "", "renderResult", "Lcom/android/tools/idea/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "hasLongText", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nLongTextAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongTextAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/LongTextAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1851#2,2:86\n*S KotlinDebug\n*F\n+ 1 LongTextAnalyzer.kt\ncom/android/tools/idea/uibuilder/visual/visuallint/analyzers/LongTextAnalyzer\n*L\n47#1:86,2\n*E\n"})
public final class LongTextAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final LongTextAnalyzer INSTANCE = new LongTextAnalyzer();

    private LongTextAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.LONG_TEXT;
    }

    @Override
    public boolean getBackgroundEnabled() {
        return LongTextAnalyzerInspection.INSTANCE.getLongTextBackground();
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull NlModel model2) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"renderResult.rootViews");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view2 = (ViewInfo)viewsToAnalyze.removeLast();
            List list = view2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"view.children");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
            if (!this.hasLongText(view2)) continue;
            issues.add(this.createIssueContent(view2));
        }
        return issues;
    }

    private final boolean hasLongText(ViewInfo view2) {
        block1: {
            Object object = view2.getViewObject();
            TextView textView = object instanceof TextView ? (TextView)object : null;
            if (textView == null || (textView = textView.getLayout()) == null) break block1;
            TextView it = textView;
            boolean bl = false;
            int n = it.getLineCount();
            for (int i = 0; i < n; ++i) {
                int numChars = it.getLineVisibleEnd(i) - it.getEllipsisCount(i) - it.getLineStart(i) + 1;
                if (numChars <= 120) continue;
                return true;
            }
        }
        return false;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view2) {
        String summary = this.nameWithId(view2) + " has lines containing more than 120 characters";
        String url = "https://d.android.com/r/studio-ui/designer/material/responsive-layout-grid-breakpoints";
        Function1 provider2 = (Function1)new Function1<Integer, HtmlBuilder>(view2, url){
            final /* synthetic */ ViewInfo $view;
            final /* synthetic */ String $url;
            {
                this.$view = $view;
                this.$url = $url;
                super(1);
            }

            public final HtmlBuilder invoke(int count) {
                return new HtmlBuilder().add(LongTextAnalyzer.access$simpleName(LongTextAnalyzer.INSTANCE, this.$view) + " has lines containing more than 120 characters in " + LongTextAnalyzer.access$previewConfigurations(LongTextAnalyzer.INSTANCE, count) + ".").newline().add("Material Design recommends reducing the width of TextView or switching to a ").addLink("multi-column layout", this.$url).add(" for breakpoints >= 600dp.");
            }
        };
        return new VisualLintAnalyzer.VisualLintIssueContent(view2, summary, (Function1<? super Integer, ? extends HtmlBuilder>)provider2);
    }

    public static final /* synthetic */ String access$simpleName(LongTextAnalyzer $this, ViewInfo view2) {
        return $this.simpleName(view2);
    }

    public static final /* synthetic */ String access$previewConfigurations(LongTextAnalyzer $this, int count) {
        return $this.previewConfigurations(count);
    }
}

