/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.lint.CommonLintUserDataHandler;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintBaseConfigIssues;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u001c\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/uibuilder/visual/VisualizationFormVisualLintHandler;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "issueModel", "Lcom/android/tools/idea/common/error/IssueModel;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/common/error/IssueModel;)V", "lintIssueProvider", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintIssueProvider;", "getLintIssueProvider", "()Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintIssueProvider;", "myBaseConfigIssues", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintBaseConfigIssues;", "clearIssueProvider", "", "clearIssueProviderAndBaseConfigurationIssue", "onActivate", "onDeactivate", "setupForLayoutlibSceneManager", "manager", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "isCancelled", "Lkotlin/Function0;", "", "intellij.android.designer"})
public final class VisualizationFormVisualLintHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final IssueModel issueModel;
    @NotNull
    private final VisualLintBaseConfigIssues myBaseConfigIssues;
    @NotNull
    private final VisualLintIssueProvider lintIssueProvider;

    public VisualizationFormVisualLintHandler(@NotNull Disposable parentDisposable, @NotNull Project project, @NotNull IssueModel issueModel) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueModel, (String)"issueModel");
        this.project = project;
        this.issueModel = issueModel;
        this.myBaseConfigIssues = new VisualLintBaseConfigIssues();
        this.lintIssueProvider = new VisualLintIssueProvider(parentDisposable);
        this.issueModel.addIssueProvider(this.lintIssueProvider);
    }

    @NotNull
    public final VisualLintIssueProvider getLintIssueProvider() {
        return this.lintIssueProvider;
    }

    public final void clearIssueProvider() {
        this.lintIssueProvider.clear();
        this.issueModel.updateErrorsList();
    }

    public final void clearIssueProviderAndBaseConfigurationIssue() {
        this.lintIssueProvider.clear();
        this.issueModel.updateErrorsList();
        this.myBaseConfigIssues.clear();
    }

    public final void setupForLayoutlibSceneManager(@NotNull LayoutlibSceneManager manager, @NotNull Function0<Boolean> isCancelled) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(isCancelled, (String)"isCancelled");
        RenderListener renderListener2 = new RenderListener(isCancelled, manager, this){
            final /* synthetic */ Function0<Boolean> $isCancelled;
            final /* synthetic */ LayoutlibSceneManager $manager;
            final /* synthetic */ VisualizationFormVisualLintHandler this$0;
            {
                this.$isCancelled = $isCancelled;
                this.$manager = $manager;
                this.this$0 = $receiver;
            }

            public void onRenderCompleted() {
                if (((Boolean)this.$isCancelled.invoke()).booleanValue() || this.$manager.getModel().isDisposed()) {
                    return;
                }
                NlModel nlModel = this.$manager.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"manager.model");
                NlModel model2 = nlModel;
                RenderResult result = this.$manager.getRenderResult();
                if (result != null) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this.this$0, result, model2){
                        final /* synthetic */ VisualizationFormVisualLintHandler this$0;
                        final /* synthetic */ RenderResult $result;
                        final /* synthetic */ NlModel $model;
                        {
                            this.this$0 = $receiver;
                            this.$result = $result;
                            this.$model = $model;
                        }

                        public final void run() {
                            VisualLintService.analyzeAfterModelUpdate$default(VisualLintService.Companion.getInstance(VisualizationFormVisualLintHandler.access$getProject$p(this.this$0)), this.this$0.getLintIssueProvider(), this.$result, this.$model, VisualizationFormVisualLintHandler.access$getMyBaseConfigIssues$p(this.this$0), false, 16, null);
                            Object object = StudioFlags.NELE_SHOW_VISUAL_LINT_ISSUE_IN_COMMON_PROBLEMS_PANEL.get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_SHOW_VISUAL_LINT_IS\u2026MMON_PROBLEMS_PANEL.get()");
                            if (((Boolean)object).booleanValue()) {
                                XmlFile xmlFile = this.$model.getFile();
                                Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"model.file");
                                CommonLintUserDataHandler.INSTANCE.updateVisualLintIssues((PsiFile)xmlFile, this.this$0.getLintIssueProvider());
                                VisualizationFormVisualLintHandler.access$getIssueModel$p(this.this$0).updateErrorsList();
                            }
                        }
                    });
                }
                this.$manager.removeRenderListener(this);
            }

            public void onRenderFailed(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$manager.removeRenderListener(this);
            }
        };
        manager.addRenderListener(renderListener2);
    }

    public final void onActivate() {
        VisualLintService.Companion.getInstance(this.project).removeAllIssueProviders();
        this.issueModel.addIssueProvider(this.lintIssueProvider);
        this.issueModel.updateErrorsList();
    }

    public final void onDeactivate() {
        block0: {
            this.issueModel.removeIssueProvider(this.lintIssueProvider);
            this.lintIssueProvider.clear();
            this.issueModel.updateErrorsList();
            FileEditor fileEditor = FileEditorManager.getInstance((Project)this.project).getSelectedEditor();
            DesignSurface<?> designSurface = fileEditor != null ? DesignSurfaceHelper.getDesignSurface(fileEditor) : null;
            NlDesignSurface nlDesignSurface = designSurface instanceof NlDesignSurface ? (NlDesignSurface)designSurface : null;
            if (nlDesignSurface == null) break block0;
            nlDesignSurface.updateErrorDisplay();
        }
    }

    public static final /* synthetic */ Project access$getProject$p(VisualizationFormVisualLintHandler $this) {
        return $this.project;
    }

    public static final /* synthetic */ VisualLintBaseConfigIssues access$getMyBaseConfigIssues$p(VisualizationFormVisualLintHandler $this) {
        return $this.myBaseConfigIssues;
    }

    public static final /* synthetic */ IssueModel access$getIssueModel$p(VisualizationFormVisualLintHandler $this) {
        return $this.issueModel;
    }
}

