/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssuePanelServiceKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.visual.analytics.MultiViewMetricTrackerKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/uibuilder/visual/IssuePanelToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "surface", "Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "(Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.designer"})
public final class IssuePanelToggleAction
extends ToggleAction {
    @NotNull
    private final NlDesignSurface surface;

    public IssuePanelToggleAction(@NotNull NlDesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        super("Toggle visibility of issue panel", "Toggle visibility of issue panel", StudioIcons.Common.WARNING_INLINE);
        this.surface = surface2;
    }

    @NotNull
    public final NlDesignSurface getSurface() {
        return this.surface;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = this.surface.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"surface.project");
        return IssuePanelService.Companion.getInstance(project).isShowingIssuePanel(this.surface);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        IssuePanelServiceKt.setIssuePanelVisibilityNoTracking(this.surface, state, true, new Runnable(e, this, state){
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ IssuePanelToggleAction this$0;
            final /* synthetic */ boolean $state;
            {
                this.$e = $e;
                this.this$0 = $receiver;
                this.$state = $state;
            }

            public final void run() {
                Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
                if (((Boolean)object).booleanValue()) {
                    Project project = (Project)this.$e.getData(PlatformDataKeys.PROJECT);
                    if (project != null) {
                        Project project2 = project;
                        boolean bl = false;
                        IssuePanelService.Companion.getInstance(project2).focusIssuePanelIfVisible();
                    }
                    MultiViewMetricTrackerKt.trackLayoutValidationToggleIssuePanel(this.this$0.getSurface(), this.$state);
                }
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
            if (project == null) break block0;
            Project project2 = project;
            boolean bl = false;
            List<Issue> list = IssuePanelService.Companion.getInstance(project2).getSharedPanelIssues();
            e.getPresentation().setVisible(!(list != null ? list.size() == 0 : false));
        }
    }
}

