/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolImageDisposer;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorConverter;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenViewLayer
extends Layer {
    public static final Map<RenderingHints.Key, Object> HQ_RENDERING_HINTS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private final ScreenView myScreenView;
    @Nullable
    private BufferedImage myCachedVisibleImage;
    @Nullable
    private RenderResult myLastRenderResult;
    private final Rectangle myScreenViewVisibleRect = new Rectangle();
    private final Dimension myScreenViewSize = new Dimension();
    private final Rectangle myCachedScreenViewDisplayRect = new Rectangle();
    private double myLastScale;
    private final ColorConverter myImageFilter;
    private static final Color CLEAR_BACKGROUND = new Color(255, 255, 255, 0);

    public ScreenViewLayer(@NotNull ScreenView screenView) {
        this(screenView, ColorBlindMode.NONE);
    }

    public ScreenViewLayer(@NotNull ScreenView screenView, @NotNull ColorBlindMode colorBlindFilter) {
        this(screenView, colorBlindFilter == ColorBlindMode.NONE ? null : new ColorConverter(colorBlindFilter));
    }

    private ScreenViewLayer(@NotNull ScreenView screenView, @Nullable ColorConverter imageFilter) {
        this.myScreenView = screenView;
        this.myLastScale = this.myScreenView.getScale();
        this.myImageFilter = imageFilter;
        Disposer.register((Disposable)screenView.getSurface(), (Disposable)this);
        if (this.myImageFilter != null) {
            Disposer.register((Disposable)this, (Disposable)this.myImageFilter);
        }
    }

    @NotNull
    private static BufferedImage getPreviewImage(@NotNull GraphicsConfiguration configuration, @NotNull ImagePool.Image renderedImage, int screenViewX, int screenViewY, @NotNull Rectangle screenViewVisibleSize, double xScaleFactor, double yScaleFactor, @Nullable BufferedImage existingBuffer, boolean screenViewHasBorderLayer) {
        boolean clearBackground;
        BufferedImage image;
        boolean bufferWithScreenViewSizeExists;
        int sx1 = (int)Math.round((double)(screenViewVisibleSize.x - screenViewX) * xScaleFactor);
        int sy1 = (int)Math.round((double)(screenViewVisibleSize.y - screenViewY) * yScaleFactor);
        int sx2 = sx1 + (int)Math.round((double)screenViewVisibleSize.width * xScaleFactor);
        int sy2 = sy1 + (int)Math.round((double)screenViewVisibleSize.height * yScaleFactor);
        boolean bl = bufferWithScreenViewSizeExists = existingBuffer != null && ImageUtil.getUserWidth((Image)existingBuffer) == screenViewVisibleSize.width && ImageUtil.getUserHeight((Image)existingBuffer) == screenViewVisibleSize.height;
        if (screenViewHasBorderLayer && bufferWithScreenViewSizeExists) {
            image = existingBuffer;
            clearBackground = true;
        } else {
            existingBuffer = image = ImageUtil.createImage((GraphicsConfiguration)configuration, (int)screenViewVisibleSize.width, (int)screenViewVisibleSize.height, (int)3);
            clearBackground = false;
        }
        int previewImageWidth = ImageUtil.getUserWidth((Image)image);
        int previewImageHeight = ImageUtil.getUserHeight((Image)image);
        Graphics2D cacheImageGraphics = image.createGraphics();
        if (clearBackground) {
            cacheImageGraphics.setColor(CLEAR_BACKGROUND);
            cacheImageGraphics.setComposite(AlphaComposite.Clear);
            cacheImageGraphics.fillRect(0, 0, previewImageWidth, previewImageHeight);
            cacheImageGraphics.setComposite(AlphaComposite.Src);
        }
        cacheImageGraphics.setRenderingHints(HQ_RENDERING_HINTS);
        renderedImage.drawImageTo((Graphics)cacheImageGraphics, 0, 0, previewImageWidth, previewImageHeight, sx1, sy1, sx2, sy2);
        cacheImageGraphics.dispose();
        return existingBuffer;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D) {
        this.myScreenView.getScaledContentSize(this.myScreenViewSize);
        this.myScreenViewVisibleRect.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
        Rectangle clipBounds = graphics2D.getClipBounds();
        if (!this.myScreenViewVisibleRect.intersects((Rectangle2D)clipBounds)) {
            return;
        }
        if ((double)this.myScreenViewVisibleRect.width > ((RectangularShape)clipBounds).getWidth() || (double)this.myScreenViewVisibleRect.height > ((RectangularShape)clipBounds).getHeight()) {
            Rectangle2D.intersect(this.myScreenViewVisibleRect, clipBounds, this.myScreenViewVisibleRect);
        }
        BufferedImage previousVisibleImage = this.myCachedVisibleImage;
        RenderResult renderResult = this.myScreenView.getResult();
        boolean drawNewImg = false;
        if (this.newRenderImageAvailable(renderResult)) {
            this.setLastRenderResult(renderResult);
            this.myScreenView.getScene().needsRebuildList();
            drawNewImg = true;
        }
        Graphics2D g = (Graphics2D)graphics2D.create();
        BufferedImage[] cachedVisibleImage = new BufferedImage[]{drawNewImg ? null : previousVisibleImage};
        double currentScale = this.myScreenView.getScale();
        if ((drawNewImg || currentScale != this.myLastScale || !this.myScreenViewVisibleRect.equals(this.myCachedScreenViewDisplayRect)) && this.myLastRenderResult != null) {
            ImagePool.Image image = this.myLastRenderResult.getRenderedImage();
            ImagePoolImageDisposer.runWithDisposeLock((ImagePool.Image)image, theImage -> {
                if (theImage.isValid()) {
                    int resultImageWidth = theImage.getWidth();
                    int resultImageHeight = theImage.getHeight();
                    this.myCachedScreenViewDisplayRect.setBounds(this.myScreenViewVisibleRect);
                    double xScaleFactor = (double)resultImageWidth / (double)this.myScreenViewSize.width;
                    double yScaleFactor = (double)resultImageHeight / (double)this.myScreenViewSize.height;
                    cachedVisibleImage[0] = ScreenViewLayer.getPreviewImage(g.getDeviceConfiguration(), theImage, this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewVisibleRect, xScaleFactor, yScaleFactor, previousVisibleImage, this.myScreenView.hasBorderLayer());
                    this.myCachedVisibleImage = cachedVisibleImage[0];
                    this.myLastScale = currentScale;
                } else {
                    cachedVisibleImage[0] = this.myCachedVisibleImage;
                }
            });
        }
        if (cachedVisibleImage[0] != null) {
            NlDesignSurface surface2;
            float degree;
            Shape screenShape = this.myScreenView.getScreenShape();
            if (screenShape != null) {
                g.clip(screenShape);
            }
            if (!Float.isNaN(degree = (surface2 = this.myScreenView.getSurface()).getRotateSurfaceDegree())) {
                g.rotate(Math.toRadians(degree), this.myScreenView.getX() + this.myScreenViewSize.width / 2, this.myScreenView.getY() + this.myScreenViewSize.height / 2);
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)cachedVisibleImage[0], (int)this.myScreenViewVisibleRect.x, (int)this.myScreenViewVisibleRect.y, null);
        }
        g.dispose();
    }

    protected void setLastRenderResult(@Nullable RenderResult result) {
        this.myLastRenderResult = result;
        if (this.myImageFilter == null || result == null) {
            return;
        }
        result.processImageIfNotDisposed(image -> {
            if (image == null) {
                return;
            }
            BufferedImage copy = image.getCopy();
            if (copy == null) {
                return;
            }
            this.myImageFilter.convert(copy, copy);
            image.paint(g2D -> {
                int w = image.getWidth();
                int h = image.getHeight();
                g2D.drawImage(copy, 0, 0, w, h, 0, 0, w, h, null);
            });
        });
    }

    private boolean newRenderImageAvailable(@Nullable RenderResult renderResult) {
        return renderResult != null && renderResult.getRenderResult().isSuccess() && renderResult.getRenderedImage().isValid() && renderResult != this.myLastRenderResult;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.setLastRenderResult(null);
    }
}

