/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandlerBase;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.MarqueeInteraction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\bH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0001\u0010\n\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlInteractionHandler;", "Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "createInteractionOnDrag", "Lcom/android/tools/idea/common/surface/Interaction;", "mouseX", "", "mouseY", "modifiersEx", "createInteractionOnPressed", "getCursorWhenNoInteraction", "Ljava/awt/Cursor;", "isInResizeZone", "", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "intellij.android.designer"})
public class NlInteractionHandler
extends InteractionHandlerBase {
    @NotNull
    private final DesignSurface<?> surface;

    public NlInteractionHandler(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        super(surface2);
        this.surface = surface2;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnPressed(int mouseX, int mouseY, int modifiersEx) {
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        SceneView view2 = sceneView;
        ScreenView screenView = (ScreenView)view2;
        if (this.isInResizeZone(view2, mouseX, mouseY)) {
            Configuration configuration = ((ScreenView)view2).getSceneManager().getModel().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"view.sceneManager.model.configuration");
            Configuration configuration2 = configuration;
            DesignSurface<?> designSurface = this.surface;
            Intrinsics.checkNotNull(designSurface, (String)"null cannot be cast to non-null type com.android.tools.idea.uibuilder.surface.NlDesignSurface");
            return new CanvasResizeInteraction((NlDesignSurface)designSurface, screenView, configuration2);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"screenView.selectionModel");
        SelectionModel selectionModel2 = selectionModel;
        NlComponent component = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component == null) {
            if (!selectionModel2.isEmpty()) {
                component = selectionModel2.getPrimary();
            } else {
                return null;
            }
        }
        Interaction interaction = null;
        if (!selectionModel2.isEmpty()) {
            ViewGroupHandler handler;
            NlComponent parent;
            NlComponent primary;
            NlComponent nlComponent = primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent2 = parent = nlComponent != null ? nlComponent.getParent() : null;
            if (parent != null && (handler = NlComponentHelperKt.getLayoutHandler(parent)) != null) {
                interaction = handler.createInteraction(screenView, mouseX, mouseY, primary);
            }
        }
        if (interaction == null) {
            ViewGroupHandler viewGroupHandler;
            NlComponent nlComponent = component;
            ViewGroupHandler viewGroupHandler2 = viewGroupHandler = nlComponent != null ? NlComponentHelperKt.getLayoutHandler(nlComponent) : null;
            if (viewGroupHandler != null) {
                NlComponent nlComponent3 = component;
                Intrinsics.checkNotNull((Object)nlComponent3);
                interaction = viewGroupHandler.createInteraction(screenView, mouseX, mouseY, nlComponent3);
            }
        }
        if (interaction == null) {
            interaction = new SceneInteraction(screenView);
        }
        return interaction;
    }

    private final boolean isInResizeZone(SceneView sceneView, int mouseX, int mouseY) {
        if (!sceneView.isResizeable() || !sceneView.getScene().isResizeAvailable()) {
            return false;
        }
        Dimension dimension = sceneView.getScaledContentSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"sceneView.scaledContentSize");
        Dimension size = dimension;
        Rectangle resizeZone = new Rectangle(sceneView.getX() + size.width, sceneView.getY() + size.height, 48, 48);
        return resizeZone.contains(mouseX, mouseY);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.surface.getSceneViewAt(mouseX, mouseY) == null) {
            SceneView sceneView = this.surface.getFocusedSceneView();
            if (sceneView == null) {
                return null;
            }
            SceneView focusedSceneView = sceneView;
            return new MarqueeInteraction(focusedSceneView);
        }
        return null;
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView != null && this.isInResizeZone(sceneView, mouseX, mouseY)) {
            return Cursor.getPredefinedCursor(5);
        }
        return super.getCursorWhenNoInteraction(mouseX, mouseY, modifiersEx);
    }
}

