/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.actions.LayoutManagerSwitcher;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.layout.PositionableContent;
import com.android.tools.idea.uibuilder.surface.layout.PositionableContentLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManagerKt;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlDesignSurfacePositionableContentLayoutManager
extends PositionableContentLayoutManager
implements LayoutManagerSwitcher {
    @NotNull
    private final NlDesignSurface myDesignSurface;
    @NotNull
    private SurfaceLayoutManager myLayoutManager;

    NlDesignSurfacePositionableContentLayoutManager(@NotNull NlDesignSurface surface2, @NotNull SurfaceLayoutManager defaultLayoutManager) {
        this.myDesignSurface = surface2;
        this.myLayoutManager = defaultLayoutManager;
    }

    @Override
    public void layoutContainer(@NotNull Collection<? extends PositionableContent> content2, @NotNull Dimension availableSize) {
        availableSize = this.myDesignSurface.getExtentSize();
        SurfaceLayoutManagerKt.layout(this.myLayoutManager, content2, availableSize.width, availableSize.height, this.myDesignSurface.isCanvasResizing());
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Collection<? extends PositionableContent> content2, @NotNull Dimension availableSize) {
        availableSize = this.myDesignSurface.getExtentSize();
        Dimension dimension = this.myLayoutManager.getRequiredSize(content2, availableSize.width, availableSize.height, null);
        dimension.setSize(Math.max(this.myDesignSurface.getScrollableViewMinSize().width, dimension.width), Math.max(this.myDesignSurface.getScrollableViewMinSize().height, dimension.height));
        return dimension;
    }

    @NotNull
    SurfaceLayoutManager getLayoutManager() {
        return this.myLayoutManager;
    }

    @Override
    public boolean isLayoutManagerSelected(@NotNull SurfaceLayoutManager manager) {
        return this.myLayoutManager.equals(manager);
    }

    @Override
    public void setLayoutManager(@NotNull SurfaceLayoutManager manager, @NotNull DesignSurface.SceneViewAlignment sceneViewAlignment) {
        this.myLayoutManager = manager;
        this.myDesignSurface.setSceneViewAlignment(sceneViewAlignment);
        this.myDesignSurface.setScrollPosition(0, 0);
        this.myDesignSurface.revalidateScrollArea();
    }

    @Override
    @NotNull
    public Map<PositionableContent, Point> getMeasuredPositionableContentPosition(@NotNull Collection<? extends PositionableContent> content2, int availableWidth, int availableHeight) {
        return this.myLayoutManager.measure(content2, availableWidth, availableHeight, this.myDesignSurface.isCanvasResizing());
    }
}

