/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.actions.LayoutPreviewHandler;
import com.android.tools.idea.actions.LayoutPreviewHandlerKt;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueProvider;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.Interactable;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.LayoutScannerControl;
import com.android.tools.idea.common.surface.LayoutScannerEnabled;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SurfaceInteractable;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewportScroller;
import com.android.tools.idea.common.surface.layout.TopBoundCenterScroller;
import com.android.tools.idea.common.surface.layout.ZoomCenterScroller;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderSettings;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NavigationHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfaceActionHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurfacePositionableContentLayoutManager;
import com.android.tools.idea.uibuilder.surface.NlInteractionHandler;
import com.android.tools.idea.uibuilder.surface.NlLayoutScanner;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.layout.GridSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.GroupedListSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManager;
import com.android.tools.idea.uibuilder.visual.VisualizationToolWindowFactory;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NlDesignSurface
extends DesignSurface<LayoutlibSceneManager>
implements ViewGroupHandler.AccessoryPanelVisibility,
LayoutPreviewHandler {
    private boolean myPreviewWithToolsVisibilityAndPosition = true;
    private static final double DEFAULT_MIN_SCALE = 0.025;
    private static final double DEFAULT_MAX_SCALE = 10.0;
    @Nullable
    private final DataProvider myDelegateDataProvider;
    @NotNull
    private ScreenViewProvider myScreenViewProvider = NlScreenViewProvider.Companion.loadPreferredMode();
    private boolean myIsCanvasResizing = false;
    private final RenderListener myRenderListener = this::modelRendered;
    @NotNull
    private ImmutableList<? extends IssueProvider> myRenderIssueProviders = ImmutableList.of();
    private final AccessoryPanel myAccessoryPanel = new AccessoryPanel(AccessoryPanel.Type.SOUTH_PANEL, true);
    @NotNull
    private final NlAnalyticsManager myAnalyticsManager;
    private final BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider;
    @NotNull
    private SurfaceLayoutManager myLayoutManager;
    @Nullable
    private final NavigationHandler myNavigationHandler;
    private final double myMinScale;
    private final double myMaxScale;
    @Nullable
    private DesignSurfaceViewportScroller myViewportScroller = null;
    private boolean myIsRenderingSynchronously = false;
    private boolean myIsAnimationScrubbing = false;
    private float myRotateSurfaceDegree = Float.NaN;
    private final Dimension myScrollableViewMinSize = new Dimension();
    @Nullable
    private LayoutScannerControl myScannerControl;
    @NotNull
    private final Set<NlSupportedActions> mySupportedActions;
    private final boolean myShouldRunVisualLintService;
    private boolean myShouldRenderErrorsPanel;
    private final VisualLintIssueProvider myVisualLintIssueProvider;

    private NlDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider2, @NotNull SurfaceLayoutManager defaultLayoutManager, @NotNull Function<DesignSurface<LayoutlibSceneManager>, ActionManager<? extends DesignSurface<LayoutlibSceneManager>>> actionManagerProvider, @NotNull Function<DesignSurface<LayoutlibSceneManager>, Interactable> interactableProvider, @NotNull Function<DesignSurface<LayoutlibSceneManager>, InteractionHandler> interactionHandlerProvider, @Nullable NavigationHandler navigationHandler, double minScale, double maxScale, @NotNull Function<DesignSurface<LayoutlibSceneManager>, DesignSurfaceActionHandler> actionHandlerProvider, @Nullable DataProvider delegateDataProvider, @NotNull SelectionModel selectionModel, DesignSurface.ZoomControlsPolicy zoomControlsPolicy, boolean shouldRunVisualLintService, @NotNull Set<NlSupportedActions> supportedActions, boolean shouldRenderErrorsPanel, double maxFitIntoZoomLevel) {
        super(project, parentDisposable, actionManagerProvider, interactableProvider, interactionHandlerProvider, surface2 -> new NlDesignSurfacePositionableContentLayoutManager((NlDesignSurface)surface2, defaultLayoutManager), actionHandlerProvider, selectionModel, zoomControlsPolicy, maxFitIntoZoomLevel);
        this.myAnalyticsManager = new NlAnalyticsManager(this);
        this.myAccessoryPanel.setSurface(this);
        this.myLayoutManager = defaultLayoutManager;
        this.mySceneManagerProvider = sceneManagerProvider2;
        this.myNavigationHandler = navigationHandler;
        this.mySupportedActions = supportedActions;
        this.myShouldRunVisualLintService = shouldRunVisualLintService;
        this.myShouldRenderErrorsPanel = shouldRenderErrorsPanel;
        this.myVisualLintIssueProvider = new VisualLintIssueProvider(this);
        if (this.myNavigationHandler != null) {
            Disposer.register((Disposable)this, (Disposable)this.myNavigationHandler);
        }
        this.myMinScale = minScale;
        this.myMaxScale = maxScale;
        this.getViewport().addChangeListener(e -> {
            DesignSurfaceViewportScroller scroller = this.myViewportScroller;
            this.myViewportScroller = null;
            if (scroller != null) {
                scroller.scroll(this.getViewport());
            }
        });
        this.myScannerControl = new NlLayoutScanner(this);
        this.myDelegateDataProvider = delegateDataProvider;
    }

    @NotNull
    public static LayoutlibSceneManager defaultSceneManagerProvider(@NotNull NlDesignSurface surface2, @NotNull NlModel model2) {
        LayoutlibSceneManager sceneManager = new LayoutlibSceneManager(model2, surface2, new LayoutScannerEnabled());
        RenderSettings settings = RenderSettings.getProjectSettings((Project)model2.getProject());
        sceneManager.setShowDecorations(settings.getShowDecorations());
        sceneManager.setUseImagePool(settings.getUseLiveRendering());
        sceneManager.setQuality(settings.getQuality());
        return sceneManager;
    }

    @NotNull
    public static SurfaceLayoutManager createDefaultSurfaceLayoutManager() {
        return new SingleDirectionLayoutManager(50, 50, 48, 48, SingleDirectionLayoutManager.Alignment.CENTER);
    }

    @NotNull
    public static ActionManager<? extends NlDesignSurface> defaultActionManagerProvider(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        return new NlActionManager((NlDesignSurface)surface2);
    }

    @NotNull
    public static NlInteractionHandler defaultInteractionHandlerProvider(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        return new NlInteractionHandler(surface2);
    }

    @NotNull
    public static NlDesignSurfaceActionHandler defaultActionHandlerProvider(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        return new NlDesignSurfaceActionHandler(surface2);
    }

    @NotNull
    public static Builder builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
        return new Builder(project, parentDisposable);
    }

    @Override
    @NotNull
    protected LayoutlibSceneManager createSceneManager(@NotNull NlModel model2) {
        LayoutlibSceneManager manager = this.mySceneManagerProvider.apply(this, model2);
        manager.addRenderListener(this.myRenderListener);
        return manager;
    }

    @Override
    @NotNull
    public NlAnalyticsManager getAnalyticsManager() {
        return this.myAnalyticsManager;
    }

    @Override
    @Nullable
    public LayoutScannerControl getLayoutScannerControl() {
        return this.myScannerControl;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
        this.setSurfaceAutoscrolls(isResizing);
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    @NotNull
    public ScreenViewProvider getScreenViewProvider() {
        return this.myScreenViewProvider;
    }

    public void setScreenViewProvider(@NotNull ScreenViewProvider screenViewProvider, boolean setAsDefault) {
        if (setAsDefault && screenViewProvider instanceof NlScreenViewProvider) {
            NlScreenViewProvider.Companion.savePreferredMode((NlScreenViewProvider)screenViewProvider);
        }
        if (screenViewProvider != this.myScreenViewProvider) {
            this.myScreenViewProvider.onViewProviderReplaced();
            this.myScreenViewProvider = screenViewProvider;
            for (SceneManager manager : this.getSceneManagers()) {
                manager.updateSceneView();
                manager.requestLayoutAndRenderAsync(false);
            }
            this.revalidateScrollArea();
        }
    }

    public void setColorBlindMode(ColorBlindMode mode) {
        this.myScreenViewProvider.setColorBlindFilter(mode);
        for (SceneManager manager : this.getSceneManagers()) {
            manager.updateSceneView();
            manager.requestLayoutAndRenderAsync(false);
        }
        this.revalidateScrollArea();
    }

    @Nullable
    public NavigationHandler getNavigationHandler() {
        return this.myNavigationHandler;
    }

    @Override
    public boolean shouldRenderErrorsPanel() {
        return this.myShouldRenderErrorsPanel;
    }

    @NotNull
    public static NlDesignSurface build(@NotNull Project project, @NotNull Disposable parentDisposable) {
        return new Builder(project, parentDisposable).build();
    }

    public void forceLayersPaint(boolean value2) {
        for (SceneView view2 : this.getSceneViews()) {
            view2.setForceLayersRepaint(value2);
        }
        this.repaint();
    }

    @Override
    @NotNull
    public AccessoryPanel getAccessoryPanel() {
        return this.myAccessoryPanel;
    }

    public void showInspectorAccessoryPanel(boolean show2) {
        for (DesignSurfaceListener listener2 : ImmutableList.copyOf((Collection)this.myListeners)) {
            listener2.showAccessoryPanel(this, show2);
        }
    }

    @Override
    public void show(@NotNull AccessoryPanel.Type type, boolean show2) {
        this.showInspectorAccessoryPanel(show2);
    }

    @Override
    public double getScreenScalingFactor() {
        return JBUIScale.sysScale((Component)((Object)this));
    }

    @Override
    @NotNull
    public ActionManager<NlDesignSurface> getActionManager() {
        return super.getActionManager();
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), NlComponentHelperKt.getW(component), NlComponentHelperKt.getH(component))).collect(ImmutableList.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @Override
    protected Dimension getScrollToVisibleOffset() {
        return new Dimension(100, 100);
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        this.myAccessoryPanel.setModel(model2);
        return super.setModel(model2);
    }

    @Override
    public void dispose() {
        this.myAccessoryPanel.setSurface(null);
        this.myRenderIssueProviders = ImmutableList.of();
        super.dispose();
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        ViewHandler handler = NlComponentHelperKt.getViewHandler(component);
        if (handler != null) {
            handler.onActivateInDesignSurface(component, x, y);
        }
        super.notifyComponentActivate(component, x, y);
    }

    public void updateErrorDisplay() {
        if (this.myIsRenderingSynchronously) {
            return;
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                Project project;
                Map results;
                if (NlDesignSurface.this.myScannerControl != null) {
                    NlDesignSurface.this.myScannerControl.resume();
                }
                if ((results = NlDesignSurface.this.getSceneManagers().stream().filter(sceneManager -> sceneManager.getRenderResult() != null).collect(Collectors.toMap(Function.identity(), LayoutlibSceneManager::getRenderResult))).isEmpty()) {
                    return;
                }
                if (NlDesignSurface.this.myScannerControl != null) {
                    for (Map.Entry entry : results.entrySet()) {
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)entry.getKey();
                        if (!manager.getLayoutScannerConfig().isIntegrateWithDefaultIssuePanel()) continue;
                        NlDesignSurface.this.myScannerControl.validateAndUpdateLint(entry.getValue(), manager.getModel());
                    }
                }
                if ((project = NlDesignSurface.this.getProject()).isDisposed()) {
                    return;
                }
                DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                    ImmutableList renderIssueProviders = null;
                    if (GradleBuildState.getInstance((Project)project).isBuildInProgress()) {
                        for (Map.Entry entry2 : results.entrySet()) {
                            if (!((RenderResult)entry2.getValue()).getLogger().hasErrors()) continue;
                            renderIssueProviders = ImmutableList.of((Object)new RenderIssueProvider(((LayoutlibSceneManager)entry2.getKey()).getModel(), RenderErrorModel.STILL_BUILDING_ERROR_MODEL));
                            break;
                        }
                    }
                    if (renderIssueProviders == null) {
                        renderIssueProviders = (ImmutableList)results.entrySet().stream().map(entry -> {
                            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel((EditorDesignSurface)NlDesignSurface.this, (RenderResult)((RenderResult)entry.getValue()), null);
                            return new RenderIssueProvider(((LayoutlibSceneManager)entry.getKey()).getModel(), errorModel);
                        }).collect(ImmutableList.toImmutableList());
                    }
                    NlDesignSurface.this.myRenderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().removeIssueProvider((IssueProvider)renderIssueProvider));
                    NlDesignSurface.this.myRenderIssueProviders = renderIssueProviders;
                    renderIssueProviders.forEach(renderIssueProvider -> NlDesignSurface.this.getIssueModel().addIssueProvider((IssueProvider)renderIssueProvider));
                });
                if (NlDesignSurface.this.myShouldRunVisualLintService && !VisualizationToolWindowFactory.hasVisibleValidationWindow(project)) {
                    VisualLintService.getInstance(project).runVisualLintAnalysis(NlDesignSurface.this, NlDesignSurface.this.myVisualLintIssueProvider, (List<? extends NlModel>)NlDesignSurface.this.getModels());
                }
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private void modelRendered() {
        this.updateErrorDisplay();
        UIUtil.invokeLaterIfNeeded(() -> this.revalidateScrollArea());
    }

    @Override
    public void deactivate() {
        this.myRenderIssueProviders.forEach(renderIssueProvider -> this.getIssueModel().removeIssueProvider((IssueProvider)renderIssueProvider));
        this.myRenderIssueProviders = ImmutableList.of();
        this.myVisualLintIssueProvider.clear();
        super.deactivate();
    }

    @Override
    public void activate() {
        super.activate();
        this.updateErrorDisplay();
    }

    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        BackgroundableProcessIndicator refreshProgressIndicator = new BackgroundableProcessIndicator(this.getProject(), "Refreshing...", PerformInBackgroundOption.ALWAYS_BACKGROUND, "", "", false);
        return this.requestSequentialRender(manager -> {
            manager.forceReinflate();
            return manager.requestUserInitiatedRenderAsync();
        }).whenComplete((r, t) -> refreshProgressIndicator.processFinish());
    }

    @NotNull
    public CompletableFuture<Void> forceRefresh() {
        return this.requestSequentialRender(manager -> {
            manager.forceReinflate();
            return manager.requestRenderAsync();
        });
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getFocusedSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = (LayoutlibSceneManager)this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return this.myMinScale;
    }

    @Override
    protected double getMaxScale() {
        return this.myMaxScale;
    }

    @Override
    public boolean canZoomToFit() {
        double zoomToFitScale;
        double currentScale = this.getScale();
        return currentScale > (zoomToFitScale = this.getFitScale()) && this.canZoomOut() || currentScale < zoomToFitScale && this.canZoomIn();
    }

    @Override
    public boolean canZoomToActual() {
        double scaleOfActual;
        double currentScale = this.getScale();
        return currentScale > (scaleOfActual = 1.0 / this.getScreenScalingFactor()) && this.canZoomOut() || currentScale < scaleOfActual && this.canZoomIn();
    }

    @Override
    public double getFitScale() {
        Dimension extent = this.getExtentSize();
        double scale = ((NlDesignSurfacePositionableContentLayoutManager)this.getSceneViewLayoutManager()).getLayoutManager().getFitIntoScale(this.getPositionableContent(), extent.width, extent.height);
        return Math.min(scale, this.myMaxFitIntoScale);
    }

    @Override
    public boolean setScale(double scale, int x, int y) {
        boolean changed = super.setScale(scale, x, y);
        if (changed) {
            DesignSurfaceViewport port = this.getViewport();
            if (this.myLayoutManager instanceof GroupedListSurfaceLayoutManager) {
                Point scrollPosition = this.getScrollPosition();
                this.myViewportScroller = new TopBoundCenterScroller(new Dimension(port.getViewSize()), new Point(scrollPosition));
            } else if (!(this.myLayoutManager instanceof GridSurfaceLayoutManager)) {
                if (x < 0 || y < 0) {
                    x = port.getViewportComponent().getWidth() / 2;
                    y = port.getViewportComponent().getHeight() / 2;
                }
                Point scrollPosition = this.getScrollPosition();
                Point zoomCenterInView = new Point(scrollPosition.x + x, scrollPosition.y + y);
                this.myViewportScroller = new ZoomCenterScroller(new Dimension(port.getViewSize()), new Point(scrollPosition), zoomCenterInView);
            }
        }
        return changed;
    }

    public final void zoomAndCenter(@NotNull SceneView sceneView, @NotNull Rectangle rectangle) {
        if (this.myScrollPane == null) {
            Logger.getInstance(NlDesignSurface.class).warn("The scroll pane is null, cannot zoom and center.");
            return;
        }
        Dimension offset = this.getScrollToVisibleOffset();
        Dimension availableSize = this.getExtentSize();
        Dimension curSize = new Dimension(rectangle.width, rectangle.height);
        double scaleChangeNeeded = Math.min((availableSize.getWidth() - (double)(2 * offset.width)) / curSize.getWidth(), (availableSize.getHeight() - (double)(2 * offset.height)) / curSize.getHeight());
        double curScale = this.getScale();
        double boundedNewScale = this.getBoundedScale(curScale * scaleChangeNeeded);
        scaleChangeNeeded = boundedNewScale / curScale;
        rectangle.setRect((double)rectangle.x * scaleChangeNeeded, (double)rectangle.y * scaleChangeNeeded, (double)rectangle.width * scaleChangeNeeded, (double)rectangle.height * scaleChangeNeeded);
        if (this.setScale(boundedNewScale)) {
            this.myViewportScroller = port -> this.scrollToCenter(sceneView, rectangle);
        } else {
            this.scrollToCenter(sceneView, rectangle);
        }
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        Scene scene = this.getScene();
        SceneView view2 = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view2 == null) {
            return;
        }
        Rectangle componentsArea = new Rectangle(0, 0, -1, -1);
        Rectangle componentRect = new Rectangle();
        list.stream().filter(nlComponent -> !nlComponent.isRoot()).forEach(nlComponent -> {
            SceneComponent component = scene.getSceneComponent((NlComponent)nlComponent);
            if (component == null) {
                return;
            }
            component.fillRect(componentRect);
            if (componentsArea.width < 0) {
                componentsArea.setBounds(componentRect);
            } else {
                componentsArea.add(componentRect);
            }
        });
        Rectangle areaToCenter = Coordinates.getSwingRectDip(view2, componentsArea);
        if (areaToCenter.isEmpty() || this.getLayeredPane().getVisibleRect().contains(areaToCenter)) {
            return;
        }
        Dimension swingViewportSize = this.getExtentSize();
        int targetSwingX = (int)areaToCenter.getCenterX();
        int targetSwingY = (int)areaToCenter.getCenterY();
        this.setScrollPosition(targetSwingX - swingViewportSize.width / 2, targetSwingY - swingViewportSize.height / 2);
        double fitScale = DesignSurfaceHelper.getFitContentIntoWindowScale(this, areaToCenter.getSize());
        if (this.getScale() > fitScale) {
            this.setScale(fitScale, targetSwingX, targetSwingY);
        }
    }

    @Override
    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        super.notifySelectionListeners(newSelection);
        this.scrollToCenter(newSelection);
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return Collections.emptyList();
        }
        ImmutableList<NlComponent> roots = model2.getComponents();
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        NlComponent root = (NlComponent)roots.get(0);
        if (root == null) {
            return Collections.emptyList();
        }
        return root.flatten().collect(Collectors.toList());
    }

    public void setRenderSynchronously(boolean enabled) {
        this.myIsRenderingSynchronously = enabled;
        if (this.myScannerControl != null) {
            if (enabled) {
                this.myScannerControl.pause();
            } else {
                this.myScannerControl.resume();
            }
        }
    }

    public boolean isRenderingSynchronously() {
        return this.myIsRenderingSynchronously;
    }

    public void setAnimationScrubbing(boolean value2) {
        this.myIsAnimationScrubbing = value2;
    }

    public void setRotateSufaceDegree(float value2) {
        this.myRotateSurfaceDegree = value2;
    }

    public float getRotateSurfaceDegree() {
        return this.myRotateSurfaceDegree;
    }

    public boolean isInAnimationScrubbing() {
        return this.myIsAnimationScrubbing;
    }

    public void setScrollableViewMinSize(@NotNull Dimension dimension) {
        this.myScrollableViewMinSize.setSize(dimension);
    }

    @Override
    public Object getData(@NotNull String dataId) {
        Object data;
        Object object = data = this.myDelegateDataProvider != null ? this.myDelegateDataProvider.getData(dataId) : null;
        if (data != null) {
            return data;
        }
        if (LayoutPreviewHandlerKt.LAYOUT_PREVIEW_HANDLER_KEY.is(dataId)) {
            return this;
        }
        return super.getData(dataId);
    }

    @NotNull
    public Set<NlSupportedActions> getSupportedActions() {
        return this.mySupportedActions;
    }

    @Override
    public boolean getPreviewWithToolsVisibilityAndPosition() {
        return this.myPreviewWithToolsVisibilityAndPosition;
    }

    @Override
    public void setPreviewWithToolsVisibilityAndPosition(boolean isPreviewWithToolsVisibilityAndPosition) {
        if (this.myPreviewWithToolsVisibilityAndPosition != isPreviewWithToolsVisibilityAndPosition) {
            this.myPreviewWithToolsVisibilityAndPosition = isPreviewWithToolsVisibilityAndPosition;
            this.forceRefresh();
        }
    }

    @NotNull
    Dimension getScrollableViewMinSize() {
        return this.myScrollableViewMinSize;
    }

    public static class Builder {
        private final Project myProject;
        private final Disposable myParentDisposable;
        private BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> mySceneManagerProvider = NlDesignSurface::defaultSceneManagerProvider;
        private SurfaceLayoutManager myLayoutManager;
        private NavigationHandler myNavigationHandler;
        private double myMinScale = 0.025;
        private double myMaxScale = 10.0;
        @Nullable
        private DataProvider myDelegateDataProvider = null;
        private Function<DesignSurface<LayoutlibSceneManager>, ActionManager<? extends DesignSurface<LayoutlibSceneManager>>> myActionManagerProvider = NlDesignSurface::defaultActionManagerProvider;
        private Function<DesignSurface<LayoutlibSceneManager>, Interactable> myInteractableProvider = SurfaceInteractable::new;
        private Function<DesignSurface<LayoutlibSceneManager>, InteractionHandler> myInteractionHandlerProvider = NlDesignSurface::defaultInteractionHandlerProvider;
        private Function<DesignSurface<LayoutlibSceneManager>, DesignSurfaceActionHandler> myActionHandlerProvider = NlDesignSurface::defaultActionHandlerProvider;
        @Nullable
        private SelectionModel mySelectionModel = null;
        private DesignSurface.ZoomControlsPolicy myZoomControlsPolicy = DesignSurface.ZoomControlsPolicy.AUTO_HIDE;
        @NotNull
        private Set<NlSupportedActions> mySupportedActions = Collections.emptySet();
        private boolean myShouldRunVisualLintService = false;
        private boolean myShouldRenderErrorsPanel = false;
        @Nullable
        private ScreenViewProvider myScreenViewProvider = null;
        private boolean mySetDefaultScreenViewProvider = false;
        private double myMaxFitIntoZoomLevel = Double.MAX_VALUE;

        private Builder(@NotNull Project project, @NotNull Disposable parentDisposable) {
            this.myProject = project;
            this.myParentDisposable = parentDisposable;
        }

        @NotNull
        public Builder setSceneManagerProvider(@NotNull BiFunction<NlDesignSurface, NlModel, LayoutlibSceneManager> sceneManagerProvider2) {
            this.mySceneManagerProvider = sceneManagerProvider2;
            return this;
        }

        @NotNull
        public Builder setLayoutManager(@NotNull SurfaceLayoutManager layoutManager) {
            this.myLayoutManager = layoutManager;
            return this;
        }

        @NotNull
        public Builder setActionManagerProvider(@NotNull Function<DesignSurface<LayoutlibSceneManager>, ActionManager<? extends DesignSurface<LayoutlibSceneManager>>> actionManagerProvider) {
            this.myActionManagerProvider = actionManagerProvider;
            return this;
        }

        @TestOnly
        @NotNull
        public Builder setInteractableProvider(@NotNull Function<DesignSurface<LayoutlibSceneManager>, Interactable> interactableProvider) {
            this.myInteractableProvider = interactableProvider;
            return this;
        }

        @NotNull
        public Builder setInteractionHandlerProvider(@NotNull Function<DesignSurface<LayoutlibSceneManager>, InteractionHandler> interactionHandlerProvider) {
            this.myInteractionHandlerProvider = interactionHandlerProvider;
            return this;
        }

        @NotNull
        public Builder setNavigationHandler(NavigationHandler navigationHandler) {
            this.myNavigationHandler = navigationHandler;
            return this;
        }

        public Builder setMinScale(double scale) {
            if (scale <= 0.0) {
                throw new IllegalStateException("The min scale (" + scale + ") is not larger than 0");
            }
            this.myMinScale = scale;
            return this;
        }

        public Builder setMaxScale(double scale) {
            this.myMaxScale = scale;
            return this;
        }

        @NotNull
        public Builder setActionHandler(@NotNull Function<DesignSurface<LayoutlibSceneManager>, DesignSurfaceActionHandler> actionHandlerProvider) {
            this.myActionHandlerProvider = actionHandlerProvider;
            return this;
        }

        @NotNull
        public Builder setDelegateDataProvider(@NotNull DataProvider dataProvider2) {
            this.myDelegateDataProvider = dataProvider2;
            return this;
        }

        @NotNull
        public Builder setSelectionModel(@NotNull SelectionModel selectionModel) {
            this.mySelectionModel = selectionModel;
            return this;
        }

        @NotNull
        public Builder setZoomControlsPolicy(@NotNull DesignSurface.ZoomControlsPolicy policy) {
            this.myZoomControlsPolicy = policy;
            return this;
        }

        @NotNull
        public Builder setRunVisualLintAnalysis(boolean value2) {
            this.myShouldRunVisualLintService = value2;
            return this;
        }

        @NotNull
        public Builder setSupportedActions(@NotNull Set<NlSupportedActions> supportedActions) {
            this.mySupportedActions = supportedActions;
            return this;
        }

        @NotNull
        public Builder setShouldRenderErrorsPanel(Boolean shouldRenderErrorsPanel) {
            this.myShouldRenderErrorsPanel = shouldRenderErrorsPanel;
            return this;
        }

        @NotNull
        public Builder setScreenViewProvider(@NotNull ScreenViewProvider screenViewProvider, boolean setAsDefault) {
            this.myScreenViewProvider = screenViewProvider;
            this.mySetDefaultScreenViewProvider = setAsDefault;
            return this;
        }

        @NotNull
        public Builder setMaxFitIntoZoomLevel(double maxFitIntoZoomLevel) {
            this.myMaxFitIntoZoomLevel = maxFitIntoZoomLevel;
            return this;
        }

        @NotNull
        public NlDesignSurface build() {
            SurfaceLayoutManager layoutManager;
            SurfaceLayoutManager surfaceLayoutManager = layoutManager = this.myLayoutManager != null ? this.myLayoutManager : NlDesignSurface.createDefaultSurfaceLayoutManager();
            if (this.myMinScale > this.myMaxScale) {
                throw new IllegalStateException("The max scale (" + this.myMaxScale + ") is lower than min scale (" + this.myMinScale + ")");
            }
            NlDesignSurface surface2 = new NlDesignSurface(this.myProject, this.myParentDisposable, this.mySceneManagerProvider, layoutManager, this.myActionManagerProvider, this.myInteractableProvider, this.myInteractionHandlerProvider, this.myNavigationHandler, this.myMinScale, this.myMaxScale, this.myActionHandlerProvider, this.myDelegateDataProvider, this.mySelectionModel != null ? this.mySelectionModel : new DefaultSelectionModel(), this.myZoomControlsPolicy, this.myShouldRunVisualLintService, this.mySupportedActions, this.myShouldRenderErrorsPanel, this.myMaxFitIntoZoomLevel);
            if (this.myScreenViewProvider != null) {
                surface2.setScreenViewProvider(this.myScreenViewProvider, this.mySetDefaultScreenViewProvider);
            }
            return surface2;
        }
    }
}

