/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEventHandler;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NlTreeUtil {
    @Nullable
    public static DelegatedTreeEventHandler getSelectionTreeHandler(@NotNull NlComponentTree tree) {
        Object parentComponent;
        TreePath parentPath;
        TreePath[] paths = tree.getSelectionModel().getSelectionPaths();
        if (paths.length == 0 || (parentPath = paths[0].getParentPath()) == null || !((parentComponent = parentPath.getLastPathComponent()) instanceof NlComponent)) {
            return null;
        }
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i].getParentPath() == parentPath) continue;
            return null;
        }
        ViewGroupHandler handler = NlComponentHelperKt.getLayoutHandler((NlComponent)parentComponent);
        if (handler != null && handler instanceof DelegatedTreeEventHandler) {
            return (DelegatedTreeEventHandler)((Object)handler);
        }
        return null;
    }

    @Nullable
    public static TreePath getUniqueParent(@NotNull TreePath[] paths) {
        TreePath parentPath;
        if (paths.length == 0 || (parentPath = paths[0].getParentPath()) == null) {
            return null;
        }
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i].getParentPath() == parentPath) continue;
            return null;
        }
        return parentPath;
    }

    static boolean delegateEvent(@NotNull DelegatedTreeEvent.Type type, @NotNull NlComponentTree tree, @NotNull NlComponent receiver, int row) {
        TreePath uniqueParent;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null && (uniqueParent = NlTreeUtil.getUniqueParent(paths)) != null) {
            DelegatedTreeEventHandler handler;
            TreePath pathForRow;
            List<Object> draggedObject = NlTreeUtil.collectComponentsFromPaths(paths);
            Object nextObject = null;
            if (row >= 0 && (pathForRow = tree.getPathForRow(row + 1)) != null && pathForRow.getParentPath() == uniqueParent) {
                nextObject = pathForRow.getLastPathComponent();
            }
            if ((handler = NlTreeUtil.getSelectionTreeHandler(tree)) != null) {
                return handler.handleTreeEvent(new DelegatedTreeEvent(tree, type, draggedObject, nextObject), receiver);
            }
        }
        return false;
    }

    @NotNull
    private static List<Object> collectComponentsFromPaths(@NotNull TreePath[] paths) {
        return Arrays.stream(paths).map(TreePath::getLastPathComponent).collect(Collectors.toList());
    }

    public static Collection<NlComponent> keepOnlyAncestors(@NotNull Collection<NlComponent> dragged) {
        Set selection = Sets.newIdentityHashSet();
        selection.addAll(dragged);
        Stack<NlComponent> toTraverse = new Stack<NlComponent>();
        for (NlComponent selectedElement : dragged) {
            List<NlComponent> children = selectedElement.getChildren();
            toTraverse.addAll(children);
            while (!toTraverse.isEmpty()) {
                NlComponent child = (NlComponent)toTraverse.pop();
                toTraverse.addAll(child.getChildren());
                if (!selection.contains(child)) continue;
                selection.remove(child);
            }
        }
        return selection;
    }
}

