/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.UtilsKt;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.NlDropInsertionPicker;
import com.android.tools.idea.uibuilder.structure.NlTreeUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDropListener
extends DropTargetAdapter {
    private static final HashSet<String> ourCopyableAttributes = new HashSet<String>(Arrays.asList("layout_width", "layout_height", "id", "background"));
    private final List<NlComponent> myDragged = new ArrayList<NlComponent>();
    private final NlComponentTree myTree;
    private DnDTransferItem myTransferItem;
    private NlComponent myDragReceiver;
    private NlComponent myNextDragSibling;
    private final NlDropInsertionPicker myInsertionPicker;

    public NlDropListener(@NotNull NlComponentTree tree) {
        this.myTree = tree;
        this.myInsertionPicker = new NlDropInsertionPicker(tree);
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
        NlDropEvent event = new NlDropEvent(dragEvent);
        InsertType type = this.captureDraggedComponents(event, true);
        if (type != null) {
            this.updateInsertionPoint(event);
        }
    }

    @Override
    public void dragOver(@NotNull DropTargetDragEvent dragEvent) {
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragExit(@NotNull DropTargetEvent event) {
        this.myTree.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent dropEvent) {
        NlDropInsertionPicker.Result finderResult = this.myInsertionPicker.findInsertionPointAt(dropEvent.getLocation(), this.myDragged, true);
        if (finderResult != null) {
            if (finderResult.shouldDelegate) {
                DelegatedTreeEvent.Type type = DelegatedTreeEvent.Type.DROP;
                boolean eventHandled = NlTreeUtil.delegateEvent(type, this.myTree, finderResult.receiver, finderResult.row);
                if (eventHandled) {
                    dropEvent.acceptDrop(3);
                    dropEvent.dropComplete(true);
                }
            } else {
                NlDropEvent event = new NlDropEvent(dropEvent);
                InsertType insertType = this.captureDraggedComponents(event, false);
                this.myDragReceiver = finderResult.receiver;
                this.myNextDragSibling = finderResult.nextComponent;
                this.performDrop(event, insertType);
            }
        }
        this.myTree.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Nullable
    private InsertType captureDraggedComponents(@NotNull NlDropEvent event, boolean isPreview) {
        this.clearDraggedComponents();
        Scene scene = this.myTree.getScene();
        if (scene == null) {
            return null;
        }
        NlModel model2 = scene.getSceneManager().getModel();
        if (event.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
            try {
                this.myTransferItem = (DnDTransferItem)event.getTransferable().getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                InsertType insertType = this.determineInsertType(event, isPreview);
                if (insertType == InsertType.MOVE) {
                    this.myDragged.addAll(NlTreeUtil.keepOnlyAncestors(scene.getDesignSurface().getSelectionModel().getSelection()));
                } else {
                    this.myDragged.addAll(NlTreeUtil.keepOnlyAncestors(model2.createComponents(this.myTransferItem, insertType)));
                }
                return insertType;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            }
        }
        return null;
    }

    @NotNull
    private InsertType determineInsertType(@NotNull NlDropEvent event, boolean isPreview) {
        NlModel model2 = this.myTree.getDesignerModel();
        if (model2 == null || this.myTransferItem == null) {
            return InsertType.MOVE;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        return model2.determineInsertType(dragType, this.myTransferItem, isPreview);
    }

    private void clearDraggedComponents() {
        this.myDragged.clear();
    }

    private void updateInsertionPoint(@NotNull NlDropEvent event) {
        NlDropInsertionPicker.Result result = this.myInsertionPicker.findInsertionPointAt(event.getLocation(), this.myDragged, true);
        if (result == null) {
            this.myTree.clearInsertionPoint();
            event.reject();
        } else {
            this.myDragReceiver = result.receiver;
            this.myNextDragSibling = result.nextComponent;
            this.myTree.markInsertionPoint(result.row, result.depth);
            event.accept(this.determineInsertType(event, true));
        }
    }

    private void performDrop(@NotNull NlDropEvent event, InsertType insertType) {
        this.myTree.skipNextUpdateDelay();
        NlModel model2 = this.myTree.getDesignerModel();
        assert (model2 != null);
        if (NlComponentHelperKt.isGroup(this.myDragReceiver) && model2.canAddComponents(this.myDragged, this.myDragReceiver, this.myDragReceiver.getChild(0), true)) {
            this.performNormalDrop(event, insertType, model2);
        } else {
            ViewHandler handler = NlComponentHelperKt.getViewHandler(this.myDragReceiver);
            if (handler instanceof ViewGroupHandler) {
                ViewGroupHandler groupHandler = (ViewGroupHandler)handler;
                groupHandler.performDrop(model2, event, this.myDragReceiver, this.myDragged, this.myNextDragSibling, insertType);
            }
        }
    }

    private void performNormalDrop(@NotNull NlDropEvent event, @NotNull InsertType insertType, @NotNull NlModel model2) {
        try {
            DesignSurface<?> surface2;
            Scene scene = this.myTree.getScene();
            DesignSurface<?> designSurface = surface2 = scene != null ? scene.getDesignSurface() : null;
            if (surface2 != null) {
                UtilsKt.addComponentsAndSelectedIfCreated(model2, this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType, surface2.getSelectionModel());
            } else {
                model2.addComponents(this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType, null);
            }
            event.accept(insertType);
            event.complete();
            model2.notifyModified(NlModel.ChangeType.DROP);
            if (scene != null) {
                scene.getDesignSurface().getSelectionModel().setSelection(this.myDragged);
                this.myTree.requestFocus();
            }
        }
        catch (Exception exception) {
            Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            event.reject();
        }
    }
}

