/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NlDropInsertionPicker {
    private final JTree myTree;

    public NlDropInsertionPicker(@NotNull NlComponentTree tree) {
        this((JTree)((Object)tree));
    }

    @VisibleForTesting
    NlDropInsertionPicker(@NotNull JTree tree) {
        this.myTree = tree;
    }

    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged) {
        return this.findInsertionPointAt(location, dragged, false);
    }

    @Nullable
    public Result findInsertionPointAt(@NotNull Point location, @NotNull List<NlComponent> dragged, boolean ignoreMissingDependency) {
        if (dragged.isEmpty()) {
            return this.findInsertionPointAt(location);
        }
        Result result = new Result();
        result.receiver = null;
        result.nextComponent = null;
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        result.row = this.myTree.getRowForPath(referencePath);
        if (referencePath == null) {
            return null;
        }
        result.depth = 1;
        Object last = referencePath.getLastPathComponent();
        if (!(last instanceof NlComponent)) {
            return null;
        }
        NlComponent receiverComponent = (NlComponent)last;
        if (this.canChangeInsertionDepth(referencePath, receiverComponent)) {
            Rectangle referenceBounds;
            TreePath parentPath;
            while ((parentPath = referencePath.getParentPath()) != null && (referenceBounds = this.myTree.getPathBounds(referencePath)) != null && this.canSelectLowerDepth(result.row, result.depth) && location.x < referenceBounds.x) {
                --result.depth;
                referencePath = parentPath;
            }
            receiverComponent = (NlComponent)referencePath.getLastPathComponent();
        }
        if (NlDropInsertionPicker.canAddComponent(receiverComponent.getModel(), receiverComponent, dragged, ignoreMissingDependency)) {
            result.receiver = receiverComponent;
            if (receiverComponent.getChildCount() != 0) {
                TreePath nextPath = this.myTree.getPathForRow(result.row + 1);
                result.nextComponent = nextPath == null ? null : (NlComponent)nextPath.getLastPathComponent();
            }
        } else {
            NlComponent parent = receiverComponent.getParent();
            --result.depth;
            if (parent == null) {
                result.receiver = receiverComponent;
            } else {
                result.receiver = parent;
                result.nextComponent = receiverComponent.getNextSibling();
                if (result.depth <= 0) {
                    this.updateInsertionPointAfterLastDescendant(referencePath, result);
                }
            }
            if (!NlDropInsertionPicker.canAddComponent(result.receiver.getModel(), result.receiver, dragged, ignoreMissingDependency)) {
                result.receiver = null;
                result.nextComponent = null;
                return null;
            }
        }
        return result;
    }

    private void updateInsertionPointAfterLastDescendant(@NotNull TreePath receiverPath, @NotNull Result result) {
        TreePath currentPath;
        TreePath lastDescendantPath = currentPath = receiverPath;
        int lastDesendantRow = result.row;
        int currentDepth = result.depth;
        Enumeration<TreePath> descendants = this.myTree.getExpandedDescendants(currentPath);
        while (descendants != null && descendants.hasMoreElements()) {
            do {
                lastDescendantPath = currentPath = descendants.nextElement();
                lastDesendantRow = Math.max(lastDesendantRow, this.myTree.getRowForPath(currentPath));
            } while (descendants.hasMoreElements());
            descendants = this.myTree.getExpandedDescendants(currentPath);
            --currentDepth;
        }
        result.row = lastDesendantRow + this.myTree.getModel().getChildCount(lastDescendantPath.getLastPathComponent());
        result.depth = currentDepth;
    }

    private Result findInsertionPointAt(@NotNull Point location) {
        TreePath path = this.myTree.getSelectionPath();
        TreePath parent = path.getParentPath();
        TreePath referencePath = this.myTree.getClosestPathForLocation(location.x, location.y);
        Result result = new Result();
        result.shouldDelegate = true;
        result.receiver = (NlComponent)parent.getLastPathComponent();
        if (referencePath == parent) {
            result.depth = 1;
            result.row = this.myTree.getRowForPath(referencePath);
            return result;
        }
        if (referencePath.getParentPath() == parent) {
            result.depth = 0;
            result.row = this.myTree.getRowForPath(referencePath);
            return result;
        }
        return null;
    }

    private boolean canChangeInsertionDepth(@NotNull TreePath path, @NotNull NlComponent component) {
        return component.getNextSibling() == null && this.myTree.getExpandedDescendants(path) == null;
    }

    private static boolean canAddComponent(@NotNull NlModel model2, @NotNull NlComponent receiver, @NotNull List<NlComponent> dragged, boolean ignoreMissingDependency) {
        return model2.canAddComponents(dragged, receiver, receiver.getChild(0), ignoreMissingDependency);
    }

    private boolean canSelectLowerDepth(int row, int relativeDepth) {
        return row == this.myTree.getRowCount() - 1 || relativeDepth > -1;
    }

    public static class Result {
        NlComponent receiver;
        NlComponent nextComponent;
        int depth;
        int row;
        boolean shouldDelegate = false;
    }
}

