/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.AndroidXConstants;
import com.android.support.AndroidxName;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import java.util.Locale;

public class ScoutMotionConvert {
    public static boolean convert(NlComponent layout2) {
        Project project = layout2.getModel().getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFile affectedFile = layout2.getBackend().getAffectedFile();
        if (affectedFile == null) {
            return false;
        }
        PsiFile layoutFile = psiManager.findFile(affectedFile);
        String fname = layoutFile.getName();
        fname = fname.substring(0, fname.lastIndexOf("."));
        Object motion_scene_name = fname + "_scene";
        if (layout2.getParent() != null) {
            Object name = layout2.getId();
            if (name == null) {
                name = layout2.assignId();
            }
            motion_scene_name = layoutFile.getName() + "_" + (String)name + "_scene";
        }
        for (NlComponent child : layout2.getChildren()) {
            String name = child.getId();
            if (name != null) continue;
            child.assignId(child.getTagName());
        }
        motion_scene_name = ((String)motion_scene_name).replace('.', '_').toLowerCase(Locale.US);
        motion_scene_name = ((String)motion_scene_name).replace(' ', '_');
        String text = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<MotionScene \n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:motion=\"http://schemas.android.com/apk/res-auto\">\n\n    <Transition\n        motion:constraintSetEnd=\"@+id/end\"\n        motion:constraintSetStart=\"@id/start\"\n        motion:duration=\"1000\">\n       <KeyFrameSet>\n       </KeyFrameSet>\n    </Transition>\n\n    <ConstraintSet android:id=\"@+id/start\">\n    </ConstraintSet>\n\n    <ConstraintSet android:id=\"@+id/end\">\n    </ConstraintSet>\n</MotionScene>";
        EditorFactory editorFactory = EditorFactory.getInstance();
        PsiDirectory xmlDir = layoutFile.getParent().getParent().findSubdirectory("xml");
        if (xmlDir == null) {
            xmlDir = layoutFile.getParent().getParent().createSubdirectory("xml");
        }
        String countStr = "";
        int count = 1;
        while (xmlDir.findFile((String)motion_scene_name + countStr + ".xml") != null) {
            countStr = Integer.toString(++count);
        }
        motion_scene_name = (String)motion_scene_name + countStr;
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText((String)motion_scene_name + ".xml", (FileType)XmlFileType.INSTANCE, (CharSequence)text);
        xmlDir.add((PsiElement)file2);
        AttributesTransaction transaction = layout2.startAttributeTransaction();
        layout2.getTag().setName(DependencyManagementUtil.mapAndroidxName((Module)layout2.getModel().getModule(), (AndroidxName)AndroidXConstants.CLASS_MOTION_LAYOUT));
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription", "@xml/" + (String)motion_scene_name);
        transaction.commit();
        return true;
    }
}

