/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

public enum Direction {
    TOP(0),
    BOTTOM(1),
    LEFT(2),
    RIGHT(3),
    BASELINE(4);

    private final int mDirection;
    static final int ORIENTATION_VERTICAL = 0;
    static final int ORIENTATION_HORIZONTAL = 1;
    private static Direction[] sAllDirections;
    private static Direction[] sVertical;
    private static Direction[] sHorizontal;

    private Direction(int n2) {
        this.mDirection = n2;
    }

    static Direction[] getAllDirections() {
        return sAllDirections;
    }

    static String toString(int directionInteger) {
        return Direction.get(directionInteger).toString();
    }

    public String toString() {
        switch (this) {
            case TOP: {
                return "N";
            }
            case BOTTOM: {
                return "S";
            }
            case RIGHT: {
                return "E";
            }
            case LEFT: {
                return "W";
            }
            case BASELINE: {
                return "B";
            }
        }
        return "?";
    }

    int getDirection() {
        return this.mDirection;
    }

    Direction getOpposite() {
        switch (this) {
            case TOP: {
                return BOTTOM;
            }
            case BOTTOM: {
                return TOP;
            }
            case RIGHT: {
                return LEFT;
            }
            case LEFT: {
                return RIGHT;
            }
            case BASELINE: {
                return BASELINE;
            }
        }
        return BASELINE;
    }

    static Direction get(int directionInteger) {
        return sAllDirections[directionInteger];
    }

    boolean reverse() {
        return this == TOP || this == LEFT;
    }

    static Direction[] getDirections(int orientation2) {
        if (orientation2 == 0) {
            return sVertical;
        }
        return sHorizontal;
    }

    public int connectTypes() {
        switch (this) {
            case TOP: 
            case BOTTOM: {
                return 2;
            }
            case RIGHT: 
            case LEFT: {
                return 2;
            }
            case BASELINE: {
                return 1;
            }
        }
        return 1;
    }

    public String getMarginString() {
        switch (this) {
            case TOP: {
                return "layout_marginTop";
            }
            case BOTTOM: {
                return "layout_marginBottom";
            }
            case RIGHT: {
                return "layout_marginRight";
            }
            case LEFT: {
                return "layout_marginLeft";
            }
        }
        return "?";
    }

    int getOrientation() {
        if (this == TOP || this == BOTTOM || this == BASELINE) {
            return 0;
        }
        return 1;
    }

    static {
        sAllDirections = Direction.values();
        sVertical = new Direction[]{TOP, BOTTOM, BASELINE};
        sHorizontal = new Direction[]{LEFT, RIGHT};
    }
}

