/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.scout.Connection;
import com.android.tools.idea.uibuilder.scout.ConstrainedWidget;
import com.android.tools.idea.uibuilder.scout.ConstraintSet;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import com.android.tools.idea.uibuilder.scout.WidgetPossibleConnections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class ConstraintSetGenerator {
    private int myNumberOfWidgets;
    private ScoutWidget[] myWidgetRecs;
    private ArrayList<WidgetPossibleConnections> myConnectionList;
    private ArrayList<ArrayList<ConstrainedWidget>> myValidWidgets;
    private ArrayList<ConstraintSet> myConstraintSets;
    public int myParentWidth = 1000;
    public int myParentHeight = 900;

    public ConstraintSetGenerator(ScoutWidget[] rectangles) {
        this.myNumberOfWidgets = rectangles.length - 1;
        this.myWidgetRecs = rectangles;
    }

    public ConstraintSet findConstraintSet() {
        this.myConnectionList = new ArrayList();
        for (int i = 1; i < this.myWidgetRecs.length; ++i) {
            WidgetPossibleConnections possibleConnections = new WidgetPossibleConnections(this.myWidgetRecs[i]);
            this.myConnectionList.add(possibleConnections);
            if (possibleConnections.getWidget().isGuideline()) continue;
            possibleConnections.generateAllConnections(this.myWidgetRecs);
        }
        this.myValidWidgets = new ArrayList();
        for (WidgetPossibleConnections widget : this.myConnectionList) {
            ArrayList<ConstrainedWidget> tempValid = this.getValidConnectionCombinations(widget);
            Collections.sort(tempValid, (a, b) -> b.compareTo((ConstrainedWidget)a));
            this.myValidWidgets.add(tempValid);
        }
        this.generateConstraintSets();
        for (ConstraintSet set : this.myConstraintSets) {
            set.calculateError();
        }
        Collections.sort(this.myConstraintSets, (a, b) -> b.compareTo((ConstraintSet)a));
        return this.myConstraintSets.get(0);
    }

    void printLists() {
        for (WidgetPossibleConnections wid : this.myConnectionList) {
            System.out.println(wid.toString());
        }
    }

    void generateConstraintSets() {
        this.myConstraintSets = new ArrayList();
        int[] minValid = new int[this.myNumberOfWidgets];
        double totalCombinations = 1.0;
        for (int i = 0; i < this.myNumberOfWidgets; ++i) {
            totalCombinations *= (double)this.myValidWidgets.get(i).size();
            minValid[i] = this.myValidWidgets.get(i).size();
        }
        CombinationGenerator gen = new CombinationGenerator(this.myNumberOfWidgets, minValid);
        long startTime = System.currentTimeMillis();
        long totalTime = 0L;
        double explored = 0.0;
        int[] combination = gen.nextPhasedCombination();
        ArrayList<ConstraintSet> generated = new ArrayList<ConstraintSet>();
        while (combination != null) {
            generated.add(new ConstraintSet(combination, this.myValidWidgets, this.myWidgetRecs[0]));
            totalTime = System.currentTimeMillis() - startTime;
            if (totalTime > 2000L) break;
            combination = gen.nextPhasedCombination();
        }
        explored = (double)generated.size() / totalCombinations;
        System.out.println("Percentage of combinations explored: " + Double.toString(explored));
        for (ConstraintSet tempSet : generated) {
            if (!tempSet.validate()) continue;
            this.myConstraintSets.add(tempSet);
        }
    }

    ArrayList<ConstrainedWidget> getValidConnectionCombinations(WidgetPossibleConnections possibleConnections) {
        ArrayList<ConstrainedWidget> validWidgets = new ArrayList<ConstrainedWidget>();
        if (possibleConnections.getWidget().isGuideline()) {
            ConstrainedWidget conWidget = new ConstrainedWidget(possibleConnections.getWidget());
            validWidgets.add(conWidget);
            return validWidgets;
        }
        for (Connection base : possibleConnections.baseline) {
            for (Connection south : possibleConnections.south) {
                for (Connection east : possibleConnections.east) {
                    for (Connection west : possibleConnections.west) {
                        for (Connection north : possibleConnections.north) {
                            if (east.destWidget() == -2 && west.destWidget() == -2 || base.destWidget() == -2 && north.destWidget() == -2 && south.destWidget() == -2 || base.destWidget() != -2 && (north.destWidget() != -2 || south.destWidget() != -2)) continue;
                            ConstrainedWidget conWidget = new ConstrainedWidget(north, south, east, west, base, possibleConnections.getWidget());
                            validWidgets.add(conWidget);
                        }
                    }
                }
            }
        }
        return validWidgets;
    }

    private class CombinationGenerator {
        private ArrayList<int[]> myGenerated;
        private int[] myMaxPhases;
        private int myPhase = 1;
        private int myWidgetNumber;
        private int myCurrent;

        public CombinationGenerator(int widgetNumber, int[] maxPhases) {
            this.myWidgetNumber = widgetNumber;
            this.myCurrent = 0;
            this.myMaxPhases = maxPhases;
            this.generateFirstPhase();
        }

        private void generateFirstPhase() {
            this.myGenerated = new ArrayList();
            this.myGenerated.add(new int[this.myWidgetNumber]);
            while (true) {
                int[] tempComb = (int[])this.myGenerated.get(this.myGenerated.size() - 1).clone();
                boolean carry = true;
                int pos = 0;
                while (carry && pos != this.myWidgetNumber) {
                    if (tempComb[pos] == 1) {
                        tempComb[pos] = 0;
                        ++pos;
                        continue;
                    }
                    if (this.myMaxPhases[pos] == 1) continue;
                    tempComb[pos] = 1;
                    carry = false;
                }
                if (carry) break;
                this.myGenerated.add(tempComb);
            }
        }

        public int[] nextPhasedCombination() {
            if (this.myCurrent > this.myGenerated.size() - 1) {
                this.generateNewPhase();
            }
            int[] comb = this.myGenerated.size() > 0 ? this.myGenerated.get(this.myCurrent) : null;
            ++this.myCurrent;
            return comb;
        }

        public void generateNewPhase() {
            ++this.myPhase;
            ArrayList<int[]> newGen = new ArrayList<int[]>(this.myGenerated);
            ArrayList<int[]> aux = new ArrayList<int[]>();
            for (int i = 0; i < this.myWidgetNumber; ++i) {
                if (this.myMaxPhases[i] <= this.myPhase) continue;
                for (int[] existing : newGen) {
                    int[] temp = (int[])existing.clone();
                    temp[i] = this.myPhase;
                    if (aux.stream().anyMatch(p -> Arrays.equals(p, temp))) continue;
                    aux.add(temp);
                }
                newGen.addAll(aux);
                aux.clear();
            }
            newGen.subList(0, this.myGenerated.size()).clear();
            this.myGenerated = newGen;
            this.myCurrent = 0;
        }
    }
}

