/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00010B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0&2\u0006\u0010(\u001a\u00020)H\u0002J*\u0010*\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010,0+0&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J0\u0010-\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0006\u0012\u0004\u0018\u00010$0+0&2\b\u0010.\u001a\u0004\u0018\u00010'2\u0006\u0010/\u001a\u00020\u0019H\u0002R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/android/tools/idea/uibuilder/palette/PreviewProvider;", "", "myDesignSurfaceSupplier", "Ljava/util/function/Supplier;", "Lcom/android/tools/idea/common/surface/DesignSurface;", "myDependencyManager", "Lcom/android/tools/idea/uibuilder/palette/DependencyManager;", "(Ljava/util/function/Supplier;Lcom/android/tools/idea/uibuilder/palette/DependencyManager;)V", "currentScale", "", "getCurrentScale", "()Ljava/lang/Double;", "renderTimeoutMillis", "", "getRenderTimeoutMillis$annotations", "()V", "getRenderTimeoutMillis", "()J", "setRenderTimeoutMillis", "(J)V", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "getSceneView", "()Lcom/android/tools/idea/common/surface/SceneView;", "constructPreviewXml", "", "scene", "item", "Lcom/android/tools/idea/uibuilder/palette/Palette$Item;", "createPreview", "Lcom/android/tools/idea/uibuilder/palette/PreviewProvider$ImageAndDimension;", "component", "Ljavax/swing/JComponent;", "extractImage", "Ljava/awt/image/BufferedImage;", "result", "Lcom/android/tools/idea/rendering/RenderResult;", "getRenderTask", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/rendering/RenderTask;", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "renderDragImage", "Lkotlin/Pair;", "Ljava/util/concurrent/Future;", "renderImage", "renderTask", "xml", "ImageAndDimension", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nPreviewProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewProvider.kt\ncom/android/tools/idea/uibuilder/palette/PreviewProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,218:1\n1#2:219\n9#3:220\n21#3:221\n*S KotlinDebug\n*F\n+ 1 PreviewProvider.kt\ncom/android/tools/idea/uibuilder/palette/PreviewProvider\n*L\n144#1:220\n203#1:221\n*E\n"})
public final class PreviewProvider {
    @NotNull
    private final Supplier<DesignSurface<?>> myDesignSurfaceSupplier;
    @NotNull
    private final DependencyManager myDependencyManager;
    private long renderTimeoutMillis;

    public PreviewProvider(@NotNull Supplier<DesignSurface<?>> myDesignSurfaceSupplier, @NotNull DependencyManager myDependencyManager) {
        Intrinsics.checkNotNullParameter(myDesignSurfaceSupplier, (String)"myDesignSurfaceSupplier");
        Intrinsics.checkNotNullParameter((Object)myDependencyManager, (String)"myDependencyManager");
        this.myDesignSurfaceSupplier = myDesignSurfaceSupplier;
        this.myDependencyManager = myDependencyManager;
        this.renderTimeoutMillis = 600L;
    }

    public final long getRenderTimeoutMillis() {
        return this.renderTimeoutMillis;
    }

    public final void setRenderTimeoutMillis(long l) {
        this.renderTimeoutMillis = l;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRenderTimeoutMillis$annotations() {
    }

    @NotNull
    public final ImageAndDimension createPreview(@NotNull JComponent component, @NotNull Palette.Item item) {
        Image image;
        Pair pair;
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Dimension size = null;
        Image image2 = null;
        ScaleContext scaleContext = ScaleContext.create((Component)component);
        Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"create(component)");
        ScaleContext scaleContext2 = scaleContext;
        CompletableFuture<Pair<BufferedImage, Future<?>>> future2 = this.myDependencyManager.needsLibraryLoad(item) ? null : this.renderDragImage(item);
        try {
            CompletableFuture<Pair<BufferedImage, Future<?>>> completableFuture = future2;
            pair2 = completableFuture != null ? completableFuture.get(this.renderTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        }
        catch (Exception exception) {
            pair2 = null;
        }
        if ((pair = pair2) == null) {
            pair = new Pair(null, null);
        }
        Pair pair3 = pair;
        BufferedImage renderedItem = (BufferedImage)pair3.component1();
        Future disposal = (Future)pair3.component2();
        if (renderedItem == null) {
            Icon icon2 = item.getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"item.icon");
            Icon icon3 = icon2;
            image = IconLoader.toImage((Icon)icon3, (ScaleContext)scaleContext2);
        } else {
            image = ImageUtil.ensureHiDPI((Image)renderedItem, (ScaleContext)scaleContext2);
        }
        Image image3 = image2 = image;
        Intrinsics.checkNotNull((Object)image3);
        int width2 = ImageUtil.getRealWidth((Image)image3);
        int height2 = ImageUtil.getRealHeight((Image)image2);
        Double d = this.getCurrentScale();
        image2 = ImageUtil.scaleImage((Image)image2, (double)(d != null ? d : 1.0));
        size = new Dimension(width2, height2);
        boolean inUserScale = !SystemInfo.isWindows || !StartupUiUtil.isJreHiDPI((Component)component);
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image2, (boolean)inUserScale);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"toBufferedImage(image, inUserScale)");
        BufferedImage bufferedImage2 = bufferedImage;
        return new ImageAndDimension(bufferedImage2, size, (Future)future2, disposal);
    }

    @VisibleForTesting
    private final CompletableFuture<Pair<BufferedImage, Future<?>>> renderDragImage(Palette.Item item) {
        Object object;
        SceneView scene;
        block3: {
            block2: {
                scene = this.getSceneView();
                object = scene;
                if (object == null) break block2;
                SceneView it = object;
                boolean bl = false;
                String string = this.constructPreviewXml(it, item);
                object = string;
                if (string != null) break block3;
            }
            CompletableFuture<Pair<BufferedImage, Future<?>>> completableFuture = CompletableFuture.completedFuture(new Pair(null, null));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Pair(null, null))");
            return completableFuture;
        }
        Object xml = object;
        Configuration configuration = scene.getSceneManager().getModel().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"scene.sceneManager.model.configuration");
        CompletionStage completionStage = ((CompletableFuture)this.getRenderTask(configuration).thenCompose(new Function(this, (String)xml){
            final /* synthetic */ PreviewProvider this$0;
            final /* synthetic */ String $xml;
            {
                this.this$0 = $receiver;
                this.$xml = $xml;
            }

            public final CompletionStage<Pair<RenderTask, RenderResult>> apply(@Nullable RenderTask renderTask) {
                return PreviewProvider.access$renderImage(this.this$0, renderTask, this.$xml);
            }
        })).thenApply(new Function(this){
            final /* synthetic */ PreviewProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public final Pair<BufferedImage, Future<?>> apply(Pair<? extends RenderTask, ? extends RenderResult> pair) {
                BufferedImage bufferedImage;
                RenderResult renderResult;
                RenderTask renderTask = (RenderTask)pair.component1();
                RenderResult renderResult2 = renderResult = (RenderResult)pair.component2();
                if (renderResult2 != null) {
                    RenderResult renderResult3 = renderResult2;
                    PreviewProvider previewProvider2 = this.this$0;
                    RenderResult it = renderResult3;
                    boolean bl = false;
                    bufferedImage = PreviewProvider.access$extractImage(previewProvider2, it);
                } else {
                    bufferedImage = null;
                }
                BufferedImage image = bufferedImage;
                RenderTask renderTask2 = renderTask;
                Future<V> disposal = renderTask2 != null ? renderTask2.dispose() : null;
                return new Pair((Object)image, (Object)disposal);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"@VisibleForTesting\n  pri\u2026ge, disposal)\n      }\n  }");
        return completionStage;
    }

    private final String constructPreviewXml(SceneView scene, Palette.Item item) {
        XmlTag xmlTag;
        NlModel nlModel = scene.getSceneManager().getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"scene.sceneManager.model");
        NlModel model2 = nlModel;
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)model2.getProject());
        String string = item.getDragPreviewXml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.dragPreviewXml");
        String xml = string;
        if (Intrinsics.areEqual((Object)xml, (Object)"")) {
            return null;
        }
        try {
            xmlTag = elementFactory.createTagFromText((CharSequence)xml);
        }
        catch (IncorrectOperationException exception) {
            return null;
        }
        XmlTag xmlTag2 = xmlTag;
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"try {\n      elementFacto\u2026{\n      return null\n    }");
        XmlTag tag = xmlTag2;
        boolean $i$f$runWriteAction = false;
        NlComponent nlComponent = (NlComponent)ApplicationManager.getApplication().runWriteAction(new Computable(model2, tag){
            final /* synthetic */ NlModel $model$inlined;
            final /* synthetic */ XmlTag $tag$inlined;
            {
                this.$model$inlined = nlModel;
                this.$tag$inlined = xmlTag;
            }

            public final T compute() {
                boolean bl = false;
                return (T)this.$model$inlined.createComponent(this.$tag$inlined, null, null, InsertType.CREATE_PREVIEW);
            }
        });
        if (nlComponent == null) {
            return null;
        }
        NlComponent component = nlComponent;
        XmlTag xmlTag3 = component.getTag();
        if (xmlTag3 == null) {
            return null;
        }
        XmlTag componentTag = xmlTag3;
        String string2 = "<LinearLayout\n    xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    android:id=\"@+id/%1$s\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:orientation=\"vertical\">\n  %2$s\n</LinearLayout>\n";
        Object[] objectArray = new Object[]{"TopLevelContainer", componentTag.getText()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        return string3;
    }

    private final CompletableFuture<RenderTask> getRenderTask(Configuration configuration) {
        Module module = configuration.getModule();
        if (module == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
            return completableFuture;
        }
        Module module2 = module;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
            return completableFuture;
        }
        AndroidFacet facet = androidFacet;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        RenderService renderService = StudioRenderService.Companion.getInstance(project);
        CompletableFuture completableFuture = StudioRenderServiceKt.taskBuilder((RenderService)renderService, (AndroidFacet)facet, (Configuration)configuration).build();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"renderService.taskBuilde\u2026t, configuration).build()");
        return completableFuture;
    }

    private final BufferedImage extractImage(RenderResult result) {
        BufferedImage bufferedImage;
        ImagePool.Image image = result.getRenderedImage();
        Intrinsics.checkNotNullExpressionValue((Object)image, (String)"result.renderedImage");
        ImagePool.Image image2 = image;
        if (!image2.isValid()) {
            return null;
        }
        ImmutableList immutableList = result.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"result.rootViews");
        Object object = (ViewInfo)CollectionsKt.firstOrNull((List)((List)immutableList));
        if (object == null || (object = object.getChildren()) == null || (object = (ViewInfo)CollectionsKt.firstOrNull((List)object)) == null) {
            return null;
        }
        Object view2 = object;
        if (image2.getHeight() < view2.getBottom() || image2.getWidth() < view2.getRight() || view2.getBottom() <= view2.getTop() || view2.getRight() <= view2.getLeft()) {
            return null;
        }
        SceneView sceneView = this.getSceneView();
        if (sceneView == null) {
            return null;
        }
        SceneView scene = sceneView;
        int shadowIncrement = 1 + Coordinates.getSwingDimension(scene, 6);
        BufferedImage bufferedImage2 = image2.getCopy();
        if (bufferedImage2 == null) {
            return null;
        }
        BufferedImage imageCopy = bufferedImage2;
        try {
            bufferedImage = imageCopy.getSubimage(view2.getLeft(), view2.getTop(), Math.min(view2.getRight() + shadowIncrement, image2.getWidth()), Math.min(view2.getBottom() + shadowIncrement, image2.getHeight()));
        }
        catch (RasterFormatException ignore2) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    private final Double getCurrentScale() {
        DesignSurface<?> designSurface = this.myDesignSurfaceSupplier.get();
        if (designSurface != null) {
            DesignSurface<?> it = designSurface;
            boolean bl = false;
            Object object = StudioFlags.NELE_DP_SIZED_PREVIEW.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_DP_SIZED_PREVIEW.get()");
            if (((Boolean)object).booleanValue()) {
                Object object2 = it.getFocusedSceneView();
                float sceneScale = object2 != null && (object2 = ((SceneView)object2).getSceneManager()) != null ? ((SceneManager)object2).getSceneScalingFactor() : 1.0f;
                return it.getScale() * it.getScreenScalingFactor() / (double)sceneScale;
            }
            return it.getScale() * it.getScreenScalingFactor();
        }
        return null;
    }

    private final SceneView getSceneView() {
        DesignSurface<?> designSurface = this.myDesignSurfaceSupplier.get();
        return designSurface != null ? designSurface.getFocusedSceneView() : null;
    }

    private final CompletableFuture<Pair<RenderTask, RenderResult>> renderImage(RenderTask renderTask, String xml) {
        if (renderTask == null) {
            CompletableFuture<Pair<RenderTask, RenderResult>> completableFuture = CompletableFuture.completedFuture(new Pair(null, null));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Pair(null, null))");
            return completableFuture;
        }
        boolean $i$f$runReadAction = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable(renderTask, xml){
            final /* synthetic */ RenderTask $renderTask$inlined;
            final /* synthetic */ String $xml$inlined;
            {
                this.$renderTask$inlined = renderTask;
                this.$xml$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                return (T)PsiFileFactory.getInstance((Project)this.$renderTask$inlined.getContext().getModule().getProject()).createFileFromText("preview.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)this.$xml$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction {\n      Ps\u2026Type.INSTANCE, xml)\n    }");
        PsiFile file2 = (PsiFile)object;
        boolean bl = file2 instanceof XmlFile;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        renderTask.setXmlFile((RenderXmlFile)new PsiXmlFile((XmlFile)file2));
        renderTask.setTransparentBackground();
        renderTask.setDecorations(false);
        renderTask.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
        renderTask.getContext().setFolderType(ResourceFolderType.LAYOUT);
        renderTask.inflate();
        CompletionStage completionStage = renderTask.render().thenApply(new Function(renderTask){
            final /* synthetic */ RenderTask $renderTask;
            {
                this.$renderTask = $renderTask;
            }

            public final Pair<RenderTask, RenderResult> apply(RenderResult result) {
                return new Pair((Object)this.$renderTask, (Object)result);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"renderTask: RenderTask?,\u2026air(renderTask, result) }");
        return completionStage;
    }

    public static final /* synthetic */ CompletableFuture access$renderImage(PreviewProvider $this, RenderTask renderTask, String xml) {
        return $this.renderImage(renderTask, xml);
    }

    public static final /* synthetic */ BufferedImage access$extractImage(PreviewProvider $this, RenderResult result) {
        return $this.extractImage(result);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/uibuilder/palette/PreviewProvider$ImageAndDimension;", "", "image", "Ljava/awt/image/BufferedImage;", "dimension", "Ljava/awt/Dimension;", "rendering", "Ljava/util/concurrent/Future;", "disposal", "(Ljava/awt/image/BufferedImage;Ljava/awt/Dimension;Ljava/util/concurrent/Future;Ljava/util/concurrent/Future;)V", "getDimension", "()Ljava/awt/Dimension;", "getDisposal", "()Ljava/util/concurrent/Future;", "getImage", "()Ljava/awt/image/BufferedImage;", "getRendering", "intellij.android.designer"})
    public static final class ImageAndDimension {
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Dimension dimension;
        @Nullable
        private final Future<?> rendering;
        @Nullable
        private final Future<?> disposal;

        public ImageAndDimension(@NotNull BufferedImage image, @NotNull Dimension dimension, @Nullable Future<?> rendering, @Nullable Future<?> disposal) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            this.image = image;
            this.dimension = dimension;
            this.rendering = rendering;
            this.disposal = disposal;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public final Dimension getDimension() {
            return this.dimension;
        }

        @Nullable
        public final Future<?> getRendering() {
            return this.rendering;
        }

        @Nullable
        public final Future<?> getDisposal() {
            return this.disposal;
        }
    }
}

