/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.ListWithMargin;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ItemList
extends ListWithMargin<Palette.Item> {
    private final DependencyManager myDependencyManager;

    public ItemList(@NotNull DependencyManager dependencyManager) {
        this.myDependencyManager = dependencyManager;
        this.setCellRenderer(new ItemCellRenderer());
    }

    public void setEmptyText(@NotNull Pair<String, String> text) {
        StatusText status2 = this.getEmptyText();
        status2.clear();
        status2.appendText((String)text.first);
        status2.appendSecondaryText((String)text.second, StatusText.DEFAULT_ATTRIBUTES, null);
    }

    @Override
    protected int getRightMarginWidth() {
        return StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD.getIconWidth();
    }

    private boolean displayFittedTextIfNecessary(int index) {
        return !UIUtil.isClientPropertyTrue((Object)((Object)this), (Object)ExpandableItemsHandler.EXPANDED_RENDERER) && !this.getExpandableItemsHandler().getExpandedItems().contains(index);
    }

    private boolean displayDownloadIcon(@NotNull Palette.Item item, int index) {
        return this.myDependencyManager.needsLibraryLoad(item) && this.displayFittedTextIfNecessary(index);
    }

    private static class ItemCellRenderer
    implements ListCellRenderer<Palette.Item> {
        private final ItemPanelRenderer myPanel = new ItemPanelRenderer();
        private final JBLabel myDownloadIcon = new JBLabel();
        private final TextCellRenderer myTextRenderer = new TextCellRenderer();

        private ItemCellRenderer() {
            this.myPanel.add((Component)((Object)this.myTextRenderer), "Center");
            this.myPanel.add((Component)this.myDownloadIcon, "East");
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends Palette.Item> list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            this.myTextRenderer.getListCellRendererComponent(list, item, index, selected, hasFocus);
            this.myPanel.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null);
            this.myPanel.setForeground(UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus));
            this.myPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
            this.myPanel.setListSize(list.getWidth(), list.getHeight());
            ItemList itemList = (ItemList)((Object)list);
            this.myDownloadIcon.setVisible(itemList.displayDownloadIcon(item, index));
            this.myDownloadIcon.setIcon(selected && hasFocus ? StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD_SELECTED : StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD);
            this.myDownloadIcon.setToolTipText("Add Project Dependency");
            this.myPanel.setToolTipText(item.getTitle());
            return this.myPanel;
        }
    }

    private static class ItemPanelRenderer
    extends JPanel {
        private int myWidth;
        private int myHeight;

        private ItemPanelRenderer() {
            super(new BorderLayout());
        }

        private void setListSize(int width2, int height2) {
            this.myWidth = width2;
            this.myHeight = height2;
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            this.setSize(this.myWidth, this.myHeight);
            this.doLayout();
            Rectangle bounds2 = new Rectangle();
            for (int index = 0; index < this.getComponentCount(); ++index) {
                JComponent component = (JComponent)this.getComponent(index);
                component.getBounds(bounds2);
                if (!bounds2.contains(event.getX(), event.getY())) continue;
                return component.getToolTipText();
            }
            return this.getToolTipText();
        }
    }

    private static class TextCellRenderer
    extends ColoredListCellRenderer<Palette.Item> {
        private TextCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Palette.Item> list, @NotNull Palette.Item item, int index, boolean selected, boolean hasFocus) {
            ItemList itemList = (ItemList)((Object)list);
            Icon icon2 = item.getIcon();
            String text = item.getTitle();
            if (itemList.displayFittedTextIfNecessary(index)) {
                int leftMargin = icon2.getIconWidth() + this.myIconTextGap + this.getIpad().right + this.getIpad().left;
                int rightMargin = StudioIcons.LayoutEditor.Extras.PALETTE_DOWNLOAD.getIconWidth();
                text = AdtUiUtils.shrinkToFit((String)text, s -> list.getFontMetrics(list.getFont()).stringWidth((String)s) <= list.getWidth() - leftMargin - rightMargin);
            }
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null);
            this.mySelectionForeground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            this.setIcon(selected && hasFocus && !ExperimentalUI.isNewUI() ? ColoredIconGenerator.generateWhiteIcon((Icon)icon2) : icon2);
            this.append(text);
        }
    }
}

