/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionDesignSurfaceEdits;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property.CustomAttributeType;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionDefaultPropertyValueProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property.Navigation;
import com.android.tools.idea.uibuilder.property.NlPropertiesModel;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.panel.api.PropertiesTable;
import com.android.tools.property.panel.api.PropertyItem;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.ptable.PTableItem;
import com.google.common.base.Predicates;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function0;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutAttributesModel
extends NlPropertiesModel {
    private final MotionLayoutPropertyProvider myMotionLayoutPropertyProvider = (MotionLayoutPropertyProvider)this.getProvider();
    private Map<String, PropertiesTable<NlPropertyItem>> myAllProperties;

    public MotionLayoutAttributesModel(@NotNull Disposable parentDisposable, @NotNull AndroidFacet facet, @NotNull MergingUpdateQueue updateQueue) {
        super(parentDisposable, new MotionLayoutPropertyProvider(facet), facet, updateQueue, false);
        this.setDefaultValueProvider(new MotionDefaultPropertyValueProvider());
    }

    public Map<String, PropertiesTable<NlPropertyItem>> getAllProperties() {
        return this.myAllProperties;
    }

    @Override
    protected void loadProperties(@Nullable Object accessoryType, @Nullable Object accessory, @NotNull List<? extends NlComponent> components, @NotNull Function0<Boolean> wantUpdate2) {
        if (accessoryType == null || accessory == null || !((Boolean)wantUpdate2.invoke()).booleanValue()) {
            return;
        }
        MotionEditorSelector.Type type = (MotionEditorSelector.Type)((Object)accessoryType);
        MTag[] tags2 = (MTag[])accessory;
        MotionSelection selection = new MotionSelection(type, tags2, components);
        MotionSelection sameOldSelection = this.findSameOldSelection(selection);
        if (sameOldSelection != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (((Boolean)wantUpdate2.invoke()).booleanValue()) {
                    sameOldSelection.update(selection);
                    this.firePropertyValueChanged();
                }
            });
            return;
        }
        this.setLastUpdateCompleted(false);
        Callable<Map> getProperties2 = () -> {
            Map<String, PropertiesTable<NlPropertyItem>> newProperties = this.myMotionLayoutPropertyProvider.getAllProperties(this, selection);
            return newProperties;
        };
        Consumer<Map> notifyUI2 = newProperties -> {
            try {
                if (((Boolean)wantUpdate2.invoke()).booleanValue()) {
                    this.updateLiveListeners(components);
                    PropertiesTable first = newProperties.isEmpty() ? PropertiesTable.Companion.emptyTable() : (PropertiesTable)newProperties.values().iterator().next();
                    this.myAllProperties = newProperties;
                    this.setProperties((PropertiesTable<NlPropertyItem>)first);
                    this.firePropertiesGenerated();
                }
            }
            finally {
                this.setUpdateCount(this.getUpdateCount() + 1);
                this.setLastUpdateCompleted(true);
            }
        };
        ReadAction.nonBlocking(getProperties2).inSmartMode(this.getProject()).expireWith((Disposable)this).finishOnUiThread(ModalityState.defaultModalityState(), notifyUI2).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    private MotionSelection findSameOldSelection(@NotNull MotionSelection selection) {
        if (this.myAllProperties == null) {
            return null;
        }
        PropertiesTable nonEmptyTable = this.myAllProperties.values().stream().filter(table -> !table.isEmpty()).findFirst().orElse(null);
        if (nonEmptyTable == null) {
            return null;
        }
        NlPropertyItem property = (NlPropertyItem)nonEmptyTable.getFirst();
        if (property == null) {
            Logger.getInstance(MotionLayoutAttributesModel.class).info("This table should not be empty!");
            return null;
        }
        MotionSelection oldSelection = MotionLayoutAttributesModel.getMotionSelection(property);
        return oldSelection != null && oldSelection.sameSelection(selection) ? oldSelection : null;
    }

    @Override
    @Nullable
    public String getPropertyValue(@NotNull NlPropertyItem property) {
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property);
        String subTag = MotionLayoutAttributesModel.getSubTag(property);
        if (selection == null) {
            return null;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            if (property.getNamespace().equals("http://schemas.android.com/apk/res/android") && property.getName().equals("id")) {
                return selection.getComponentId();
            }
            return null;
        }
        if (subTag != null && subTag.equals("CustomAttribute")) {
            MTag customTag = MotionLayoutAttributesModel.findCustomTag(motionTag, property.getName());
            return customTag != null ? customTag.getAttributeValue(MotionLayoutPropertyProvider.mapToCustomType(property.getType())) : null;
        }
        if (subTag == null) {
            return motionTag.getAttributeValue(property.getName());
        }
        MotionSceneTag sectionTag = MotionLayoutAttributesModel.getSubTag(motionTag, subTag);
        if (sectionTag == null) {
            return null;
        }
        return sectionTag.getAttributeValue(property.getName());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.myAllProperties = Collections.emptyMap();
    }

    @Override
    @Nullable
    public XmlTag getPropertyTag(@NotNull NlPropertyItem property) {
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property);
        if (selection == null) {
            return null;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            return null;
        }
        return selection.getXmlTag(motionTag);
    }

    @Override
    public void setPropertyValue(@NotNull NlPropertyItem property, @Nullable String newValue) {
        String attributeName = property.getName();
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property);
        String subTagName = MotionLayoutAttributesModel.getSubTag(property);
        MTag.TagWriter tagWriter = null;
        if (selection == null) {
            return;
        }
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            tagWriter = MotionLayoutAttributesModel.createConstraintTag(selection);
        } else if (subTagName != null && subTagName.equals("CustomAttribute")) {
            MTag customTag = MotionLayoutAttributesModel.findCustomTag(motionTag, property.getName());
            if (customTag != null) {
                tagWriter = MotionSceneUtils.getTagWriter(customTag);
                attributeName = MotionLayoutPropertyProvider.mapToCustomType(property.getType());
            }
        } else if (subTagName == null) {
            tagWriter = MotionSceneUtils.getTagWriter(motionTag);
        } else if (selection.getType() == MotionEditorSelector.Type.CONSTRAINT || selection.getType() == MotionEditorSelector.Type.TRANSITION) {
            MotionSceneTag sectionTag = MotionLayoutAttributesModel.getSubTag(motionTag, subTagName);
            if (sectionTag != null) {
                tagWriter = MotionSceneUtils.getTagWriter(sectionTag);
            } else if (newValue != null) {
                tagWriter = MotionLayoutAttributesModel.createSubTag(selection, motionTag, subTagName);
            }
        }
        if (tagWriter != null) {
            tagWriter.setAttribute(property.getNamespace(), attributeName, newValue);
            tagWriter.commit(String.format("Set %1$s.%2$s to %3$s", tagWriter.getTagName(), property.getName(), newValue));
        }
    }

    @Override
    public void browseToValue(@NotNull NlPropertyItem property) {
        Navigation.INSTANCE.browseToValue(property);
    }

    public static MTag.TagWriter createSubTag(@NotNull MotionSelection selection, @NotNull MotionSceneTag constraintTag, @NotNull String section) {
        MTag.TagWriter tagWriter = MotionSceneUtils.getChildTagWriter(constraintTag, section);
        MotionAttributes attrs = selection.getMotionAttributes();
        if (attrs != null) {
            Predicate<MotionAttributes.DefinedAttribute> isApplicable = MotionLayoutAttributesModel.findIncludePredicate(section);
            for (MotionAttributes.DefinedAttribute attr2 : attrs.getAttrMap().values()) {
                if (!isApplicable.test(attr2)) continue;
                tagWriter.setAttribute(attr2.getNamespace(), attr2.getName(), attr2.getValue());
            }
        }
        return tagWriter;
    }

    private static Predicate<MotionAttributes.DefinedAttribute> findIncludePredicate(@NotNull String sectionName) {
        switch (sectionName) {
            case "Layout": {
                return attr2 -> attr2.isLayoutAttribute();
            }
            case "PropertySet": {
                return attr2 -> attr2.isPropertySetAttribute();
            }
            case "Transform": {
                return attr2 -> attr2.isTransformAttribute();
            }
            case "Motion": {
                return attr2 -> attr2.isMotionAttribute();
            }
        }
        return Predicates.alwaysFalse();
    }

    public void addCustomProperty(@NotNull String attributeName, @NotNull String value2, @NotNull CustomAttributeType type, @NotNull MotionSelection selection, @NotNull TableLineModel lineModel) {
        Consumer<MotionSceneTag> applyToModel = newCustomTag -> {
            NlPropertyItem newProperty2 = MotionLayoutPropertyProvider.createCustomProperty(attributeName, type.getTagName(), selection, this);
            lineModel.addItem((PTableItem)newProperty2);
            PropertiesTable customProperties = this.getAllProperties().get("CustomAttribute");
            if (customProperties == null) {
                HashBasedTable customTable = HashBasedTable.create((int)3, (int)10);
                customProperties = PropertiesTable.Companion.create((Table)customTable);
                this.getAllProperties().put("CustomAttribute", (PropertiesTable<NlPropertyItem>)customProperties);
            }
            customProperties.put((PropertyItem)newProperty2);
        };
        this.createCustomXmlTag(selection, attributeName, value2, type, applyToModel);
    }

    public void createCustomXmlTag(@NotNull MotionSelection selection, @NotNull String attrName, @NotNull String value2, @NotNull CustomAttributeType type, @NotNull Consumer<MotionSceneTag> operation) {
        String valueAttrName = type.getTagName();
        String newValue = StringUtil.isNotEmpty((String)value2) ? value2 : type.getDefaultValue();
        String commandName = String.format("Set %1$s.%2$s to %3$s", "CustomAttribute", attrName, newValue);
        MTag.TagWriter tagWriter = null;
        MTag oldCustomTag = null;
        MotionSceneTag motionTag = selection.getMotionSceneTag();
        if (motionTag == null) {
            tagWriter = MotionLayoutAttributesModel.createConstraintTag(selection);
            if (tagWriter == null) {
                return;
            }
        } else {
            oldCustomTag = MotionLayoutAttributesModel.findCustomTag(motionTag, attrName);
        }
        MTag.TagWriter constraintWriter = tagWriter;
        tagWriter = tagWriter != null ? tagWriter.getChildTagWriter("CustomAttribute") : (oldCustomTag != null ? oldCustomTag.getTagWriter() : motionTag.getChildTagWriter("CustomAttribute"));
        tagWriter.setAttribute("http://schemas.android.com/apk/res-auto", "attributeName", attrName);
        tagWriter.setAttribute("http://schemas.android.com/apk/res-auto", valueAttrName, newValue);
        if (oldCustomTag != null) {
            for (String attr2 : MotionSceneAttrs.ourCustomAttribute) {
                if (attr2 == valueAttrName) continue;
                tagWriter.setAttribute("http://schemas.android.com/apk/res-auto", attr2, null);
            }
        }
        MTag.TagWriter committer = constraintWriter != null ? constraintWriter : tagWriter;
        Runnable transaction = () -> {
            MTag createdCustomTag = committer.commit(commandName);
            if (!createdCustomTag.getTagName().equals("CustomAttribute")) {
                createdCustomTag = createdCustomTag.getChildTags("CustomAttribute")[0];
            }
            operation.accept((MotionSceneTag)createdCustomTag);
        };
        ApplicationManager.getApplication().assertIsDispatchThread();
        WriteCommandAction.runWriteCommandAction((Project)this.getFacet().getModule().getProject(), (String)commandName, null, (Runnable)transaction, (PsiFile[])new PsiFile[]{selection.getSceneFile()});
    }

    private static MTag.TagWriter createConstraintTag(@NotNull MotionSelection selection) {
        if (selection.getType() != MotionEditorSelector.Type.CONSTRAINT) {
            return null;
        }
        MotionAttributes attrs = selection.getMotionAttributes();
        if (attrs == null) {
            return null;
        }
        MTag constraintSetTag = attrs.getConstraintSet();
        if (constraintSetTag == null) {
            return null;
        }
        MTag.TagWriter tagWriter = constraintSetTag.getChildTagWriter("Constraint");
        if (tagWriter == null) {
            return null;
        }
        tagWriter.setAttribute("http://schemas.android.com/apk/res/android", "id", selection.getComponentId());
        for (MotionAttributes.DefinedAttribute attr2 : attrs.getAttrMap().values()) {
            tagWriter.setAttribute(attr2.getNamespace(), attr2.getName(), attr2.getValue());
        }
        return tagWriter;
    }

    @Override
    protected boolean wantSelectionUpdate(@Nullable DesignSurface<?> surface2, @Nullable DesignSurface<?> activeSurface, @Nullable AccessoryPanelInterface panel, @Nullable AccessoryPanelInterface activePanel, @Nullable Object selectedAccessoryType, @Nullable Object selectedAccessory) {
        return surface2 != null && surface2 == activeSurface && panel instanceof MotionDesignSurfaceEdits && panel == activePanel && selectedAccessoryType != null && selectedAccessory != null;
    }

    @Nullable
    public static MotionSelection getMotionSelection(@NotNull NlPropertyItem property) {
        return (MotionSelection)property.getOptionalValue1();
    }

    @Nullable
    public static String getSubTag(@NotNull NlPropertyItem property) {
        return (String)property.getOptionalValue2();
    }

    @Nullable
    public static MTag findCustomTag(MotionSceneTag motionTag, @Nullable String attrName) {
        if (attrName == null) {
            return null;
        }
        return Arrays.stream(motionTag.getChildTags("CustomAttribute")).filter(child -> attrName.equals(child.getAttributeValue("attributeName"))).findFirst().orElse(null);
    }

    @Nullable
    public static MotionSceneTag getSubTag(@NotNull MotionSceneTag constraint, @NotNull String sectionTagName) {
        MTag[] tags2 = constraint.getChildTags(sectionTagName);
        if (tags2.length == 0 || !(tags2[0] instanceof MotionSceneTag)) {
            return null;
        }
        return (MotionSceneTag)tags2[0];
    }
}

