/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScenePicker;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.StringMTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Drawing;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class OverviewPanel
extends JPanel {
    public static final boolean DEBUG = false;
    private static final int ROUND_SIZE = 5;
    private static final int MAX_OPTIMIZE_LINES = 7;
    static Font ourBaseFont = new Font("SansSerif", 1, 12);
    MEScenePicker picker = new MEScenePicker();
    MTag mMotionScene;
    MTag[] mConstraintSet;
    MTag[] mTransitions;
    int[] mTransitionStart;
    int[] mTransitionEnd;
    int[] mOnActionSize;
    String[] mConstraintSetNames;
    int mTransitionSelected = -1;
    int mConstraintSetSelected = -1;
    private MTag mLayout;
    MTagActionListener mListener;
    private Stroke mThickStroke = new BasicStroke(2.0f);
    private Stroke mDashStroke = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f, 5.0f}, 0.0f);
    GeneralPath mPath = new GeneralPath();
    int mRectPathLen = 4;
    int[] mRectPathX = new int[this.mRectPathLen];
    int[] mRectPathY = new int[this.mRectPathLen];
    private boolean mComputedDerivedLines = false;
    private static int MIN_CS_WIDTH = MEUI.scale(50);
    private static int MAX_CS_WIDTH = MEUI.scale(80);
    boolean mHighlightStart = false;
    boolean mHighlightEnd = false;
    private static final String MAIN_TOOL_TIP = null;
    private static int CS_GAP = MEUI.scale(20);
    private static int ARROW_HEIGHT = 10;
    private int arrow_spacing;
    private MTag mMouseOverObject;
    private static final Stroke ourFatStroke = new BasicStroke(5.0f);
    private static final Stroke ourSelectedStroke = new BasicStroke(2.0f);
    private MTag mMouseOverDerived;
    private float mTransitionProgress = Float.NaN;
    private boolean mControlDown = false;
    private final ActionGroup myActionGroup;
    private boolean mTransitionHovered = false;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private boolean mShowSaveGif = (Boolean)StudioFlags.NELE_MOTION_SAVE_GIF.get();
    DerivedSetLine[] mDerivedLines = new DerivedSetLine[10];
    int mTotalDerivedLines;
    int cs_width;
    int cs_height;

    public void setTransitionProgress(float pos) {
        this.mTransitionProgress = pos;
        this.repaint();
    }

    public void setActionListener(MTagActionListener l) {
        this.mListener = l;
    }

    public OverviewPanel() {
        for (int i = 0; i < this.mDerivedLines.length; ++i) {
            this.mDerivedLines[i] = new DerivedSetLine();
        }
        this.mTotalDerivedLines = 0;
        this.setBackground(MEUI.ourPrimaryPanelBackground);
        this.myActionGroup = this.createPopupActionGroup();
        this.setToolTipText("OverViewPanel showing ConstraintSets and Transitions");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1 && OverviewPanel.this.mTransitionHovered && OverviewPanel.this.mShowSaveGif) {
                    OverviewPanel.this.showPopupMenu(e);
                    return;
                }
                OverviewPanel.this.requestFocusInWindow();
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                OverviewPanel.this.mControlDown = e.isControlDown();
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), true);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), false);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                OverviewPanel.this.updateFromMouse(e.getX(), e.getY(), false);
            }
        });
        this.picker.setSelectListener(new MEScenePicker.HitElementListener(){

            @Override
            public void over(Object over, double dist) {
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int flag;
                OverviewPanel.this.mControlDown = e.isControlDown();
                int n = flag = OverviewPanel.this.mControlDown ? 1 : 0;
                if (OverviewPanel.this.mTransitionSelected >= 0) {
                    switch (e.getExtendedKeyCode()) {
                        case 8: 
                        case 127: {
                            if (OverviewPanel.this.mTransitions.length > 1) {
                                OverviewPanel.this.mListener.delete(new MTag[]{OverviewPanel.this.mTransitions[OverviewPanel.this.mTransitionSelected]}, 0);
                            } else {
                                Notification notification = new Notification("Motion Editor", "Can not remove last transition: at least one required", NotificationType.WARNING);
                                Notifications.Bus.notify((Notification)notification);
                                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ((Notification)notification).expire(), 2L, TimeUnit.SECONDS);
                            }
                            return;
                        }
                        case 38: {
                            OverviewPanel.this.setTransitionSetIndex((OverviewPanel.this.mTransitionSelected - 1 + OverviewPanel.this.mTransitions.length) % OverviewPanel.this.mTransitions.length);
                            break;
                        }
                        case 40: {
                            OverviewPanel.this.setConstraintSetIndex(0);
                            if (OverviewPanel.this.mListener == null) break;
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mConstraintSet[0], flag);
                            break;
                        }
                        case 37: {
                            OverviewPanel.this.setTransitionSetIndex((OverviewPanel.this.mTransitionSelected - 1 + OverviewPanel.this.mTransitions.length) % OverviewPanel.this.mTransitions.length);
                            break;
                        }
                        case 39: {
                            OverviewPanel.this.setTransitionSetIndex((OverviewPanel.this.mTransitionSelected + 1) % OverviewPanel.this.mTransitions.length);
                        }
                    }
                    if (OverviewPanel.this.mTransitionSelected >= 0 && OverviewPanel.this.mListener != null) {
                        OverviewPanel.this.mListener.select(OverviewPanel.this.mTransitions[OverviewPanel.this.mTransitionSelected], flag);
                    }
                } else if (OverviewPanel.this.mConstraintSetSelected >= 0) {
                    switch (e.getKeyCode()) {
                        case 67: {
                            if (!e.isControlDown() && !e.isMetaDown()) break;
                            MEUI.copy(OverviewPanel.this.mConstraintSet[OverviewPanel.this.mConstraintSetSelected - 1]);
                            break;
                        }
                        case 86: {
                            if (!e.isControlDown() && !e.isMetaDown()) break;
                            OverviewPanel.this.paste();
                            break;
                        }
                        case 8: 
                        case 127: {
                            if (OverviewPanel.this.mConstraintSetSelected > 0 && OverviewPanel.this.mConstraintSetSelected - 1 < OverviewPanel.this.mConstraintSet.length) {
                                OverviewPanel.this.mListener.delete(new MTag[]{OverviewPanel.this.mConstraintSet[OverviewPanel.this.mConstraintSetSelected - 1]}, 0);
                            }
                            return;
                        }
                        case 38: {
                            if (OverviewPanel.this.mTransitions.length <= 0) break;
                            OverviewPanel.this.setTransitionSetIndex(0);
                            if (OverviewPanel.this.mListener == null) break;
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mTransitions[0], flag);
                            break;
                        }
                        case 40: {
                            OverviewPanel.this.setConstraintSetIndex((OverviewPanel.this.mConstraintSetSelected + 1) % (OverviewPanel.this.mConstraintSet.length + 1));
                            break;
                        }
                        case 37: {
                            OverviewPanel.this.setConstraintSetIndex((OverviewPanel.this.mConstraintSetSelected - 1 + 1 + OverviewPanel.this.mConstraintSet.length) % (OverviewPanel.this.mConstraintSet.length + 1));
                            break;
                        }
                        case 39: {
                            OverviewPanel.this.setConstraintSetIndex((OverviewPanel.this.mConstraintSetSelected + 1) % (OverviewPanel.this.mConstraintSet.length + 1));
                        }
                    }
                    if (OverviewPanel.this.mListener != null) {
                        if (OverviewPanel.this.mConstraintSetSelected == 0) {
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mLayout, flag);
                        } else if (OverviewPanel.this.mConstraintSetSelected > 0 && OverviewPanel.this.mConstraintSet.length > OverviewPanel.this.mConstraintSetSelected - 1) {
                            OverviewPanel.this.mListener.select(OverviewPanel.this.mConstraintSet[OverviewPanel.this.mConstraintSetSelected - 1], flag);
                        }
                    }
                }
            }
        });
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String buff = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            StringMTag pastedTag = StringMTag.parse(buff);
            HashMap<String, MTag.Attribute> attr2 = pastedTag.getAttrList();
            if ("ConstraintSet".equals(pastedTag.getTagName())) {
                MTag.TagWriter writer = this.mMotionScene.getChildTagWriter("ConstraintSet");
                if (writer == null) {
                    return;
                }
                for (String s : attr2.keySet()) {
                    MTag.Attribute a = attr2.get(s);
                    if (a == null || a.mAttribute.equals("id")) {
                        Object value2 = a.mValue;
                        if (((String)value2).matches(".*_c[0123456789]+")) {
                            int n = ((String)value2).lastIndexOf("_c");
                            int end = Integer.parseInt(((String)value2).substring(n + 2));
                            String start = ((String)value2).substring(0, n);
                            value2 = start + "_c" + (end + 1);
                        } else {
                            value2 = ((String)value2).matches(".*_c") ? (String)value2 + "1" : (String)value2 + "_c";
                        }
                        writer.setAttribute(a.mNamespace, a.mAttribute, (String)value2);
                        continue;
                    }
                    writer.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                }
                this.addRecursive(pastedTag.getChildTags(), writer);
                writer.commit("paste");
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addRecursive(StringMTag[] children, MTag.TagWriter writer) {
        if (children == null || children.length == 0) {
            return;
        }
        for (StringMTag child : children) {
            MTag.TagWriter childWriter = writer.getChildTagWriter(child.getTagName());
            HashMap<String, MTag.Attribute> attr2 = child.getAttrList();
            for (String s : attr2.keySet()) {
                MTag.Attribute a = attr2.get(s);
                childWriter.setAttribute(a.mNamespace, a.mAttribute, a.mValue);
                this.addRecursive(child.getChildTags(), childWriter);
            }
        }
    }

    private void updateFromMouse(int x, int y, boolean select2) {
        final MTag[] objects = new MTag[1];
        final DerivedSetLine[] line = new DerivedSetLine[1];
        this.picker.setSelectListener(new MEScenePicker.HitElementListener(){

            @Override
            public void over(Object over, double dist) {
                if (over instanceof MTag) {
                    objects[0] = (MTag)over;
                } else {
                    line[0] = (DerivedSetLine)over;
                }
            }
        });
        this.picker.find(x, y);
        if (line[0] != null && this.mMouseOverDerived != line[0].mConstraintSet) {
            this.mMouseOverDerived = line[0].mConstraintSet;
            String id2 = Utils.stripID(line[0].mConstraintSet.getAttributeValue("id"));
            this.setToolTipText(id2 + " derives from " + line[0].mDerivedFrom);
            this.mMouseOverObject = null;
            this.repaint();
            return;
        }
        if (line[0] == null && this.mMouseOverDerived != null) {
            this.mMouseOverDerived = null;
            this.setToolTipText(MAIN_TOOL_TIP);
            this.repaint();
        }
        if (objects[0] == null) {
            if (this.mMouseOverObject != null) {
                this.mMouseOverObject = null;
                this.setToolTipText(MAIN_TOOL_TIP);
                this.repaint();
            }
            return;
        }
        MTag found = objects[0];
        if (select2 && this.mListener != null) {
            this.mListener.select(found, this.mControlDown ? 1 : 0);
        } else if (this.mMouseOverObject != found) {
            this.mMouseOverObject = found;
            switch (found.getTagName()) {
                case "Transition": {
                    this.setToolTipText("Transition " + Utils.formatTransition(found));
                    this.mTransitionHovered = true;
                    break;
                }
                case "ConstraintSet": {
                    this.setToolTipText("ConstraintSet " + Utils.stripID(found.getAttributeValue("id")));
                    this.mTransitionHovered = false;
                    break;
                }
                default: {
                    this.setToolTipText("Original MotionLayout");
                    this.mTransitionHovered = false;
                }
            }
            this.repaint();
        }
    }

    void debugSize(String str) {
        int w = this.getWidth();
        int h = this.getHeight();
        System.out.println(str + " act w,h = " + w + "," + h);
        Dimension d = this.getPreferredSize();
        System.out.println(str + " prf w,h = " + d.width + "," + d.height);
        d = this.getMinimumSize();
        System.out.println(str + " min w,h = " + d.width + "," + d.height);
        d = this.getMaximumSize();
        System.out.println(str + " max w,h = " + d.width + "," + d.height);
    }

    private void calcDimensions() {
        boolean has_strings = false;
        for (int i = 0; i < this.mTransitions.length; ++i) {
            if (null == this.mTransitions[i].getAttributeValue("id")) continue;
            has_strings = true;
            break;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int spaces = CS_GAP * this.mConstraintSet.length + 3;
        int noc = this.mConstraintSet.length + 1;
        this.cs_width = (w - CS_GAP * 2 - 2) / noc - CS_GAP;
        if (this.cs_width > MAX_CS_WIDTH) {
            this.cs_width = MAX_CS_WIDTH;
        } else if (this.cs_width < MIN_CS_WIDTH) {
            this.cs_width = MIN_CS_WIDTH;
        }
        int p_width = (this.cs_width + CS_GAP) * noc + 2 + CS_GAP;
        this.cs_height = this.cs_width * 3 / 2;
        int str_space = 0;
        if (has_strings) {
            int font_height = this.getFontMetrics(this.getFont()).getHeight();
            str_space = font_height / 2;
        }
        this.arrow_spacing = str_space + CS_GAP + ARROW_HEIGHT;
        int transition_height = CS_GAP + this.arrow_spacing + this.mTransitions.length * this.arrow_spacing;
        int derive_height = 46;
        int p_height = derive_height + transition_height + this.cs_height + CS_GAP;
        this.setPreferredSize(new Dimension(p_width, p_height));
    }

    private int getmConstraintSetX(int number) {
        if (number > 0) {
            return (this.cs_width + CS_GAP) * number + CS_GAP * 2 + 2;
        }
        return (this.cs_width + CS_GAP) * number + CS_GAP;
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x2;
        int x1;
        int end;
        int start;
        int clicks;
        int swipes;
        int i;
        if (this.mMotionScene == null) {
            return;
        }
        Graphics2D g2g = (Graphics2D)g;
        this.picker.reset();
        int w = this.getWidth();
        int h = this.getHeight();
        this.calcDimensions();
        int noc = this.mConstraintSet.length + 1;
        int space = 10;
        if (space * (noc + 1) * 2 > w) {
            space = 1;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        if (noc == 0) {
            return;
        }
        boolean focus = this.hasFocus();
        Color colorNormalLine = MEUI.Overview.ourCS_Border;
        Color colorHoverLine = MEUI.Overview.ourCS_HoverBorder;
        Color colorSelectedLine = focus ? MEUI.Overview.ourCS_SelectedFocusBorder : MEUI.Overview.ourCS_SelectedBorder;
        int csWidth = this.cs_width;
        Stroke stroke = g2g.getStroke();
        g2g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int yGap = 24;
        int selectedStart = -1;
        int selectedEnd = -1;
        int constraintSetY = CS_GAP + this.arrow_spacing + this.mTransitions.length * this.arrow_spacing;
        int yoffset = CS_GAP + this.arrow_spacing - ARROW_HEIGHT / 2;
        Arrays.fill(this.mOnActionSize, 0);
        for (i = 0; i < this.mTransitions.length; ++i) {
            swipes = 0;
            clicks = 0;
            for (MTag tag : this.mTransitions[i].getChildren()) {
                String tagName = tag.getTagName();
                if ("OnSwipe".equals(tagName)) {
                    ++swipes;
                }
                if (!"OnClick".equals(tagName)) continue;
                ++clicks;
            }
            start = this.mTransitionStart[i];
            end = this.mTransitionEnd[i];
            x1 = this.getmConstraintSetX(start + 1) + csWidth / 2;
            x2 = this.getmConstraintSetX(end + 1) + csWidth / 2;
            y = yoffset + i * this.arrow_spacing;
            g.setColor(this.mTransitionSelected == i ? colorSelectedLine : colorNormalLine);
            if (this.mTransitionSelected == i) {
                selectedStart = start;
                selectedEnd = end;
                g.setColor(colorSelectedLine);
            } else {
                g.setColor(colorNormalLine);
            }
            boolean hoverHighlight = this.mMouseOverObject != null && this.mTransitions[i] == this.mMouseOverObject;
            this.drawTransition((Graphics2D)g, hoverHighlight, x1, x2, y, constraintSetY, this.mTransitions[i], Float.NaN, 0.0f);
            if (clicks <= 0 && swipes <= 0) continue;
            this.mOnActionSize[i] = this.drawActions(g, swipes, clicks, x1, x2, y);
        }
        ((Graphics2D)g).setStroke(ourSelectedStroke);
        for (i = 0; i < this.mTransitions.length; ++i) {
            String str;
            swipes = 0;
            clicks = 0;
            for (MTag tag : this.mTransitions[i].getChildren()) {
                String tagName = tag.getTagName();
                if ("OnSwipe".equals(tagName)) {
                    ++swipes;
                }
                if (!"OnClick".equals(tagName)) continue;
                ++clicks;
            }
            start = this.mTransitionStart[i];
            end = this.mTransitionEnd[i];
            x1 = this.getmConstraintSetX(start + 1) + csWidth / 2;
            x2 = this.getmConstraintSetX(end + 1) + csWidth / 2;
            y = yoffset + i * this.arrow_spacing;
            g.setColor(this.mTransitionSelected == i ? colorSelectedLine : colorNormalLine);
            if (this.mTransitionSelected != i) continue;
            selectedStart = start;
            selectedEnd = end;
            g.setColor(colorSelectedLine);
            float stagger = 0.0f;
            if (this.mTransitionSelected == i && !Float.isNaN(this.mTransitionProgress) && (str = this.mTransitions[i].getAttributeValue("staggered")) != null) {
                stagger = Float.parseFloat(str);
            }
            boolean hoverHighlight = this.mMouseOverObject != null && this.mTransitions[i] == this.mMouseOverObject;
            this.drawTransition((Graphics2D)g, hoverHighlight, x1, x2, y, constraintSetY, this.mTransitions[i], this.mTransitionProgress, stagger);
            if (clicks <= 0 && swipes <= 0) continue;
            this.drawActions(g, swipes, clicks, x1, x2, y);
        }
        for (i = 0; i < this.mTransitions.length; ++i) {
            int start2 = this.mTransitionStart[i];
            int end2 = this.mTransitionEnd[i];
            int x12 = this.getmConstraintSetX(start2 + 1) + csWidth / 2;
            int x22 = this.getmConstraintSetX(end2 + 1) + csWidth / 2;
            int y2 = yoffset + i * this.arrow_spacing;
            g.setColor(this.mTransitionSelected == i ? colorSelectedLine : colorNormalLine);
            if (this.mTransitionSelected == i) {
                selectedStart = start2;
                selectedEnd = end2;
                g.setColor(colorSelectedLine);
            } else {
                g.setColor(colorNormalLine);
            }
            this.picker.addLine(this.mTransitions[i], 3, x12, y2, x22, y2, 2);
            String str = this.mTransitions[i].getAttributeValue("id");
            if (str == null) continue;
            g.setFont(ourBaseFont);
            str = Utils.stripID(str);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D bounds2 = fm.getStringBounds(str, g);
            int strX = x12 > x22 ? x12 - (int)bounds2.getWidth() - 20 : x12 + 4;
            Color tmp = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(strX += this.mOnActionSize[i], y2 - fm.getHeight(), (int)bounds2.getWidth(), (int)bounds2.getHeight());
            g.setColor(tmp);
            g.drawString(str, strX, y2 - 5);
        }
        int csHeight = this.cs_height;
        g2g.setStroke(this.mThickStroke);
        g.setFont(ourBaseFont);
        FontMetrics fm = g.getFontMetrics();
        String maxString = "Layout";
        int maxStringWidth = maxString.length();
        for (int i2 = 0; i2 < this.mConstraintSetNames.length; ++i2) {
            int width2 = this.mConstraintSetNames[i2].length();
            if (width2 <= maxStringWidth) continue;
            maxStringWidth = width2;
            maxString = this.mConstraintSetNames[i2];
        }
        maxStringWidth = fm.stringWidth(maxString);
        int margin = MEUI.scale(1);
        g.setFont(ourBaseFont);
        while (csWidth < maxStringWidth + margin) {
            float f = (float)g.getFont().getSize() / 1.4f;
            g.setFont(g.getFont().deriveFont(f));
            fm = g.getFontMetrics();
            maxStringWidth = fm.stringWidth(maxString);
        }
        int line_x = this.getmConstraintSetX(1) - CS_GAP - 1;
        int line_y = constraintSetY;
        g.setColor(colorNormalLine);
        g.drawLine(line_x, line_y, line_x, line_y + this.cs_height);
        if (this.mTransitions.length == 0 && this.mConstraintSet.length == 0) {
            Image constraintSetImage = MEIcons.getUnscaledIconImage(MEIcons.CREATE_CONSTRAINTSET);
            Image transitionImage = MEIcons.getUnscaledIconImage(MEIcons.CREATE_TRANSITION);
            ((Graphics2D)g).drawImage(constraintSetImage, line_x + 72, line_y - 30 + this.cs_height / 2, constraintSetImage.getWidth(null), constraintSetImage.getHeight(null), null);
            ((Graphics2D)g).drawImage(transitionImage, line_x + 62, line_y + 4 + this.cs_height / 2, transitionImage.getWidth(null), transitionImage.getHeight(null), null);
            ((Graphics2D)g).drawString("      Use       to create a new", line_x + 20, line_y - 16 + this.cs_height / 2);
            ((Graphics2D)g).drawString("     constraint set, and use to", line_x + 20, line_y + this.cs_height / 2);
            ((Graphics2D)g).drawString("create       a transition between", line_x + 20, line_y + 16 + this.cs_height / 2);
            ((Graphics2D)g).drawString("        two constraint sets", line_x + 20, line_y + 32 + this.cs_height / 2);
        }
        for (int i3 = 0; i3 <= this.mConstraintSet.length; ++i3) {
            int stringWidth;
            boolean transitionHighlightEnd;
            boolean selected;
            int setIndex = i3 - 1;
            if (i3 == 0) {
                setIndex = this.mConstraintSet.length;
            }
            int x = this.getmConstraintSetX(i3);
            int y3 = constraintSetY;
            boolean hover = false;
            boolean drawLayout = i3 == 0;
            boolean bl = selected = this.mConstraintSetSelected == i3;
            if (selectedEnd == setIndex || selectedStart == setIndex) {
                selected = true;
            }
            boolean transitionHighlightStart = this.mHighlightStart && selectedStart == setIndex;
            boolean bl2 = transitionHighlightEnd = this.mHighlightEnd && selectedEnd == setIndex;
            if (this.mMouseOverObject != null) {
                boolean bl3 = hover = (drawLayout ? this.mLayout : this.mConstraintSet[setIndex]) == this.mMouseOverObject;
            }
            if (!drawLayout) {
                this.picker.addRect(this.mConstraintSet[setIndex], 3, x, y3, x + csWidth, y3 + csHeight);
            } else {
                this.picker.addRect(this.mLayout, 3, x, y3, x + csWidth, y3 + csHeight);
            }
            String name = drawLayout ? "Layout" : this.mConstraintSetNames[setIndex];
            Color colorBackground = MEUI.Overview.ourCS_Background;
            Color textColor = MEUI.Overview.ourCS_TextColor;
            if (this.mConstraintSetSelected == i3) {
                if (focus) {
                    colorBackground = MEUI.Overview.ourCS_SelectedFocusBackground;
                    textColor = MEUI.Overview.ourCS_FocusTextColor;
                } else {
                    colorBackground = MEUI.Overview.ourCS_SelectedBackground;
                }
            }
            g.setColor(colorBackground);
            g.fillRoundRect(x, y3, csWidth, csHeight, space, space);
            Color color = colorNormalLine;
            if (hover) {
                color = colorHoverLine;
            }
            if (selected) {
                color = colorSelectedLine;
            }
            if (transitionHighlightStart || transitionHighlightEnd) {
                color = MEUI.Overview.ourPositionColor;
            }
            g.setColor(color);
            g.drawRoundRect(x, y3, csWidth, csHeight, space, space);
            if (i3 == 0) {
                g.setColor(colorBackground);
                g.fillRoundRect(x, y3, csWidth, csHeight, space, space);
                g.setColor(MEUI.Overview.ourML_BarColor);
                g.fillRoundRect(x, y3, csWidth, csHeight / 4 + 1, space, space);
                g.setColor(color);
                g.drawRoundRect(x, y3, csWidth, csHeight, space, space);
                g.fillRect(x, y3 + csHeight / 4, csWidth, 2);
            }
            g.setColor(textColor);
            if (drawLayout) {
                stringWidth = fm.stringWidth("Motion");
                int mx = x + (csWidth - stringWidth) / 2;
                int my = y3 + csHeight / 2 - fm.getHeight() + fm.getAscent();
                g.drawString("Motion", mx, my);
                stringWidth = fm.stringWidth("Layout");
                int lx = x + (csWidth - stringWidth) / 2;
                int ly = y3 + csHeight / 2 + fm.getAscent();
                g.drawString("Layout", lx, ly);
                continue;
            }
            stringWidth = fm.stringWidth(name);
            g.drawString(name, x += (csWidth - stringWidth) / 2, y3 += (csHeight - fm.getHeight()) / 2 + fm.getAscent());
        }
        int rectY = constraintSetY;
        int lineY = rectY + csHeight;
        if (!this.mComputedDerivedLines) {
            this.mTotalDerivedLines = 0;
            if (this.mDerivedLines.length < this.mConstraintSet.length) {
                this.mDerivedLines = new DerivedSetLine[this.mConstraintSet.length + 1];
                for (i = 0; i < this.mDerivedLines.length; ++i) {
                    this.mDerivedLines[i] = new DerivedSetLine();
                }
            }
            for (i = 0; i < this.mConstraintSet.length; ++i) {
                String derived = Utils.stripID(this.mConstraintSet[i].getAttributeValue("deriveConstraintsFrom"));
                if (derived == null) continue;
                for (j = 0; j < this.mConstraintSet.length; ++j) {
                    int lineDstX;
                    String id2 = Utils.stripID(this.mConstraintSet[j].getAttributeValue("id"));
                    if (!id2.equals(derived)) continue;
                    fromRectX = this.getmConstraintSetX(i + 1);
                    toRectX = this.getmConstraintSetX(j + 1);
                    lineSrcX = fromRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mDstX = lineDstX = toRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mSrcX = lineSrcX;
                    this.mDerivedLines[this.mTotalDerivedLines].mPathYOffset = 10 * (this.mDerivedLines.length - this.mTotalDerivedLines);
                    ++this.mTotalDerivedLines;
                }
            }
            if (this.mTotalDerivedLines > 7) {
                OverviewPanel.locallyOptimizeLines(this.mDerivedLines, this.mTotalDerivedLines, 4);
            } else {
                OverviewPanel.optimizeLines(this.mDerivedLines, this.mTotalDerivedLines);
            }
            this.mComputedDerivedLines = true;
        } else {
            this.mTotalDerivedLines = 0;
            if (this.mDerivedLines.length < this.mConstraintSet.length) {
                this.mDerivedLines = new DerivedSetLine[this.mConstraintSet.length + 1];
                for (i = 0; i < this.mDerivedLines.length; ++i) {
                    this.mDerivedLines[i] = new DerivedSetLine();
                }
            }
            for (i = 0; i < this.mConstraintSet.length; ++i) {
                String derived = Utils.stripID(this.mConstraintSet[i].getAttributeValue("deriveConstraintsFrom"));
                if (derived == null) continue;
                for (j = 0; j < this.mConstraintSet.length; ++j) {
                    int lineDstX;
                    String id3 = Utils.stripID(this.mConstraintSet[j].getAttributeValue("id"));
                    if (!id3.equals(derived)) continue;
                    fromRectX = this.getmConstraintSetX(i + 1);
                    toRectX = this.getmConstraintSetX(j + 1);
                    lineSrcX = fromRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mDstX = lineDstX = toRectX + csWidth / 2;
                    this.mDerivedLines[this.mTotalDerivedLines].mSrcX = lineSrcX;
                    this.mDerivedLines[this.mTotalDerivedLines].mConstraintSet = this.mConstraintSet[i];
                    this.mDerivedLines[this.mTotalDerivedLines].mDerivedFrom = derived;
                    ++this.mTotalDerivedLines;
                }
            }
        }
        int GAP = 10;
        for (int i4 = 0; i4 < this.mTotalDerivedLines; ++i4) {
            g2g.setStroke(this.mDashStroke);
            g.setColor(Color.LIGHT_GRAY);
            this.mPath.reset();
            this.mRectPathX[0] = this.mDerivedLines[i4].mSrcX - 5;
            this.mRectPathY[0] = lineY;
            this.mRectPathX[1] = this.mRectPathX[0];
            this.mRectPathY[1] = lineY + this.mDerivedLines[i4].mPathYOffset;
            this.mRectPathX[2] = this.mDerivedLines[i4].mDstX + 5;
            this.mRectPathY[2] = this.mRectPathY[1];
            this.mRectPathX[3] = this.mRectPathX[2];
            this.mRectPathY[3] = lineY + 5;
            this.mPath.moveTo(this.mRectPathX[0], this.mRectPathY[0]);
            Drawing.drawRound(this.mPath, this.mRectPathX, this.mRectPathY, this.mRectPathLen, 20);
            Drawing.drawPick(this.picker, this.mDerivedLines[i4], this.mRectPathX, this.mRectPathY, this.mRectPathLen, 20);
            g2g.draw(this.mPath);
            this.mPath.reset();
            this.mPath.moveTo(this.mRectPathX[3], this.mRectPathY[3]);
            this.mPath.lineTo(this.mRectPathX[3] - 5, this.mRectPathY[3]);
            this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3] - 5);
            this.mPath.lineTo(this.mRectPathX[3] + 5, this.mRectPathY[3]);
            this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3]);
            g2g.setStroke(stroke);
            g2g.draw(this.mPath);
        }
    }

    private int drawActions(Graphics g, int swipes, int clicks, int x1, int x2, int y) {
        int dir;
        int onSize = 4;
        boolean backward = x2 < x1;
        int offset = MEUI.scale(6);
        int gap = MEUI.scale(2);
        int markx = x1 - MEUI.scale(2) - 1;
        int totalSpace = 0;
        int n = dir = backward ? -1 : 1;
        if (clicks > 0) {
            g.fillRoundRect(markx + (backward ? -offset - onSize : offset), y - onSize - 2, onSize, onSize, onSize, onSize);
            totalSpace = dir * (onSize + gap);
            markx += totalSpace;
        }
        if (swipes > 0) {
            int longpill = onSize * 3;
            g.fillRoundRect(markx + (backward ? -offset - longpill : offset), y - onSize - 2, longpill, onSize, onSize, onSize);
            totalSpace += dir * (longpill + gap);
        }
        return totalSpace;
    }

    private void drawTransition(Graphics2D g, boolean hoverHighlight, int x1, int x2, int y, int constraintSetY, Object tag, float progress, float stagger) {
        int tri_delta_y = 5;
        int tri_delta_x = 5;
        this.mPath.reset();
        this.mRectPathX[0] = x1 - 5;
        this.mRectPathY[0] = constraintSetY - 4;
        this.mRectPathX[1] = this.mRectPathX[0];
        this.mRectPathY[1] = y;
        this.mRectPathX[2] = x2 + 5;
        this.mRectPathY[2] = this.mRectPathY[1];
        this.mRectPathX[3] = this.mRectPathX[2];
        this.mRectPathY[3] = constraintSetY - 8;
        this.mPath.moveTo(this.mRectPathX[0], this.mRectPathY[0]);
        Drawing.drawRound(this.mPath, this.mRectPathX, this.mRectPathY, this.mRectPathLen, 5);
        Drawing.drawPick(this.picker, tag, this.mRectPathX, this.mRectPathY, this.mRectPathLen, 5);
        this.mPath.lineTo(this.mRectPathX[3] - tri_delta_x, this.mRectPathY[3]);
        this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3] + tri_delta_y);
        this.mPath.lineTo(this.mRectPathX[3] + tri_delta_x, this.mRectPathY[3]);
        this.mPath.lineTo(this.mRectPathX[3], this.mRectPathY[3]);
        if (hoverHighlight) {
            Stroke originalStroke = g.getStroke();
            Color originalColor = g.getColor();
            g.setStroke(ourFatStroke);
            g.setColor(MEUI.Overview.ourCS_HoverBorder);
            g.draw(this.mPath);
            g.setColor(originalColor);
            g.setStroke(originalStroke);
        } else {
            g.draw(this.mPath);
        }
        this.mHighlightStart = false;
        this.mHighlightEnd = false;
        if (!Float.isNaN(progress)) {
            if (progress > 1.0f) {
                progress = 1.0f;
            }
            if (progress < 0.0f) {
                progress = 0.0f;
            }
            stagger = Math.abs(stagger);
            float scale = 1.0f / (1.0f - stagger);
            float startProgress = progress * scale;
            float endProgress = (progress - stagger) * scale;
            float startx = (float)this.mRectPathX[0] + startProgress * (float)(this.mRectPathX[3] - this.mRectPathX[0]) - 4.0f;
            float endx = (float)this.mRectPathX[0] + endProgress * (float)(this.mRectPathX[3] - this.mRectPathX[0]) + 4.0f;
            int clipy = this.mRectPathY[3] + ((double)progress < 0.3 ? 3 : 0);
            Rectangle rect = g.getClipBounds();
            g.clipRect(0, 0, this.getWidth(), clipy);
            Color originalColor = g.getColor();
            g.setPaint(new LinearGradientPaint(startx, 0.0f, endx, 0.0f, new float[]{0.0f, 0.01f, 0.99f, 1.0f}, new Color[]{originalColor, MEUI.Overview.ourPositionColor, MEUI.Overview.ourPositionColor, originalColor}));
            g.draw(this.mPath);
            g.setClip(rect);
            g.setColor(originalColor);
            if (Math.abs(startx + 4.0f - (float)this.mRectPathX[0]) < 2.0f) {
                this.mHighlightStart = true;
            }
            if (Math.abs(endx - 4.0f - (float)this.mRectPathX[3]) < 2.0f) {
                this.mHighlightEnd = true;
            }
        }
        Color originalColor = g.getColor();
        if (this.mHighlightStart) {
            g.setColor(MEUI.Overview.ourPositionColor);
        }
        g.drawLine(this.mRectPathX[0] - tri_delta_x, this.mRectPathY[0], this.mRectPathX[0] + tri_delta_x, this.mRectPathY[0]);
        if (this.mHighlightEnd) {
            g.setColor(MEUI.Overview.ourPositionColor);
        } else {
            g.setColor(originalColor);
        }
        this.mRectPathX[0] = this.mRectPathX[3] - tri_delta_x;
        this.mRectPathY[0] = this.mRectPathY[3];
        this.mRectPathX[1] = this.mRectPathX[3];
        this.mRectPathY[1] = this.mRectPathY[3] + tri_delta_y;
        this.mRectPathX[2] = this.mRectPathX[3] + tri_delta_x;
        this.mRectPathY[2] = this.mRectPathY[3];
        g.fillPolygon(this.mRectPathX, this.mRectPathY, 4);
        g.drawPolygon(this.mRectPathX, this.mRectPathY, 4);
        g.setColor(originalColor);
    }

    private void drawTransition_orig(Graphics2D g, boolean hoverHighlight, int x1, int x2, int y, int constraintSetY, Object tag) {
        int delta;
        this.picker.addLine(tag, 3, x1, y, x2, y, 2);
        int n = delta = x2 > x1 ? -5 : 5;
        if (hoverHighlight) {
            Stroke originalStroke = g.getStroke();
            Color originalColor = g.getColor();
            g.setStroke(ourFatStroke);
            g.setColor(MEUI.Overview.ourCS_HoverBorder);
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y - delta, x1, y + delta);
            g.drawLine(x2, y, x2 + delta, y + delta);
            g.drawLine(x2, y, x2 + delta, y - delta);
            g.setColor(originalColor);
            g.setStroke(originalStroke);
        }
        g.drawLine(x1, y, x2, y);
        g.drawLine(x1, y - delta, x1, y + delta);
        g.drawLine(x2, y, x2 + delta, y + delta);
        g.drawLine(x2, y, x2 + delta, y - delta);
    }

    @VisibleForTesting
    static void optimizeLines(DerivedSetLine[] lines, int lineCount) {
        int maxLevels = 3;
        int total = OverviewPanel.intPower(maxLevels, lineCount);
        double minCost = Double.MAX_VALUE;
        int minPattern = -1;
        for (int i = 0; i < total; ++i) {
            int level = i;
            for (int j = 0; j < lineCount; ++j) {
                lines[j].mPathYOffset = level % maxLevels;
                level /= maxLevels;
            }
            double cost = OverviewPanel.lineCost(lines, lineCount, maxLevels);
            if (!(cost < minCost)) continue;
            minCost = cost;
            minPattern = i;
        }
        int level = minPattern;
        for (int j = 0; j < lineCount; ++j) {
            int value2 = level % maxLevels;
            level /= maxLevels;
            lines[j].mPathYOffset = value2 * 12 + 20;
        }
    }

    @VisibleForTesting
    static void locallyOptimizeLines(DerivedSetLine[] lines, int lineCount, int maxLevels) {
        int i;
        boolean canReduce = true;
        DeltaInfo delta = new DeltaInfo(-1, -1, -1);
        for (i = 0; i < lineCount; ++i) {
            lines[i].mPathYOffset = 0;
        }
        while (canReduce) {
            canReduce = OverviewPanel.reduceCostStepwise(lines, lineCount, maxLevels);
        }
        for (i = 0; i < lineCount; ++i) {
            lines[i].mPathYOffset = lines[i].mPathYOffset * 12 + 20;
        }
    }

    private static boolean reduceCostStepwise(DerivedSetLine[] lines, int lineCount, int maxLevels) {
        int maxReducedCost = 0;
        boolean canReduce = false;
        DeltaInfo delta = new DeltaInfo(-1, -1, -1);
        DeltaInfo tmpDelta = new DeltaInfo(-1, -1, -1);
        for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
            int reducedCost = 0;
            DerivedSetLine l1 = lines[lineIndex];
            int curLevel = l1.mPathYOffset;
            int[] costs = OverviewPanel.getAllCosts(lines, lineCount);
            for (int i = 0; i < maxLevels; ++i) {
                if (curLevel == i) continue;
                l1.mPathYOffset = i;
                int cost = 0;
                for (int j = 0; j < lineCount; ++j) {
                    if (j == lineIndex) continue;
                    DerivedSetLine l2 = lines[j];
                    cost += OverviewPanel.calcualteCost(l1, l2);
                }
                if (costs[lineIndex] - cost <= reducedCost) continue;
                tmpDelta.myReducedCost = reducedCost = costs[lineIndex] - cost;
                tmpDelta.myLineIndex = lineIndex;
                tmpDelta.myLevel = i;
            }
            l1.mPathYOffset = curLevel;
            if (tmpDelta.myReducedCost <= maxReducedCost) continue;
            delta = tmpDelta;
            canReduce = true;
        }
        if (canReduce) {
            lines[delta.myLineIndex].mPathYOffset = delta.myLevel;
        }
        return canReduce;
    }

    private static int[] getAllCosts(DerivedSetLine[] lines, int lineCount) {
        int[] costs = new int[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            DerivedSetLine l1 = lines[i];
            int cost = 0;
            for (int j = 0; j < lineCount; ++j) {
                if (i == j) continue;
                DerivedSetLine l2 = lines[j];
                cost += OverviewPanel.calcualteCost(l1, l2);
            }
            costs[i] = cost;
        }
        return costs;
    }

    private static int calcualteCost(DerivedSetLine l1, DerivedSetLine l2) {
        int cost = 0;
        if (Math.max(Math.min(l1.mSrcX, l1.mDstX), Math.min(l2.mSrcX, l2.mDstX)) < Math.min(Math.max(l1.mSrcX, l1.mDstX), Math.max(l2.mSrcX, l2.mDstX)) && l1.mPathYOffset == l2.mPathYOffset) {
            cost += 5;
        } else {
            boolean l1Inside;
            boolean bl = l1Inside = (l1.mSrcX - l2.mSrcX) * (l1.mSrcX - l2.mDstX) <= 0 && (l1.mDstX - l2.mSrcX) * (l1.mDstX - l2.mDstX) <= 0;
            if (l1Inside && l1.mPathYOffset > l2.mPathYOffset) {
                cost += 5;
            }
        }
        return cost;
    }

    private static double lineCost(DerivedSetLine[] lines, int lineCount, int maxLevels) {
        int i;
        double ret = 0.0;
        for (i = 0; i < lineCount; ++i) {
            ret += (double)lines[i].mPathYOffset;
        }
        for (i = 0; i < lineCount; ++i) {
            DerivedSetLine l1 = lines[i];
            for (int j = i + 1; j < lineCount; ++j) {
                DerivedSetLine l2 = lines[j];
                ret += (double)OverviewPanel.calcualteCost(l1, l2);
            }
        }
        return ret;
    }

    static int intPower(int a, int b) {
        int ret = a;
        for (int i = 1; i < b; ++i) {
            ret *= a;
        }
        return ret;
    }

    void setConstraintSetIndex(int index) {
        this.mTransitionSelected = -1;
        this.mConstraintSetSelected = index;
        this.repaint();
    }

    void setTransitionSetIndex(int index) {
        this.mConstraintSetSelected = -1;
        this.mTransitionSelected = index;
        this.repaint();
    }

    void setSelected(MTag tag) {
        int i;
        this.mTransitionSelected = -1;
        this.mConstraintSetSelected = -1;
        for (i = 0; i < this.mConstraintSet.length; ++i) {
            if (tag != this.mConstraintSet[i]) continue;
            this.mConstraintSetSelected = i;
            return;
        }
        for (i = 0; i < this.mTransitions.length; ++i) {
            if (tag != this.mTransitions[i]) continue;
            this.mTransitionSelected = i;
            return;
        }
    }

    public void setMTag(MTag motionScene, MTag layout2) {
        this.mComputedDerivedLines = false;
        this.mMotionScene = motionScene;
        this.mLayout = layout2;
        this.mConstraintSet = motionScene.getChildTags("ConstraintSet");
        this.mTransitions = motionScene.getChildTags("Transition");
        this.mTransitionStart = new int[this.mTransitions.length];
        this.mTransitionEnd = new int[this.mTransitions.length];
        this.mOnActionSize = new int[this.mTransitions.length];
        this.mConstraintSetNames = new String[this.mConstraintSet.length];
        for (int j = 0; j < this.mConstraintSet.length; ++j) {
            this.mConstraintSetNames[j] = Utils.stripID(this.mConstraintSet[j].getAttributeValue("id"));
        }
        for (int i = 0; i < this.mTransitions.length; ++i) {
            String start = Utils.stripID(this.mTransitions[i].getAttributeValue("constraintSetStart"));
            String end = Utils.stripID(this.mTransitions[i].getAttributeValue("constraintSetEnd"));
            for (int j = 0; j < this.mConstraintSetNames.length; ++j) {
                if (start.equals(this.mConstraintSetNames[j])) {
                    this.mTransitionStart[i] = j;
                }
                if (!end.equals(this.mConstraintSetNames[j])) continue;
                this.mTransitionEnd[i] = j;
            }
        }
        this.calcDimensions();
        this.revalidate();
        this.repaint();
    }

    private void showPopupMenu(@NotNull MouseEvent e) {
        ActionPopupMenu popupMenu2 = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", this.myActionGroup);
        popupMenu2.getComponent().show(e.getComponent(), e.getX(), e.getY());
    }

    @NotNull
    private ActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction mySaveGifAction = new AnAction("Save Gif", "Save selected transition as Gif", MEIcons.SAVE){

            public void actionPerformed(@NotNull AnActionEvent event) {
                OverviewPanel.this.mListener.performAction(1);
            }
        };
        group.add(mySaveGifAction);
        return group;
    }

    static class DerivedSetLine {
        public MTag mConstraintSet;
        public String mDerivedFrom;
        int mSrcX;
        int mDstX;
        int mPathYOffset = 10;

        DerivedSetLine() {
        }
    }

    private static class DeltaInfo {
        int myLineIndex;
        int myReducedCost;
        int myLevel;

        DeltaInfo(int lineIndex, int cost, int level) {
            this.myLineIndex = lineIndex;
            this.myReducedCost = cost;
            this.myLevel = level;
        }
    }
}

