/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.NlComponentTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.actions.ClickOrSwipeAction;
import com.android.tools.idea.uibuilder.handlers.motion.editor.actions.PanelAction;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScrollPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.METabbedPane;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateConstraintSet;
import com.android.tools.idea.uibuilder.handlers.motion.editor.createDialogs.CreateTransition;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.CombinedListPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.ConstraintSetPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.DefaultToolbarImpl;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.ErrorPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.LayoutPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MTagActionListener;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.OverviewPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.TransitionPanel;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.NotNull;

public class MotionEditor
extends JPanel {
    public static final boolean DEBUG = false;
    private final JPanel mMainPanel;
    private CardLayout mErrorSwitchCard;
    public Track myTrack = new Track();
    ErrorPanel myErrorPanel = new ErrorPanel();
    MeModel mMeModel;
    MotionEditorSelector mMotionEditorSelector = new MotionEditorSelector();
    JTabbedPane mTabbedTopPane = new METabbedPane();
    MotionScenePanel mMotionSceneTabb = new MotionScenePanel();
    private TransitionPanel mTransitionPanel = new TransitionPanel(this);
    ConstraintSetPanel mConstraintSetPanel = new ConstraintSetPanel();
    LayoutPanel mLayoutPanel = new LayoutPanel();
    CombinedListPanel mCombinedListPanel = new CombinedListPanel();
    OverviewPanel mOverviewPanel = new OverviewPanel();
    JScrollPane mOverviewScrollPane = new MEScrollPane(this.mOverviewPanel);
    CardLayout mCardLayout = new CardLayout();
    JPanel mCenterPanel = new JPanel(this.mCardLayout);
    private static final String LAYOUT_PANEL = "Layout";
    private static final String TRANSITION_PANEL = "Transition";
    private static final String CONSTRAINTSET_PANEL = "ConstraintSet";
    private String mCurrentlyDisplaying = "ConstraintSet";
    private final List<Command> myCommandListeners = new ArrayList<Command>();
    PanelAction createConstrainSet = new PanelAction(new CreateConstraintSet(), this);
    PanelAction createTransition = new PanelAction(new CreateTransition(), this);
    AnActionButton clickOrSwipe = new ClickOrSwipeAction(this);
    AnActionButton cycleAction = new AnActionButton("Cycle between layouts", MEIcons.CYCLE_LAYOUT){

        public void actionPerformed(@NotNull AnActionEvent e) {
            MotionEditor.this.layoutTop();
        }
    };
    JSplitPane mTopPanel;
    boolean mUpdatingModel;
    JPopupMenu myPopupMenu = new JPopupMenu();
    private static final String MAIN_PANEL = "main";
    private static final String ERROR_PANEL = "error";
    private int mFlags;
    LayoutMode mLayoutMode = null;
    private MTag mSelectedTag;

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.mMotionSceneTabb != null) {
            this.myErrorPanel.updateUI();
            this.mMotionSceneTabb.updateUI();
            this.mTransitionPanel.updateUI();
            this.mConstraintSetPanel.updateUI();
            this.mLayoutPanel.updateUI();
            this.mCombinedListPanel.updateUI();
            this.mOverviewScrollPane.updateUI();
            this.mCenterPanel.updateUI();
            this.myPopupMenu.updateUI();
            int n = this.myPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.myPopupMenu.getComponent(i);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).updateUI();
            }
        }
    }

    public void selectById(String[] ids) {
        switch (this.mCurrentlyDisplaying) {
            case "Layout": {
                this.mLayoutPanel.selectByIds(ids);
                break;
            }
            case "ConstraintSet": {
                this.mConstraintSetPanel.selectById(ids);
                break;
            }
        }
    }

    public void addCommandListener(Command command) {
        this.myCommandListeners.add(command);
    }

    private void fireCommand(Command.Action action2, MTag[] tags2) {
        for (Command listener2 : this.myCommandListeners) {
            listener2.perform(action2, tags2);
        }
    }

    public void stopAnimation() {
        this.mTransitionPanel.mTimeLinePanel.stopAnimation();
    }

    public void dataChanged() {
        this.setMTag(this.mMeModel);
    }

    public MotionEditor() {
        super(new CardLayout());
        this.mErrorSwitchCard = (CardLayout)this.getLayout();
        this.mMainPanel = new JPanel(new BorderLayout());
        this.add((Component)this.mMainPanel, MAIN_PANEL);
        this.add((Component)this.myErrorPanel, ERROR_PANEL);
        this.mErrorSwitchCard.show(this, MAIN_PANEL);
        this.mOverviewScrollPane.setBorder(BorderFactory.createEmptyBorder());
        JPanel ui = new JPanel(new GridLayout(2, 1));
        this.mCombinedListPanel.setSelectionListener(e -> this.listSelection());
        this.mMotionEditorSelector.addSelectionListener(new MotionEditorSelector.Listener(){

            @Override
            public void selectionChanged(MotionEditorSelector.Type selection, MTag[] tag, int flags) {
                MotionEditor.this.mMeModel.setSelected(selection, tag);
            }
        });
        ui.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mCombinedListPanel.setPreferredSize(new Dimension(10, 100));
        this.mTopPanel = new JSplitPane(1, this.mCombinedListPanel, this.mOverviewScrollPane);
        this.mTopPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, MEUI.ourBorder));
        ui.add(this.mTopPanel);
        ui.add((Component)this.mCenterPanel, "Center");
        this.mCenterPanel.add((Component)this.mTransitionPanel, TRANSITION_PANEL);
        this.mCenterPanel.add((Component)this.mConstraintSetPanel, CONSTRAINTSET_PANEL);
        this.mCenterPanel.add((Component)this.mLayoutPanel, LAYOUT_PANEL);
        this.mTransitionPanel.setListeners(this.mMotionEditorSelector);
        this.mConstraintSetPanel.setListeners(this.mMotionEditorSelector);
        this.mLayoutPanel.setListeners(this.mMotionEditorSelector);
        this.mCenterPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mLayoutPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mConstraintSetPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mCombinedListPanel.setBackground(MEUI.ourPrimaryPanelBackground);
        this.mOverviewPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mTransitionPanel.addTimeLineListener(new MotionEditorSelector.TimeLineListener(){

            @Override
            public void command(MotionEditorSelector.TimeLineCmd cmd, float pos) {
                switch (cmd) {
                    case MOTION_PROGRESS: {
                        MotionEditor.this.mOverviewPanel.setTransitionProgress(pos);
                        break;
                    }
                    case MOTION_SCRUB: 
                    case MOTION_PLAY: {
                        break;
                    }
                    case MOTION_STOP: {
                        MotionEditor.this.mOverviewPanel.setTransitionProgress(Float.NaN);
                    }
                }
            }
        });
        MTagActionListener mTagActionListener = new MTagActionListener(){

            @Override
            public void select(MTag selected, int flags) {
                MotionEditor.this.selectTag(selected, flags);
            }

            @Override
            public void performAction(int type) {
                if (type == 1) {
                    MotionEditor.this.mTransitionPanel.mTimeLinePanel.notifyTimeLineListeners(MotionEditorSelector.TimeLineCmd.MOTION_CAPTURE, Float.valueOf(0.0f));
                }
            }

            @Override
            public void delete(MTag[] tags2, int flags) {
                MotionEditor.this.fireCommand(Command.Action.DELETE, tags2);
            }
        };
        this.mOverviewPanel.setActionListener(mTagActionListener);
        this.mTransitionPanel.setActionListener(mTagActionListener);
        this.mMainPanel.add(ui);
        DefaultToolbarImpl toolbarLeft = new DefaultToolbarImpl(this, "MotionEditorLeft", (List<? extends AnAction>)ImmutableList.of((Object)((Object)this.createConstrainSet), (Object)((Object)this.createTransition), (Object)this.clickOrSwipe));
        DefaultToolbarImpl toolbarRight = new DefaultToolbarImpl(this, "MotionEditorRight", (List<? extends AnAction>)ImmutableList.of((Object)this.cycleAction));
        JPanel toolbar = new JPanel(new BorderLayout());
        toolbar.add((Component)((Object)toolbarLeft), "West");
        toolbar.add((Component)((Object)toolbarRight), "East");
        this.mMainPanel.add((Component)toolbar, "North");
        this.layoutTop();
    }

    public void addSelectionListener(MotionEditorSelector.Listener listener2) {
        this.mMotionEditorSelector.addSelectionListener(listener2);
    }

    private void notifyListeners(MotionEditorSelector.Type type, MTag[] tags2, int flags) {
        this.mMotionEditorSelector.notifyListeners(type, tags2, flags);
    }

    public MeModel getMeModel() {
        return this.mMeModel;
    }

    public MTag getSelectedTag() {
        return this.mSelectedTag;
    }

    public void selectTag(MTag tag, int flags) {
        String tagName;
        this.mFlags = flags;
        String string = tagName = tag != null ? tag.getTagName() : null;
        if (tagName != null && tagName.equals(TRANSITION_PANEL)) {
            if (this.mTransitionPanel.mTimeLinePanel.isPlaying()) {
                return;
            }
            this.mTransitionPanel.mTimeLinePanel.resetMotionProgress();
        }
        if (tag != null && tagName != null && tag.equals(this.mSelectedTag)) {
            this.mConstraintSetPanel.clearSelection();
            this.mLayoutPanel.clearSelection();
            this.mTransitionPanel.clearSelection();
            this.mMeModel.setSelectedViewIDs(new ArrayList<String>());
            this.notifyListeners(this.findSelectionType(tagName), new MTag[]{tag}, flags);
        }
        this.mSelectedTag = tag;
        if (tag != null) {
            this.mCombinedListPanel.selectTag(tag);
        }
    }

    private MotionEditorSelector.Type findSelectionType(String tagName) {
        switch (tagName) {
            case "ConstraintSet": {
                return MotionEditorSelector.Type.CONSTRAINT_SET;
            }
            case "Transition": {
                return MotionEditorSelector.Type.TRANSITION;
            }
        }
        return MotionEditorSelector.Type.LAYOUT;
    }

    public void setMTag(MTag motionScene, MTag layout2, String layoutFileName, String motionSceneFileName, String setupError) {
        if (setupError == null && this.myErrorPanel.validateMotionScene(motionScene)) {
            this.mErrorSwitchCard.show(this, MAIN_PANEL);
            this.setMTag(new MeModel(motionScene, layout2, layoutFileName, motionSceneFileName, this.myTrack));
        } else {
            if (setupError != null) {
                this.myErrorPanel.myErrorLabel.setText("<HTML>MotionScene error:<ul>" + setupError + "</ul></HTML>");
            }
            this.mErrorSwitchCard.show(this, ERROR_PANEL);
        }
    }

    private MTag findSelectedTagInNewModel(MeModel newModel2) {
        if (this.mSelectedTag instanceof MotionSceneTag) {
            return newModel2.motionScene.getChildTagWithTreeId(this.mSelectedTag.getTagName(), this.mSelectedTag.getTreeId());
        }
        if (this.mSelectedTag instanceof NlComponentTag) {
            return newModel2.layout;
        }
        return null;
    }

    private static MTag asConstraintSet(MTag selection) {
        return selection != null && selection.getTagName().equals(CONSTRAINTSET_PANEL) ? selection : null;
    }

    private static MTag asTransition(MTag selection) {
        return selection != null && selection.getTagName().equals(TRANSITION_PANEL) ? selection : null;
    }

    private static MTag asLayout(MTag selection) {
        return selection instanceof NlComponentTag ? selection : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMTag(MeModel model2) {
        this.mUpdatingModel = true;
        try {
            MTag newSelection = this.findSelectedTagInNewModel(model2);
            model2.setSelectedViewIDs(this.mMeModel != null ? this.mMeModel.getSelectedViewIDs() : MeModel.EMPTY_STRING_ARRAY);
            this.mSelectedTag = newSelection;
            this.mMeModel = model2;
            this.mMotionSceneTabb.setMTag(this.mMeModel.motionScene);
            this.mCombinedListPanel.setMTag(this.mMeModel.motionScene, this.mMeModel.layout);
            this.mOverviewPanel.setMTag(this.mMeModel.motionScene, this.mMeModel.layout);
            this.mLayoutPanel.setMTag(MotionEditor.asLayout(newSelection), this.mMeModel);
            this.mConstraintSetPanel.setMTag(MotionEditor.asConstraintSet(newSelection), this.mMeModel);
            this.mTransitionPanel.setMTag(MotionEditor.asTransition(newSelection), this.mMeModel);
            this.mSelectedTag = newSelection;
            MTag[] mtags = model2.motionScene.getChildTags(CONSTRAINTSET_PANEL);
            this.createTransition.setEnabled(mtags.length >= 2);
            mtags = model2.motionScene.getChildTags(TRANSITION_PANEL);
            this.clickOrSwipe.setEnabled(mtags.length >= 1);
        }
        finally {
            this.mUpdatingModel = false;
        }
    }

    public boolean isUpdatingModel() {
        return this.mUpdatingModel;
    }

    private void layoutTop() {
        this.mLayoutMode = this.mLayoutMode == null ? LayoutMode.OVERVIEW_ONLY_LAYOUT : LayoutMode.values()[(this.mLayoutMode.ordinal() + 1) % LayoutMode.values().length];
        Track.changeLayout(this.myTrack);
        switch (this.mLayoutMode) {
            case VERTICAL_LAYOUT: {
                this.mCombinedListPanel.setSplitView(true);
                this.mTopPanel.setOrientation(0);
                this.mTopPanel.remove(this.mCombinedListPanel);
                this.mTopPanel.remove(this.mOverviewScrollPane);
                this.mTopPanel.setBottomComponent(this.mCombinedListPanel);
                this.mTopPanel.setTopComponent(this.mOverviewScrollPane);
                this.mTopPanel.setResizeWeight(0.666);
                this.mTopPanel.setDividerLocation(0.666);
                this.mTopPanel.setEnabled(false);
                this.mTopPanel.setDividerSize(0);
                break;
            }
            case HORIZONTAL_LAYOUT: {
                this.mCombinedListPanel.setSplitView(false);
                this.mTopPanel.setOrientation(1);
                this.mTopPanel.remove(this.mCombinedListPanel);
                this.mTopPanel.remove(this.mOverviewScrollPane);
                this.mTopPanel.setRightComponent(this.mOverviewScrollPane);
                this.mTopPanel.setLeftComponent(this.mCombinedListPanel);
                this.mTopPanel.setResizeWeight(0.333);
                this.mTopPanel.setDividerLocation(0.333);
                this.mTopPanel.setEnabled(false);
                this.mTopPanel.setDividerSize(0);
                break;
            }
            case OVERVIEW_ONLY_LAYOUT: {
                this.mCombinedListPanel.setSplitView(false);
                this.mTopPanel.setOrientation(1);
                this.mTopPanel.remove(this.mCombinedListPanel);
                this.mTopPanel.remove(this.mOverviewScrollPane);
                this.mTopPanel.setRightComponent(this.mOverviewScrollPane);
                this.mTopPanel.setResizeWeight(0.0);
                this.mTopPanel.setDividerLocation(0.0);
                this.mTopPanel.setEnabled(false);
                this.mTopPanel.setDividerSize(0);
            }
        }
        this.mTopPanel.validate();
    }

    void listSelection() {
        int index = this.mCombinedListPanel.getSelectedConstraintSet();
        if (index >= 0) {
            this.constraintSetSelection();
        } else {
            this.transitionSelection();
        }
    }

    void constraintSetSelection() {
        int index = this.mCombinedListPanel.getSelectedConstraintSet();
        this.mOverviewPanel.setConstraintSetIndex(index);
        this.mTransitionPanel.stopAnimation();
        if (index >= 0) {
            Track.showConstraintSetTable(this.myTrack);
            MTag[] c_sets = this.mCombinedListPanel.mMotionScene.getChildTags(CONSTRAINTSET_PANEL);
            if (0 < index) {
                this.mCurrentlyDisplaying = CONSTRAINTSET_PANEL;
                this.mCardLayout.show(this.mCenterPanel, CONSTRAINTSET_PANEL);
                MTag selectedConstraintSet = c_sets[index - 1];
                this.notifyListeners(MotionEditorSelector.Type.CONSTRAINT_SET, new MTag[]{selectedConstraintSet}, 0);
                this.mSelectedTag = selectedConstraintSet;
                this.mConstraintSetPanel.setMTag(selectedConstraintSet, this.mMeModel);
            } else {
                MTag[] mTagArray;
                Track.showLayoutTable(this.myTrack);
                this.mCurrentlyDisplaying = LAYOUT_PANEL;
                this.mCardLayout.show(this.mCenterPanel, LAYOUT_PANEL);
                if (this.mCombinedListPanel.mMotionLayout == null) {
                    mTagArray = new MTag[]{};
                } else {
                    MTag[] mTagArray2 = new MTag[1];
                    mTagArray = mTagArray2;
                    mTagArray2[0] = this.mCombinedListPanel.mMotionLayout;
                }
                this.notifyListeners(MotionEditorSelector.Type.LAYOUT, mTagArray, 0);
                this.mLayoutPanel.setMTag(this.mCombinedListPanel.mMotionLayout, this.mMeModel);
                this.mSelectedTag = this.mCombinedListPanel.mMotionLayout;
            }
        }
    }

    void transitionSelection() {
        Track.transitionSelection(this.myTrack);
        int index = this.mCombinedListPanel.getSelectedTransition();
        this.mOverviewPanel.setTransitionSetIndex(index);
        this.mCurrentlyDisplaying = TRANSITION_PANEL;
        this.mCardLayout.show(this.mCenterPanel, TRANSITION_PANEL);
        MTag[] transitions2 = this.mCombinedListPanel.mMotionScene.getChildTags(TRANSITION_PANEL);
        if (transitions2.length == 0) {
            this.constraintSetSelection();
            return;
        }
        MTag selectedTransition = transitions2[index];
        this.mTransitionPanel.setMTag(selectedTransition, this.mMeModel);
        this.notifyListeners(MotionEditorSelector.Type.TRANSITION, new MTag[]{selectedTransition}, this.mFlags);
        this.mSelectedTag = selectedTransition;
    }

    public void selectTransition() {
        this.mCombinedListPanel.selectTransition();
        this.transitionSelection();
    }

    public void addTimeLineListener(MotionEditorSelector.TimeLineListener timeLineListener) {
        this.mTransitionPanel.addTimeLineListener(timeLineListener);
    }

    public int getPlayMode() {
        return this.mTransitionPanel.mTimeLinePanel.getYoyoMode();
    }

    public float getTimeLineSpeed() {
        return this.mTransitionPanel.mTimeLinePanel.getSpeedMultiplier();
    }

    class MotionScenePanel
    extends JPanel {
        Icon icon;
        JTextField mDefaultDurationText;
        JButton mTransitionHeader;
        DefaultTableModel mTransitionModel;
        JTable mTransitionTable;
        JScrollPane mSPTransition;
        JButton mConstraintSetHeader;
        DefaultTableModel mConstraintSetModel;
        JTable mConstraintSetTable;
        JScrollPane mSPConstraintSet;

        private void stripButton(JButton button) {
            button.setBackground(this.getBackground());
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            button.setFocusPainted(false);
            button.setOpaque(false);
            button.setAlignmentX(1.0f);
        }

        public void setMTag(MTag motionScene) {
            String value2 = motionScene.getAttributeValue("defaultDuration");
            this.mDefaultDurationText.setText(value2 == null ? "" : value2);
            MTag[] transitions2 = motionScene.getChildTags(MotionEditor.TRANSITION_PANEL);
            this.mTransitionHeader.setText("Transitions (" + transitions2.length + ")");
            Object[] table_data = new String[4];
            this.mTransitionModel.setNumRows(0);
            for (int i = 0; i < transitions2.length; ++i) {
                MTag t = transitions2[i];
                String id2 = t.getAttributeValue("id");
                String start = t.getAttributeValue("constraintSetStart");
                String end = t.getAttributeValue("constraintSetEnd");
                String duration = t.getAttributeValue("duration");
                table_data[0] = id2;
                table_data[1] = start;
                table_data[2] = end;
                table_data[3] = duration;
                this.mTransitionModel.addRow(table_data);
            }
            this.mTransitionModel.fireTableDataChanged();
            MTag[] sets = motionScene.getChildTags(MotionEditor.CONSTRAINTSET_PANEL);
            this.mConstraintSetModel.setNumRows(0);
            for (int i = 0; i < sets.length; ++i) {
                MTag t = sets[i];
                String id3 = t.getAttributeValue("id");
                String derive = t.getAttributeValue("deriveConstraintsFrom");
                if (derive == null) {
                    derive = "(base)";
                }
                MTag[] children = t.getChildTags();
                table_data[0] = id3;
                table_data[1] = derive;
                table_data[2] = "" + children.length;
                this.mConstraintSetModel.addRow(table_data);
            }
            this.mConstraintSetModel.fireTableDataChanged();
        }

        MotionScenePanel() {
            super(new GridBagLayout());
            this.icon = UIManager.getIcon("Tree.closedIcon");
            this.mDefaultDurationText = new JTextField();
            this.mTransitionHeader = new JButton("Transitions (1)", this.icon);
            this.mTransitionModel = new DefaultTableModel(new String[]{"id", "start", "end", "duration"}, 0);
            this.mTransitionTable = new JTable(this.mTransitionModel);
            this.mSPTransition = new JScrollPane(this.mTransitionTable);
            this.mConstraintSetHeader = new JButton("ConstraintSets (2)", this.icon);
            this.mConstraintSetModel = new DefaultTableModel(new String[]{"id", "derived", "Constraints"}, 0);
            this.mConstraintSetTable = new JTable(this.mConstraintSetModel);
            this.mSPConstraintSet = new JScrollPane(this.mConstraintSetTable);
            this.stripButton(this.mTransitionHeader);
            this.stripButton(this.mConstraintSetHeader);
            Insets table_inset = new Insets(0, 20, 0, 20);
            GridBagConstraints gbc = new GridBagConstraints();
            Insets default_inset = gbc.insets;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            JLabel label = new JLabel("Default Duration");
            this.add((Component)label, gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            this.mDefaultDurationText.setText("XXXXXXXX");
            this.mDefaultDurationText.setPreferredSize(this.mDefaultDurationText.getPreferredSize());
            this.mDefaultDurationText.setText(" 1000ms");
            this.add((Component)this.mDefaultDurationText, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            this.add((Component)this.mTransitionHeader, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            this.add((Component)new JSeparator(), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.fill = 1;
            gbc.insets = table_inset;
            this.mSPTransition.setPreferredSize(this.mTransitionTable.getPreferredSize());
            gbc.weighty = 1.0;
            this.add((Component)this.mSPTransition, gbc);
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            gbc.insets = default_inset;
            gbc.fill = 2;
            this.add((Component)this.mConstraintSetHeader, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            this.add((Component)new JSeparator(), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 20, 0, 20);
            this.mSPConstraintSet.setPreferredSize(this.mConstraintSetTable.getPreferredSize());
            this.add((Component)this.mSPConstraintSet, gbc);
            gbc.weighty = 0.0;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            this.add((Component)new JComponent(){}, gbc);
        }
    }

    public static interface Command {
        public void perform(Action var1, MTag[] var2);

        public static enum Action {
            DELETE,
            COPY;

        }
    }

    static enum LayoutMode {
        VERTICAL_LAYOUT,
        HORIZONTAL_LAYOUT,
        OVERVIEW_ONLY_LAYOUT;

    }
}

