/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEJTable;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MeModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class LayoutPanel
extends JPanel {
    private static boolean DEBUG = false;
    ArrayList<MTag> mParent;
    MTag mMotionLayout;
    ArrayList<MTag> mDisplayedRows = new ArrayList();
    DefaultTableModel mConstraintSetModel = new DefaultTableModel(new String[]{"Type", "id", "Constrained"}, 0);
    JTable mConstraintSetTable = new MEJTable(this.mConstraintSetModel);
    private String mDerived;
    private MeModel mMeModel;
    private JLabel mTitle;
    private MotionEditorSelector mMotionEditorSelector;
    private boolean mBuildingTable;
    static String[] ourLayoutDir = new String[]{"Left_", "Right_", "Start_", "End_", "Top_", "Bottom_", "Baseline_"};
    static String[] ourConstraintLabel = new String[]{"horizontal", "horizontal", "horizontal", "horizontal", "vertical", "vertical", "vertical"};
    static HashMap<String, String> labelType = new HashMap();

    LayoutPanel() {
        super(new BorderLayout());
        JPanel left = new JPanel(new FlowLayout(0));
        JPanel right2 = new JPanel(new FlowLayout(2));
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)left, "West");
        top.add((Component)right2, "East");
        top.setBorder(MEUI.getPanelBottomBorder());
        this.mConstraintSetTable.setShowHorizontalLines(false);
        this.mTitle = new JLabel("Layout ", MEIcons.LIST_LAYOUT, 2);
        left.add(this.mTitle);
        JScrollPane transitionProperties = new JScrollPane(this.mConstraintSetTable);
        transitionProperties.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)transitionProperties, "Center");
        this.add((Component)top, "North");
        this.mConstraintSetTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                this.setBorder(noFocusBorder);
                return this;
            }
        });
        this.mConstraintSetTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !this.mBuildingTable) {
                this.tableSelection();
            }
        });
    }

    private void tableSelection() {
        MTag[] mTagArray;
        int index = this.mConstraintSetTable.getSelectedRow();
        Track.layoutTableSelect(this.mMeModel.myTrack);
        if (index == -1 || this.mDisplayedRows.size() == 0) {
            mTagArray = new MTag[]{};
        } else {
            MTag[] mTagArray2 = new MTag[1];
            mTagArray = mTagArray2;
            mTagArray2[0] = this.mDisplayedRows.get(index);
        }
        MTag[] tag = mTagArray;
        if (tag.length != 0) {
            this.mMeModel.setSelectedViewIDs(Arrays.asList(Utils.stripID(tag[0].getAttributeValue("id"))));
        } else {
            this.mMeModel.setSelectedViewIDs(MeModel.EMPTY_STRING_ARRAY);
        }
        this.mMotionEditorSelector.notifyListeners(MotionEditorSelector.Type.LAYOUT_VIEW, tag, 0);
    }

    public void buildTable() {
        this.mBuildingTable = true;
        HashSet found = new HashSet();
        this.mConstraintSetModel.setNumRows(0);
        this.mDisplayedRows.clear();
        if (this.mMotionLayout == null) {
            return;
        }
        MTag[] sets = this.mMotionLayout.getChildTags();
        for (int i = 0; i < sets.length; ++i) {
            MTag view2 = sets[i];
            Object[] row = new String[3];
            String id2 = Utils.stripID(view2.getAttributeValue("id"));
            row[0] = view2.getTagName();
            ArrayList<MTag> children = view2.getChildren();
            HashMap<String, MTag.Attribute> attrs = view2.getAttrList();
            row[1] = id2;
            HashSet<String> constrained_sides = new HashSet<String>();
            Set<String> alist = attrs.keySet();
            for (String key : alist) {
                if (!key.contains("layout_")) continue;
                for (String s : labelType.keySet()) {
                    if (!key.contains(s)) continue;
                    constrained_sides.add(labelType.get(s));
                }
            }
            row[2] = Arrays.toString(constrained_sides.toArray(new String[0]));
            this.mDisplayedRows.add(view2);
            this.mConstraintSetModel.addRow(row);
        }
        this.mBuildingTable = false;
        this.mConstraintSetModel.fireTableDataChanged();
    }

    private void updateModelIfNecessary() {
        Set found;
        Set ids = Arrays.stream(this.mMotionLayout.getChildTags()).map(view2 -> Utils.stripID(view2.getAttributeValue("id"))).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!ids.equals(found = this.mConstraintSetModel.getDataVector().stream().map(row -> (String)row.get(1)).collect(Collectors.toSet()))) {
            this.buildTable();
        }
    }

    private String getMask(ArrayList<MTag> children, HashMap<String, MTag.Attribute> attrs, String id2) {
        if (children.size() == 0 || attrs.size() > 1 && id2 != null) {
            return "all";
        }
        Object mask = "";
        for (MTag child : children) {
            mask = (String)mask + (((String)mask).isEmpty() ? "" : "|") + child.getTagName();
        }
        return mask;
    }

    public void setMTag(MTag layout2, MeModel meModel) {
        this.mMeModel = meModel;
        this.mMotionLayout = layout2;
        this.mDerived = null;
        String label = "Layout " + meModel.layoutFileName;
        if (layout2 != null) {
            label = label + " (" + Utils.stripID(layout2.getAttributeValue("id")) + ")";
        }
        this.mTitle.setText(label);
        String[] selected = this.mMeModel != null ? this.mMeModel.getSelectedViewIDs() : MeModel.EMPTY_STRING_ARRAY;
        this.buildTable();
        if (layout2 != null) {
            this.selectByIds(selected);
        }
    }

    public void setListeners(MotionEditorSelector listeners) {
        this.mMotionEditorSelector = listeners;
    }

    public void selectByIds(String[] ids) {
        this.updateModelIfNecessary();
        HashSet<String> selectedSet = new HashSet<String>(Arrays.asList(ids));
        this.mConstraintSetTable.clearSelection();
        for (int i = 0; i < this.mConstraintSetModel.getRowCount(); ++i) {
            String id2 = (String)this.mConstraintSetModel.getValueAt(i, 1);
            if (!selectedSet.contains(id2)) continue;
            this.mConstraintSetTable.addRowSelectionInterval(i, i);
        }
    }

    public void clearSelection() {
        this.mConstraintSetTable.clearSelection();
    }

    static {
        for (int i = 0; i < ourLayoutDir.length; ++i) {
            labelType.put(ourLayoutDir[i], ourConstraintLabel[i]);
        }
    }
}

