/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEIcons;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TimeLineTopLeft
extends JPanel {
    JButton mForward = MEUI.createToolBarButton(MEIcons.FORWARD, "Jump to the end of the Transition");
    JButton mBackward = MEUI.createToolBarButton(MEIcons.BACKWARD, "Jump to the start of the Transition");
    JButton mPlay = MEUI.createToolBarButton(MEIcons.PLAY, "Play the transition");
    JButton mSlow = MEUI.createToolBarButton(MEIcons.SMALL_DOWN_ARROW, "x1");
    JButton mLoop = MEUI.createToolBarButton(MEIcons.LOOP_FORWARD, "Cycle between forward, backward, and yoyo");
    JButton[] buttons = new JButton[]{this.mLoop, this.mBackward, this.mPlay, this.mForward, this.mSlow};
    Icon[] loop_cycle = new Icon[]{MEIcons.LOOP_FORWARD, MEIcons.LOOP_BACKWARD, MEIcons.LOOP_YOYO};
    int loopMode = 0;
    boolean mIsPlaying = false;
    ArrayList<ControlsListener> mTimeLineListeners = new ArrayList();

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.buttons == null) {
            return;
        }
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MEUI.ourBorder));
        this.setPreferredSize(new Dimension(MEUI.ourLeftColumnWidth, MEUI.ourHeaderHeight));
        Dimension size = new Dimension(MEUI.scale(13), MEUI.scale(13));
        for (int i = 0; i < this.buttons.length; ++i) {
            JButton button = this.buttons[i];
            button.setPreferredSize(size);
        }
    }

    TimeLineTopLeft() {
        super(new GridBagLayout());
        this.mSlow.setText("1.0x");
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, MEUI.ourBorder));
        this.setBackground(MEUI.ourSecondaryPanelBackground);
        Dimension size = new Dimension(MEUI.scale(13), MEUI.scale(13));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(MEUI.scale(1), MEUI.scale(1), MEUI.scale(1), MEUI.scale(1));
        for (int i = 0; i < this.buttons.length; ++i) {
            JButton button = this.buttons[i];
            button.setBackground(this.getBackground());
            TimelineCommands cmd = TimelineCommands.values()[i];
            if (cmd == TimelineCommands.SPEED) {
                gbc.weightx = 1.0;
                gbc.fill = 2;
                button.setForeground(MEUI.ourTextColor);
                button.setHorizontalTextPosition(2);
                button.setFont(MEUI.getToolBarButtonSmallFont());
            } else {
                gbc.weightx = 0.05;
                gbc.fill = 0;
            }
            button.setPreferredSize(size);
            this.add((Component)button, gbc);
            ++gbc.gridx;
            gbc.insets.left = 0;
        }
        this.mBackward.addActionListener(e -> {
            this.displayPlay();
            this.command(TimelineCommands.START, 0);
        });
        this.mForward.addActionListener(e -> {
            this.displayPlay();
            this.command(TimelineCommands.END, 0);
        });
        this.mPlay.addActionListener(e -> {
            if (this.mIsPlaying) {
                this.displayPlay();
                this.command(TimelineCommands.PAUSE, 0);
            } else {
                this.displayPause();
                this.command(TimelineCommands.PLAY, 0);
            }
        });
        this.mSlow.addActionListener(e -> this.command(TimelineCommands.SPEED, 0));
        this.mLoop.addActionListener(e -> {
            this.loopMode = (this.loopMode + 1) % 3;
            this.mLoop.setIcon(this.loop_cycle[this.loopMode]);
            this.command(TimelineCommands.LOOP, this.loopMode);
        });
        this.setPreferredSize(new Dimension(MEUI.ourLeftColumnWidth, MEUI.ourHeaderHeight));
    }

    void command(TimelineCommands commands2, int mode) {
        this.notifyTimeLineListeners(commands2, mode);
    }

    public void addControlsListener(ControlsListener listener2) {
        this.mTimeLineListeners.add(listener2);
    }

    public void notifyTimeLineListeners(TimelineCommands cmd, int mode) {
        for (ControlsListener listener2 : this.mTimeLineListeners) {
            listener2.action(cmd, mode);
        }
    }

    public void displayPlay() {
        this.mIsPlaying = false;
        this.mPlay.setIcon(MEIcons.PLAY);
    }

    public void displayPause() {
        this.mIsPlaying = true;
        this.mPlay.setIcon(MEIcons.PAUSE);
    }

    public static enum TimelineCommands {
        LOOP,
        START,
        PLAY,
        END,
        SPEED,
        PAUSE;

    }

    public static interface ControlsListener {
        public void action(TimelineCommands var1, int var2);
    }
}

