/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.timeline;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;

public class TickMarkCalculator {
    private float actual_minx;
    private float actual_maxx;
    private float minx;
    private float maxx;
    private float mTickX;
    int ins_left = MEUI.scale(10);
    int ins_right = MEUI.scale(15);
    int ins_top = 0;
    int ins_botom = 0;
    int mCanvasWidth;
    DecimalFormat df = new DecimalFormat("###.##");
    int mGraphWidth;

    public void setInsets(int l, int r, int t, int b) {
        this.ins_botom = b;
        this.ins_left = l;
        this.ins_right = r;
        this.ins_top = t;
    }

    public void setRange(float min, float max) {
        this.actual_minx = min;
        this.actual_maxx = max;
    }

    public void calcRangeTicks(int canvasWidth) {
        this.mCanvasWidth = canvasWidth;
        double dx = this.actual_maxx - this.actual_minx;
        int sw = canvasWidth;
        double border = 1.09345;
        this.mTickX = (float)TickMarkCalculator.calcTick(sw, dx);
        dx = (double)this.mTickX * Math.ceil(border * dx / (double)this.mTickX);
        double tx = ((double)(this.actual_minx + this.actual_maxx) - dx) / 2.0;
        this.minx = this.actual_minx;
        tx = ((double)(this.actual_minx + this.actual_maxx) + dx) / 2.0;
        tx = (double)this.mTickX * Math.ceil(tx / (double)this.mTickX);
        this.maxx = this.actual_maxx;
    }

    public static double calcTick(int scr, double range) {
        int aprox_x_ticks = scr / 100;
        int type = 1;
        double best = Math.log10(range / (double)aprox_x_ticks);
        double n = Math.log10(range / (double)(aprox_x_ticks * 2));
        if (TickMarkCalculator.frac(n) < TickMarkCalculator.frac(best)) {
            best = n;
            type = 2;
        }
        if (TickMarkCalculator.frac(n = Math.log10(range / (double)(aprox_x_ticks * 5))) < TickMarkCalculator.frac(best)) {
            best = n;
            type = 5;
        }
        return (double)type * Math.pow(10.0, Math.floor(best));
    }

    public int getCount() {
        float e = 1.0E-4f * (this.maxx - this.minx);
        return 1 + (int)(0.5 + (double)((this.maxx - this.minx) / this.mTickX));
    }

    public void calcTicks(int[] ticks) {
        int draw_width = this.mCanvasWidth - this.ins_left - this.ins_right;
        float e = 1.0E-4f * (this.maxx - this.minx);
        int tcount = 0;
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            float fx = this.mTickX * (float)i;
            int ix = (int)((float)draw_width * fx / (this.maxx - this.minx) + (float)this.ins_left);
            ticks[tcount++] = ix;
        }
    }

    public int floatToPosition(float value2) {
        int draw_width = this.mCanvasWidth - this.ins_left - this.ins_right;
        int ix = (int)((float)draw_width * (value2 + this.minx) / (this.maxx - this.minx) + (float)this.ins_left);
        return ix;
    }

    public int paint(Graphics2D g, int w, int h, int[] ticks) {
        int draw_width = this.mCanvasWidth - this.ins_left - this.ins_right;
        float e = 1.0E-4f * (this.maxx - this.minx);
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int text_height = fm.getHeight();
        int top = text_height / 2;
        int tcount = 0;
        int count = this.getCount();
        for (int x = 0; x < count; ++x) {
            float fx = this.mTickX * (float)x;
            int ix = (int)((float)draw_width * fx / (this.maxx - this.minx) + (float)this.ins_left);
            ticks[tcount++] = ix;
            g.drawLine(ix, top + text_height, ix, h - this.ins_botom);
            String str = this.df.format(fx + this.minx);
            int sw = fm.stringWidth(str) / 2;
            g.drawString(str, ix - sw, ascent + top);
        }
        return tcount;
    }

    static double frac(double x) {
        return x - Math.floor(x);
    }
}

