/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.adapters;

import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewPanel;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.GifWriter;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.WaitFor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MESaveGif {
    GifWriter mWriter;
    private AtomicBoolean isRenderCompleted = new AtomicBoolean(false);
    private final ModelListener myModelListener = new ModelListener(){

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            MESaveGif.this.isRenderCompleted.set(true);
        }
    };

    public MESaveGif(File file2, int timeBetweenFramesMS, boolean loopContinuously, String comment) {
        this.mWriter = new GifWriter(file2, timeBetweenFramesMS, loopContinuously, comment);
    }

    public void saveGif(final NlDesignSurface designSurface, final int numSavedImages, final int yoyoMode, final MotionLayoutComponentHelper helper, Project myProject, final int waitForTime) {
        ((NlModel)designSurface.getModels().get(0)).addListener(this.myModelListener);
        new Task.Modal(myProject, "Saving Gif", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(String.format(Locale.US, "saving %d / %d frames", 0, numSavedImages));
                indicator.setIndeterminate(false);
                JComponent pane = designSurface.getInteractionPane();
                if (pane instanceof SceneViewPanel) {
                    boolean shouldTranslate;
                    int size = yoyoMode == 2 ? numSavedImages / 2 : numSavedImages;
                    int margin = 50;
                    SceneViewPanel mySceneViewPanel = (SceneViewPanel)pane;
                    int panelWidth = mySceneViewPanel.getWidth();
                    int panelHeight = mySceneViewPanel.getHeight();
                    SceneView view2 = designSurface.getFocusedSceneView();
                    Dimension dim2 = view2.getContentSize(null);
                    double viewScale = view2.getScale();
                    double maxScale = 1.0;
                    boolean bl = shouldTranslate = maxScale >= viewScale;
                    if (viewScale < maxScale) {
                        maxScale = viewScale;
                    }
                    int width2 = (int)(dim2.getWidth() * maxScale) + margin;
                    int height2 = (int)(dim2.getHeight() * maxScale) + margin;
                    double dScale = maxScale / viewScale;
                    int translateX = -(panelWidth - width2) / 2;
                    int translateY = -(panelHeight - height2) / 2;
                    try {
                        int frame;
                        String progressText = "Saving %d / %d frames";
                        float step = 1.0f / (float)size;
                        boolean isFirstPass = true;
                        int i = 0;
                        while (i < size) {
                            frame = i++;
                            MESaveGif.this.saveImage(indicator, size, mySceneViewPanel, shouldTranslate, width2, height2, dScale, translateX, translateY, progressText, step, frame, numSavedImages, yoyoMode, helper, waitForTime, isFirstPass);
                        }
                        isFirstPass = false;
                        if (yoyoMode == 2) {
                            int j = size;
                            while (j < numSavedImages) {
                                frame = j++;
                                MESaveGif.this.saveImage(indicator, size, mySceneViewPanel, shouldTranslate, width2, height2, dScale, translateX, translateY, progressText, step, frame, numSavedImages, yoyoMode, helper, waitForTime, isFirstPass);
                            }
                        }
                        indicator.setText("Saving Gif file...");
                        MESaveGif.this.mWriter.close();
                        helper.setProgress(0.0f);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)e.getMessage(), (String)"Failed to save gif file"));
                    }
                }
            }
        }.queue();
    }

    private void saveImage(@NotNull ProgressIndicator indicator, int size, SceneViewPanel mySceneViewPanel, boolean shouldTranslate, int width2, int height2, double dScale, int translateX, int translateY, String progressText, float step, int frame, int numSavedImages, int yoyoMode, MotionLayoutComponentHelper helper, int waitForTime, boolean isFirstPass) {
        this.isRenderCompleted.set(false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            indicator.setText(String.format(Locale.US, progressText, frame + 1, numSavedImages));
            indicator.setFraction((double)(1.0f * (float)(frame + 1) / (float)numSavedImages));
            BufferedImage img = new BufferedImage(width2, height2, 1);
            Graphics2D g2d = img.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (shouldTranslate) {
                g2d.translate(translateX, translateY);
            }
            g2d.scale(dScale, dScale);
            if (yoyoMode == 0 || isFirstPass && yoyoMode == 2) {
                helper.setProgress(step * (float)frame);
            } else if (yoyoMode == 1) {
                helper.setProgress(step * (float)(size - frame));
            } else {
                helper.setProgress(step * (float)(size - (frame + 1 - size)));
            }
            new WaitFor(waitForTime){

                protected boolean condition() {
                    return MESaveGif.this.isRenderCompleted.get();
                }
            };
            mySceneViewPanel.paint(g2d);
            try {
                this.mWriter.addImage(img);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

