/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.io.PsiFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class MotionSceneTagWriter
extends MotionSceneTag
implements MTag.TagWriter {
    private MotionSceneTag mTag;
    private String mType;
    private ArrayList<MTag.CommitListener> myListeners = new ArrayList();
    private HashMap<String, MTag.Attribute> mNewAttrList = new LinkedHashMap<String, MTag.Attribute>();
    private DeleteTag deleteRun;

    public MotionSceneTagWriter(MotionSceneTag parent, String type) {
        super(null, parent);
        this.mType = type;
    }

    public MotionSceneTagWriter(MotionSceneTag tag) {
        super(tag.myXmlTag, tag.mParent);
        this.mTag = tag;
        this.mType = tag.getTagName();
    }

    @Override
    public String getTagName() {
        return this.mType;
    }

    @Override
    public void setAttribute(String type, String attribute, String value2) {
        MTag.Attribute a = new MTag.Attribute();
        a.mAttribute = type + ":" + attribute;
        a.mAttribute = attribute;
        a.mNamespace = type;
        a.mValue = value2;
        Track track2 = MotionSceneTagWriter.getRoot((MotionSceneTag)this).myTrack;
        Track.motionEditorEdit(track2);
        this.mAttrList.put(a.mAttribute, a);
        this.mNewAttrList.put(a.mAttribute, a);
    }

    @Override
    public MTag.TagWriter getChildTagWriter(String name) {
        MotionSceneTagWriter ret = new MotionSceneTagWriter(this, name);
        this.myChildren.add(ret);
        return ret;
    }

    @Override
    public MTag commit(String commandName) {
        boolean tagCreated = false;
        if (this.deleteRun != null) {
            this.deleteRun.delete(commandName);
            this.deleteRun = null;
            return null;
        }
        MotionSceneTag.Root root = MotionSceneTagWriter.getRoot(this);
        if (root == null) {
            return null;
        }
        if (this.myXmlTag != null) {
            this.update(root, commandName);
        } else {
            this.myXmlTag = MotionSceneTagWriter.createTag(this.mType, this, root, commandName);
            tagCreated = true;
        }
        MotionSceneTag result = new MotionSceneTag(this.myXmlTag, this.mParent);
        for (MTag child : this.myChildren) {
            if (!(child instanceof MotionSceneTagWriter)) continue;
            MotionSceneTagWriter tagWriter = (MotionSceneTagWriter)child;
            result.myChildren.add(tagWriter.commit(commandName));
        }
        if (tagCreated && !(this.mParent instanceof MotionSceneTagWriter)) {
            this.mParent.myChildren.add(result);
        }
        this.notifyListeners(result);
        return result;
    }

    private void update(MotionSceneTag.Root root, String commandName) {
        WriteCommandAction.runWriteCommandAction((Project)root.mProject, (String)commandName, null, () -> {
            MTag.Attribute a;
            boolean hasVerticalConstraint = false;
            boolean hasHorizontalConstraint = false;
            CommandProcessor.getInstance().addAffectedFiles(root.mProject, new VirtualFile[]{root.mModel.getFile().getVirtualFile()});
            CommandProcessor.getInstance().addAffectedFiles(root.mProject, new VirtualFile[]{root.mXmlFile.getVirtualFile()});
            for (String key : this.mNewAttrList.keySet()) {
                MTag.Attribute attr2 = this.mNewAttrList.get(key);
                hasVerticalConstraint |= MotionSceneAttrs.VERTICAL_CONSTRAINT_ATTRS.contains(attr2.mAttribute);
                hasHorizontalConstraint |= MotionSceneAttrs.HORIZONTAL_CONSTRAINT_ATTRS.contains(attr2.mAttribute);
                String namespace = MotionSceneAttrs.lookupName(attr2);
                this.myXmlTag.setAttribute(attr2.mAttribute, namespace, attr2.mValue);
                this.mTag.getAttrList().put(attr2.mAttribute, attr2);
            }
            if (hasVerticalConstraint) {
                this.myXmlTag.setAttribute("layout_editor_absoluteY", "http://schemas.android.com/apk/res-auto", null);
                a = new MTag.Attribute();
                a.mAttribute = "layout_editor_absoluteY";
                a.mNamespace = "http://schemas.android.com/apk/res-auto";
                this.mTag.getAttrList().put("layout_editor_absoluteY", a);
            }
            if (hasHorizontalConstraint) {
                this.myXmlTag.setAttribute("layout_editor_absoluteX", "http://schemas.android.com/apk/res-auto", null);
                a = new MTag.Attribute();
                a.mAttribute = "layout_editor_absoluteX";
                a.mNamespace = "http://schemas.android.com/apk/res-auto";
                this.mTag.getAttrList().put("layout_editor_absoluteX", a);
            }
        }, (PsiFile[])new PsiFile[]{root.mXmlFile, root.mModel.getFile()});
        MotionSceneTagWriter.saveAndNotify((PsiFile)root.mXmlFile, root.mModel);
    }

    private static MotionSceneTag.Root getRoot(MotionSceneTag tag) {
        while (!(tag instanceof MotionSceneTag.Root)) {
            tag = tag.mParent;
            if (tag != null) continue;
            return null;
        }
        return (MotionSceneTag.Root)tag;
    }

    private static XmlTag writeAction(MotionSceneTag.Root root, String commandName, Computable<XmlTag> computable, PsiFile ... files) {
        return (XmlTag)WriteCommandAction.writeCommandAction((Project)root.mProject, (PsiFile[])files).withName(commandName).withGroupId(null).compute(() -> (XmlTag)computable.compute());
    }

    public static XmlTag createTag(String type, MotionSceneTagWriter tag, MotionSceneTag.Root root, String commandName) {
        XmlTag createdTag = MotionSceneTagWriter.writeAction(root, commandName, (Computable<XmlTag>)((Computable)() -> {
            CommandProcessor.getInstance().addAffectedFiles(root.mProject, new VirtualFile[]{root.mModel.getFile().getVirtualFile()});
            CommandProcessor.getInstance().addAffectedFiles(root.mProject, new VirtualFile[]{root.mXmlFile.getVirtualFile()});
            XmlTag transitionTag = ((MotionSceneTag)tag.getParent()).myXmlTag;
            XmlTag child = transitionTag.createChildTag(type, null, null, false);
            child = transitionTag.addSubTag(child, false);
            for (String key : tag.mNewAttrList.keySet()) {
                MTag.Attribute attr2 = tag.mNewAttrList.get(key);
                String namespace = MotionSceneAttrs.lookupName(attr2);
                child.setAttribute(attr2.mAttribute, namespace, attr2.mValue);
            }
            return child;
        }), new PsiFile[]{root.mXmlFile, root.mModel.getFile()});
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)root.mProject, (VirtualFile)root.mVirtualFile);
        MotionSceneTagWriter.saveAndNotify((PsiFile)xmlFile, root.mModel);
        return createdTag;
    }

    @Override
    public MTag.TagWriter deleteTag() {
        if (this.deleteRun != null) {
            return this;
        }
        final MotionSceneTag.Root root = MotionSceneTagWriter.getRoot(this);
        if (root == null) {
            throw new RuntimeException("no root tag");
        }
        if (this.myXmlTag == null) {
            throw new RuntimeException("myXmlTag is null");
        }
        final XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)root.mProject, (VirtualFile)root.mVirtualFile);
        this.deleteRun = new DeleteTag(){

            @Override
            public void delete(String cmd) {
                WriteCommandAction.runWriteCommandAction((Project)root.mProject, (String)cmd, null, () -> {
                    CommandProcessor.getInstance().addAffectedFiles(root2.mProject, new VirtualFile[]{root2.mModel.getFile().getVirtualFile()});
                    CommandProcessor.getInstance().addAffectedFiles(root2.mProject, new VirtualFile[]{root2.mXmlFile.getVirtualFile()});
                    MotionSceneTagWriter.this.myXmlTag.delete();
                }, (PsiFile[])new PsiFile[]{xmlFile, root.mModel.getFile()});
            }
        };
        return this;
    }

    public static void saveAndNotify(PsiFile xmlFile, NlModel nlModel) {
        PsiFileUtil.saveFileIfNecessary(xmlFile);
        ApplicationManager.getApplication().invokeLater(() -> nlModel.notifyModified(NlModel.ChangeType.EDIT));
    }

    @Override
    public void addCommitListener(MTag.CommitListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeCommitListener(MTag.CommitListener listener2) {
        this.myListeners.remove(listener2);
    }

    private void notifyListeners(MotionSceneTag tag) {
        for (MTag.CommitListener listener2 : this.myListeners) {
            listener2.commit(tag);
        }
    }

    static interface DeleteTag {
        public void delete(String var1);
    }
}

