/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTagWriter;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

public class MotionSceneTag
implements MTag {
    private static final boolean DEBUG = false;
    XmlTag myXmlTag;
    MotionSceneTag mParent;
    ArrayList<MTag> myChildren = new ArrayList();
    HashMap<String, MTag.Attribute> mAttrList = new HashMap();

    MotionSceneTag() {
    }

    public MotionSceneTag(XmlTag tag, MotionSceneTag parent) {
        this.init(tag, parent);
    }

    protected void init(XmlTag tag, MotionSceneTag parent) {
        this.myXmlTag = tag;
        this.mParent = parent;
        if (tag == null) {
            return;
        }
        for (XmlTag xmlTag : tag.getSubTags()) {
            if ("Include".equalsIgnoreCase(xmlTag.getName())) {
                this.myChildren.add(new MotionSceneIncludeTag(xmlTag, this));
                continue;
            }
            this.myChildren.add(new MotionSceneTag(xmlTag, this));
        }
        for (XmlTag xmlTag : tag.getAttributes()) {
            MTag.Attribute a = new MTag.Attribute();
            a.mAttribute = xmlTag.getName();
            a.mAttribute = a.mAttribute.substring(a.mAttribute.indexOf(":") + 1);
            a.mNamespace = xmlTag.getNamespacePrefix();
            a.mValue = xmlTag.getValue();
            this.mAttrList.put(a.mAttribute, a);
        }
    }

    @Override
    public String getTagName() {
        if (this.myXmlTag == null) {
            return null;
        }
        return this.myXmlTag.getName();
    }

    @Override
    public ArrayList<MTag> getChildren() {
        return this.myChildren;
    }

    @Override
    public HashMap<String, MTag.Attribute> getAttrList() {
        return this.mAttrList;
    }

    @Override
    public MTag[] getChildTags() {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            if (!child.getTagName().equals(type)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String attribute, String value2) {
        if (value2 == null) {
            return null;
        }
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            String childValue = child.getAttributeValue(attribute);
            if (childValue == null || !childValue.endsWith(value2)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type, String attribute, String value2) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            String childValue;
            if (!child.getTagName().equals(type) || (childValue = child.getAttributeValue(attribute)) == null || !childValue.endsWith(value2)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag getChildTagWithTreeId(String type, String treeId) {
        if (treeId == null) {
            return null;
        }
        for (MTag child : this.myChildren) {
            String childValue;
            if (!child.getTagName().equals(type) || (childValue = child.getTreeId()) == null || !childValue.equals(treeId)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getTreeId() {
        switch (this.getTagName()) {
            case "ConstraintSet": {
                return Utils.stripID(this.getAttributeValue("id"));
            }
            case "Transition": {
                return String.format("%1$s|%2$s|%3$s", Utils.stripID(this.getAttributeValue("id")), Utils.stripID(this.getAttributeValue("constraintSetStart")), Utils.stripID(this.getAttributeValue("constraintSetEnd")));
            }
            case "KeyAttribute": 
            case "KeyPosition": 
            case "KeyCycle": 
            case "KeyTimeCycle": 
            case "KeyTrigger": {
                return this.computeKeyFrameTreeId();
            }
        }
        return null;
    }

    private String computeKeyFrameTreeId() {
        String tagName = this.getTagName();
        String target = this.getAttributeValue("motionTarget");
        String pos = this.getAttributeValue("framePosition");
        StringBuilder key = new StringBuilder();
        key.append(tagName);
        if (pos != null) {
            key.append(",").append(pos);
        }
        if (target != null) {
            if (target.startsWith("@")) {
                key.append("|Id:").append(Utils.stripID(target));
            } else {
                key.append("|Tag:").append(target);
            }
        }
        for (String keyAttribute : MotionSceneAttrs.KeyAttributeOptions) {
            if (this.getAttributeValue(keyAttribute) == null) continue;
            key.append(",").append(keyAttribute);
        }
        return key.toString();
    }

    @Override
    public String getAttributeValue(String attribute) {
        for (MTag.Attribute value2 : this.mAttrList.values()) {
            if (!value2.mAttribute.equals(attribute)) continue;
            return value2.mValue;
        }
        return null;
    }

    @Override
    public void print(String space) {
        System.out.println("\n" + space + "<" + this.getTagName() + ">");
        for (XmlAttribute value2 : this.myXmlTag.getAttributes()) {
            System.out.println(space + "   " + value2.getName() + "=\"" + value2.getValue() + "\"");
        }
        for (MTag child : this.myChildren) {
            child.print(space + "   ");
        }
        System.out.println(space + "</" + this.getTagName() + ">");
    }

    public XmlTag getXmlTag() {
        return this.myXmlTag != null && this.myXmlTag.isValid() ? this.myXmlTag : null;
    }

    @Override
    public String toXmlString() {
        return this.toFormalXmlString("");
    }

    @Override
    public String toFormalXmlString(String space) {
        Object ret = "";
        if (space == null) {
            ret = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            space = "";
        }
        ret = (String)ret + "\n" + space + "<" + this.getTagName();
        for (XmlAttribute value2 : this.myXmlTag.getAttributes()) {
            ret = (String)ret + "\n" + space + "   " + value2.getNamespacePrefix() + ":" + value2.getName() + "=\"" + value2.getValue() + "\"";
            ret = (String)ret + " getValue() = " + value2.getValue();
            ret = (String)ret + " getNamespacePrefix() = " + value2.getNamespacePrefix();
            ret = (String)ret + " getNamespace() = " + value2.getNamespace();
            ret = (String)ret + " getName() = " + value2.getName();
            ret = (String)ret + " getValue() = " + value2.getLocalName();
            ret = (String)ret + " getValue() = " + value2.getDisplayValue();
        }
        ret = (String)ret + " >\n";
        for (MTag child : this.myChildren) {
            ret = (String)ret + child.toFormalXmlString(space + "  ");
        }
        ret = (String)ret + space + "</" + this.getTagName() + ">\n";
        return ret;
    }

    @Override
    public void printFormal(String space, PrintStream out) {
        if (space == null) {
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            space = "";
        }
        out.print("\n" + space + "<" + this.getTagName());
        for (XmlAttribute value2 : this.myXmlTag.getAttributes()) {
            out.print("\n" + space + "   " + value2.getName() + "=\"" + value2.getValue() + "\"");
            String string = "  ";
        }
        out.println(" >");
        for (MTag child : this.myChildren) {
            child.printFormal(space + "  ", out);
        }
        out.println(space + "</" + this.getTagName() + ">");
    }

    @Override
    public MTag getParent() {
        return this.mParent;
    }

    private static Root getRoot(MotionSceneTag tag) {
        while (!(tag instanceof Root)) {
            tag = tag.mParent;
            if (tag != null) continue;
            return null;
        }
        return (Root)tag;
    }

    @Override
    public void setClientData(String type, Object motionAttributes) {
    }

    @Override
    public Object getClientData(String type) {
        return null;
    }

    @Override
    public MTag.TagWriter getChildTagWriter(String name) {
        return new MotionSceneTagWriter(this, name);
    }

    @Override
    public MotionSceneTagWriter getTagWriter() {
        return new MotionSceneTagWriter(this);
    }

    public static Root parse(NlComponent motionLayout, Project project, VirtualFile virtualFile2, XmlFile file2, Track track2) {
        Root root = MotionSceneTag.parse(motionLayout, project, virtualFile2, file2);
        root.myTrack = track2;
        return root;
    }

    public static Root parse(NlComponent motionLayout, Project project, VirtualFile virtualFile2, XmlFile file2) {
        NlModel model2 = motionLayout == null ? null : motionLayout.getModel();
        return new Root(file2.getRootTag(), project, virtualFile2, file2, model2);
    }

    class MotionSceneIncludeTag
    extends MotionSceneTag {
        Root includeFile;

        public MotionSceneIncludeTag(XmlTag tag, MotionSceneTag parent) {
            super(tag, parent);
            MTag.Attribute attr2 = (MTag.Attribute)this.mAttrList.get("constraintSet");
            Root myRoot = null;
            MotionSceneTag t = parent;
            while (t != null) {
                if (t instanceof Root) {
                    myRoot = (Root)t;
                }
                t = t.mParent;
            }
            if (myRoot == null) {
                return;
            }
            String fileName = attr2.mValue.substring(attr2.mValue.indexOf(47));
            if (myRoot.mModel != null) {
                this.includeFile = this.getFile(myRoot.mProject, myRoot.mModel, fileName);
            } else {
                XmlFile xmlFile = (XmlFile)myRoot.mXmlFile.getContainingFile();
                XmlTag inc_tag = xmlFile.getRootTag();
                this.includeFile = new Root(inc_tag, myRoot.mProject, null, xmlFile, myRoot.mModel);
            }
        }

        @Override
        public String getTagName() {
            return this.includeFile.getTagName();
        }

        @Override
        public String getAttributeValue(String attribute) {
            return this.includeFile.getAttributeValue(attribute);
        }

        @Override
        public ArrayList<MTag> getChildren() {
            return this.includeFile.getChildren();
        }

        @Override
        public MTag.TagWriter getChildTagWriter(String name) {
            return this.includeFile.getChildTagWriter(name);
        }

        @Override
        public MotionSceneTagWriter getTagWriter() {
            return this.includeFile.getTagWriter();
        }

        @Override
        public HashMap<String, MTag.Attribute> getAttrList() {
            return this.includeFile.getAttrList();
        }

        @Override
        public MTag[] getChildTags() {
            return this.includeFile.getChildTags();
        }

        @Override
        public MTag[] getChildTags(String type) {
            return this.includeFile.getChildTags(type);
        }

        @Override
        public MTag[] getChildTags(String attribute, String value2) {
            return this.includeFile.getChildTags(attribute, value2);
        }

        @Override
        public MTag[] getChildTags(String type, String attribute, String value2) {
            return this.includeFile.getChildTags(type, attribute, value2);
        }

        @Override
        public MTag getChildTagWithTreeId(String type, String treeId) {
            return this.includeFile.getChildTagWithTreeId(type, treeId);
        }

        @Override
        public String getTreeId() {
            return this.includeFile.getTreeId();
        }

        private Root getFile(Project project, NlModel model2, String fileName) {
            VirtualFile dir;
            AndroidFacet facet = model2.getFacet();
            List resourcesXML = IdeResourcesUtil.getResourceSubdirs((ResourceFolderType)ResourceFolderType.XML, (Iterable)StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet).getResourceDirs());
            if (resourcesXML.isEmpty()) {
                Debug.log(" resourcesXML.isEmpty() ");
                return null;
            }
            Debug.log(fileName);
            VirtualFile virtualFile2 = null;
            Iterator iterator = resourcesXML.iterator();
            while (iterator.hasNext() && (virtualFile2 = (dir = (VirtualFile)iterator.next()).findFileByRelativePath(fileName + ".xml")) == null) {
            }
            if (virtualFile2 == null) {
                System.err.println("virtualFile == null");
                return null;
            }
            XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)project, virtualFile2);
            XmlTag tag = xmlFile.getRootTag();
            return new Root(tag, project, virtualFile2, xmlFile, model2);
        }
    }

    public static class Root
    extends MotionSceneTag {
        Project mProject;
        VirtualFile mVirtualFile;
        XmlFile mXmlFile;
        NlModel mModel;
        Track myTrack = null;

        public Root(XmlTag tag, Project project, VirtualFile virtualFile2, XmlFile file2, NlModel model2) {
            this.mProject = project;
            this.mVirtualFile = virtualFile2;
            this.mXmlFile = file2;
            this.mModel = model2;
            this.init(tag, null);
        }
    }
}

