/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.AndroidXConstants;
import com.android.ide.common.gradle.Version;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.AccessorySelectionListener;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionDesignSurfaceEdits;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionLayoutInterface;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.NlComponentTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MESaveGif;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditor;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.io.PsiFileUtil;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionAccessoryPanel
implements AccessoryPanelInterface,
MotionLayoutInterface,
MotionDesignSurfaceEdits {
    private static final boolean DEBUG = false;
    private static final boolean TEMP_HACK_FORCE_APPLY = false;
    private final Project myProject;
    private final NlDesignSurface myDesignSurface;
    private final ResourceNotificationManager.ResourceChangeListener myResourceListener;
    private final NlComponentTag myMotionLayoutTag;
    private final NlComponent myMotionLayoutNlComponent;
    MotionSceneTag myMotionScene;
    VirtualFile myMotionSceneFile;
    ViewGroupHandler.AccessoryPanelVisibility mVisibility;
    MotionEditor mMotionEditor = new MotionEditor();
    public static final String TIMELINE = "Timeline";
    MotionLayoutComponentHelper myMotionHelper;
    private String mSelectedStartConstraintId;
    private String mSelectedEndConstraintId;
    private float mLastProgress = 0.0f;
    private final List<AccessorySelectionListener> myListeners;
    private NlComponent mySelection;
    private NlComponent myMotionLayout;
    private MotionEditorSelector.Type mLastSelection = MotionEditorSelector.Type.LAYOUT;
    private MTag[] myLastSelectedTags;
    private boolean mShowPath = true;
    private boolean myUpdatingSelectionInLayoutEditor = false;
    private boolean myUpdatingSelectionFromLayoutEditor = false;
    private float myStartDegree = Float.NaN;
    private float myEndDegree = Float.NaN;
    private static final int NUM_SAVED_IMAGES = 60;
    private static final int WAIF_FOR_TIME = 100;
    private static final int GIF_PLAY_DELAY = 80;
    private MESaveGif mySaveGif;

    private void applyMotionSceneValue(boolean apply) {
    }

    public MotionAccessoryPanel(final @NotNull NlDesignSurface surface2, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility visibility) {
        this.myDesignSurface = surface2;
        this.myProject = surface2.getProject();
        this.myMotionLayoutNlComponent = parent;
        this.myMotionLayoutTag = new NlComponentTag(parent, null);
        this.mVisibility = visibility;
        MotionLayoutComponentHelper.clearCache();
        this.myMotionHelper = MotionLayoutComponentHelper.create(this.myMotionLayoutNlComponent);
        this.myListeners = new ArrayList<AccessorySelectionListener>();
        this.myResourceListener = this.createResourceChangeListener();
        this.mMotionEditor.myTrack.init(this.myDesignSurface);
        SelectionModel designSurfaceSelection = this.myDesignSurface.getSelectionModel();
        List<NlComponent> dsSelection = designSurfaceSelection.getSelection();
        designSurfaceSelection.addListener((SelectionModel model2, List<NlComponent> selection) -> this.handleSelectionChanged(model2, selection));
        this.mMotionEditor.addCommandListener(new MotionEditor.Command(){

            @Override
            public void perform(MotionEditor.Command.Action action2, MTag[] tag) {
                switch (action2) {
                    case DELETE: {
                        for (int i = 0; i < tag.length; ++i) {
                            tag[i].getTagWriter().deleteTag().commit("delete " + tag[i].getTagName());
                        }
                        break;
                    }
                    case COPY: {
                        CharSequence[] buff = new CharSequence[tag.length];
                        for (int i = 0; i < tag.length; ++i) {
                            buff[i] = MTag.serializeTag(tag[i]);
                        }
                        break;
                    }
                }
            }
        });
        this.mMotionEditor.addSelectionListener(new MotionEditorSelector.Listener(){

            @Override
            public void selectionChanged(MotionEditorSelector.Type selection, MTag[] tag, int flags) {
                MotionAccessoryPanel.this.mLastSelection = selection;
                MotionAccessoryPanel.this.myLastSelectedTags = tag;
                switch (selection) {
                    case CONSTRAINT_SET: {
                        String id2 = tag[0].getAttributeValue("id");
                        if (id2 == null) break;
                        MotionAccessoryPanel.this.mSelectedStartConstraintId = Utils.stripID(id2);
                        MotionAccessoryPanel.this.mSelectedEndConstraintId = null;
                        MotionAccessoryPanel.this.myMotionHelper.setState(MotionAccessoryPanel.this.mSelectedStartConstraintId);
                        break;
                    }
                    case TRANSITION: {
                        MotionAccessoryPanel.this.mSelectedStartConstraintId = Utils.stripID(tag[0].getAttributeValue("constraintSetStart"));
                        MotionAccessoryPanel.this.mSelectedEndConstraintId = Utils.stripID(tag[0].getAttributeValue("constraintSetEnd"));
                        MotionAccessoryPanel.this.myMotionHelper.setTransition(MotionAccessoryPanel.this.mSelectedStartConstraintId, MotionAccessoryPanel.this.mSelectedEndConstraintId);
                        MotionAccessoryPanel.this.myMotionHelper.setProgress(MotionAccessoryPanel.this.mLastProgress);
                        if (flags == 1) {
                            MotionAccessoryPanel.this.mShowPath = !MotionAccessoryPanel.this.mShowPath;
                        }
                        MotionAccessoryPanel.this.myMotionHelper.setShowPaths(MotionAccessoryPanel.this.mShowPath);
                        break;
                    }
                    case LAYOUT: {
                        MotionAccessoryPanel.this.selectOnDesignSurface(tag);
                        MotionAccessoryPanel.this.myMotionHelper.setState(null);
                        MotionAccessoryPanel.this.mSelectedStartConstraintId = null;
                        break;
                    }
                    case CONSTRAINT: {
                        MotionAccessoryPanel.this.selectOnDesignSurface(tag);
                        if (tag[0] instanceof MotionSceneTag) {
                            MotionSceneTag msTag = (MotionSceneTag)tag[0];
                            String id3 = Utils.stripID(msTag.getAttributeValue("id"));
                            MTag[] layoutViews = MotionAccessoryPanel.this.myMotionLayoutTag.getChildTags();
                            for (int i = 0; i < layoutViews.length; ++i) {
                                MTag view2 = layoutViews[i];
                                String vid = Utils.stripID(view2.getAttributeValue("id"));
                                if (!vid.equals(id3)) continue;
                                MotionAccessoryPanel.this.updateSelectionInLayoutEditor((NlComponentTag)view2);
                            }
                            break;
                        }
                        if (!(tag[0] instanceof NlComponentTag)) break;
                        MotionAccessoryPanel.this.updateSelectionInLayoutEditor((NlComponentTag)tag[0]);
                        break;
                    }
                    case LAYOUT_VIEW: {
                        if (tag.length <= 0 || !(tag[0] instanceof NlComponentTag)) break;
                        MotionAccessoryPanel.this.updateSelectionInLayoutEditor((NlComponentTag)tag[0]);
                        break;
                    }
                }
                if (!MotionAccessoryPanel.this.mMotionEditor.isUpdatingModel()) {
                    MotionAccessoryPanel.this.fireSelectionChanged(Collections.singletonList(MotionAccessoryPanel.this.mySelection));
                }
            }
        });
        this.mMotionEditor.addTimeLineListener(new MotionEditorSelector.TimeLineListener(){

            @Override
            public void command(MotionEditorSelector.TimeLineCmd cmd, float pos) {
                switch (cmd) {
                    case MOTION_PROGRESS: {
                        MotionAccessoryPanel.this.myMotionHelper.setProgress(pos);
                        MotionAccessoryPanel.this.mLastProgress = pos;
                        MotionAccessoryPanel.this.applyRotation();
                        break;
                    }
                    case MOTION_SCRUB: {
                        surface2.setAnimationScrubbing(true);
                        MotionAccessoryPanel.this.startScreenRotating();
                    }
                    case MOTION_PLAY: {
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
                        manager.updateSceneView();
                        manager.requestLayoutAndRenderAsync(false);
                        surface2.setRenderSynchronously(true);
                        break;
                    }
                    case MOTION_STOP: {
                        surface2.setRenderSynchronously(false);
                        surface2.setAnimationScrubbing(false);
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
                        manager.requestLayoutAndRenderAsync(false);
                        MotionAccessoryPanel.this.stopScreenRotating();
                        break;
                    }
                    case MOTION_CAPTURE: {
                        int playMode = MotionAccessoryPanel.this.mMotionEditor.getPlayMode();
                        int numImages = playMode == 2 ? 60 : 30;
                        float speed = MotionAccessoryPanel.this.mMotionEditor.getTimeLineSpeed();
                        int playDelay = (int)(80.0f / speed);
                        String filename = MotionAccessoryPanel.this.mSelectedStartConstraintId + "->" + MotionAccessoryPanel.this.mSelectedEndConstraintId + ".gif";
                        LayoutlibSceneManager manager = (LayoutlibSceneManager)surface2.getSceneManager();
                        manager.updateSceneView();
                        manager.requestLayoutAndRenderAsync(false);
                        surface2.setRenderSynchronously(true);
                        FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Transition as GIF", "Save the selected transition as GIF", new String[]{"gif"});
                        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Project)null);
                        VirtualFileWrapper fileWrapper = saveFileDialog.save(filename);
                        if (fileWrapper == null) break;
                        File file2 = fileWrapper.getFile();
                        MotionAccessoryPanel.this.mySaveGif = new MESaveGif(file2, playDelay, true, "Written by Android Studio");
                        MotionAccessoryPanel.this.mySaveGif.saveGif(MotionAccessoryPanel.this.myDesignSurface, numImages, playMode, MotionAccessoryPanel.this.myMotionHelper, MotionAccessoryPanel.this.myProject, 100);
                    }
                }
            }
        });
        MotionSceneTag.Root motionScene = this.getMotionScene(this.myMotionLayoutNlComponent);
        this.myMotionScene = motionScene;
        VirtualFile sceneFile = this.myMotionSceneFile = motionScene == null ? null : motionScene.mVirtualFile;
        String sceneFileName = sceneFile == null ? "" : sceneFile.getName();
        String layoutFileName = MotionAccessoryPanel.getLayoutFileName(surface2);
        this.mMotionEditor.setMTag(this.myMotionScene, this.myMotionLayoutTag, layoutFileName, sceneFileName, this.getSetupError());
        if (this.myMotionScene == null) {
            return;
        }
        MTag[] cSet = this.myMotionScene.getChildTags("ConstraintSet");
        if (cSet != null && cSet.length > 0) {
            this.mMotionEditor.selectTag(cSet[0], 0);
        }
        parent.putClientProperty(TIMELINE, this);
        AndroidFacet facet = parent.getModel().getFacet();
        ResourceNotificationManager.getInstance((Project)this.myProject).addListener(this.myResourceListener, facet, null, null);
        this.handleSelectionChanged(designSurfaceSelection, dsSelection);
    }

    @NotNull
    private static String getLayoutFileName(@NotNull NlDesignSurface surface2) {
        NlModel model2 = surface2.getModel();
        if (model2 == null) {
            return "";
        }
        return model2.getVirtualFile().getName().replace(".xml", "");
    }

    @NotNull
    private ResourceNotificationManager.ResourceChangeListener createResourceChangeListener() {
        return new ResourceNotificationManager.ResourceChangeListener(){

            public void resourcesChanged(@NotNull ImmutableSet<ResourceNotificationManager.Reason> reason) {
                boolean forLayout;
                boolean bl = forLayout = MotionAccessoryPanel.this.mLastSelection == MotionEditorSelector.Type.LAYOUT || MotionAccessoryPanel.this.mLastSelection == MotionEditorSelector.Type.LAYOUT_VIEW;
                if (forLayout) {
                    return;
                }
                MotionAccessoryPanel.this.mLastSelection = null;
                MotionAccessoryPanel.this.myLastSelectedTags = null;
                MotionSceneTag.Root motionScene = MotionAccessoryPanel.this.getMotionScene(MotionAccessoryPanel.this.myMotionLayoutNlComponent);
                if (motionScene != null) {
                    MotionAccessoryPanel.this.myMotionScene = motionScene;
                    MotionAccessoryPanel.this.myMotionSceneFile = motionScene.mVirtualFile;
                    MotionAccessoryPanel.this.mMotionEditor.setMTag(MotionAccessoryPanel.this.myMotionScene, MotionAccessoryPanel.this.myMotionLayoutTag, "", "", MotionAccessoryPanel.this.getSetupError());
                    if (MotionAccessoryPanel.this.myLastSelectedTags == null) {
                        MotionAccessoryPanel.this.selectSomething(motionScene);
                    }
                }
                MotionAccessoryPanel.this.fireSelectionChanged(Collections.singletonList(MotionAccessoryPanel.this.mySelection));
                if (motionScene != null) {
                    PsiFileUtil.saveFileIfNecessary((PsiFile)motionScene.mXmlFile);
                }
            }
        };
    }

    private void updateSelectionInLayoutEditor(@NotNull NlComponentTag tag) {
        this.updateSelectionInLayoutEditor(Collections.singletonList(tag.mComponent));
    }

    private void updateSelectionInLayoutEditor(@NotNull List<NlComponent> selected) {
        if (this.myUpdatingSelectionInLayoutEditor || this.myUpdatingSelectionFromLayoutEditor) {
            return;
        }
        this.myUpdatingSelectionInLayoutEditor = true;
        try {
            this.myDesignSurface.getSelectionModel().setSelection(selected);
            this.myDesignSurface.repaint();
        }
        finally {
            this.myUpdatingSelectionInLayoutEditor = false;
        }
    }

    private void selectSomething(@NotNull MotionSceneTag motionScene) {
        MTag[] sets = motionScene.getChildTags("ConstraintSet");
        if (sets.length == 0) {
            return;
        }
        this.mLastSelection = MotionEditorSelector.Type.CONSTRAINT_SET;
        this.myLastSelectedTags = new MTag[]{sets[0]};
    }

    private String getSetupError() {
        GoogleMavenArtifactId artifact = GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT;
        NlDependencyManager dep = NlDependencyManager.getInstance();
        if (dep == null) {
            return null;
        }
        if (this.myMotionLayout == null) {
            return null;
        }
        if (this.myMotionLayout.getModel() == null) {
            return null;
        }
        Version v = dep.getModuleDependencyVersion(artifact, this.myMotionLayout.getModel().getFacet());
        NlDependencyManager.getInstance().getModuleDependencyVersion(artifact, this.myMotionLayout.getModel().getFacet());
        String error = "Version ConstraintLayout library must be version 2.0.0 beta3 or later";
        if (v == null) {
            return null;
        }
        if (v.compareTo(Version.Companion.parse("2.0.0-beta03")) < 0) {
            return error;
        }
        return null;
    }

    private void selectOnDesignSurface(MTag[] tag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        if (this.myUpdatingSelectionInLayoutEditor || this.myUpdatingSelectionFromLayoutEditor) {
            return;
        }
        String[] ids = new String[selection.size()];
        int count = 0;
        for (NlComponent component : selection) {
            ids[count++] = Utils.stripID(component.getId());
        }
        this.myUpdatingSelectionFromLayoutEditor = true;
        try {
            this.mMotionEditor.selectById(ids);
            this.fireSelectionChanged(selection);
        }
        finally {
            this.myUpdatingSelectionFromLayoutEditor = false;
        }
    }

    @Nullable
    MotionSceneTag.Root getMotionScene(NlComponent motionLayout) {
        VirtualFile dir;
        String ref = motionLayout.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (ref == null) {
            System.err.println("getAttribute(layoutDescription ) returned null");
            return null;
        }
        int index = ref.lastIndexOf("@xml/");
        if (index < 0) {
            System.err.println("layoutDescription  did not have \"@xml/\"");
            return null;
        }
        String fileName = ref.substring(index + 5);
        if (fileName.isEmpty()) {
            System.err.println("layoutDescription \"" + ref + "\"");
            return null;
        }
        AndroidFacet facet = motionLayout.getModel().getFacet();
        List resourcesXML = IdeResourcesUtil.getResourceSubdirs((ResourceFolderType)ResourceFolderType.XML, (Iterable)StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet).getResourceDirs());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile2 = null;
        Iterator iterator = resourcesXML.iterator();
        while (iterator.hasNext() && (virtualFile2 = (dir = (VirtualFile)iterator.next()).findFileByRelativePath(fileName + ".xml")) == null) {
        }
        if (virtualFile2 == null) {
            System.err.println("virtualFile == null");
            return null;
        }
        XmlFile xmlFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, virtualFile2);
        return MotionSceneTag.parse(motionLayout, this.myProject, virtualFile2, xmlFile, this.mMotionEditor.myTrack);
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        return this.mMotionEditor;
    }

    @Override
    @NotNull
    public JPanel createPanel(AccessoryPanel.Type type) {
        return new JPanel(){
            {
                this.setBackground(Color.RED);
            }
        };
    }

    @Override
    public void updateAccessoryPanelWithSelection(@NotNull AccessoryPanel.Type type, @NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            this.mySelection = null;
            return;
        }
        this.mySelection = selection.get(0);
        this.myMotionLayout = MotionUtils.getMotionLayoutAncestor(this.mySelection);
        this.fireSelectionChanged(selection);
    }

    @Override
    public void deactivate() {
        this.mMotionEditor.stopAnimation();
        this.myMotionLayout = null;
        MotionLayoutComponentHelper.clearCache();
        AndroidFacet facet = this.myMotionLayoutNlComponent.getModel().getFacet();
        ResourceNotificationManager.getInstance((Project)this.myProject).removeListener(this.myResourceListener, facet, null, null);
    }

    @Override
    public void updateAfterModelDerivedDataChanged() {
        MotionLayoutComponentHelper.clearCache();
        this.myMotionHelper = MotionLayoutComponentHelper.create(this.myMotionLayoutNlComponent);
        if (this.mLastSelection == MotionEditorSelector.Type.LAYOUT) {
            this.myMotionHelper.setState(null);
            this.mSelectedStartConstraintId = null;
        } else if (this.mLastSelection == MotionEditorSelector.Type.CONSTRAINT_SET) {
            this.myMotionHelper.setState(this.mSelectedStartConstraintId);
        } else if (this.mSelectedStartConstraintId != null && this.mSelectedEndConstraintId == null) {
            this.myMotionHelper.setState(this.mSelectedStartConstraintId);
        } else if (this.mSelectedStartConstraintId != null && this.mSelectedEndConstraintId != null) {
            this.myMotionHelper.setTransition(this.mSelectedStartConstraintId, this.mSelectedEndConstraintId);
            this.mMotionEditor.stopAnimation();
        } else {
            this.myMotionHelper.setState(null);
            this.mSelectedStartConstraintId = null;
        }
    }

    @Override
    public void addListener(@NotNull AccessorySelectionListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull AccessorySelectionListener listener2) {
        this.myListeners.remove(listener2);
    }

    @Override
    public void requestSelection() {
        this.fireSelectionChanged(Collections.singletonList(this.mySelection));
    }

    private void fireSelectionChanged(@NotNull List<NlComponent> components) {
        boolean forLayout = this.mLastSelection == MotionEditorSelector.Type.LAYOUT || this.mLastSelection == MotionEditorSelector.Type.LAYOUT_VIEW;
        MotionEditorSelector.Type type = forLayout ? null : this.mLastSelection;
        MTag[] tags2 = forLayout ? null : this.myLastSelectedTags;
        List<NlComponent> selectedComponents = forLayout ? this.convertToLayoutSelection() : components;
        ArrayList<AccessorySelectionListener> copy = new ArrayList<AccessorySelectionListener>(this.myListeners);
        copy.forEach(listener2 -> listener2.selectionChanged(this, (Object)type, tags2, selectedComponents));
    }

    private List<NlComponent> convertToLayoutSelection() {
        ArrayList<NlComponent> views = new ArrayList<NlComponent>();
        if (this.myLastSelectedTags != null) {
            for (MTag tag : this.myLastSelectedTags) {
                NlComponent component;
                if (!(tag instanceof NlComponentTag) || (component = ((NlComponentTag)tag).getComponent()) == null) continue;
                views.add(component);
            }
        }
        if (views.isEmpty() && this.myMotionLayoutNlComponent != null) {
            views.add(this.myMotionLayoutNlComponent);
        }
        return views;
    }

    @Override
    public boolean showPopupMenuActions() {
        return false;
    }

    @Override
    public boolean handlesWriteForComponent(String id2) {
        boolean handlesWrite = this.getSelectedConstraintSet() != null;
        return handlesWrite;
    }

    @Override
    public String getSelectedConstraintSet() {
        return this.mSelectedStartConstraintId;
    }

    @Override
    @Nullable
    public XmlFile getTransitionFile(@NotNull NlComponent component) {
        if (!(NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.MOTION_LAYOUT) || (component = component.getParent()) != null && NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.MOTION_LAYOUT))) {
            return null;
        }
        String file2 = component.getAttribute("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (file2 == null) {
            return null;
        }
        int index = file2.lastIndexOf("@xml/");
        String fileName = file2.substring(index + 5);
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        AndroidFacet facet = component.getModel().getFacet();
        List resourcesXML = IdeResourcesUtil.getResourceSubdirs((ResourceFolderType)ResourceFolderType.XML, (Iterable)StudioResourceRepositoryManager.getModuleResources((AndroidFacet)facet).getResourceDirs());
        if (resourcesXML.isEmpty()) {
            return null;
        }
        VirtualFile directory = (VirtualFile)resourcesXML.get(0);
        VirtualFile virtualFile2 = directory.findFileByRelativePath(fileName + ".xml");
        return (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)virtualFile2);
    }

    @Override
    @Nullable
    public XmlTag getConstraintSet(XmlFile file2, String constraintSetId) {
        XmlTag[] children = file2.getRootTag().findSubTags("ConstraintSet");
        for (int i = 0; i < children.length; ++i) {
            String childId;
            XmlAttribute attribute = children[i].getAttribute("android:id");
            if (attribute == null || !(childId = Utils.stripID(attribute.getValue())).equalsIgnoreCase(constraintSetId)) continue;
            return children[i];
        }
        return null;
    }

    @Override
    @Nullable
    public XmlTag getConstrainView(XmlTag constraintSet, String id2) {
        XmlTag[] children = constraintSet.getSubTags();
        for (int i = 0; i < children.length; ++i) {
            XmlAttribute attribute = children[i].getAttribute("android:id");
            if (attribute == null) continue;
            String value2 = attribute.getValue();
            int index = value2.lastIndexOf("id/");
            if ((value2 = value2.substring(index + 3)) == null || !value2.equalsIgnoreCase(id2)) continue;
            return children[i];
        }
        return null;
    }

    @Override
    @Nullable
    public List<XmlTag> getKeyframes(XmlFile file2, String componentId) {
        XmlTag[] children = file2.getRootTag().findSubTags("KeyFrames");
        ArrayList<XmlTag> found = new ArrayList<XmlTag>();
        for (int i = 0; i < children.length; ++i) {
            XmlTag[] keyframes = children[i].getSubTags();
            for (int j = 0; j < keyframes.length; ++j) {
                XmlTag keyframe = keyframes[j];
                XmlAttribute attribute = keyframe.getAttribute("motion:target");
                if (attribute == null) continue;
                String keyframeTarget = attribute.getValue();
                int index = keyframeTarget.indexOf(47);
                if (index != -1) {
                    keyframeTarget = keyframeTarget.substring(index + 1);
                }
                if (!componentId.equalsIgnoreCase(keyframeTarget)) continue;
                found.add(keyframe);
            }
        }
        return found;
    }

    public MotionSceneTag getMotionScene() {
        return this.myMotionScene;
    }

    private void startScreenRotating() {
        this.myStartDegree = Float.NaN;
        this.myEndDegree = Float.NaN;
        if (this.mLastSelection != MotionEditorSelector.Type.TRANSITION) {
            this.applyRotation();
            return;
        }
        MTag startConstraintSet = null;
        MTag endConstraintSet = null;
        if (this.myLastSelectedTags != null && this.myLastSelectedTags.length > 0) {
            startConstraintSet = this.mMotionEditor.getMeModel().findStartConstraintSet(this.myLastSelectedTags[0]);
            endConstraintSet = this.mMotionEditor.getMeModel().findEndConstraintSet(this.myLastSelectedTags[0]);
        }
        if (startConstraintSet != null && endConstraintSet != null) {
            String startScreenRotation = startConstraintSet.getAttributeValue("screenRotation");
            String endScreenRotation = endConstraintSet.getAttributeValue("screenRotation");
            if (startScreenRotation != null && NumberUtils.isParsable((String)startScreenRotation)) {
                this.myStartDegree = Float.parseFloat(startScreenRotation);
            }
            if (endScreenRotation != null && NumberUtils.isParsable((String)endScreenRotation)) {
                this.myEndDegree = Float.parseFloat(endScreenRotation);
            }
        }
        this.applyRotation();
    }

    private void applyRotation() {
        float rotationDegree = this.myStartDegree + this.mLastProgress * (this.myEndDegree - this.myStartDegree);
        this.myDesignSurface.setRotateSufaceDegree(rotationDegree);
    }

    private void stopScreenRotating() {
        this.myStartDegree = Float.NaN;
        this.myEndDegree = Float.NaN;
        this.myDesignSurface.setRotateSufaceDegree(Float.NaN);
    }

    private /* synthetic */ void lambda$applyMotionSceneValue$1() {
        this.myMotionLayoutTag.mComponent.setAttribute("http://schemas.android.com/tools", "applyMotionScene", "false");
    }

    private /* synthetic */ void lambda$applyMotionSceneValue$0() {
        this.myMotionLayoutTag.mComponent.setAttribute("http://schemas.android.com/tools", "applyMotionScene", null);
    }
}

