/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

class MotionLayoutSceneInteraction
extends ConstraintSceneInteraction {
    private static final double SLOPE = 20.0;
    private final NlDesignSurface mySurface;
    private int startX;
    private int startY;
    private NlComponent mySelectedComponent;
    public static final String MOTION_DRAG_KEYFRAME = "MotionDragKeyFrame";
    public static final String MOTION_KEY_POS_TYPE = "MotionDragKeyPosType";
    public static final String MOTION_KEY_POS_PERCENT = "MotionDragKeyPosPercent";
    private KeyframeCandidate myKeyframeCandidate = new KeyframeCandidate();
    private static final int MAX_KEY_POSITIONS = 101;
    private String[] myPositionAttributes = new String[2];
    private float[] myPositionsValues = new float[2];
    private final DecimalFormat myFloatFormatter = MotionLayoutSceneInteraction.createFloatFormatter();

    public MotionLayoutSceneInteraction(@NotNull SceneView sceneView, @NotNull NlComponent primary) {
        super(sceneView, primary);
        this.mySelectedComponent = primary;
        this.mySurface = (NlDesignSurface)sceneView.getSurface();
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        float fy;
        float fx;
        this.startX = x;
        this.startY = y;
        MotionLayoutComponentHelper helper = MotionLayoutComponentHelper.create(this.mySelectedComponent);
        if (MotionLayoutSceneInteraction.hitKeyframe(helper, this.mySelectedComponent, fx = (float)Coordinates.getAndroidX(this.mySceneView, x), fy = (float)Coordinates.getAndroidY(this.mySceneView, y), this.myKeyframeCandidate)) {
            this.mySelectedComponent.putClientProperty(MOTION_DRAG_KEYFRAME, this.myKeyframeCandidate.selectedKeyFrame);
            this.mySelectedComponent.putClientProperty(MOTION_KEY_POS_TYPE, this.myKeyframeCandidate.keyPosType);
            this.mySelectedComponent.putClientProperty(MOTION_KEY_POS_PERCENT, new float[]{this.myKeyframeCandidate.keyPosPercentX, this.myKeyframeCandidate.keyPosPercentY});
            this.mySurface.setRenderSynchronously(true);
            this.mySurface.setAnimationScrubbing(true);
        }
    }

    public static boolean hitKeyframe(@NotNull MotionLayoutComponentHelper helper, @NotNull NlComponent component, float fx, float fy, @NotNull KeyframeCandidate keyframeCandidate) {
        keyframeCandidate.clear();
        try {
            int noOfKeyPosition = helper.getKeyframeInfo(component, 2, keyframeCandidate.keyFrameInfo);
            keyframeCandidate.myKeyInfo.setInfo(keyframeCandidate.keyFrameInfo, noOfKeyPosition);
            while (keyframeCandidate.myKeyInfo.next()) {
                if (keyframeCandidate.myKeyInfo.getType() != 2) continue;
                float x = keyframeCandidate.myKeyInfo.getLocationX();
                float y = keyframeCandidate.myKeyInfo.getLocationY();
                double dx = Math.abs(x - fx);
                double dy = Math.abs(y - fy);
                if (!(dx < 20.0) || !(dy < 20.0)) continue;
                keyframeCandidate.selectedKeyFrame = keyframeCandidate.myKeyInfo.getIndex();
                keyframeCandidate.keyPosType = keyframeCandidate.myKeyInfo.getKeyPosType();
                keyframeCandidate.keyPosPercentX = keyframeCandidate.myKeyInfo.getKeyPosPercentX();
                keyframeCandidate.keyPosPercentY = keyframeCandidate.myKeyInfo.getKeyPosPercentY();
                break;
            }
        }
        catch (Exception noOfKeyPosition) {
            // empty catch block
        }
        int keyFrameCount = helper.getKeyframePos(component, keyframeCandidate.keyFrameTypes, keyframeCandidate.keyFramePos);
        if (keyFrameCount <= 0) {
            return false;
        }
        Object view2 = NlComponentHelperKt.getViewInfo(component).getViewObject();
        for (int i = 0; i < keyframeCandidate.keyFrameTypes.length; ++i) {
            if (keyframeCandidate.keyFrameTypes[i] / 1000 != 2) continue;
            float kx = keyframeCandidate.keyFramePos[i * 2];
            float ky = keyframeCandidate.keyFramePos[i * 2 + 1];
            double dx = Math.sqrt((kx - fx) * (kx - fx));
            double dy = Math.sqrt((ky - fy) * (ky - fy));
            if (!(dx < 20.0) || !(dy < 20.0)) continue;
            int framePosition = keyframeCandidate.keyFrameTypes[i] % 1000;
            keyframeCandidate.keyframe = helper.getKeyframe(view2, 2, framePosition);
            keyframeCandidate.position = framePosition;
            break;
        }
        return keyframeCandidate.keyframe != null;
    }

    public static boolean hitKeyFrame(@NotNull SceneView sceneView, int x, int y, MotionLayoutComponentHelper helper, NlComponent component) {
        float fx = Coordinates.getAndroidX(sceneView, x);
        float fy = Coordinates.getAndroidY(sceneView, y);
        return MotionLayoutSceneInteraction.hitKeyframe(helper, component, fx, fy, new KeyframeCandidate());
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.myKeyframeCandidate.keyframe == null) {
            return;
        }
        this.myPositionAttributes[0] = "percentX";
        this.myPositionAttributes[1] = "percentY";
        ViewInfo info = NlComponentHelperKt.getViewInfo(this.mySelectedComponent);
        if (info != null) {
            float fx = Coordinates.getAndroidX(this.mySceneView, x);
            float fy = Coordinates.getAndroidY(this.mySceneView, y);
            Object view2 = info.getViewObject();
            MotionLayoutComponentHelper helper = MotionLayoutComponentHelper.create(this.mySelectedComponent);
            if (helper.getPositionKeyframe(this.myKeyframeCandidate.keyframe, view2, fx, fy, this.myPositionAttributes, this.myPositionsValues)) {
                helper.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[0], Float.valueOf(this.myPositionsValues[0]));
                helper.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[1], Float.valueOf(this.myPositionsValues[1]));
                helper.setKeyframe(this.myKeyframeCandidate.keyframe, "drawPath", 4);
                this.mySelectedComponent.getModel().notifyLiveUpdate(false);
            }
        }
        try {
            MotionLayoutComponentHelper helper = MotionLayoutComponentHelper.create(this.mySelectedComponent);
            int noOfKeyPosition = helper.getKeyframeInfo(this.mySelectedComponent, 2, this.myKeyframeCandidate.keyFrameInfo);
            this.myKeyframeCandidate.myKeyInfo.setInfo(this.myKeyframeCandidate.keyFrameInfo, noOfKeyPosition);
            while (this.myKeyframeCandidate.myKeyInfo.next()) {
                int index;
                if (this.myKeyframeCandidate.myKeyInfo.getType() != 2 || (index = this.myKeyframeCandidate.myKeyInfo.getIndex()) != this.myKeyframeCandidate.selectedKeyFrame) continue;
                this.myKeyframeCandidate.keyPosPercentX = this.myKeyframeCandidate.myKeyInfo.getKeyPosPercentX();
                this.myKeyframeCandidate.keyPosPercentY = this.myKeyframeCandidate.myKeyInfo.getKeyPosPercentY();
                float[] pos = (float[])this.mySelectedComponent.getClientProperty(MOTION_KEY_POS_PERCENT);
                if (pos != null) {
                    pos[0] = this.myKeyframeCandidate.keyPosPercentX;
                    pos[1] = this.myKeyframeCandidate.keyPosPercentY;
                } else {
                    this.mySelectedComponent.putClientProperty(MOTION_KEY_POS_PERCENT, new float[]{this.myKeyframeCandidate.keyPosPercentX, this.myKeyframeCandidate.keyPosPercentY});
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        this.mySurface.setRenderSynchronously(false);
        this.mySurface.setAnimationScrubbing(false);
        if (this.myKeyframeCandidate.keyframe == null || this.mySelectedComponent == null) {
            return;
        }
        this.mySelectedComponent.putClientProperty(MOTION_DRAG_KEYFRAME, null);
        this.mySelectedComponent.putClientProperty(MOTION_KEY_POS_TYPE, null);
        this.mySelectedComponent.putClientProperty(MOTION_KEY_POS_PERCENT, null);
        this.myPositionAttributes[0] = "percentX";
        this.myPositionAttributes[1] = "percentY";
        ViewInfo info = NlComponentHelperKt.getViewInfo(this.mySelectedComponent);
        String selectedId = this.mySelectedComponent.ensureId();
        if (info != null) {
            float fx = Coordinates.getAndroidX(this.mySceneView, x);
            float fy = Coordinates.getAndroidY(this.mySceneView, y);
            Object view2 = info.getViewObject();
            MotionLayoutComponentHelper helper = MotionLayoutComponentHelper.create(this.mySelectedComponent);
            if (helper.getPositionKeyframe(this.myKeyframeCandidate.keyframe, view2, fx, fy, this.myPositionAttributes, this.myPositionsValues)) {
                helper.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[0], Float.valueOf(this.myPositionsValues[0]));
                helper.setKeyframe(this.myKeyframeCandidate.keyframe, this.myPositionAttributes[1], Float.valueOf(this.myPositionsValues[1]));
                helper.setKeyframe(this.myKeyframeCandidate.keyframe, "drawPath", 0);
                NlComponent motionLayoutComponent = MotionUtils.getMotionLayoutAncestor(this.mySelectedComponent);
                if (motionLayoutComponent != null) {
                    MotionSceneTag motionScene = MotionUtils.getMotionScene(motionLayoutComponent);
                    MTag[] transitions2 = motionScene.getChildTags("Transition");
                    String startState = helper.getStartState();
                    String endState = helper.getEndState();
                    MTag[] keyframes = null;
                    if (startState != null && endState != null) {
                        int i;
                        for (i = 0; i < transitions2.length; ++i) {
                            MTag[] keyframesSet;
                            MTag transition = transitions2[i];
                            String transitionStart = transition.getAttributeValue("constraintSetStart");
                            String transitionEnd = transition.getAttributeValue("constraintSetEnd");
                            if (!startState.equals(Utils.stripID(transitionStart)) || !endState.equals(Utils.stripID(transitionEnd)) || (keyframesSet = transition.getChildTags("KeyFrameSet")) == null || keyframesSet.length <= 0) continue;
                            keyframes = keyframesSet[0].getChildTags("KeyPosition");
                            break;
                        }
                        if (keyframes != null) {
                            for (i = 0; i < keyframes.length; ++i) {
                                String motionTarget;
                                int framePosition;
                                void keyframe = keyframes[i];
                                String framePositionValue = keyframe.getAttributeValue("framePosition");
                                int n = framePosition = framePositionValue != null ? Integer.parseInt(framePositionValue) : -1;
                                if (framePosition != this.myKeyframeCandidate.position || (motionTarget = keyframe.getAttributeValue("motionTarget")) == null || !selectedId.equals(Utils.stripID(motionTarget))) continue;
                                MTag.TagWriter keyframeModification = keyframe.getTagWriter();
                                keyframeModification.setAttribute("http://schemas.android.com/apk/res-auto", this.myPositionAttributes[0], this.formatValue(this.myPositionsValues[0]));
                                keyframeModification.setAttribute("http://schemas.android.com/apk/res-auto", this.myPositionAttributes[1], this.formatValue(this.myPositionsValues[1]));
                                keyframeModification.commit("Modified Position Keyframe");
                            }
                        }
                    }
                }
                this.mySelectedComponent.getModel().notifyLiveUpdate(false);
            }
        }
        this.myKeyframeCandidate.clear();
    }

    @NotNull
    private static DecimalFormat createFloatFormatter() {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.US);
        return new DecimalFormat("#.###", symbols);
    }

    private String formatValue(float value2) {
        return this.myFloatFormatter.format(value2);
    }

    private static class KeyframeCandidate {
        Object keyframe;
        int position = -1;
        int[] keyFrameTypes = new int[101];
        float[] keyFramePos = new float[202];
        int keyPosType = 0;
        float keyPosPercentX;
        float keyPosPercentY;
        int selectedKeyFrame;
        int[] keyFrameInfo = new int[808];
        MotionLayoutComponentHelper.KeyInfo myKeyInfo = new MotionLayoutComponentHelper.KeyInfo();

        private KeyframeCandidate() {
        }

        public void clear() {
            this.keyframe = null;
            this.position = -1;
        }
    }
}

