/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.utils.HashCodes;
import com.intellij.psi.xml.XmlAttribute;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttrName
implements Comparable<AttrName> {
    private final String myNamespace;
    private final String myName;
    private Comparator<AttrName> ourComparator = Comparator.comparing(AttrName::getName).thenComparing(AttrName::getNamespace);

    public AttrName(@NotNull String namespace, @NotNull String name) {
        this.myNamespace = namespace;
        this.myName = name;
    }

    public AttrName(@NotNull XmlAttribute attribute) {
        this(attribute.getNamespace(), attribute.getLocalName());
    }

    @NotNull
    public String getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public static String getMotionNamespace() {
        return "http://schemas.android.com/apk/res-auto";
    }

    @NotNull
    public static AttrName motionAttr(@NotNull String name) {
        return new AttrName(AttrName.getMotionNamespace(), name);
    }

    @NotNull
    public static AttrName androidAttr(@NotNull String name) {
        return new AttrName("http://schemas.android.com/apk/res/android", name);
    }

    @NotNull
    public static AttrName customAttr(@NotNull String name) {
        return new AttrName("", name);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myNamespace.hashCode(), (int)this.myName.hashCode());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AttrName)) {
            return false;
        }
        AttrName attr2 = (AttrName)other;
        return Objects.equals(this.myNamespace, attr2.myNamespace) && Objects.equals(this.myName, attr2.myName);
    }

    @Override
    public int compareTo(@NotNull AttrName other) {
        return this.ourComparator.compare(this, other);
    }

    @NotNull
    public String toString() {
        return this.myName;
    }

    private boolean is(@NotNull String namespace, @NotNull String name) {
        return this.myNamespace.equals(namespace) && this.myName.equals(name);
    }

    public boolean isMotionAttr(@NotNull String name) {
        return this.is(AttrName.getMotionNamespace(), name);
    }

    public boolean isId() {
        return this.is("http://schemas.android.com/apk/res/android", "id");
    }
}

