/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.actions;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.actions.LinearLayoutAction;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ToggleOrientationAction
extends LinearLayoutAction {
    @Override
    protected void perform(@NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
        List<NlComponent> targetLinearLayouts = ToggleOrientationAction.getTargetLinearLayouts(component, selectedChildren);
        NlWriteCommandActionUtil.run(targetLinearLayouts, "Change LinearLayout orientation", () -> {
            for (NlComponent child : targetLinearLayouts) {
                boolean isVertical = handler.isVertical(child);
                String value2 = isVertical ? null : "vertical";
                child.setAttribute("http://schemas.android.com/apk/res/android", "orientation", value2);
            }
        });
    }

    @Override
    protected void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, int modifiers) {
        List<NlComponent> targetLinearLayouts = ToggleOrientationAction.getTargetLinearLayouts(component, selectedChildren);
        NlComponent primary = targetLinearLayouts.get(0);
        boolean vertical = handler.isVertical(primary);
        presentation.setLabel("Convert orientation to " + (vertical ? "horizontal" : "vertical"));
        Icon icon2 = vertical ? StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ : StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_VERT;
        presentation.setIcon(icon2);
    }

    private static List<NlComponent> getTargetLinearLayouts(@NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
        ArrayList<NlComponent> targetLinearLayouts = new ArrayList<NlComponent>();
        for (NlComponent child : selectedChildren) {
            if (!NlComponentHelperKt.isOrHasSuperclass(child, "LinearLayout")) continue;
            targetLinearLayouts.add(child);
        }
        if (targetLinearLayouts.isEmpty()) {
            targetLinearLayouts.add(parent);
        }
        return targetLinearLayouts;
    }
}

