/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionSeparator;
import com.android.tools.idea.uibuilder.api.actions.ViewActionUtils;
import com.android.tools.idea.uibuilder.handlers.common.ViewGroupPlaceholder;
import com.android.tools.idea.uibuilder.handlers.linear.LinearDragHandler;
import com.android.tools.idea.uibuilder.handlers.linear.LinearPlaceholderFactory;
import com.android.tools.idea.uibuilder.handlers.linear.actions.BaselineAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ClearWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.DistributeWeightsAction;
import com.android.tools.idea.uibuilder.handlers.linear.actions.ToggleOrientationAction;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearResizeTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.model.FillPolicy;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearLayoutHandler
extends ViewGroupHandler {
    final HashMap<SceneComponent, SceneComponent> myDraggingComponents = new HashMap();

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        if (!component.getTagName().equals("LinearLayout")) {
            return super.getTitleAttributes(component);
        }
        return this.isVertical(component) ? "(vertical)" : "(horizontal)";
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!component.getTagName().equals("LinearLayout")) {
            return super.getIcon(component);
        }
        return this.isVertical(component) ? StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_VERT : StudioIcons.LayoutEditor.Palette.LINEAR_LAYOUT_HORZ;
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"orientation", (Object)"gravity");
    }

    @Override
    @NotNull
    public List<String> getLayoutInspectorProperties() {
        return ImmutableList.of((Object)"layout_weight");
    }

    public boolean isVertical(@NotNull NlComponent component) {
        return "vertical".equals(component.resolveAttribute("http://schemas.android.com/apk/res/android", "orientation"));
    }

    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (layout2.getDrawWidth() == 0 || layout2.getDrawHeight() == 0) {
            return null;
        }
        return new LinearDragHandler(editor, this, layout2, components, type);
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.MOVE) {
            return;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(newChild);
        if (viewHandler != null) {
            boolean vertical = this.isVertical(layout2);
            FillPolicy fill2 = viewHandler.getFillPolicy();
            String fillParent = "match_parent";
            if (fill2.fillHorizontally(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fillParent);
            } else if (!vertical && fill2 == FillPolicy.WIDTH_IN_VERTICAL) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", "1");
            }
            if (fill2.fillVertically(vertical)) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fillParent);
            }
        }
        boolean duplicateWeight = true;
        boolean duplicate0dip = true;
        String sameWeight = null;
        String sizeAttribute = this.isVertical(layout2) ? "layout_height" : "layout_width";
        for (NlComponent target : layout2.getChildren()) {
            String size;
            if (target == newChild) continue;
            String weight = target.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
            if (weight == null || weight.isEmpty()) {
                duplicateWeight = false;
                break;
            }
            if (sameWeight != null && !sameWeight.equals(weight)) {
                duplicateWeight = false;
            } else {
                sameWeight = weight;
            }
            if ((size = target.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute)) == null || size.startsWith("0")) continue;
            duplicate0dip = false;
            break;
        }
        if (duplicateWeight && sameWeight != null) {
            newChild.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", sameWeight);
            if (duplicate0dip) {
                newChild.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
            }
        }
    }

    static float getWeight(@NotNull NlComponent linearLayoutChild) {
        String weight = linearLayoutChild.getAttribute("http://schemas.android.com/apk/res/android", "layout_weight");
        if (weight != null && !weight.isEmpty()) {
            try {
                return Float.parseFloat(weight);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    static float getWeightSum(@NotNull NlComponent linearLayout) {
        String weightSum = linearLayout.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        if (weightSum != null) {
            try {
                float sum = Float.parseFloat(weightSum);
                return sum;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return LinearLayoutHandler.getSumOfWeights(linearLayout);
    }

    private static float getSumOfWeights(@NotNull NlComponent linearLayout) {
        float sum = 0.0f;
        for (NlComponent child : linearLayout.getChildren()) {
            sum += LinearLayoutHandler.getWeight(child);
        }
        return sum;
    }

    public void clearWeights(@NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren) {
        String sizeAttribute = this.isVertical(component) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", null);
            String size = selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute);
            if (size == null || !size.startsWith("0")) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "wrap_content");
        }
    }

    public void distributeWeights(@NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren) {
        if (selectedChildren.isEmpty()) {
            return;
        }
        String weightSum = component.getAttribute("http://schemas.android.com/apk/res/android", "weightSum");
        double sum = -1.0;
        if (weightSum != null && !weightSum.isEmpty()) {
            try {
                sum = Double.parseDouble(weightSum);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int numTargets = selectedChildren.size();
        double share = sum <= 0.0 ? 1.0 : sum / (double)numTargets;
        String value2 = XmlUtils.formatFloatValue((double)((float)share));
        String sizeAttribute = this.isVertical(component) ? "layout_height" : "layout_width";
        for (NlComponent selected : selectedChildren) {
            selected.setAttribute("http://schemas.android.com/apk/res/android", "layout_weight", value2);
            if (!"wrap_content".equals(selected.getAttribute("http://schemas.android.com/apk/res/android", sizeAttribute))) continue;
            selected.setAttribute("http://schemas.android.com/apk/res/android", sizeAttribute, "0dp");
        }
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        actions2.add(ViewActionUtils.getViewOptionsAction());
        actions2.add(new ToggleOrientationAction());
        actions2.add(new BaselineAction());
        actions2.add(new DistributeWeightsAction());
        actions2.add(new ClearWeightsAction());
        actions2.add(new ViewActionSeparator());
        actions2.addAll(ViewActionUtils.getToggleSizeActions());
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        this.addToolbarActionsToMenu("LinearLayout", actions2);
        return true;
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView sceneView, int x, int y, @NotNull NlComponent component) {
        return new SceneInteraction(sceneView);
    }

    @Override
    public boolean handlesPainting() {
        return true;
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)new LinearDragTarget(this));
        LinearLayoutHandler.createResizeTarget(parentComponent, childComponent, (ImmutableList.Builder<Target>)listBuilder);
        this.createSeparatorTargets(parentComponent, childComponent, (ImmutableList.Builder<Target>)listBuilder);
        return listBuilder.build();
    }

    private void createSeparatorTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        SceneComponent draggingComponent = this.myDraggingComponents.get(parentComponent);
        if (draggingComponent != null && draggingComponent != childComponent) {
            boolean isLayoutOrientationVertical = this.isVertical(parentComponent.getNlComponent());
            if (LinearLayoutHandler.canReceiveBefore(parentComponent, childComponent, draggingComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, false));
            }
            if (LinearLayoutHandler.isLastChild(parentComponent, childComponent)) {
                listBuilder.add((Object)new LinearSeparatorTarget(isLayoutOrientationVertical, true));
            }
        }
    }

    private static void createResizeTarget(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent, @NotNull ImmutableList.Builder<Target> listBuilder) {
        String orientation2 = parentComponent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        boolean showLeft = true;
        boolean showTop = true;
        boolean showBottom = true;
        boolean showRight = true;
        String gravityAttribute = childComponent.getNlComponent().getAttribute("http://schemas.android.com/apk/res/android", "layout_gravity");
        if (gravityAttribute == null || gravityAttribute.contains("fill")) {
            showLeft = false;
            showTop = false;
        } else {
            String[] gravities;
            String[] stringArray = gravities = gravityAttribute.split("\\|");
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String gravity;
                switch (gravity = stringArray[i]) {
                    case "left": 
                    case "start": {
                        showLeft = false;
                        continue block18;
                    }
                    case "top": {
                        showTop = false;
                        continue block18;
                    }
                    case "bottom": {
                        showBottom = false;
                        continue block18;
                    }
                    case "right": 
                    case "end": {
                        showRight = false;
                        continue block18;
                    }
                    case "center_horizontal": {
                        if (!"vertical".equals(orientation2)) continue block18;
                        showTop = false;
                        continue block18;
                    }
                    case "center_vertical": {
                        if (!"horizontal".equals(orientation2)) continue block18;
                        showLeft = false;
                    }
                }
            }
        }
        if (showLeft) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT));
        }
        if (showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.TOP));
        }
        if (showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.BOTTOM));
        }
        if (showRight) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT));
        }
        if (showLeft && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_TOP));
        }
        if (showLeft && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM));
        }
        if (showRight && showTop) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP));
        }
        if (showRight && showBottom) {
            listBuilder.add((Object)new LinearResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM));
        }
    }

    private static boolean canReceiveBefore(@NotNull SceneComponent parent, @NotNull SceneComponent nextSibling, @NotNull SceneComponent draggingComponent) {
        List<NlComponent> children = parent.getNlComponent().getChildren();
        int i = children.indexOf(nextSibling.getNlComponent());
        return i > -1 && (i == 0 || children.get(i - 1) != draggingComponent.getNlComponent());
    }

    private static boolean isLastChild(@NotNull SceneComponent linearLayoutComponent, @NotNull SceneComponent child) {
        NlComponent nlComponent = linearLayoutComponent.getNlComponent();
        return nlComponent.getChild(nlComponent.getChildCount() - 1) == child.getNlComponent();
    }

    public static boolean insertComponentAtTarget(@NotNull SceneComponent component, @NotNull LinearSeparatorTarget separatorTarget) {
        SceneComponent sceneParent = component.getParent();
        if (sceneParent == null) {
            return false;
        }
        NlComponent parent = sceneParent.getNlComponent();
        NlComponent before = !separatorTarget.isAtEnd() ? separatorTarget.getComponent().getNlComponent() : null;
        NlModel model2 = parent.getModel();
        model2.addComponents((List<NlComponent>)ImmutableList.of((Object)component.getNlComponent()), parent, before, InsertType.MOVE, null);
        return true;
    }

    public void setDragging(@NotNull SceneComponent draggedComponent, boolean isDragging) {
        if (isDragging && !this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.put(draggedComponent.getParent(), draggedComponent);
        } else if (!isDragging && this.myDraggingComponents.containsKey(draggedComponent.getParent())) {
            this.myDraggingComponents.remove(draggedComponent.getParent());
        }
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component, @NotNull List<SceneComponent> draggedComponents) {
        boolean vertical = this.isVertical(component.getNlComponent());
        ArrayList<Placeholder> list = new ArrayList<Placeholder>();
        if (vertical) {
            int bottomOfChildren = component.getDrawY();
            int left = component.getDrawX();
            int right2 = component.getDrawX() + component.getDrawWidth();
            for (SceneComponent child : component.getChildren()) {
                list.add(LinearPlaceholderFactory.createVerticalPlaceholder(component, child, child.getDrawY(), left, right2));
                bottomOfChildren = Math.max(bottomOfChildren, child.getDrawY() + child.getDrawHeight());
            }
            list.add(LinearPlaceholderFactory.createVerticalPlaceholder(component, null, bottomOfChildren, left, right2));
        } else {
            int rightOfChildren = component.getDrawX();
            int top = component.getDrawY();
            int bottom2 = component.getDrawY() + component.getDrawHeight();
            for (SceneComponent child : component.getChildren()) {
                list.add(LinearPlaceholderFactory.createHorizontalPlaceholder(component, child, child.getDrawX(), top, bottom2));
                rightOfChildren = Math.max(rightOfChildren, child.getDrawX() + child.getDrawWidth());
            }
            list.add(LinearPlaceholderFactory.createHorizontalPlaceholder(component, null, rightOfChildren, top, bottom2));
        }
        list.add(new ViewGroupPlaceholder(component));
        return list;
    }
}

