/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.NonPlaceholderDragTarget;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.uibuilder.handlers.coordinator.DrawSnapTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0014J\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ0\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget;", "Lcom/android/tools/idea/common/scene/target/BaseTarget;", "Lcom/android/tools/idea/common/scene/NonPlaceholderDragTarget;", "type", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget$Type;", "(Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget$Type;)V", "DEBUG", "", "mySize", "", "myType", "coordinateInRange", "x", "left", "", "right", "getPreferenceLevel", "isHittable", "isSnapped", "y", "layout", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "top", "bottom", "render", "", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "snap", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "Type", "intellij.android.designer"})
public final class CoordinatorSnapTarget
extends BaseTarget
implements NonPlaceholderDragTarget {
    private final boolean DEBUG;
    @NotNull
    private Type myType;
    private int mySize;

    public CoordinatorSnapTarget(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.myType = type;
        this.mySize = 32;
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int left, int top, int right2, int bottom2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int l = left;
        int t = top;
        int r = right2;
        int b = bottom2;
        int d = Math.min(Math.min(b - t, r - l) / 4, this.mySize);
        if (this.myType == Type.RIGHT_TOP || this.myType == Type.RIGHT || this.myType == Type.RIGHT_BOTTOM) {
            l = r - d;
        } else if (this.myType == Type.TOP || this.myType == Type.CENTER || this.myType == Type.BOTTOM) {
            l = l + (r - l) / 2 - d / 2;
        }
        if (this.myType == Type.LEFT_BOTTOM || this.myType == Type.BOTTOM || this.myType == Type.RIGHT_BOTTOM) {
            t = b - d;
        } else if (this.myType == Type.LEFT || this.myType == Type.CENTER || this.myType == Type.RIGHT) {
            t = t + (b - t) / 2 - d / 2;
        }
        r = l + d;
        b = t + d;
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        if (this.DEBUG) {
            Color color = this.mIsOver ? Color.orange : Color.green;
            list.addRect(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, color);
            list.addLine(sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, color);
            list.addLine(sceneContext, this.myLeft, this.myBottom, this.myRight, this.myTop, color);
        }
        DrawSnapTarget.Companion.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.mIsOver);
    }

    @Override
    protected boolean isHittable() {
        return !this.myComponent.isSelected() && !this.myComponent.isDragging();
    }

    public final boolean isSnapped(int x, int y) {
        return this.coordinateInRange(x, this.myLeft, this.myRight) && this.coordinateInRange(y, this.myTop, this.myBottom);
    }

    private final boolean coordinateInRange(int x, float left, float right2) {
        return (float)x >= left && (float)x <= right2;
    }

    public final void snap(@NotNull NlAttributesHolder attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String value2 = switch (WhenMappings.$EnumSwitchMapping$0[this.myType.ordinal()]) {
            case 1 -> "start|center";
            case 2 -> "end|center";
            case 3 -> "top|center";
            case 4 -> "bottom|center";
            case 5 -> "start|top";
            case 6 -> "start|bottom";
            case 7 -> "center";
            case 8 -> "end|top";
            case 9 -> "end|bottom";
            default -> throw new NoWhenBranchMatchedException();
        };
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchorGravity", value2);
        NlComponent nlComponent = this.myComponent.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"myComponent.nlComponent");
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchor", "@+id/" + NlComponentHelperKt.ensureLiveId(nlComponent));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget$Type;", "", "(Ljava/lang/String;I)V", "LEFT", "LEFT_TOP", "LEFT_BOTTOM", "RIGHT", "RIGHT_TOP", "RIGHT_BOTTOM", "TOP", "CENTER", "BOTTOM", "intellij.android.designer"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LEFT = new Type();
        public static final /* enum */ Type LEFT_TOP = new Type();
        public static final /* enum */ Type LEFT_BOTTOM = new Type();
        public static final /* enum */ Type RIGHT = new Type();
        public static final /* enum */ Type RIGHT_TOP = new Type();
        public static final /* enum */ Type RIGHT_BOTTOM = new Type();
        public static final /* enum */ Type TOP = new Type();
        public static final /* enum */ Type CENTER = new Type();
        public static final /* enum */ Type BOTTOM = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value2) {
            return Enum.valueOf(Type.class, value2);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.LEFT, Type.LEFT_TOP, Type.LEFT_BOTTOM, Type.RIGHT, Type.RIGHT_TOP, Type.RIGHT_BOTTOM, Type.TOP, Type.CENTER, Type.BOTTOM};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LEFT_TOP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LEFT_BOTTOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.CENTER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RIGHT_TOP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.RIGHT_BOTTOM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

