/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorDragTarget;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorSnapTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J \u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J*\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragHandler;", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "handler", "Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;", "layout", "Lcom/android/tools/idea/common/scene/SceneComponent;", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/common/api/DragType;", "(Lcom/android/tools/idea/uibuilder/api/ViewEditor;Lcom/android/tools/idea/uibuilder/api/ViewGroupHandler;Lcom/android/tools/idea/common/scene/SceneComponent;Ljava/util/List;Lcom/android/tools/idea/common/api/DragType;)V", "dragTarget", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragTarget;", "sceneComponent", "snapTargets", "", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget;", "cancel", "", "commit", "x", "", "y", "modifiers", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "dragWidgetFromComponentTree", "dragWidgetFromPalette", "start", "update", "", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nCoordinatorDragHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinatorDragHandler.kt\ncom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n1549#3:117\n1620#3,3:118\n800#3,11:121\n766#3:132\n857#3,2:133\n*S KotlinDebug\n*F\n+ 1 CoordinatorDragHandler.kt\ncom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragHandler\n*L\n63#1:117\n63#1:118,3\n63#1:121,11\n72#1:132\n72#1:133,2\n*E\n"})
public final class CoordinatorDragHandler
extends DragHandler {
    @NotNull
    private SceneComponent sceneComponent;
    @NotNull
    private final CoordinatorDragTarget dragTarget;
    @NotNull
    private final List<CoordinatorSnapTarget> snapTargets;

    /*
     * WARNING - void declaration
     */
    public CoordinatorDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent layout2, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        SceneComponent sceneComponent;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(editor, handler, layout2, components, type);
        this.dragTarget = new CoordinatorDragTarget();
        this.snapTargets = new ArrayList();
        boolean bl2 = bl = components.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        NlComponent dragged = components.get(0);
        CoordinatorDragHandler coordinatorDragHandler = this;
        SceneComponent sceneComponent2 = layout2.getScene().getSceneComponent(dragged);
        if (sceneComponent2 == null) {
            void $this$_init__u24lambda_u240;
            TemporarySceneComponent temporarySceneComponent;
            TemporarySceneComponent temporarySceneComponent2 = temporarySceneComponent = new TemporarySceneComponent(layout2.getScene(), dragged);
            CoordinatorDragHandler coordinatorDragHandler2 = coordinatorDragHandler;
            boolean bl3 = false;
            $this$_init__u24lambda_u240.setSize(editor.pxToDp(NlComponentHelperKt.getW(dragged)), editor.pxToDp(NlComponentHelperKt.getH(dragged)));
            coordinatorDragHandler = coordinatorDragHandler2;
            sceneComponent = temporarySceneComponent;
        } else {
            sceneComponent = sceneComponent2;
        }
        coordinatorDragHandler.sceneComponent = sceneComponent;
        this.sceneComponent.setTargetProvider(new TargetProvider(){

            @Override
            @NotNull
            public final List<Target> createTargets(@NotNull SceneComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CollectionsKt.listOf((Object)dragTarget);
            }
        });
        this.sceneComponent.updateTargets();
        this.dragTarget.setComponent(this.sceneComponent);
        this.sceneComponent.setSelected(true);
        this.sceneComponent.setDrawState(SceneComponent.DrawState.DRAG);
        layout2.addChild(this.sceneComponent);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        this.dragTarget.mouseDown(x, y);
        this.snapTargets.clear();
        v0 = this.snapTargets;
        var4_4 = this.sceneComponent.getParent();
        if (var4_4 == null || (var5_5 = var4_4.getChildren()) == null) ** GOTO lbl-1000
        var6_6 = var5_5;
        var15_7 = v0;
        $i$f$map = false;
        var8_9 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_17 = (SceneComponent)item$iv$iv;
            var16_20 = destination$iv$iv;
            $i$a$-map-CoordinatorDragHandler$start$1 = false;
            var16_20.add(it.getTargets());
        }
        v0 = var15_7;
        var6_6 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        if (var6_6 == null) ** GOTO lbl-1000
        $this$mapTo$iv$iv = var6_6;
        var15_7 = v0;
        $i$f$filterIsInstance = false;
        $i$f$mapTo = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CoordinatorSnapTarget)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        v0 = var15_7;
        var8_9 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (var8_9 != null) {
            v1 = var8_9;
        } else lbl-1000:
        // 3 sources

        {
            v1 = CollectionsKt.emptyList();
        }
        v0.addAll(v1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull SceneContext sceneContext) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        String ret = super.update(x, y, modifiers, sceneContext);
        int dx = x + this.startX - this.sceneComponent.getDrawWidth() / 2;
        int dy = y + this.startY - this.sceneComponent.getDrawHeight() / 2;
        Iterable iterable = this.snapTargets;
        int n = dy;
        int n2 = dx;
        CoordinatorDragTarget coordinatorDragTarget = this.dragTarget;
        boolean $i$f$filter = false;
        void var10_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoordinatorSnapTarget it = (CoordinatorSnapTarget)element$iv$iv;
            boolean bl = false;
            if (!it.isSnapped(x, y)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        coordinatorDragTarget.mouseDrag(n2, n, list, sceneContext);
        return ret;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
        this.editor.insertChildren(this.layout.getNlComponent(), this.components, -1, insertType);
        switch (WhenMappings.$EnumSwitchMapping$0[insertType.ordinal()]) {
            case 1: {
                this.dragWidgetFromPalette(x, y);
                break;
            }
            case 2: {
                this.dragWidgetFromComponentTree(x, y);
                break;
            }
            default: {
                Logger.getInstance((String)this.getClass().getName()).error("Unexpected InsertType in " + this.getClass().getName() + "#commit}");
            }
        }
        this.layout.getScene().removeComponent(this.sceneComponent);
        this.layout.getScene().requestLayoutIfNeeded();
    }

    private final void dragWidgetFromPalette(int x, int y) {
        this.layout.getScene().needsRebuildList();
        int dx = this.editor.pxToDp(x) + this.startX - this.sceneComponent.getDrawWidth() / 2;
        int dy = this.editor.pxToDp(y) + this.startY - this.sceneComponent.getDrawHeight() / 2;
        for (NlComponent child : this.components) {
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.dragTarget.mouseRelease(dx, dy, child);
        }
    }

    private final void dragWidgetFromComponentTree(int x, int y) {
        for (NlComponent child : this.components) {
            SceneComponent sceneComponent;
            if (this.layout.getSceneComponent(child) == null) continue;
            sceneComponent.setDragging(true);
            this.dragTarget.setComponent(sceneComponent);
            int dx = this.editor.pxToDp(x) + this.startX - sceneComponent.getDrawWidth() / 2;
            int dy = this.editor.pxToDp(y) + this.startY - sceneComponent.getDrawHeight() / 2;
            this.dragTarget.mouseRelease(dx, dy, CollectionsKt.emptyList());
        }
    }

    @Override
    public void cancel() {
        this.editor.getScene().removeComponent(this.sceneComponent);
        this.dragTarget.mouseCancel();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InsertType.values().length];
            try {
                nArray[InsertType.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InsertType.MOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

