/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidgetContainer;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Rectangle;
import java.util.ArrayList;

public class WidgetContainer
extends ConstraintWidget {
    protected ArrayList<ConstraintWidget> mChildren = new ArrayList();

    @Override
    public void reset() {
        this.mChildren.clear();
        super.reset();
    }

    public void add(ConstraintWidget widget) {
        this.mChildren.add(widget);
        if (widget.getParent() != null) {
            WidgetContainer container = (WidgetContainer)widget.getParent();
            container.remove(widget);
        }
        widget.setParent(this);
    }

    public void remove(ConstraintWidget widget) {
        this.mChildren.remove(widget);
        widget.setParent(null);
    }

    public ArrayList<ConstraintWidget> getChildren() {
        return this.mChildren;
    }

    public static Rectangle getBounds(ArrayList<ConstraintWidget> widgets) {
        Rectangle bounds2 = new Rectangle();
        if (widgets.isEmpty()) {
            return bounds2;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        int widgetsSize = widgets.size();
        for (int i = 0; i < widgetsSize; ++i) {
            ConstraintWidget widget = widgets.get(i);
            if (widget.getX() < minX) {
                minX = widget.getX();
            }
            if (widget.getY() < minY) {
                minY = widget.getY();
            }
            if (widget.getRight() > maxX) {
                maxX = widget.getRight();
            }
            if (widget.getBottom() <= maxY) continue;
            maxY = widget.getBottom();
        }
        bounds2.setBounds(minX, minY, maxX - minX, maxY - minY);
        return bounds2;
    }

    @Override
    public void setOffset(int x, int y) {
        super.setOffset(x, y);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = this.mChildren.get(i);
            widget.setOffset(this.getRootX(), this.getRootY());
        }
    }

    @Override
    public void updateDrawPosition() {
        super.updateDrawPosition();
        if (this.mChildren == null) {
            return;
        }
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = this.mChildren.get(i);
            widget.setOffset(this.getDrawX(), this.getDrawY());
            if (widget instanceof ConstraintWidgetContainer) continue;
            widget.updateDrawPosition();
        }
    }

    public void layout() {
        this.updateDrawPosition();
        if (this.mChildren == null) {
            return;
        }
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
    }
}

