/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTagHandler
extends ViewHandler {
    private static final String DIVIDER_BACKGROUND = "?android:attr/listDivider";
    public static final Predicate<String> SUITABLE_LAYOUT_CLASS = ViewTagHandler::isViewSuitableForLayout;

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"class", (Object)"style");
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        return "<view>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        return "<view>";
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<view/>";
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        return super.getXml(tagName, xmlType);
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (insertType == InsertType.CREATE && newChild.getAttribute(null, "class") == null && !ViewTagHandler.isVerticalDivider(newChild) && !ViewTagHandler.isHorizontalDivider(newChild)) {
            String src = ViewTagHandler.browseClasses(newChild.getModel(), null);
            if (src != null) {
                NlWriteCommandActionUtil.run(newChild, "Setting layout attribute", () -> newChild.setAttribute(null, "class", src));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!component.getTagName().equals("view")) {
            return super.getIcon(component);
        }
        if (ViewTagHandler.isVerticalDivider(component)) {
            return StudioIcons.LayoutEditor.Palette.VERTICAL_DIVIDER;
        }
        if (ViewTagHandler.isHorizontalDivider(component)) {
            return StudioIcons.LayoutEditor.Palette.HORIZONTAL_DIVIDER;
        }
        return StudioIcons.LayoutEditor.Palette.VIEW;
    }

    private static boolean isVerticalDivider(@NotNull NlComponent component) {
        return DIVIDER_BACKGROUND.equals(component.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component, "layout_width");
    }

    private static boolean isHorizontalDivider(@NotNull NlComponent component) {
        return DIVIDER_BACKGROUND.equals(component.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component, "layout_height");
    }

    private static boolean hasShortWidth(@NotNull NlComponent component, @NotNull String attributeName) {
        String value2 = component.getAttribute("http://schemas.android.com/apk/res/android", attributeName);
        if (value2 == null) {
            return false;
        }
        switch (value2) {
            case "1": 
            case "1px": 
            case "1dp": 
            case "1dip": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String browseClasses(@NotNull NlModel model2, @Nullable String existingValue) {
        return ViewEditor.displayClassInput(model2, "Views", Collections.singleton("android.view.View"), SUITABLE_LAYOUT_CLASS, existingValue);
    }

    private static boolean isViewSuitableForLayout(@NotNull String qualifiedName) {
        return !qualifiedName.startsWith("android.") || qualifiedName.startsWith("android.support.") || qualifiedName.startsWith("androidx.");
    }
}

