/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.SetColorBlindModeAction;
import com.android.tools.idea.actions.SetScreenViewProviderAction;
import com.android.tools.idea.common.actions.IssueNotificationAction;
import com.android.tools.idea.common.actions.NextDeviceAction;
import com.android.tools.idea.common.actions.RefreshRenderAction;
import com.android.tools.idea.common.actions.ToggleDeviceNightModeAction;
import com.android.tools.idea.common.actions.ToggleDeviceOrientationAction;
import com.android.tools.idea.common.editor.ToolbarActionGroups;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.DeviceMenuAction2;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.NightModeMenuAction;
import com.android.tools.idea.configurations.OrientationMenuAction;
import com.android.tools.idea.configurations.SystemUiModeAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.configurations.ThemeMenuAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayMenuAction;
import com.android.tools.idea.uibuilder.actions.LayoutQualifierDropdownMenu;
import com.android.tools.idea.uibuilder.actions.SwitchToNextScreenViewProviderAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import org.jetbrains.annotations.NotNull;

public final class DefaultNlToolbarActionGroups
extends ToolbarActionGroups {
    public DefaultNlToolbarActionGroups(@NotNull NlDesignSurface surface2) {
        super(surface2);
    }

    @Override
    @NotNull
    protected ActionGroup getEastGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("LayoutEditor.HelpAssistant"));
        return group;
    }

    @Override
    @NotNull
    protected ActionGroup getNorthGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.isInVisualizationTool()) {
            return group;
        }
        ImmutableList<NlModel> models2 = this.mySurface.getModels();
        VirtualFile file2 = !models2.isEmpty() ? ((NlModel)models2.get(0)).getVirtualFile() : null;
        LayoutQualifierDropdownMenu dropdown = new LayoutQualifierDropdownMenu(file2);
        group.add((AnAction)dropdown);
        group.addSeparator();
        DropDownAction designModeAction = this.createDesignModeAction();
        this.appendShortcutText((AnAction)designModeAction, SwitchToNextScreenViewProviderAction.getInstance());
        group.add((AnAction)designModeAction);
        group.addSeparator();
        OrientationMenuAction orientationMenuAction = new OrientationMenuAction(() -> ((DesignSurface)this.mySurface).getConfiguration(), true);
        this.appendShortcutText((AnAction)orientationMenuAction, ToggleDeviceOrientationAction.getInstance());
        group.add((AnAction)orientationMenuAction);
        if (((Boolean)StudioFlags.NELE_OVERLAY_PROVIDER.get()).booleanValue() && OverlayConfiguration.EP_NAME.hasAnyExtensions()) {
            group.addSeparator();
            OverlayMenuAction overlayAction = new OverlayMenuAction((EditorDesignSurface)this.mySurface);
            group.add((AnAction)overlayAction);
        }
        group.addSeparator();
        if (((Boolean)StudioFlags.NELE_DYNAMIC_THEMING_ACTION.get()).booleanValue()) {
            SystemUiModeAction systemUiModeAction = new SystemUiModeAction(() -> ((DesignSurface)this.mySurface).getConfiguration());
            this.appendShortcutText((AnAction)systemUiModeAction, ToggleDeviceNightModeAction.getInstance());
            group.add((AnAction)systemUiModeAction);
        } else {
            NightModeMenuAction nightModeAction = new NightModeMenuAction(() -> ((DesignSurface)this.mySurface).getConfiguration());
            this.appendShortcutText((AnAction)nightModeAction, ToggleDeviceNightModeAction.getInstance());
            group.add((AnAction)nightModeAction);
        }
        group.addSeparator();
        if (((Boolean)StudioFlags.NELE_NEW_DEVICE_MENU.get()).booleanValue()) {
            DeviceMenuAction2 menuAction2 = new DeviceMenuAction2(() -> this.mySurface.getConfigurations().stream().findFirst().orElse(null), (oldDevice, newDevice) -> this.mySurface.zoomToFit());
            this.appendShortcutText((AnAction)menuAction2, NextDeviceAction.getInstance());
            group.add((AnAction)menuAction2);
        } else {
            DeviceMenuAction menuAction = new DeviceMenuAction(() -> ((DesignSurface)this.mySurface).getConfiguration(), (oldDevice, newDevice) -> this.mySurface.zoomToFit());
            this.appendShortcutText((AnAction)menuAction, NextDeviceAction.getInstance());
            group.add((AnAction)menuAction);
        }
        group.add((AnAction)new TargetMenuAction(() -> ((DesignSurface)this.mySurface).getConfiguration()));
        group.add((AnAction)new ThemeMenuAction(() -> ((DesignSurface)this.mySurface).getConfiguration()));
        group.addSeparator();
        group.add((AnAction)new LocaleMenuAction(() -> ((DesignSurface)this.mySurface).getConfiguration()));
        group.addSeparator();
        return group;
    }

    private void appendShortcutText(@NotNull AnAction targetAction, @NotNull AnAction action2) {
        String shortcutsText = KeymapUtil.getPreferredShortcutText((Shortcut[])action2.getShortcutSet().getShortcuts());
        Presentation presentation = targetAction.getTemplatePresentation();
        if (!shortcutsText.isEmpty()) {
            presentation.setDescription(String.format("%s (%s)", presentation.getDescription(), shortcutsText));
        }
    }

    @NotNull
    private DropDownAction createDesignModeAction() {
        NlDesignSurface nlDesignSurface = (NlDesignSurface)this.mySurface;
        DropDownAction designSurfaceMenu = new DropDownAction("Select Design Surface", "Select Design Surface", StudioIcons.LayoutEditor.Toolbar.VIEW_MODE);
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.RENDER, nlDesignSurface));
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.BLUEPRINT, nlDesignSurface));
        designSurfaceMenu.addAction((AnAction)new SetScreenViewProviderAction(NlScreenViewProvider.RENDER_AND_BLUEPRINT, nlDesignSurface));
        DefaultActionGroup colorBlindMode = DropDownAction.createSubMenuGroup(() -> "Color Blind Modes");
        colorBlindMode.addAction((AnAction)new SetColorBlindModeAction(ColorBlindMode.PROTANOPES, nlDesignSurface));
        colorBlindMode.addAction((AnAction)new SetColorBlindModeAction(ColorBlindMode.PROTANOMALY, nlDesignSurface));
        colorBlindMode.addAction((AnAction)new SetColorBlindModeAction(ColorBlindMode.DEUTERANOPES, nlDesignSurface));
        colorBlindMode.addAction((AnAction)new SetColorBlindModeAction(ColorBlindMode.DEUTERANOMALY, nlDesignSurface));
        colorBlindMode.addAction((AnAction)new SetColorBlindModeAction(ColorBlindMode.TRITANOPES, nlDesignSurface));
        designSurfaceMenu.addAction((AnAction)colorBlindMode);
        designSurfaceMenu.addSeparator();
        designSurfaceMenu.addAction((AnAction)RefreshRenderAction.getInstance());
        return designSurfaceMenu;
    }

    @Override
    @NotNull
    protected ActionGroup getNorthEastGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.isInVisualizationTool()) {
            return group;
        }
        group.add((AnAction)IssueNotificationAction.getInstance());
        return group;
    }

    private boolean isInVisualizationTool() {
        return ((NlDesignSurface)this.mySurface).getScreenViewProvider() == NlScreenViewProvider.VISUALIZATION;
    }
}

