/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFilesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.actions.CreateVariationAction;
import com.android.tools.idea.uibuilder.actions.LayoutQualifierDropdownMenuKt;
import com.android.tools.idea.uibuilder.actions.SwitchToVariationAction;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.google.common.collect.ImmutableCollection;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0014J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/actions/LayoutQualifierDropdownMenu;", "Lcom/android/tools/adtui/actions/DropDownAction;", "()V", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "displayText", "", "createVariationsActions", "", "configuration", "Lcom/android/tools/idea/configurations/Configuration;", "surface", "Lcom/android/tools/idea/ui/designer/EditorDesignSurface;", "displayTextInToolbar", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isPerformableWithoutActionButton", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateActions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.designer"})
public final class LayoutQualifierDropdownMenu
extends DropDownAction {
    @NotNull
    private final String displayText;

    public LayoutQualifierDropdownMenu(@Nullable VirtualFile file2) {
        super(LayoutQualifierDropdownMenuKt.access$generateLayoutAndQualifierTitle(file2), "Action to switch and create qualifiers for layout files", null);
        this.displayText = LayoutQualifierDropdownMenuKt.access$generateLayoutAndQualifierTitle(file2);
    }

    private LayoutQualifierDropdownMenu() {
        this(null);
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    protected boolean isPerformableWithoutActionButton() {
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NlDesignSurface nlDesignSurface = (NlDesignSurface)e.getDataContext().getData(DesignerDataKeys.DESIGN_SURFACE);
        ScreenViewProvider screenViewProvider = nlDesignSurface != null ? nlDesignSurface.getScreenViewProvider() : null;
        e.getPresentation().setEnabled(screenViewProvider == NlScreenViewProvider.RENDER || screenViewProvider == NlScreenViewProvider.BLUEPRINT || screenViewProvider == NlScreenViewProvider.Companion.getDEFAULT_SCREEN_MODE());
        e.getPresentation().setText(this.displayText, false);
    }

    public boolean updateActions(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.removeAll();
        DesignSurface designSurface = (DesignSurface)context.getData(DesignerDataKeys.DESIGN_SURFACE);
        if (designSurface == null) {
            return true;
        }
        DesignSurface surface2 = designSurface;
        ImmutableCollection<Configuration> immutableCollection = surface2.getConfigurations();
        Intrinsics.checkNotNullExpressionValue(immutableCollection, (String)"surface.configurations");
        Configuration configuration = (Configuration)CollectionsKt.firstOrNull((Iterable)((Iterable)immutableCollection));
        if (configuration == null) {
            return true;
        }
        Configuration config = configuration;
        this.createVariationsActions(config, surface2);
        return true;
    }

    private final void createVariationsActions(Configuration configuration, EditorDesignSurface surface2) {
        VirtualFile virtualFile2 = configuration.getFile();
        if (virtualFile2 != null) {
            Project project = configuration.getConfigModule().getProject();
            List variations = IdeResourcesUtil.getResourceVariations((VirtualFile)virtualFile2, (boolean)true);
            for (VirtualFile file2 : variations) {
                String title = LayoutQualifierDropdownMenuKt.access$generateLayoutAndQualifierTitle(file2);
                this.add(new SwitchToVariationAction(title, project, file2, Intrinsics.areEqual((Object)virtualFile2, (Object)file2)));
            }
            this.addSeparator();
            ResourceFolderType folderType = ResourceFilesUtil.getFolderType((VirtualFile)configuration.getFile());
            if (folderType == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveTablet = false;
                for (VirtualFile file3 : variations) {
                    SmallestScreenWidthQualifier size;
                    FolderConfiguration config;
                    String name;
                    Intrinsics.checkNotNullExpressionValue((Object)file3.getParent().getName(), (String)"file.parent.name");
                    if (!StringsKt.startsWith$default((String)name, (String)"layout", (boolean)false, (int)2, null) || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation2 = config.getScreenOrientationQualifier();
                    if (orientation2 != null && orientation2.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveTablet) break;
                    }
                    if ((size = config.getSmallestScreenWidthQualifier()) == null || size.getValue() < 600) continue;
                    haveTablet = true;
                    if (!haveLandscape) continue;
                }
                if (!haveLandscape) {
                    this.add(new CreateVariationAction(surface2, "Create Landscape Qualifier", "layout-land"));
                }
                if (!haveTablet) {
                    this.add(new CreateVariationAction(surface2, "Create Tablet Qualifier", "layout-sw600dp"));
                }
                this.add(new CreateVariationAction(surface2, "Add Resource Qualifier", null));
            } else {
                this.add(new CreateVariationAction(surface2, "Create Alternative...", null));
            }
        }
    }
}

