/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.layout;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.layout.SingleComponentLayoutAlgorithm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003567B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001f\u001a\u00020\u00032\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u00032\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!H\u0002J\u001e\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0018\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u001a\u0010*\u001a\u00020%2\u0006\u0010,\u001a\u00020\u000e2\b\b\u0002\u0010-\u001a\u00020\u0017H\u0002J\u001e\u0010.\u001a\u00020%2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u00103\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\u0003H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm;", "Lcom/android/tools/idea/naveditor/scene/layout/SingleComponentLayoutAlgorithm;", "state", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "module", "Lcom/intellij/openapi/module/Module;", "sceneManager", "Lcom/android/tools/idea/naveditor/scene/NavSceneManager;", "(Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;Lcom/intellij/openapi/module/Module;Lcom/android/tools/idea/naveditor/scene/NavSceneManager;)V", "(Lcom/intellij/openapi/module/Module;Lcom/android/tools/idea/naveditor/scene/NavSceneManager;)V", "_storage", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage;", "filePositionMap", "", "Lcom/intellij/psi/xml/XmlFile;", "storage", "getStorage", "()Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage;", "tagPositionMap", "Lcom/google/common/collect/BiMap;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/xml/XmlTag;", "canSave", "", "doLayout", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "getPosition", "tag", "getPositionData", "getPositions", "getPositionsFromPath", "pathWithNulls", "", "", "maybeGetPositionsFromPath", "rectifyIds", "", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "layoutPositions", "reload", "positions", "file", "force", "restorePositionData", "path", "position", "", "save", "setPosition", "tryToFindNewNestedGraphPosition", "LayoutPositions", "Point", "Storage", "intellij.android.nav.editor"})
@SourceDebugExtension(value={"SMAP\nManualLayoutAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualLayoutAlgorithm.kt\ncom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1#2:324\n1360#3:325\n1446#3,5:326\n766#3:331\n857#3,2:332\n1851#3,2:334\n1549#3:336\n1620#3,3:337\n1549#3:340\n1620#3,3:341\n*S KotlinDebug\n*F\n+ 1 ManualLayoutAlgorithm.kt\ncom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm\n*L\n164#1:325\n164#1:326,5\n194#1:331\n194#1:332,2\n194#1:334,2\n205#1:336\n205#1:337,3\n219#1:340\n219#1:341,3\n*E\n"})
public final class ManualLayoutAlgorithm
extends SingleComponentLayoutAlgorithm {
    @NotNull
    private final Module module;
    @NotNull
    private final NavSceneManager sceneManager;
    @Nullable
    private Storage _storage;
    @NotNull
    private final BiMap<SmartPsiElementPointer<XmlTag>, LayoutPositions> tagPositionMap;
    @NotNull
    private final Map<XmlFile, LayoutPositions> filePositionMap;

    public ManualLayoutAlgorithm(@NotNull Module module, @NotNull NavSceneManager sceneManager) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sceneManager, (String)"sceneManager");
        this.module = module;
        this.sceneManager = sceneManager;
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create()");
        this.tagPositionMap = (BiMap)hashBiMap;
        this.filePositionMap = new LinkedHashMap();
    }

    private final Storage getStorage() {
        Storage result = this._storage;
        if (result == null) {
            Object object = this.module.getProject().getService(Storage.class);
            Intrinsics.checkNotNull((Object)object);
            this._storage = result = (Storage)object;
        }
        return result;
    }

    @VisibleForTesting
    public ManualLayoutAlgorithm(@NotNull LayoutPositions state, @NotNull Module module, @NotNull NavSceneManager sceneManager) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sceneManager, (String)"sceneManager");
        this(module, sceneManager);
        this._storage = new Storage();
        this.getStorage().setRootPositions$intellij_android_nav_editor(state);
    }

    @Override
    protected boolean doLayout(@NotNull SceneComponent component) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (Intrinsics.areEqual((Object)component.getNlComponent().getClientProperty("skipPersistedLayout"), (Object)true)) {
            return false;
        }
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component.nlComponent");
        if (!NavComponentHelperKt.isDestination(nlComponent)) {
            return false;
        }
        XmlFile xmlFile = component.getNlComponent().getModel().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"component.nlComponent.model.file");
        ManualLayoutAlgorithm.reload$default(this, xmlFile, false, 2, null);
        NlComponent nlComponent2 = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"component.nlComponent");
        if (NavComponentHelperKt.isNavigation(nlComponent2) && component.getParent() == null) {
            return true;
        }
        LayoutPositions positions = this.getPosition(component.getNlComponent().getTag());
        if (positions == null) {
            XmlFile xmlFile2 = component.getNlComponent().getModel().getFile();
            Intrinsics.checkNotNullExpressionValue((Object)xmlFile2, (String)"component.nlComponent.model.file");
            this.reload(xmlFile2, true);
            positions = this.getPosition(component.getNlComponent().getTag());
        }
        if (positions == null) {
            positions = this.tryToFindNewNestedGraphPosition(component);
        }
        if ((object = positions) == null || (object = ((LayoutPositions)object).getMyPosition()) == null) {
            return false;
        }
        Object location = object;
        component.setPosition(((Point)location).getX(), ((Point)location).getY());
        return true;
    }

    private final void reload(XmlFile file2, boolean force) {
        if (this.filePositionMap.containsKey(file2) && !force) {
            return;
        }
        LayoutPositions layoutPositions = this.getStorage().getState().get(file2.getName());
        if (layoutPositions == null) {
            return;
        }
        LayoutPositions positions = layoutPositions;
        this.filePositionMap.put(file2, positions);
        XmlTag xmlTag = file2.getRootTag();
        if (xmlTag == null) {
            return;
        }
        XmlTag component = xmlTag;
        this.reload(positions, component);
    }

    static /* synthetic */ void reload$default(ManualLayoutAlgorithm manualLayoutAlgorithm, XmlFile xmlFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        manualLayoutAlgorithm.reload(xmlFile, bl);
    }

    private final void reload(LayoutPositions positions, XmlTag tag) {
        this.tagPositionMap.inverse().remove((Object)positions);
        this.setPosition(tag, positions);
        for (Map.Entry<String, LayoutPositions> entry : positions.getMyPositions().entrySet()) {
            XmlTag[] xmlTagArray;
            String id2 = entry.getKey();
            LayoutPositions position = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)tag.getSubTags(), (String)"tag.subTags");
            for (XmlTag subtag : xmlTagArray) {
                String subtagId;
                if (subtag.getAttributeValue("id", "http://schemas.android.com/apk/res/android") != null) {
                    String p0;
                    boolean bl = false;
                    v0 = ResourcesUtil.stripPrefixFromId((String)p0);
                } else {
                    v0 = subtagId = null;
                }
                if (subtagId == null && Intrinsics.areEqual((Object)subtag.getName(), (Object)"include")) {
                    String string = subtag.getAttributeValue("graph", "http://schemas.android.com/apk/res-auto");
                    if (string != null) {
                        String string2 = string.substring(12);
                        v3 = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    } else {
                        v3 = subtagId = null;
                    }
                }
                if (!Intrinsics.areEqual((Object)subtagId, (Object)id2)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)subtag, (String)"subtag");
                this.reload(position, subtag);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component.nlComponent");
        if (!NavComponentHelperKt.isDestination(nlComponent)) {
            return;
        }
        Point newPoint = new Point(component.getDrawX(), component.getDrawY());
        Point oldPoint = this.getPositions(component).getMyPosition();
        if (!Intrinsics.areEqual((Object)oldPoint, (Object)newPoint)) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            NlModel nlModel = component.getNlComponent().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"component.nlComponent.model");
            NlModel model2 = nlModel;
            if (oldPoint != null) {
                WriteCommandAction.writeCommandAction((PsiFile)((PsiFile)model2.getFile()), (PsiFile[])new PsiFile[0]).withName("Move Destination").run(new ThrowableRunnable(component, model2, oldPoint, this, newPoint){
                    final /* synthetic */ SceneComponent $component;
                    final /* synthetic */ NlModel $model;
                    final /* synthetic */ Point $oldPoint;
                    final /* synthetic */ ManualLayoutAlgorithm this$0;
                    final /* synthetic */ Point $newPoint;
                    {
                        this.$component = $component;
                        this.$model = $model;
                        this.$oldPoint = $oldPoint;
                        this.this$0 = $receiver;
                        this.$newPoint = $newPoint;
                    }

                    public final void run() {
                        NlComponent nlComponent = this.$component.getNlComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component.nlComponent");
                        List<String> path = NavComponentHelperKt.getIdPath(nlComponent);
                        VirtualFile[] virtualFileArray = new VirtualFile[]{this.$model.getVirtualFile()};
                        VirtualFile[] virtualFileArray2 = virtualFileArray;
                        BasicUndoableAction action2 = new BasicUndoableAction(this.$component, this.$oldPoint, this.this$0, path, this.$newPoint, virtualFileArray2){
                            final /* synthetic */ SceneComponent $component;
                            final /* synthetic */ Point $oldPoint;
                            final /* synthetic */ ManualLayoutAlgorithm this$0;
                            final /* synthetic */ List<String> $path;
                            final /* synthetic */ Point $newPoint;
                            {
                                this.$component = $component;
                                this.$oldPoint = $oldPoint;
                                this.this$0 = $receiver;
                                this.$path = $path;
                                this.$newPoint = $newPoint;
                                super($super_call_param$1);
                            }

                            public void undo() {
                                this.$component.setPosition(this.$oldPoint.getX(), this.$oldPoint.getY());
                                LayoutPositions positions = ManualLayoutAlgorithm.access$getPositionsFromPath(this.this$0, this.$path);
                                positions.setMyPosition(this.$oldPoint);
                                ManualLayoutAlgorithm.access$getTagPositionMap$p(this.this$0).inverse().remove((Object)positions);
                                ManualLayoutAlgorithm.access$getSceneManager$p(this.this$0).requestRenderAsync();
                            }

                            public void redo() {
                                this.$component.setPosition(this.$newPoint.getX(), this.$newPoint.getY());
                                LayoutPositions positions = ManualLayoutAlgorithm.access$getPositionsFromPath(this.this$0, this.$path);
                                positions.setMyPosition(this.$newPoint);
                                ManualLayoutAlgorithm.access$getTagPositionMap$p(this.this$0).inverse().remove((Object)positions);
                                ManualLayoutAlgorithm.access$getSceneManager$p(this.this$0).requestRenderAsync();
                            }
                        };
                        UndoManager.getInstance((Project)this.$component.getNlComponent().getModel().getProject()).undoableActionPerformed((UndoableAction)action2);
                    }
                });
            }
            LayoutPositions newPositions = this.getPositions(component);
            newPositions.setMyPosition(newPoint);
            this.tagPositionMap.inverse().remove((Object)newPositions);
            this.setPosition(component.getNlComponent().getTag(), newPositions);
            String string = component.getNlComponent().getModel().getVirtualFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"component.nlComponent.model.virtualFile.name");
            String fileName = string;
            ImmutableList<NlComponent> immutableList = model2.getComponents();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"model.components");
            Iterable iterable = (Iterable)immutableList;
            ManualLayoutAlgorithm manualLayoutAlgorithm = this;
            boolean $i$f$flatMap = false;
            void var9_10 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                NlComponent it = (NlComponent)element$iv$iv;
                boolean bl = false;
                List<NlComponent> list = it.getChildren();
                Intrinsics.checkNotNullExpressionValue(list, (String)"it.children");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            LayoutPositions layoutPositions = this.getStorage().getState().get(fileName);
            Intrinsics.checkNotNull((Object)layoutPositions);
            manualLayoutAlgorithm.rectifyIds(collection, layoutPositions);
        }
    }

    private final LayoutPositions getPositions(SceneComponent component) {
        LayoutPositions componentPositions = this.getPosition(component.getNlComponent().getTag());
        if (componentPositions == null) {
            NlComponent nlComponent = component.getNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component.nlComponent");
            NlComponent nlComponent2 = nlComponent;
            List<String> path = NavComponentHelperKt.getIdPath(nlComponent2);
            componentPositions = this.getPositionsFromPath(path);
        }
        if (componentPositions.getMyPosition() == null) {
            LayoutPositions layoutPositions = this.tryToFindNewNestedGraphPosition(component);
            if (layoutPositions == null) {
                layoutPositions = componentPositions;
            }
            componentPositions = layoutPositions;
        }
        return componentPositions;
    }

    /*
     * WARNING - void declaration
     */
    private final LayoutPositions tryToFindNewNestedGraphPosition(SceneComponent component) {
        LayoutPositions layoutPositions;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        List<String> idPath;
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component.nlComponent");
        NlComponent nlComponent2 = nlComponent;
        if (!NavComponentHelperKt.isNavigation(nlComponent2)) {
            return null;
        }
        List<String> it = idPath = NavComponentHelperKt.getIdPath(nlComponent2);
        boolean bl = false;
        List<String> pathPrefix = it.subList(0, it.size() - 1);
        Point averagePoint = new Point(0, 0, 3, null);
        List<NlComponent> list = nlComponent2.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"nlComponent.children");
        List<NlComponent> children = list;
        if (children.isEmpty()) {
            return null;
        }
        Iterable $this$filter$iv = children;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            NlComponent it2 = (NlComponent)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            if (!NavComponentHelperKt.isDestination(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NlComponent it3 = (NlComponent)element$iv;
            boolean bl3 = false;
            Object object = this.maybeGetPositionsFromPath(CollectionsKt.plus((Collection)pathPrefix, (Object)it3.getId()));
            if (object == null || (object = ((LayoutPositions)object).getMyPosition()) == null) {
                return null;
            }
            Object oldChildPosition = object;
            averagePoint.setX(averagePoint.getX() + ((Point)oldChildPosition).getX() / children.size());
            averagePoint.setY(averagePoint.getY() + ((Point)oldChildPosition).getY() / children.size());
        }
        LayoutPositions it4 = layoutPositions = this.getPositionsFromPath(idPath);
        boolean bl4 = false;
        it4.setMyPosition(averagePoint);
        return layoutPositions;
    }

    /*
     * WARNING - void declaration
     */
    private final LayoutPositions getPositionsFromPath(List<String> pathWithNulls) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pathWithNulls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it;
            if (string2 == null) {
                string2 = "_null";
            }
            collection.add(string2);
        }
        List path = (List)destination$iv$iv;
        LayoutPositions positions = this.getStorage().getState();
        for (String parentId : path) {
            LayoutPositions newPositions = positions.get(parentId);
            if (newPositions == null) {
                newPositions = new LayoutPositions();
                positions.put(parentId, newPositions);
            }
            positions = newPositions;
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private final LayoutPositions maybeGetPositionsFromPath(List<String> pathWithNulls) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pathWithNulls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it;
            if (string2 == null) {
                string2 = "_null";
            }
            collection.add(string2);
        }
        List path = (List)destination$iv$iv;
        LayoutPositions positions = this.getStorage().getState();
        for (String parentId : path) {
            if (positions.get(parentId) != null) continue;
            return null;
        }
        return positions;
    }

    @Override
    public void restorePositionData(@NotNull List<String> path, @NotNull Object position) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position instanceof LayoutPositions)) {
            return;
        }
        LayoutPositions existing = this.getPositionsFromPath(path);
        existing.setMyPosition(((LayoutPositions)position).getMyPosition());
        existing.setMyPositions(((LayoutPositions)position).getMyPositions());
    }

    @Override
    @NotNull
    public LayoutPositions getPositionData(@NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this.getPositions(component);
    }

    private final void rectifyIds(Collection<? extends NlComponent> components, LayoutPositions layoutPositions) {
        Set seenComponents = new LinkedHashSet();
        for (NlComponent nlComponent : components) {
            String string;
            LayoutPositions cachedPositions;
            LayoutPositions layoutPositions2 = this.getPosition(nlComponent.getTag());
            if (layoutPositions2 == null) {
                layoutPositions2 = cachedPositions = new LayoutPositions();
            }
            if (NavComponentHelperKt.isInclude(nlComponent)) {
                String string2 = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
                if (string2 != null) {
                    String string3 = string2.substring(12);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string = null;
                }
            } else {
                string = nlComponent.getId();
            }
            String id2 = string;
            LayoutPositions persistedPositions = layoutPositions.get(id2);
            if (!Intrinsics.areEqual((Object)cachedPositions, (Object)persistedPositions)) {
                String origId;
                Object v4;
                Map<String, LayoutPositions> idMap;
                block11: {
                    idMap = layoutPositions.getMyPositions();
                    Iterable iterable = idMap.entrySet();
                    for (Object t : iterable) {
                        Map.Entry it = (Map.Entry)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getValue(), (Object)cachedPositions)) continue;
                        v4 = t;
                        break block11;
                    }
                    v4 = null;
                }
                Map.Entry entry = v4;
                String string4 = origId = entry != null ? (String)entry.getKey() : null;
                if (origId != null) {
                    idMap.remove(origId);
                }
                if (id2 != null) {
                    idMap.put(id2, cachedPositions);
                }
            }
            if (id2 != null) {
                seenComponents.add(id2);
            }
            List<NlComponent> list = nlComponent.getChildren();
            Intrinsics.checkNotNullExpressionValue(list, (String)"component.children");
            this.rectifyIds((Collection<? extends NlComponent>)list, cachedPositions);
        }
        layoutPositions.getMyPositions().keySet().retainAll(seenComponents);
    }

    private final LayoutPositions getPosition(XmlTag tag) {
        LayoutPositions layoutPositions;
        XmlTag xmlTag = tag;
        if (xmlTag != null) {
            XmlTag it = xmlTag;
            boolean bl = false;
            layoutPositions = (LayoutPositions)this.tagPositionMap.get((Object)SmartPointerManager.createPointer((PsiElement)((PsiElement)it)));
        } else {
            layoutPositions = null;
        }
        return layoutPositions;
    }

    private final void setPosition(XmlTag tag, LayoutPositions positions) {
        block0: {
            XmlTag xmlTag = tag;
            if (xmlTag == null) break block0;
            XmlTag it = xmlTag;
            boolean bl = false;
            ((Map)this.tagPositionMap).put(SmartPointerManager.createPointer((PsiElement)((PsiElement)it)), positions);
        }
    }

    @Override
    public boolean canSave() {
        return true;
    }

    public static final /* synthetic */ LayoutPositions access$getPositionsFromPath(ManualLayoutAlgorithm $this, List pathWithNulls) {
        return $this.getPositionsFromPath(pathWithNulls);
    }

    public static final /* synthetic */ BiMap access$getTagPositionMap$p(ManualLayoutAlgorithm $this) {
        return $this.tagPositionMap;
    }

    public static final /* synthetic */ NavSceneManager access$getSceneManager$p(ManualLayoutAlgorithm $this) {
        return $this.sceneManager;
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0086\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0000R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00000\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "", "()V", "myPosition", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;", "getMyPosition", "()Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;", "setMyPosition", "(Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;)V", "myPositions", "", "", "getMyPositions", "()Ljava/util/Map;", "setMyPositions", "(Ljava/util/Map;)V", "get", "id", "put", "", "sub", "intellij.android.nav.editor"})
    public static final class LayoutPositions {
        @NotNull
        private Map<String, LayoutPositions> myPositions = new LinkedHashMap();
        @Nullable
        private Point myPosition;

        @NotNull
        public final Map<String, LayoutPositions> getMyPositions() {
            return this.myPositions;
        }

        public final void setMyPositions(@NotNull Map<String, LayoutPositions> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.myPositions = map2;
        }

        @Nullable
        public final Point getMyPosition() {
            return this.myPosition;
        }

        public final void setMyPosition(@Nullable Point point) {
            this.myPosition = point;
        }

        @Nullable
        public final LayoutPositions get(@Nullable String id2) {
            return this.myPositions.get(id2);
        }

        public final void put(@NotNull String id2, @NotNull LayoutPositions sub) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
            this.myPositions.put(id2, sub);
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;", "", "x", "", "y", "(II)V", "getX", "()I", "setX", "(I)V", "getY", "setY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.nav.editor"})
    public static final class Point {
        private int x;
        private int y;

        @JvmOverloads
        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public /* synthetic */ Point(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        @NotNull
        public final Point copy(int x, int y) {
            return new Point(x, y);
        }

        public static /* synthetic */ Point copy$default(Point point, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = point.x;
            }
            if ((n3 & 2) != 0) {
                n2 = point.y;
            }
            return point.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Point(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Point)) {
                return false;
            }
            Point point = (Point)other;
            if (this.x != point.x) {
                return false;
            }
            return this.y == point.y;
        }

        @JvmOverloads
        public Point(int x) {
            this(x, 0, 2, null);
        }

        @JvmOverloads
        public Point() {
            this(0, 0, 3, null);
        }
    }

    @State(name="navEditor-manualLayoutAlgorithm2", storages={@com.intellij.openapi.components.Storage(value="navEditor.xml")})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R&\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0003\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "()V", "rootPositions", "getRootPositions$intellij_android_nav_editor$annotations", "getRootPositions$intellij_android_nav_editor", "()Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "setRootPositions$intellij_android_nav_editor", "(Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;)V", "getState", "loadState", "", "state", "intellij.android.nav.editor"})
    private static final class Storage
    implements PersistentStateComponent<LayoutPositions> {
        @Nullable
        private LayoutPositions rootPositions;

        @Nullable
        public final LayoutPositions getRootPositions$intellij_android_nav_editor() {
            return this.rootPositions;
        }

        public final void setRootPositions$intellij_android_nav_editor(@Nullable LayoutPositions layoutPositions) {
            this.rootPositions = layoutPositions;
        }

        @VisibleForTesting
        public static /* synthetic */ void getRootPositions$intellij_android_nav_editor$annotations() {
        }

        @NotNull
        public LayoutPositions getState() {
            LayoutPositions result = this.rootPositions;
            if (result == null) {
                this.rootPositions = result = new LayoutPositions();
            }
            return result;
        }

        public void loadState(@NotNull LayoutPositions state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.rootPositions = state;
        }
    }
}

