/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.model;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.analytics.NavLogEvent;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import icons.StudioIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0016R/\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/naveditor/model/NavComponentMixin;", "Lcom/android/tools/idea/common/model/NlComponent$XmlModelComponentMixin;", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "(Lcom/android/tools/idea/common/model/NlComponent;)V", "includeAttrs", "Lcom/google/common/collect/Table;", "", "getIncludeAttrs", "()Lcom/google/common/collect/Table;", "includeAttrs$delegate", "Lkotlin/Lazy;", "beforeMove", "", "insertType", "Lcom/android/tools/idea/common/api/InsertType;", "receiver", "ids", "", "getAttribute", "namespace", "attribute", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "maybeHandleDeletion", "", "children", "", "intellij.android.nav.editor"})
@SourceDebugExtension(value={"SMAP\nNavComponentHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavComponentHelper.kt\ncom/android/tools/idea/naveditor/model/NavComponentMixin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,608:1\n1851#2,2:609\n1743#2,3:611\n*S KotlinDebug\n*F\n+ 1 NavComponentHelper.kt\ncom/android/tools/idea/naveditor/model/NavComponentMixin\n*L\n545#1:609,2\n580#1:611,3\n*E\n"})
public final class NavComponentMixin
extends NlComponent.XmlModelComponentMixin {
    @NotNull
    private final Lazy includeAttrs$delegate;

    public NavComponentMixin(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(component);
        this.includeAttrs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Table<String, String, String>>(component){
            final /* synthetic */ NlComponent $component;
            {
                this.$component = $component;
                super(0);
            }

            @Nullable
            public final Table<String, String, String> invoke() {
                Table result;
                block2: {
                    XmlFile xmlFile = NavComponentHelperKt.getIncludeFile(this.$component);
                    if (xmlFile == null) {
                        return null;
                    }
                    XmlFile xmlFile2 = xmlFile;
                    HashBasedTable hashBasedTable = HashBasedTable.create();
                    Intrinsics.checkNotNullExpressionValue((Object)hashBasedTable, (String)"create()");
                    result = (Table)hashBasedTable;
                    XmlAttribute[] xmlAttributeArray = xmlFile2.getRootTag();
                    if (xmlAttributeArray == null || (xmlAttributeArray = xmlAttributeArray.getAttributes()) == null) break block2;
                    XmlAttribute[] $this$forEach$iv = xmlAttributeArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String value2;
                        XmlAttribute element$iv;
                        XmlAttribute it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        if (it.getValue() == null) continue;
                        boolean bl2 = false;
                        result.put((Object)it.getNamespace(), (Object)it.getLocalName(), (Object)value2);
                    }
                }
                return result;
            }
        }));
    }

    public boolean maybeHandleDeletion(@NotNull Collection<? extends NlComponent> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NlComponent it = (NlComponent)element$iv;
            boolean bl = false;
            NavUsageTracker tracker2 = NavUsageTracker.Companion.getInstance(it.getModel());
            NavLogEvent navLogEvent = NavComponentHelperKt.isAction(it) ? tracker2.createEvent(NavEditorEvent.NavEditorEventType.DELETE_ACTION).withActionInfo(it) : (NavComponentHelperKt.isInclude(it) ? tracker2.createEvent(NavEditorEvent.NavEditorEventType.DELETE_INCLUDE) : (NavComponentHelperKt.isNavigation(it) ? tracker2.createEvent(NavEditorEvent.NavEditorEventType.DELETE_NESTED) : (NavComponentHelperKt.isDestination(it) ? tracker2.createEvent(NavEditorEvent.NavEditorEventType.DELETE_DESTINATION).withDestinationInfo(it) : (Intrinsics.areEqual((Object)it.getTagName(), (Object)"deepLink") ? tracker2.createEvent(NavEditorEvent.NavEditorEventType.DELETE_DEEPLINK) : (Intrinsics.areEqual((Object)it.getTagName(), (Object)"argument") ? tracker2.createEvent(NavEditorEvent.NavEditorEventType.DELETE_ARGUMENT) : null)))));
            if (navLogEvent == null) continue;
            navLogEvent.log();
        }
        return false;
    }

    private final Table<String, String, String> getIncludeAttrs() {
        Lazy lazy = this.includeAttrs$delegate;
        return (Table)lazy.getValue();
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        NlComponent nlComponent = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component");
        if (NavComponentHelperKt.isInclude(nlComponent)) {
            if (Intrinsics.areEqual((Object)attribute, (Object)"graph")) {
                return null;
            }
            Table<String, String, String> table = this.getIncludeAttrs();
            return table != null ? (String)table.get((Object)namespace, (Object)attribute) : null;
        }
        return null;
    }

    @Override
    public void beforeMove(@NotNull InsertType insertType, @NotNull NlComponent receiver, @NotNull Set<String> ids) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)insertType), (String)"insertType");
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            List<NlComponent> list = receiver.getChildren();
            Intrinsics.checkNotNullExpressionValue(list, (String)"receiver.children");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NlComponent it = (NlComponent)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.getComponent().getId())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.getComponent().incrementId(ids);
        }
    }

    @Override
    @Nullable
    public String getTooltipText() {
        NlComponent nlComponent = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component");
        return NavComponentHelperKt.isAction(nlComponent) ? this.getComponent().getId() : null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon2;
        NlComponent nlComponent = this.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"component");
        if (NavComponentHelperKt.isInclude(nlComponent)) {
            Icon icon3 = StudioIcons.NavEditor.Tree.INCLUDE_GRAPH;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"INCLUDE_GRAPH");
        } else {
            NlComponent nlComponent2 = this.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"component");
            if (NavComponentHelperKt.isNavigation(nlComponent2)) {
                Icon icon4 = StudioIcons.NavEditor.Tree.NESTED_GRAPH;
                icon2 = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"NESTED_GRAPH");
            } else {
                NlComponent nlComponent3 = this.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)nlComponent3, (String)"component");
                if (NavComponentHelperKt.isAction(nlComponent3)) {
                    Icon icon5 = StudioIcons.NavEditor.Properties.ACTION;
                    icon2 = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ACTION");
                } else {
                    NlComponent nlComponent4 = this.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)nlComponent4, (String)"component");
                    if (NavComponentHelperKt.getClassName(nlComponent4) == null) {
                        Icon icon6 = StudioIcons.NavEditor.Tree.PLACEHOLDER;
                        icon2 = icon6;
                        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"PLACEHOLDER");
                    } else {
                        NlComponent nlComponent5 = this.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)nlComponent5, (String)"component");
                        if (NavComponentHelperKt.isActivity(nlComponent5)) {
                            Icon icon7 = StudioIcons.NavEditor.Tree.ACTIVITY;
                            icon2 = icon7;
                            Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"ACTIVITY");
                        } else {
                            Icon icon8 = StudioIcons.NavEditor.Tree.FRAGMENT;
                            icon2 = icon8;
                            Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"FRAGMENT");
                        }
                    }
                }
            }
        }
        return icon2;
    }
}

