/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import com.android.tools.idea.compose.preview.animation.InspectorColors;
import com.android.tools.idea.compose.preview.animation.InspectorLayout;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import javax.swing.JSlider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter;", "", "()V", "Diamond", "Slider", "Thumb", "intellij.android.compose-designer"})
public final class InspectorPainter {
    @NotNull
    public static final InspectorPainter INSTANCE = new InspectorPainter();

    private InspectorPainter() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Diamond;", "", "x", "", "y", "colorIndex", "(III)V", "diamond", "Ljava/awt/Polygon;", "diamondOutline", "getX", "()I", "getY", "contains", "", "paint", "", "g", "Ljava/awt/Graphics2D;", "hover", "paintOutline", "xArray", "", "size", "yArray", "Companion", "intellij.android.compose-designer"})
    public static final class Diamond {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int x;
        private final int y;
        private final int colorIndex;
        @NotNull
        private final Polygon diamond;
        @NotNull
        private final Polygon diamondOutline;

        public Diamond(int x, int y, int colorIndex) {
            this.x = x;
            this.y = y;
            this.colorIndex = colorIndex;
            this.diamond = new Polygon(this.xArray(Companion.diamondSize()), this.yArray(Companion.diamondSize()), 4);
            this.diamondOutline = new Polygon(this.xArray(Companion.diamondSize() + 1), this.yArray(Companion.diamondSize() + 1), 4);
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        private final int[] xArray(int size) {
            int[] nArray = new int[]{this.x, this.x + size, this.x, this.x - size};
            return nArray;
        }

        private final int[] yArray(int size) {
            int[] nArray = new int[]{this.y - size, this.y, this.y + size, this.y};
            return nArray;
        }

        public final void paint(@NotNull Graphics2D g, boolean hover) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.setColor(hover ? InspectorColors.INSTANCE.getLINE_OUTLINE_COLOR_ACTIVE() : (Color)new JBColor(Color.white, JBColor.border().darker()));
            g.fillPolygon(this.diamondOutline);
            g.setColor((Color)InspectorColors.INSTANCE.getGRAPH_COLORS().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
            g.fillPolygon(this.diamond);
        }

        public final void paintOutline(@NotNull Graphics2D g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.setColor((Color)InspectorColors.INSTANCE.getGRAPH_COLORS().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
            g.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
            g.drawPolygon(this.diamondOutline);
        }

        public final boolean contains(int x, int y) {
            return this.diamondOutline.contains(x, y);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Diamond$Companion;", "", "()V", "diamondSize", "", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            public final int diamondSize() {
                return JBUI.scale((int)6);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Slider;", "", "()V", "MINIMUM_TICK_DISTANCE", "", "TICK_INCREMENTS", "", "[Ljava/lang/Integer;", "getTickIncrement", "slider", "Ljavax/swing/JSlider;", "minimumTickSize", "intellij.android.compose-designer"})
    @SourceDebugExtension(value={"SMAP\nInspectorPainter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorPainter.kt\ncom/android/tools/idea/compose/preview/animation/InspectorPainter$Slider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,191:1\n13543#2,2:192\n*S KotlinDebug\n*F\n+ 1 InspectorPainter.kt\ncom/android/tools/idea/compose/preview/animation/InspectorPainter$Slider\n*L\n85#1:192,2\n*E\n"})
    public static final class Slider {
        @NotNull
        public static final Slider INSTANCE = new Slider();
        private static final int MINIMUM_TICK_DISTANCE = 150;
        @NotNull
        private static final Integer[] TICK_INCREMENTS;

        private Slider() {
        }

        public final int getTickIncrement(@NotNull JSlider slider, int minimumTickSize) {
            Intrinsics.checkNotNullParameter((Object)slider, (String)"slider");
            if (slider.getMaximum() == 0 || slider.getWidth() == 0) {
                return slider.getMaximum();
            }
            int increment = (int)((float)minimumTickSize / (float)slider.getWidth() * (float)(slider.getMaximum() - slider.getMinimum()));
            Integer[] $this$forEach$iv = TICK_INCREMENTS;
            boolean $i$f$forEach = false;
            for (Integer element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (increment < it) continue;
                return increment / (it - 1) * it;
            }
            return 1;
        }

        public static /* synthetic */ int getTickIncrement$default(Slider slider, JSlider jSlider, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 150;
            }
            return slider.getTickIncrement(jSlider, n);
        }

        static {
            Integer[] integerArray = new Integer[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 10000, 1000, 200, 50, 10, 5, 2};
            TICK_INCREMENTS = integerArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Thumb;", "", "()V", "HANDLE_HALF_HEIGHT", "", "HANDLE_HALF_WIDTH", "THUMB_COLOR", "Lcom/intellij/ui/JBColor;", "paintThumbForHorizSlider", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "height", "intellij.android.compose-designer"})
    public static final class Thumb {
        @NotNull
        public static final Thumb INSTANCE = new Thumb();
        @NotNull
        private static final JBColor THUMB_COLOR = new JBColor(4882943, 11851775);
        private static final int HANDLE_HALF_WIDTH = 5;
        private static final int HANDLE_HALF_HEIGHT = 5;

        private Thumb() {
        }

        public final void paintThumbForHorizSlider(@NotNull Graphics2D g, int x, int y, int height2) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.setColor((Color)THUMB_COLOR);
            g.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
            g.drawLine(x, y, x, y + height2);
            int handleHeight = 10;
            int[] nArray = new int[]{x, x - 5, x - 5, x + 5, x + 5};
            int[] xPoints = nArray;
            int[] nArray2 = new int[]{y, y - 5, y - handleHeight, y - handleHeight, y - 5};
            int[] yPoints = nArray2;
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
    }
}

