/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.analytics;

import com.google.common.hash.Hashing;
import com.google.wireless.android.sdk.stats.ComposeMultiPreviewEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0006\u0010\u0015\u001a\u00020\u0010J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\u001e\u0010\u0018\u001a\u00020\u00002\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0013R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/compose/preview/analytics/MultiPreviewNodeInfo;", "", "type", "Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo$NodeType;", "(Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo$NodeType;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "nodeInfoBuilder", "Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo$Builder;", "kotlin.jvm.PlatformType", "build", "Lcom/google/wireless/android/sdk/stats/ComposeMultiPreviewEvent$ComposeMultiPreviewNodeInfo;", "clearCounters", "", "equals", "", "other", "hashCode", "", "isMultiPreviewType", "isPreviewType", "isRootComposableType", "isUseless", "withChildNodes", "multiPreviewChildNodes", "", "previewChildrenCount", "withComposableFqn", "composableFqn", "", "withDepthLevel", "depthLevel", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nMultiPreviewUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPreviewUsageTracker.kt\ncom/android/tools/idea/compose/preview/analytics/MultiPreviewNodeInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n766#2:229\n857#2,2:230\n1851#2,2:232\n*S KotlinDebug\n*F\n+ 1 MultiPreviewUsageTracker.kt\ncom/android/tools/idea/compose/preview/analytics/MultiPreviewNodeInfo\n*L\n176#1:229\n176#1:230,2\n182#1:232,2\n*E\n"})
public final class MultiPreviewNodeInfo {
    @NotNull
    private final Logger LOG;
    private final ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.Builder nodeInfoBuilder;

    public MultiPreviewNodeInfo(@NotNull ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Logger logger2 = Logger.getInstance(MultiPreviewNodeInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(MultiPreviewNodeInfo::class.java)");
        this.LOG = logger2;
        this.nodeInfoBuilder = ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.newBuilder().setNodeType(type);
    }

    public final boolean isUseless() {
        return this.nodeInfoBuilder.getSubtreePreviewsCount() == 0;
    }

    public final boolean isPreviewType() {
        return this.nodeInfoBuilder.getNodeType() == ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType.PREVIEW_NODE;
    }

    private final boolean isMultiPreviewType() {
        return this.nodeInfoBuilder.getNodeType() == ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType.MULTIPREVIEW_NODE;
    }

    private final boolean isRootComposableType() {
        return this.nodeInfoBuilder.getNodeType() == ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.NodeType.ROOT_COMPOSABLE_FUNCTION_NODE;
    }

    private final void clearCounters() {
        this.nodeInfoBuilder.clearPreviewChildsCount();
        this.nodeInfoBuilder.clearMultiPreviewChildsCount();
        this.nodeInfoBuilder.clearSubtreePreviewsCount();
        this.nodeInfoBuilder.clearSubtreeMultiPreviewsCount();
        this.nodeInfoBuilder.clearSubtreeUselessNodesCount();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiPreviewNodeInfo withChildNodes(@NotNull Collection<MultiPreviewNodeInfo> multiPreviewChildNodes, int previewChildrenCount) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(multiPreviewChildNodes, (String)"multiPreviewChildNodes");
        if (!this.isMultiPreviewType() && !this.isRootComposableType()) {
            this.LOG.error("Nodes of a type different that MultiPreview and RootComposable shouldn't have child nodes");
            return this;
        }
        this.clearCounters();
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)multiPreviewChildNodes);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MultiPreviewNodeInfo it = (MultiPreviewNodeInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isMultiPreviewType()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List childNodes = (List)destination$iv$iv;
        this.nodeInfoBuilder.setPreviewChildsCount(previewChildrenCount);
        this.nodeInfoBuilder.setSubtreePreviewsCount(previewChildrenCount);
        Iterable $this$forEach$iv = childNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo.Builder builder2;
            MultiPreviewNodeInfo it = (MultiPreviewNodeInfo)element$iv;
            boolean bl = false;
            if (!it.isUseless()) {
                builder2 = this.nodeInfoBuilder;
                int n = builder2.getMultiPreviewChildsCount();
                builder2.setMultiPreviewChildsCount(n + 1);
            }
            builder2 = this.nodeInfoBuilder;
            builder2.setSubtreePreviewsCount(builder2.getSubtreePreviewsCount() + it.nodeInfoBuilder.getSubtreePreviewsCount());
            builder2 = this.nodeInfoBuilder;
            builder2.setSubtreeMultiPreviewsCount(builder2.getSubtreeMultiPreviewsCount() + it.nodeInfoBuilder.getSubtreeMultiPreviewsCount());
            builder2 = this.nodeInfoBuilder;
            builder2.setSubtreeUselessNodesCount(builder2.getSubtreeUselessNodesCount() + it.nodeInfoBuilder.getSubtreeUselessNodesCount());
        }
        if (this.isMultiPreviewType()) {
            if (this.isUseless()) {
                var4_3 = this.nodeInfoBuilder;
                var5_4 = var4_3.getSubtreeUselessNodesCount();
                var4_3.setSubtreeUselessNodesCount(var5_4 + 1);
            } else {
                var4_3 = this.nodeInfoBuilder;
                var5_4 = var4_3.getSubtreeMultiPreviewsCount();
                var4_3.setSubtreeMultiPreviewsCount(var5_4 + 1);
            }
        }
        return this;
    }

    @NotNull
    public final MultiPreviewNodeInfo withDepthLevel(int depthLevel) {
        this.nodeInfoBuilder.setDepthLevel(depthLevel);
        return this;
    }

    @NotNull
    public final MultiPreviewNodeInfo withComposableFqn(@NotNull String composableFqn) {
        Intrinsics.checkNotNullParameter((Object)composableFqn, (String)"composableFqn");
        this.nodeInfoBuilder.setAnonymizedComposableId(Hashing.farmHashFingerprint64().newHasher().putString((CharSequence)composableFqn, Charsets.UTF_8).hash().asLong());
        return this;
    }

    @NotNull
    public final ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo build() {
        ComposeMultiPreviewEvent.ComposeMultiPreviewNodeInfo composeMultiPreviewNodeInfo = this.nodeInfoBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)composeMultiPreviewNodeInfo, (String)"nodeInfoBuilder.build()");
        return composeMultiPreviewNodeInfo;
    }

    public int hashCode() {
        return this.nodeInfoBuilder.build().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultiPreviewNodeInfo && Intrinsics.areEqual(this.getClass(), other.getClass()) && Intrinsics.areEqual((Object)this.nodeInfoBuilder.build(), (Object)((MultiPreviewNodeInfo)other).nodeInfoBuilder.build());
    }
}

