/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.actions;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfoKt;
import com.android.tools.idea.compose.preview.ComposeViewInfoParserKt;
import com.android.tools.idea.compose.preview.SourceLocation;
import com.android.tools.idea.compose.preview.actions.ZoomToSelectionAction;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/compose/preview/actions/ZoomToSelectionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "surface", "Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "title", "", "(Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;Lcom/android/tools/idea/common/surface/SceneView;Ljava/lang/String;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "x", "", "getX$annotations", "()V", "y", "getY$annotations", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nZoomToSelectionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZoomToSelectionAction.kt\ncom/android/tools/idea/compose/preview/actions/ZoomToSelectionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class ZoomToSelectionAction
extends AnAction {
    @NotNull
    private final NlDesignSurface surface;
    @NotNull
    private final SceneView sceneView;
    @NotNull
    private final Logger logger;
    private final int x;
    private final int y;

    public ZoomToSelectionAction(@NotNull NlDesignSurface surface2, @NotNull SceneView sceneView, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(title);
        this.surface = surface2;
        this.sceneView = sceneView;
        Logger logger2 = Logger.getInstance(ZoomToSelectionAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(ZoomToSelectionAction::class.java)");
        this.logger = logger2;
        Point mousePosition = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(mousePosition, this.surface.getInteractionPane());
        this.x = Coordinates.getAndroidX(this.sceneView, mousePosition.x);
        this.y = Coordinates.getAndroidY(this.sceneView, mousePosition.y);
    }

    public /* synthetic */ ZoomToSelectionAction(NlDesignSurface nlDesignSurface, SceneView sceneView, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = ComposePreviewBundle.message("action.zoom.to.selection", new Object[0]);
        }
        this(nlDesignSurface, sceneView, string);
    }

    private static /* synthetic */ void getX$annotations() {
    }

    private static /* synthetic */ void getY$annotations() {
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SceneManager sceneManager = this.sceneView.getSceneManager();
        LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
        e.getPresentation().setEnabledAndVisible((layoutlibSceneManager != null ? layoutlibSceneManager.getRenderResult() : null) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        var3_2 = this.sceneView.getScene().getRoot();
        if (var3_2 == null || (var4_3 = var3_2.getNlComponent()) == null || (var5_4 = NlComponentHelperKt.getViewInfo(var4_3)) == null) ** GOTO lbl-1000
        viewInfo = var5_4;
        $i$a$-let-ZoomToSelectionAction$actionPerformed$deepestViewInfos$1 = false;
        var6_7 = ComposeViewInfoParserKt.parseViewInfo(viewInfo, (Function1<? super SourceLocation, ? extends SourceLocation>)((Function1)actionPerformed.deepestViewInfos.1.1.INSTANCE), this.logger);
        if (var6_7 != null) {
            v0 = ComposeViewInfoKt.findDeepestHits(var6_7, this.x, this.y);
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        deepestViewInfos = v0;
        var3_2 = deepestViewInfos;
        if (var3_2 == null || var3_2.isEmpty() != false) {
            this.logger.info("Could not find the view to zoom to, zooming to the whole Preview.");
            this.surface.zoomAndCenter(this.sceneView, new Rectangle(new Point(0, 0), this.sceneView.getScaledContentSize()));
            return;
        }
        if (deepestViewInfos.size() > 1) {
            this.logger.warn("Expected 1 view to zoom to, but found " + deepestViewInfos.size() + ", choosing the last one.");
        }
        composeViewInfo = (ComposeViewInfo)CollectionsKt.last((Iterable)deepestViewInfos);
        it = composeViewInfo.getBounds();
        $i$a$-let-ZoomToSelectionAction$actionPerformed$1 = false;
        topLeftCorner = new Point(Coordinates.getSwingDimension(this.sceneView, it.getLeft()), Coordinates.getSwingDimension(this.sceneView, it.getTop()));
        size = new Dimension(Coordinates.getSwingDimension(this.sceneView, it.getWidth()), Coordinates.getSwingDimension(this.sceneView, it.getHeight()));
        this.surface.zoomAndCenter(this.sceneView, new Rectangle(topLeftCorner, size));
    }
}

