/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.ComposePreviewManager;
import com.android.tools.idea.compose.preview.ComposePreviewRepresentationProviderKt;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfoKt;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BQ\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012$\u0010\t\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/compose/preview/ComposePreviewInspector;", "", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "composeViewInfoProvider", "Lkotlin/Function1;", "Lcom/android/tools/idea/common/surface/SceneView;", "", "Lcom/android/tools/idea/compose/preview/ComposeViewInfo;", "onInspected", "Lkotlin/Function3;", "", "", "(Lcom/android/tools/idea/common/surface/DesignSurface;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function3;)V", "currentTooltipPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "currentViewInfo", "findComposeViewInfo", "x", "y", "inspect", "intellij.android.compose-designer"})
public final class ComposePreviewInspector {
    @NotNull
    private final DesignSurface<?> surface;
    @NotNull
    private final Function1<SceneView, List<ComposeViewInfo>> composeViewInfoProvider;
    @NotNull
    private final Function3<List<ComposeViewInfo>, Integer, Integer, Unit> onInspected;
    @Nullable
    private ComposeViewInfo currentViewInfo;
    @Nullable
    private JBPopup currentTooltipPopup;

    public ComposePreviewInspector(@NotNull DesignSurface<?> surface2, @NotNull Function1<? super SceneView, ? extends List<ComposeViewInfo>> composeViewInfoProvider, @NotNull Function3<? super List<ComposeViewInfo>, ? super Integer, ? super Integer, Unit> onInspected) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter(composeViewInfoProvider, (String)"composeViewInfoProvider");
        Intrinsics.checkNotNullParameter(onInspected, (String)"onInspected");
        this.surface = surface2;
        this.composeViewInfoProvider = composeViewInfoProvider;
        this.onInspected = onInspected;
    }

    public final void inspect(int x, int y) {
        boolean inspectionEnabled;
        ComposePreviewManager composePreviewManager = (ComposePreviewManager)ComposePreviewRepresentationProviderKt.getCOMPOSE_PREVIEW_MANAGER().getData((DataProvider)this.surface);
        boolean bl = inspectionEnabled = composePreviewManager != null ? composePreviewManager.isInspectionTooltipEnabled() : false;
        if (!inspectionEnabled) {
            this.currentViewInfo = null;
            JBPopup jBPopup = this.currentTooltipPopup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            this.currentTooltipPopup = null;
            return;
        }
        List<ComposeViewInfo> viewInfo = this.findComposeViewInfo(x, y);
        this.onInspected.invoke(viewInfo, (Object)x, (Object)y);
    }

    private final List<ComposeViewInfo> findComposeViewInfo(int x, int y) {
        SceneView sceneView = this.surface.getSceneViewAt(x, y);
        if (sceneView == null) {
            return CollectionsKt.emptyList();
        }
        SceneView sceneView2 = sceneView;
        int xPx = Coordinates.getAndroidX(sceneView2, x);
        int yPx = Coordinates.getAndroidY(sceneView2, y);
        for (ComposeViewInfo composeViewInfo : (List)this.composeViewInfoProvider.invoke((Object)sceneView2)) {
            Collection<ComposeViewInfo> hits = ComposeViewInfoKt.findDeepestHits(composeViewInfo, xPx, yPx);
            if (!(!hits.isEmpty())) continue;
            return CollectionsKt.toList((Iterable)hits);
        }
        return CollectionsKt.emptyList();
    }
}

