/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.preview.property;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.compose.pickers.preview.property.AndroidDimension;
import com.android.tools.idea.compose.pickers.preview.property.DeviceConfigKt;
import com.android.tools.idea.compose.pickers.preview.property.DimUnit;
import com.android.tools.idea.compose.pickers.preview.property.MutableDeviceConfig;
import com.android.tools.idea.compose.pickers.preview.property.Orientation;
import com.android.tools.idea.compose.pickers.preview.property.Shape;
import com.android.tools.idea.compose.pickers.preview.utils.DeviceUtilsKt;
import com.android.tools.idea.compose.preview.Preview;
import com.android.tools.idea.compose.preview.util.device.DeviceSpecDimensionUtilKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.utils.HashCodes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 22\u00020\u0001:\u00012Bc\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010*\u001a\u00020\u0003J\u0013\u0010+\u001a\u00020 2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020\nH\u0016J\u0010\u0010.\u001a\u00020/*\u000600j\u0002`1H\u0002R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013R\u0011\u0010(\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016\u00a8\u00063"}, d2={"Lcom/android/tools/idea/compose/pickers/preview/property/DeviceConfig;", "", "deviceId", "", "width", "", "height", "dimUnit", "Lcom/android/tools/idea/compose/pickers/preview/property/DimUnit;", "dpi", "", "shape", "Lcom/android/tools/idea/compose/pickers/preview/property/Shape;", "chinSize", "orientation", "Lcom/android/tools/idea/compose/pickers/preview/property/Orientation;", "parentDeviceId", "(Ljava/lang/String;FFLcom/android/tools/idea/compose/pickers/preview/property/DimUnit;ILcom/android/tools/idea/compose/pickers/preview/property/Shape;FLcom/android/tools/idea/compose/pickers/preview/property/Orientation;Ljava/lang/String;)V", "getChinSize", "()F", "chinSizeString", "getChinSizeString", "()Ljava/lang/String;", "getDeviceId", "getDimUnit", "()Lcom/android/tools/idea/compose/pickers/preview/property/DimUnit;", "getDpi", "()I", "getHeight", "heightString", "getHeightString", "isRound", "", "()Z", "getOrientation", "()Lcom/android/tools/idea/compose/pickers/preview/property/Orientation;", "getParentDeviceId", "getShape", "()Lcom/android/tools/idea/compose/pickers/preview/property/Shape;", "getWidth", "widthString", "getWidthString", "deviceSpec", "equals", "other", "hashCode", "addOrientationIfNeeded", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "intellij.android.compose-designer"})
public class DeviceConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String deviceId;
    private final float width;
    private final float height;
    @NotNull
    private final DimUnit dimUnit;
    private final int dpi;
    @NotNull
    private final Shape shape;
    private final float chinSize;
    @NotNull
    private final Orientation orientation;
    @Nullable
    private final String parentDeviceId;

    public DeviceConfig(@Nullable String deviceId, float width2, float height2, @NotNull DimUnit dimUnit, int dpi2, @NotNull Shape shape2, float chinSize, @NotNull Orientation orientation2, @Nullable String parentDeviceId) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimUnit), (String)"dimUnit");
        Intrinsics.checkNotNullParameter((Object)((Object)shape2), (String)"shape");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation2), (String)"orientation");
        this.deviceId = deviceId;
        this.width = width2;
        this.height = height2;
        this.dimUnit = dimUnit;
        this.dpi = dpi2;
        this.shape = shape2;
        this.chinSize = chinSize;
        this.orientation = orientation2;
        this.parentDeviceId = parentDeviceId;
    }

    public /* synthetic */ DeviceConfig(String string, float f, float f2, DimUnit dimUnit, int n, Shape shape2, float f3, Orientation orientation2, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            f = Preview.DeviceSpec.INSTANCE.getDEFAULT_WIDTH_DP$intellij_android_compose_designer();
        }
        if ((n2 & 4) != 0) {
            f2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_HEIGHT_DP$intellij_android_compose_designer();
        }
        if ((n2 & 8) != 0) {
            dimUnit = Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT$intellij_android_compose_designer();
        }
        if ((n2 & 0x10) != 0) {
            n = Preview.DeviceSpec.INSTANCE.getDEFAULT_DPI$intellij_android_compose_designer();
        }
        if ((n2 & 0x20) != 0) {
            shape2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_SHAPE$intellij_android_compose_designer();
        }
        if ((n2 & 0x40) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 0x80) != 0) {
            orientation2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_ORIENTATION$intellij_android_compose_designer();
        }
        if ((n2 & 0x100) != 0) {
            string2 = null;
        }
        this(string, f, f2, dimUnit, n, shape2, f3, orientation2, string2);
    }

    @Nullable
    public final String getDeviceId() {
        return this.deviceId;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @NotNull
    public DimUnit getDimUnit() {
        return this.dimUnit;
    }

    public int getDpi() {
        return this.dpi;
    }

    @NotNull
    public Shape getShape() {
        return this.shape;
    }

    public float getChinSize() {
        return this.chinSize;
    }

    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Nullable
    public String getParentDeviceId() {
        return this.parentDeviceId;
    }

    @NotNull
    public final String getWidthString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getWidth()).toString();
    }

    @NotNull
    public final String getHeightString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getHeight()).toString();
    }

    @NotNull
    public final String getChinSizeString() {
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(this.getChinSize()).toString();
    }

    public boolean isRound() {
        return this.getShape() == Shape.Round || this.getShape() == Shape.Chin;
    }

    @NotNull
    public final String deviceSpec() {
        StringBuilder builder2 = new StringBuilder("spec:");
        if (!((Boolean)StudioFlags.COMPOSE_PREVIEW_DEVICESPEC_INJECTOR.get()).booleanValue()) {
            float resolvedWidth = this.getWidth();
            float resolvedHeight = this.getHeight();
            if (this.getOrientation() == Orientation.portrait && this.getWidth() > this.getHeight() || this.getOrientation() == Orientation.landscape && this.getHeight() > this.getWidth()) {
                resolvedWidth = this.getHeight();
                resolvedHeight = this.getWidth();
            }
            DeviceConfigKt.access$appendParamValue(builder2, "shape", this.getShape().name());
            DeviceConfigKt.access$appendSeparator(builder2);
            DeviceConfigKt.access$appendParamValue(builder2, "width", String.valueOf(MathKt.roundToInt((float)resolvedWidth)));
            DeviceConfigKt.access$appendSeparator(builder2);
            DeviceConfigKt.access$appendParamValue(builder2, "height", String.valueOf(MathKt.roundToInt((float)resolvedHeight)));
            DeviceConfigKt.access$appendSeparator(builder2);
            DeviceConfigKt.access$appendParamValue(builder2, "unit", this.getDimUnit().name());
            DeviceConfigKt.access$appendSeparator(builder2);
            DeviceConfigKt.access$appendParamValue(builder2, "dpi", String.valueOf(this.getDpi()));
            String string = builder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }
        if (this.getParentDeviceId() != null) {
            DeviceConfigKt.access$appendParamValue(builder2, "parent", String.valueOf(this.getParentDeviceId()));
            this.addOrientationIfNeeded(builder2);
            String string = builder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }
        DeviceConfigKt.access$appendParamValue(builder2, "width", this.getWidthString() + this.getDimUnit().name());
        DeviceConfigKt.access$appendSeparator(builder2);
        DeviceConfigKt.access$appendParamValue(builder2, "height", this.getHeightString() + this.getDimUnit().name());
        if (this.getDpi() != Preview.DeviceSpec.INSTANCE.getDEFAULT_DPI$intellij_android_compose_designer()) {
            DeviceConfigKt.access$appendSeparator(builder2);
            DeviceConfigKt.access$appendParamValue(builder2, "dpi", String.valueOf(this.getDpi()));
        }
        if (this.isRound()) {
            DeviceConfigKt.access$appendSeparator(builder2);
            DeviceConfigKt.access$appendParamValue(builder2, "isRound", String.valueOf(this.isRound()));
            if (MathKt.roundToInt((float)this.getChinSize()) != 0) {
                DeviceConfigKt.access$appendSeparator(builder2);
                DeviceConfigKt.access$appendParamValue(builder2, "chinSize", this.getChinSizeString() + this.getDimUnit().name());
            }
        }
        this.addOrientationIfNeeded(builder2);
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void addOrientationIfNeeded(StringBuilder $this$addOrientationIfNeeded) {
        if (this.getHeight() > this.getWidth() && this.getOrientation() == Orientation.landscape || this.getWidth() > this.getHeight() && this.getOrientation() == Orientation.portrait) {
            DeviceConfigKt.access$appendSeparator($this$addOrientationIfNeeded);
            DeviceConfigKt.access$appendParamValue($this$addOrientationIfNeeded, "orientation", this.getOrientation().name());
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DeviceConfig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.deviceSpec(), (Object)((DeviceConfig)other).deviceSpec());
    }

    public int hashCode() {
        String string = this.getParentDeviceId();
        return HashCodes.mix((int)Float.hashCode(this.getWidth()), (int)Float.hashCode(this.getHeight()), (int)this.getDpi(), (int)this.getShape().hashCode(), (int)this.getDimUnit().hashCode(), (int)Float.hashCode(this.getChinSize()), (int)Boolean.hashCode(this.isRound()), (int)this.getOrientation().hashCode(), (int)(string != null ? string.hashCode() : 0));
    }

    public DeviceConfig() {
        this(null, 0.0f, 0.0f, null, 0, null, 0.0f, null, null, 511, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J&\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J \u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ \u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/compose/pickers/preview/property/DeviceConfig$Companion;", "", "()V", "parseDeviceSpecLanguage", "Lcom/android/tools/idea/compose/pickers/preview/property/DeviceConfig;", "params", "", "", "availableDevices", "", "Lcom/android/sdklib/devices/Device;", "parseFromCustomDeviceSpecLanguage", "parseFromExistingDeviceWithDeviceSpecLanguage", "device", "toDeviceConfigOrNull", "serialized", "toMutableDeviceConfigOrNull", "Lcom/android/tools/idea/compose/pickers/preview/property/MutableDeviceConfig;", "intellij.android.compose-designer"})
    @SourceDebugExtension(value={"SMAP\nDeviceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/idea/compose/pickers/preview/property/DeviceConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EnumUtils.kt\ncom/android/tools/idea/kotlin/EnumUtilsKt\n*L\n1#1,558:1\n1#2:559\n766#3:560\n857#3,2:561\n1179#3,2:563\n1253#3,4:565\n288#3,2:579\n27#4,5:569\n27#4,5:574\n27#4,5:581\n27#4,5:586\n*S KotlinDebug\n*F\n+ 1 DeviceConfig.kt\ncom/android/tools/idea/compose/pickers/preview/property/DeviceConfig$Companion\n*L\n260#1:560\n260#1:561,2\n261#1:563,2\n261#1:565,4\n327#1:579,2\n280#1:569,5\n284#1:574,5\n342#1:581,5\n398#1:586,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final MutableDeviceConfig toMutableDeviceConfigOrNull(@Nullable String serialized, @NotNull Collection<Device> availableDevices) {
            Intrinsics.checkNotNullParameter(availableDevices, (String)"availableDevices");
            DeviceConfig deviceConfig = this.toDeviceConfigOrNull(serialized, availableDevices);
            return deviceConfig != null ? DeviceConfigKt.toMutableConfig(deviceConfig) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DeviceConfig toDeviceConfigOrNull(@Nullable String serialized, @NotNull Collection<Device> availableDevices) {
            int n;
            Enum enum_;
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object;
            String referenceDeviceId;
            String configString;
            block21: {
                block20: {
                    Intrinsics.checkNotNullParameter(availableDevices, (String)"availableDevices");
                    if (serialized == null || !StringsKt.startsWith$default((String)serialized, (String)"spec:", (boolean)false, (int)2, null)) {
                        return null;
                    }
                    configString = StringsKt.substringAfter$default((String)serialized, (String)"spec:", null, (int)2, null);
                    referenceDeviceId = (String)DeviceConfigKt.access$getReferenceDeviceIds$p().get(serialized);
                    object = referenceDeviceId;
                    if (object == null) break block20;
                    String it = object;
                    boolean bl = false;
                    Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)it));
                    object = map2;
                    if (map2 != null) break block21;
                }
                object = MapsKt.emptyMap();
            }
            Object deviceIdMap = object;
            Object object2 = new char[]{','};
            object2 = StringsKt.split$default((CharSequence)configString, (char[])object2, (boolean)false, (int)0, (int)6, null);
            Object object3 = deviceIdMap;
            boolean $i$f$filter = false;
            void bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(it.length() >= 3 && StringsKt.contains$default((CharSequence)it, (char)'=', (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map bl2 = destination$iv$iv2;
                String paramString = (String)element$iv$iv;
                boolean bl3 = false;
                Pair pair = new Pair((Object)((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)paramString, (char)'=', null, (int)2, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)paramString, (char)'=', null, (int)2, null))).toString());
                bl2.put(pair.getFirst(), pair.getSecond());
            }
            Map paramsMap = MapsKt.plus((Map)object3, (Map)destination$iv$iv2);
            if (!paramsMap.containsKey("shape")) {
                Object object4 = StudioFlags.COMPOSE_PREVIEW_DEVICESPEC_INJECTOR.get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"COMPOSE_PREVIEW_DEVICESPEC_INJECTOR.get()");
                if (((Boolean)object4).booleanValue()) {
                    return this.parseDeviceSpecLanguage(paramsMap, availableDevices);
                }
            }
            String value$iv = paramsMap.getOrDefault("shape", "");
            boolean $i$f$enumValueOfOrNull = false;
            try {
                destination$iv$iv2 = Shape.valueOf(value$iv);
            }
            catch (Exception _$iv) {
                destination$iv$iv2 = null;
            }
            Shape shape2 = (Shape)((Object)destination$iv$iv2);
            if (shape2 == null) {
                return null;
            }
            Shape shape3 = shape2;
            Integer n2 = StringsKt.toIntOrNull((String)paramsMap.getOrDefault("width", ""));
            if (n2 == null) {
                return null;
            }
            int width2 = n2;
            Integer n3 = StringsKt.toIntOrNull((String)paramsMap.getOrDefault("height", ""));
            if (n3 == null) {
                return null;
            }
            int height2 = n3;
            String _$iv = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)paramsMap.getOrDefault("unit", ""));
            boolean $i$f$enumValueOfOrNull2 = false;
            try {
                void value$iv2;
                enum_ = DimUnit.valueOf((String)value$iv2);
            }
            catch (Exception _$iv2) {
                enum_ = null;
            }
            DimUnit dimUnit = (DimUnit)enum_;
            if (dimUnit == null) {
                return null;
            }
            DimUnit dimUnit2 = dimUnit;
            Object object5 = StudioFlags.NELE_DP_SIZED_PREVIEW.get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"NELE_DP_SIZED_PREVIEW.get()");
            if (((Boolean)object5).booleanValue() && referenceDeviceId != null) {
                Object v = DeviceConfigKt.access$getReferenceDeviceRealDensities$p().get(referenceDeviceId);
                Intrinsics.checkNotNull(v);
                n = ((Number)v).intValue();
            } else {
                Integer n4 = StringsKt.toIntOrNull((String)paramsMap.getOrDefault("dpi", ""));
                if (n4 != null) {
                    n = n4;
                } else {
                    return null;
                }
            }
            int dpi2 = n;
            return new DeviceConfig(referenceDeviceId, width2, height2, dimUnit2, dpi2, shape3, 0.0f, width2 > height2 ? Orientation.landscape : Orientation.portrait, null, 320, null);
        }

        private final DeviceConfig parseDeviceSpecLanguage(Map<String, String> params, Collection<Device> availableDevices) {
            String parentId = params.get("parent");
            if (parentId != null) {
                Object v0;
                block3: {
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)parentId)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Device device = v0;
                if (device == null) {
                    return null;
                }
                Device matchingDevice = device;
                return this.parseFromExistingDeviceWithDeviceSpecLanguage(matchingDevice, params);
            }
            return this.parseFromCustomDeviceSpecLanguage(params);
        }

        private final DeviceConfig parseFromExistingDeviceWithDeviceSpecLanguage(Device device, Map<String, String> params) {
            DeviceConfig initialConfig = DeviceUtilsKt.toDeviceConfig(device);
            if (params.get("orientation") != null) {
                MutableDeviceConfig mutableDeviceConfig;
                Enum enum_;
                String value$iv = params.getOrDefault("orientation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Orientation.valueOf(value$iv);
                }
                catch (Exception _$iv) {
                    enum_ = null;
                }
                Orientation orientation2 = (Orientation)enum_;
                if (orientation2 == null) {
                    return null;
                }
                Orientation orientation3 = orientation2;
                MutableDeviceConfig $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u244 = mutableDeviceConfig = DeviceConfigKt.toMutableConfig(initialConfig);
                boolean bl = false;
                $this$parseFromExistingDeviceWithDeviceSpecLanguage_u24lambda_u244.setOrientation(orientation3);
                return DeviceConfigKt.toImmutableConfig(mutableDeviceConfig);
            }
            return initialConfig;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final DeviceConfig parseFromCustomDeviceSpecLanguage(Map<String, String> params) {
            Orientation orientation2;
            float chinSizeValue;
            boolean isRound;
            int dpi2;
            AndroidDimension androidDimension = DeviceConfigKt.access$parseAndroidNumberOrNull(params.get("width"));
            if (androidDimension == null) {
                return null;
            }
            AndroidDimension width2 = androidDimension;
            AndroidDimension androidDimension2 = DeviceConfigKt.access$parseAndroidNumberOrNull(params.get("height"));
            if (androidDimension2 == null) {
                return null;
            }
            AndroidDimension height2 = androidDimension2;
            AndroidDimension chinSize = DeviceConfigKt.access$parseAndroidNumberOrNull(params.get("chinSize"));
            if (width2.getUnit() != height2.getUnit()) {
                return null;
            }
            if (params.get("chinSize") != null && (chinSize == null || chinSize.getUnit() != width2.getUnit())) {
                return null;
            }
            DimUnit dimUnit = width2.getUnit();
            if (params.get("dpi") != null) {
                Object object = params.get("dpi");
                if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) return null;
                v3 = (Integer)object;
            } else {
                v3 = dpi2 = Preview.DeviceSpec.INSTANCE.getDEFAULT_DPI$intellij_android_compose_designer();
            }
            if (params.get("isRound") != null) {
                Object object = params.get("isRound");
                if (object == null || (object = StringsKt.toBooleanStrictOrNull((String)object)) == null) return null;
                v5 = (Boolean)object;
            } else {
                v5 = isRound = Preview.DeviceSpec.INSTANCE.getDEFAULT_IS_ROUND$intellij_android_compose_designer();
            }
            if (params.get("chinSize") != null) {
                AndroidDimension androidDimension3 = chinSize;
                if (androidDimension3 == null) return null;
                v7 = androidDimension3.getValue();
            } else {
                v7 = chinSizeValue = 0.0f;
            }
            if (params.get("orientation") != null) {
                Enum enum_;
                String value$iv = params.getOrDefault("orientation", "");
                boolean $i$f$enumValueOfOrNull = false;
                try {
                    enum_ = Orientation.valueOf(value$iv);
                }
                catch (Exception _$iv) {
                    enum_ = null;
                }
                if ((orientation2 = (Orientation)enum_) == null) {
                    return null;
                }
            } else {
                orientation2 = width2.getValue() > height2.getValue() ? Orientation.landscape : Orientation.portrait;
            }
            Orientation orientation3 = orientation2;
            return new DeviceConfig(params.get("id"), width2.getValue(), height2.getValue(), dimUnit, dpi2, isRound || chinSizeValue > 0.0f ? Shape.Round : Shape.Normal, chinSizeValue, orientation3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

