/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.preview.enumsupport.devices;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.compose.pickers.base.enumsupport.DescriptionEnumValue;
import com.android.tools.idea.compose.pickers.base.enumsupport.PsiEnumValue;
import com.android.tools.idea.compose.pickers.base.enumsupport.PsiEnumValueImpl;
import com.android.tools.idea.compose.pickers.preview.enumsupport.devices.DeviceClass;
import com.android.tools.idea.compose.pickers.preview.enumsupport.devices.DeviceClassesKt;
import com.android.tools.idea.compose.pickers.preview.property.DeviceConfig;
import com.android.tools.idea.compose.pickers.preview.property.DimUnit;
import com.android.tools.idea.compose.pickers.preview.property.Orientation;
import com.android.tools.idea.compose.pickers.preview.property.Shape;
import com.android.tools.property.panel.api.EnumValue;
import com.google.wireless.android.sdk.stats.EditorPickerEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ<\u0010\u0019\u001a\u00020\u00002\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010 \u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J*\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010+\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\f\u00101\u001a\b\u0012\u0004\u0012\u00020302R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceEnumValueBuilder;", "", "()V", "deviceEnumValues", "", "Lcom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceClass;", "", "Lcom/android/tools/idea/compose/pickers/base/enumsupport/PsiEnumValue;", "addAuto", "device", "Lcom/android/sdklib/devices/Device;", "addAutoDevice", "widthPx", "", "heightPx", "diagonalIn", "", "addById", "displayName", "", "id", "type", "addDefaultsIfMissing", "", "addDesktop", "addDevicePx", "overrideDisplayName", "orientation", "Lcom/android/tools/idea/compose/pickers/preview/property/Orientation;", "addGeneric", "addGenericById", "addPhone", "addPhoneById", "addReferenceDevice", "name", "description", "immutableDeviceConfig", "Lcom/android/tools/idea/compose/pickers/preview/property/DeviceConfig;", "trackableValue", "Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction$PreviewPickerModification$PreviewPickerValue;", "addTablet", "addTabletById", "addTv", "addTvDevice", "addWear", "addWearDevice", "isRound", "", "chinSizePx", "includeDefaultsAndBuild", "", "Lcom/android/tools/property/panel/api/EnumValue;", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nDeviceClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceClasses.kt\ncom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceEnumValueBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n1851#2:331\n1851#2,2:332\n1852#2:334\n*S KotlinDebug\n*F\n+ 1 DeviceClasses.kt\ncom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceEnumValueBuilder\n*L\n247#1:331\n252#1:332,2\n247#1:334\n*E\n"})
public final class DeviceEnumValueBuilder {
    @NotNull
    private final Map<DeviceClass, List<PsiEnumValue>> deviceEnumValues;

    public DeviceEnumValueBuilder() {
        Pair[] pairArray = new Pair[]{new Pair((Object)DeviceClass.ReferenceDevice, (Object)new ArrayList()), new Pair((Object)DeviceClass.Phone, (Object)new ArrayList()), new Pair((Object)DeviceClass.Tablet, (Object)new ArrayList()), new Pair((Object)DeviceClass.Desktop, (Object)new ArrayList()), new Pair((Object)DeviceClass.Wear, (Object)new ArrayList()), new Pair((Object)DeviceClass.Tv, (Object)new ArrayList()), new Pair((Object)DeviceClass.Auto, (Object)new ArrayList()), new Pair((Object)DeviceClass.Generic, (Object)new ArrayList())};
        this.deviceEnumValues = MapsKt.mapOf((Pair[])pairArray);
    }

    private final DeviceEnumValueBuilder addReferenceDevice(String name, String description, DeviceConfig immutableDeviceConfig, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue trackableValue) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            DeviceEnumValueBuilder $this$addReferenceDevice_u24lambda_u240 = deviceEnumValueBuilder = this;
            boolean bl = false;
            String deviceSpec = immutableDeviceConfig.deviceSpec();
            DescriptionEnumValue enumValue = PsiEnumValue.Companion.withTooltip(deviceSpec, name, description, trackableValue);
            List<PsiEnumValue> list = $this$addReferenceDevice_u24lambda_u240.deviceEnumValues.get((Object)DeviceClass.ReferenceDevice);
            if (list == null) break block0;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    private final DeviceEnumValueBuilder addDevicePx(String overrideDisplayName, DeviceClass type, int widthPx, int heightPx, double diagonalIn, Orientation orientation2) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block1: {
            DeviceEnumValueBuilder $this$addDevicePx_u24lambda_u242 = deviceEnumValueBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            double dpiCalc = Math.sqrt(1.0 * (double)widthPx * (double)widthPx + 1.0 * (double)heightPx * (double)heightPx) / diagonalIn;
            double dpi2 = Math.rint(dpiCalc * (double)100) / 100.0;
            Density density = AvdScreenData.getScreenDensity((boolean)true, (double)dpi2, (int)heightPx);
            Intrinsics.checkNotNullExpressionValue((Object)density, (String)"getScreenDensity(true, dpi, heightPx)");
            Density density2 = density;
            String deviceSpec = new DeviceConfig(null, widthPx, heightPx, DimUnit.px, density2.getDpiValue(), null, 0.0f, orientation2, null, 353, null).deviceSpec();
            Object object = overrideDisplayName;
            if (object == null) {
                object = Math.rint(diagonalIn * (double)100) / (double)100 + "\" " + type.name() + " " + heightPx + "p";
            }
            String display = object;
            PsiEnumValueImpl enumValue = PsiEnumValue.Companion.indented(deviceSpec, display, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_NONE);
            List<PsiEnumValue> list = $this$addDevicePx_u24lambda_u242.deviceEnumValues.get((Object)type);
            if (list == null) break block1;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    static /* synthetic */ DeviceEnumValueBuilder addDevicePx$default(DeviceEnumValueBuilder deviceEnumValueBuilder, String string, DeviceClass deviceClass, int n, int n2, double d, Orientation orientation2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = null;
        }
        return deviceEnumValueBuilder.addDevicePx(string, deviceClass, n, n2, d, orientation2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addWearDevice(boolean isRound, int chinSizePx, @NotNull String displayName) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            DeviceEnumValueBuilder $this$addWearDevice_u24lambda_u243 = deviceEnumValueBuilder = this;
            boolean bl = false;
            Density density = AvdScreenData.getScreenDensity((boolean)false, (double)224.0, (int)300);
            Intrinsics.checkNotNullExpressionValue((Object)density, (String)"getScreenDensity(false, 224.0, 300)");
            Density density2 = density;
            Shape shape2 = isRound ? Shape.Round : Shape.Normal;
            String deviceSpec = new DeviceConfig(null, 300.0f, 300.0f, DimUnit.px, density2.getDpiValue(), shape2, chinSizePx, null, null, 385, null).deviceSpec();
            PsiEnumValueImpl enumValue = PsiEnumValue.Companion.indented(deviceSpec, displayName, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_NONE);
            List<PsiEnumValue> list = $this$addWearDevice_u24lambda_u243.deviceEnumValues.get((Object)DeviceClass.Wear);
            if (list == null) break block0;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    @NotNull
    public final DeviceEnumValueBuilder addTvDevice(int widthPx, int heightPx, double diagonalIn) {
        return DeviceEnumValueBuilder.addDevicePx$default(this, null, DeviceClass.Tv, widthPx, heightPx, diagonalIn, Orientation.landscape, 1, null);
    }

    @NotNull
    public final DeviceEnumValueBuilder addAutoDevice(int widthPx, int heightPx, double diagonalIn) {
        return DeviceEnumValueBuilder.addDevicePx$default(this, null, DeviceClass.Auto, widthPx, heightPx, diagonalIn, Orientation.landscape, 1, null);
    }

    @NotNull
    public final DeviceEnumValueBuilder addPhone(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addPhoneById(string, string2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addTablet(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addTabletById(string, string2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addWear(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addById(string, string2, DeviceClass.Wear);
    }

    @NotNull
    public final DeviceEnumValueBuilder addTv(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addById(string, string2, DeviceClass.Tv);
    }

    @NotNull
    public final DeviceEnumValueBuilder addAuto(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addById(string, string2, DeviceClass.Auto);
    }

    @NotNull
    public final DeviceEnumValueBuilder addGeneric(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addGenericById(string, string2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addDesktop(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.displayName");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.id");
        return this.addById(string, string2, DeviceClass.Desktop);
    }

    @NotNull
    public final DeviceEnumValueBuilder addPhoneById(@NotNull String displayName, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.addById(displayName, id2, DeviceClass.Phone);
    }

    @NotNull
    public final DeviceEnumValueBuilder addTabletById(@NotNull String displayName, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.addById(displayName, id2, DeviceClass.Tablet);
    }

    @NotNull
    public final DeviceEnumValueBuilder addGenericById(@NotNull String displayName, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.addById(displayName, id2, DeviceClass.Generic);
    }

    @NotNull
    public final DeviceEnumValueBuilder addById(@NotNull String displayName, @NotNull String id2, @NotNull DeviceClass type) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            DeviceEnumValueBuilder $this$addById_u24lambda_u244 = deviceEnumValueBuilder = this;
            boolean bl = false;
            PsiEnumValueImpl enumValue = PsiEnumValue.Companion.indented("id:" + id2, displayName, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_NONE);
            List<PsiEnumValue> list = $this$addById_u24lambda_u244.deviceEnumValues.get((Object)type);
            if (list == null) break block0;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    @NotNull
    public final List<EnumValue> includeDefaultsAndBuild() {
        this.addDefaultsIfMissing();
        List enumValues = new ArrayList();
        Iterable $this$forEach$iv = this.deviceEnumValues.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<PsiEnumValue> values2;
            DeviceClass type = (DeviceClass)((Object)element$iv);
            boolean bl = false;
            List<PsiEnumValue> list = values2 = this.deviceEnumValues.get((Object)type);
            boolean bl2 = list != null ? !((Collection)list).isEmpty() : false;
            if (!bl2) continue;
            if (!((Collection)enumValues).isEmpty()) {
                enumValues.add(EnumValue.Companion.getSEPARATOR());
            }
            enumValues.add(EnumValue.Companion.header(type.getDisplay(), type.getIcon()));
            Iterable $this$forEach$iv2 = values2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                EnumValue p0 = (EnumValue)element$iv2;
                boolean bl3 = false;
                enumValues.add(p0);
            }
        }
        return enumValues;
    }

    private final void addDefaultsIfMissing() {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        if (!this.deviceEnumValues.containsKey((Object)DeviceClass.ReferenceDevice)) break block12;
                                        List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.ReferenceDevice);
                                        boolean bl = list != null ? list.isEmpty() : false;
                                        if (!bl) break block13;
                                    }
                                    this.addReferenceDevice("Medium Phone", "This reference device uses the COMPACT width size class, which represents 99% of Android phones in portrait orientation.", DeviceClassesKt.getReferencePhoneConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_PHONE);
                                    this.addReferenceDevice("Foldable", "This reference device uses the MEDIUM width size class, which represents foldables in unfolded portrait orientation, or 94% of all tablets in portrait orientation.", DeviceClassesKt.getReferenceFoldableConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_FOLDABLE);
                                    this.addReferenceDevice("Medium Tablet", "This reference device uses the EXPANDED width size class, which represents 97% of Android tablets in landscape orientation.", DeviceClassesKt.getReferenceTabletConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_TABLET);
                                    this.addReferenceDevice("Desktop", "This reference device uses the EXPANDED width size class, which represents 97% of Android desktops in landscape orientation.", DeviceClassesKt.getReferenceDesktopConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_DESKTOP);
                                }
                                if (!this.deviceEnumValues.containsKey((Object)DeviceClass.Wear)) break block14;
                                List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Wear);
                                boolean bl = list != null ? list.isEmpty() : false;
                                if (!bl) break block15;
                            }
                            this.addWearDevice(false, 0, "Square");
                            this.addWearDevice(true, 0, "Round");
                            this.addWearDevice(true, 30, "Round Chin");
                        }
                        if (!this.deviceEnumValues.containsKey((Object)DeviceClass.Tv)) break block16;
                        List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Tv);
                        boolean bl = list != null ? list.isEmpty() : false;
                        if (!bl) break block17;
                    }
                    this.addTvDevice(3840, 2160, 55.0);
                    this.addTvDevice(1920, 1080, 55.0);
                    this.addTvDevice(1280, 720, 55.0);
                }
                if (!this.deviceEnumValues.containsKey((Object)DeviceClass.Auto)) break block18;
                List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Auto);
                boolean bl = list != null ? list.isEmpty() : false;
                if (!bl) break block19;
            }
            this.addAutoDevice(1024, 768, 8.4);
        }
    }
}

