/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.annotator;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.compose.annotator.PreviewAnnotationCheckKt;
import com.android.tools.idea.compose.annotator.check.common.BadType;
import com.android.tools.idea.compose.annotator.check.common.CheckResult;
import com.android.tools.idea.compose.annotator.check.common.CheckRule;
import com.android.tools.idea.compose.annotator.check.common.Failure;
import com.android.tools.idea.compose.annotator.check.common.Missing;
import com.android.tools.idea.compose.annotator.check.common.ParameterRule;
import com.android.tools.idea.compose.annotator.check.common.Repeated;
import com.android.tools.idea.compose.annotator.check.common.Unknown;
import com.android.tools.idea.compose.annotator.check.device.DeviceSpecCheckState;
import com.android.tools.idea.compose.annotator.check.device.DeviceSpecCheckStateKt;
import com.android.tools.idea.compose.annotator.check.device.DeviceSpecRule;
import com.android.tools.idea.compose.pickers.preview.model.PsiPickerDataKeysKt;
import com.android.tools.idea.compose.pickers.preview.utils.DeviceUtilsKt;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J4\u0010\u000e\u001a\u00020\u00042\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u001a\u0010\u0019\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/compose/annotator/PreviewAnnotationCheck;", "", "()V", "Passed", "Lcom/android/tools/idea/compose/annotator/check/common/CheckResult;", "checkDeviceId", "deviceId", "", "module", "Lcom/intellij/openapi/module/Module;", "checkDeviceName", "deviceName", "checkDeviceParameter", "deviceParameterValue", "checkDeviceSpecParams", "originalParams", "", "Lkotlin/Pair;", "rule", "Lcom/android/tools/idea/compose/annotator/check/common/CheckRule;", "checkPreviewAnnotationIfNeeded", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "failedCheck", "description", "findDefaultDeviceAndReturnFix", "", "Lcom/android/sdklib/devices/Device;", "unknownParameterValue", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewAnnotationCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewAnnotationCheck.kt\ncom/android/tools/idea/compose/annotator/PreviewAnnotationCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1549#2:369\n1620#2,3:370\n1194#2,2:373\n1222#2,4:375\n766#2:379\n857#2,2:380\n1179#2,2:382\n1253#2,4:384\n1851#2,2:388\n1851#2,2:390\n1851#2,2:392\n1851#2,2:394\n1743#2,3:396\n1743#2,3:399\n1743#2,3:402\n*S KotlinDebug\n*F\n+ 1 PreviewAnnotationCheck.kt\ncom/android/tools/idea/compose/annotator/PreviewAnnotationCheck\n*L\n206#1:369\n206#1:370,3\n215#1:373,2\n215#1:375,4\n221#1:379\n221#1:380,2\n221#1:382,2\n221#1:384,4\n238#1:388,2\n260#1:390,2\n262#1:392,2\n276#1:394,2\n292#1:396,3\n306#1:399,3\n315#1:402,3\n*E\n"})
public final class PreviewAnnotationCheck {
    @NotNull
    public static final PreviewAnnotationCheck INSTANCE = new PreviewAnnotationCheck();
    @NotNull
    private static final CheckResult Passed = new CheckResult(CollectionsKt.emptyList(), null);

    private PreviewAnnotationCheck() {
    }

    private final CheckResult failedCheck(String description) {
        return new CheckResult(CollectionsKt.listOf((Object)new Failure(description)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final CheckResult checkPreviewAnnotationIfNeeded(@NotNull KtAnnotationEntry annotationEntry) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return this.failedCheck("No read access");
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)annotationEntry));
        UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
        if (uAnnotation == null) {
            return this.failedCheck("Can't get annotation UElement");
        }
        UAnnotation annotation = uAnnotation;
        if (!PreviewAnnotationCheckKt.access$hasValidTarget(annotation)) {
            String string;
            Object object = StudioFlags.COMPOSE_MULTIPREVIEW.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"COMPOSE_MULTIPREVIEW.get()");
            if (((Boolean)object).booleanValue()) {
                string = " or an annotation class";
                return this.failedCheck("Preview target must be a composable function" + string);
            }
            string = "";
            return this.failedCheck("Preview target must be a composable function" + string);
        }
        UExpression uExpression = annotation.findDeclaredAttributeValue("device");
        if (uExpression == null) {
            return Passed;
        }
        UExpression deviceValueExpression = uExpression;
        String string = UastUtils.evaluateString((UExpression)deviceValueExpression);
        if (string == null) {
            return this.failedCheck("Can't get string literal of 'device' value");
        }
        String deviceValue = string;
        PreviewAnnotationCheck previewAnnotationCheck = INSTANCE;
        synchronized (previewAnnotationCheck) {
            Pair pair;
            boolean bl = false;
            Pair pair2 = (Pair)annotationEntry.getUserData(PreviewAnnotationCheckKt.access$getPreviewCheckResultKey$p());
            if (pair2 != null) {
                Pair pair3;
                Pair pair4 = pair3 = pair2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)pair4.getFirst(), (Object)deviceValue)) {
                    Logger.getInstance(PreviewAnnotationCheck.class).debug("Found existing CheckResult");
                    return (CheckResult)pair4.getSecond();
                }
                annotationEntry.putUserData(PreviewAnnotationCheckKt.access$getPreviewCheckResultKey$p(), null);
                pair = pair3;
            } else {
                pair = null;
            }
            Pair pair5 = pair;
        }
        previewAnnotationCheck = INSTANCE;
        synchronized (previewAnnotationCheck) {
            CheckResult checkResult;
            boolean bl = false;
            CheckResult checkResult2 = checkResult = INSTANCE.checkDeviceParameter(deviceValue, ProjectRootsUtilKt.getModule((PsiElement)((PsiElement)annotationEntry)));
            boolean bl3 = false;
            annotationEntry.putUserData(PreviewAnnotationCheckKt.access$getPreviewCheckResultKey$p(), (Object)new Pair((Object)deviceValue, (Object)checkResult2));
            return checkResult;
        }
    }

    private final CheckResult checkDeviceParameter(String deviceParameterValue, Module module) {
        CheckResult checkResult;
        if (StringsKt.startsWith$default((String)deviceParameterValue, (String)"id:", (boolean)false, (int)2, null)) {
            checkResult = module == null ? this.failedCheck("Couldn't obtain Module") : this.checkDeviceId(StringsKt.substringAfter$default((String)deviceParameterValue, (String)"id:", null, (int)2, null), module);
        } else if (StringsKt.startsWith$default((String)deviceParameterValue, (String)"name:", (boolean)false, (int)2, null)) {
            checkResult = module == null ? this.failedCheck("Couldn't obtain Module") : this.checkDeviceName(StringsKt.substringAfter$default((String)deviceParameterValue, (String)"name:", null, (int)2, null), module);
        } else if (StringsKt.startsWith$default((String)deviceParameterValue, (String)"spec:", (boolean)false, (int)2, null)) {
            Collection deviceSpecParams = PreviewAnnotationCheckKt.access$toParameterList(StringsKt.substringAfter$default((String)deviceParameterValue, (String)"spec:", null, (int)2, null));
            DeviceSpecRule rule = (Boolean)StudioFlags.COMPOSE_PREVIEW_DEVICESPEC_INJECTOR.get() == false ? DeviceSpecRule.Legacy : (StringsKt.contains$default((CharSequence)deviceParameterValue, (CharSequence)"shape", (boolean)false, (int)2, null) ? DeviceSpecRule.Legacy : (StringsKt.contains$default((CharSequence)deviceParameterValue, (CharSequence)"parent=", (boolean)false, (int)2, null) ? DeviceSpecRule.LanguageWithParentId : DeviceSpecRule.LanguageBased));
            checkResult = this.checkDeviceSpecParams(deviceSpecParams, rule, module);
        } else {
            checkResult = StringsKt.isBlank((CharSequence)deviceParameterValue) ? Passed : new CheckResult(CollectionsKt.listOf((Object)new Unknown(ComposePreviewBundle.message("picker.preview.annotator.lint.error.unsupported", new Object[0]))), "id:pixel_5");
        }
        return checkResult;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckResult checkDeviceSpecParams(Collection<Pair<String, String>> originalParams, CheckRule rule, Module module) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        List issues = new ArrayList();
        Map appliedParams = new LinkedHashMap();
        Set repeated = new LinkedHashSet();
        Iterable $this$map$iv = rule.getRequiredParameters();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it2;
            ParameterRule parameterRule = (ParameterRule)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((ParameterRule)((Object)it2)).getName());
        }
        Set requiredParamsCheckList = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        List $this$checkDeviceSpecParams_u24lambda_u245 = $i$f$map22 = (List)new ArrayList();
        boolean bl = false;
        $this$checkDeviceSpecParams_u24lambda_u245.addAll((Collection)rule.getRequiredParameters());
        $this$checkDeviceSpecParams_u24lambda_u245.addAll((Collection)rule.getOptionalParameters());
        Iterable $i$f$map22 = $i$f$map22;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void $i$f$mapTo22 = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            ParameterRule parameterRule = (ParameterRule)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getName(), element$iv$iv);
        }
        Map namesToParamRule = destination$iv$iv2;
        Iterable $this$filter$iv = originalParams;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl3 = false;
            if (!namesToParamRule.containsKey(it.getFirst())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$associate = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl3 = destination$iv$iv3;
            Pair it3 = (Pair)element$iv$iv;
            boolean bl4 = false;
            bl3.put(it3.getFirst(), it3.getSecond());
        }
        Map fixableParams = MapsKt.toMutableMap((Map)destination$iv$iv3);
        DeviceSpecCheckState deviceSpecState = new DeviceSpecCheckState();
        DataProvider dataProvider2 = new DataProvider(module, deviceSpecState){
            final /* synthetic */ Module $module;
            final /* synthetic */ DeviceSpecCheckState $deviceSpecState;
            {
                this.$module = $module;
                this.$deviceSpecState = $deviceSpecState;
            }

            @Nullable
            public final Object getData(@NotNull String it) {
                Object object;
                block4: {
                    String string;
                    block2: {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            string = it;
                            if (!Intrinsics.areEqual((Object)string, (Object)PsiPickerDataKeysKt.getAvailableDevicesKey().getName())) break block2;
                            object = this.$module;
                            if (object == null) break block3;
                            Module module = object;
                            Module module2 = this.$module;
                            Module it2 = module;
                            boolean bl = false;
                            List<Device> list = DeviceUtilsKt.getSdkDevices(module2);
                            object = list;
                            if (list != null) break block4;
                        }
                        object = CollectionsKt.emptyList();
                        break block4;
                    }
                    object = Intrinsics.areEqual((Object)string, (Object)DeviceSpecCheckStateKt.getDeviceSpecCheckStateKey().getName()) ? this.$deviceSpecState : null;
                }
                return object;
            }
        };
        List paramsToFix = new ArrayList(fixableParams.size());
        Iterable $this$forEach$iv = originalParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv$iv;
            element$iv$iv = (Pair)element$iv;
            boolean bl5 = false;
            String paramName = (String)element$iv$iv.component1();
            String value2 = (String)element$iv$iv.component2();
            if (!namesToParamRule.containsKey(paramName)) {
                issues.add(new Unknown(paramName));
                continue;
            }
            if (appliedParams.containsKey(paramName)) {
                repeated.add(paramName);
                continue;
            }
            Object v = namesToParamRule.get(paramName);
            Intrinsics.checkNotNull(v);
            ParameterRule paramRule = (ParameterRule)v;
            if (!paramRule.checkValue(value2, dataProvider2)) {
                paramsToFix.add(paramName);
                issues.add(new BadType(paramName, paramRule.getExpectedType()));
            }
            appliedParams.put(paramName, value2);
            requiredParamsCheckList.remove(paramName);
        }
        $this$forEach$iv = repeated;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            issues.add(new Repeated((String)it));
        }
        $this$forEach$iv = requiredParamsCheckList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String missingParamName = (String)element$iv;
            boolean bl7 = false;
            Object v = namesToParamRule.get(missingParamName);
            Intrinsics.checkNotNull(v);
            ParameterRule missingParamRule = (ParameterRule)v;
            String candidate = missingParamRule.getDefaultValue();
            if (!missingParamRule.checkValue(candidate, dataProvider2)) {
                paramsToFix.add(missingParamName);
            }
            fixableParams.put(missingParamName, candidate);
            issues.add(new Missing(missingParamName));
        }
        $this$forEach$iv = paramsToFix;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl8 = false;
            Object v = namesToParamRule.get(it);
            Intrinsics.checkNotNull(v);
            ParameterRule parameterRule = (ParameterRule)v;
            Object v2 = fixableParams.get(it);
            Intrinsics.checkNotNull(v2);
            fixableParams.put(it, parameterRule.getFixedOrDefaultValue((String)v2, dataProvider2));
        }
        return new CheckResult(issues, PreviewAnnotationCheckKt.access$buildDeviceSpecString(fixableParams));
    }

    private final CheckResult findDefaultDeviceAndReturnFix(List<Device> $this$findDefaultDeviceAndReturnFix, String unknownParameterValue) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$findDefaultDeviceAndReturnFix;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Device it = (Device)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"pixel_5")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? new CheckResult(CollectionsKt.listOf((Object)new Unknown(unknownParameterValue)), "id:pixel_5") : this.failedCheck("Default Device: pixel_5 not found");
    }

    private final CheckResult checkDeviceId(String deviceId, Module module) {
        boolean bl;
        List<Device> sdkDevices;
        block3: {
            sdkDevices = DeviceUtilsKt.getSdkDevices(module);
            Iterable $this$any$iv = sdkDevices;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Device it = (Device)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)deviceId)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isValid = bl;
        return isValid ? Passed : this.findDefaultDeviceAndReturnFix(sdkDevices, deviceId);
    }

    private final CheckResult checkDeviceName(String deviceName, Module module) {
        boolean bl;
        List<Device> sdkDevices;
        block3: {
            sdkDevices = DeviceUtilsKt.getSdkDevices(module);
            Iterable $this$any$iv = sdkDevices;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Device it = (Device)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)deviceName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isValid = bl;
        return isValid ? Passed : this.findDefaultDeviceAndReturnFix(sdkDevices, deviceName);
    }
}

