/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface.layout;

import com.android.tools.idea.common.surface.layout.DesignSurfaceViewport;
import com.android.tools.idea.common.surface.layout.DesignSurfaceViewportScroller;
import java.awt.Dimension;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/common/surface/layout/TopBoundCenterScroller;", "Lcom/android/tools/idea/common/surface/layout/DesignSurfaceViewportScroller;", "oldViewSize", "Ljava/awt/Dimension;", "scrollPosition", "Ljava/awt/Point;", "(Ljava/awt/Dimension;Ljava/awt/Point;)V", "scroll", "", "port", "Lcom/android/tools/idea/common/surface/layout/DesignSurfaceViewport;", "intellij.android.designer"})
public final class TopBoundCenterScroller
implements DesignSurfaceViewportScroller {
    @NotNull
    private final Dimension oldViewSize;
    @NotNull
    private final Point scrollPosition;

    public TopBoundCenterScroller(@NotNull Dimension oldViewSize, @NotNull Point scrollPosition) {
        Intrinsics.checkNotNullParameter((Object)oldViewSize, (String)"oldViewSize");
        Intrinsics.checkNotNullParameter((Object)scrollPosition, (String)"scrollPosition");
        this.oldViewSize = oldViewSize;
        this.scrollPosition = scrollPosition;
    }

    @Override
    public void scroll(@NotNull DesignSurfaceViewport port) {
        int n;
        int newViewPositionX;
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Dimension newViewSize = port.getViewComponent().getPreferredSize();
        if (newViewSize.width == 0 || newViewSize.height == 0) {
            return;
        }
        Dimension portSize = port.getExtentSize();
        if (this.oldViewSize.width == 0 || this.oldViewSize.height == 0) {
            return;
        }
        if (portSize.width >= newViewSize.width) {
            v0 = 0;
        } else {
            int halfPortWidth = portSize.width / 2;
            int oldXCenter = this.scrollPosition.x + halfPortWidth;
            double xWeight = (double)oldXCenter / (double)this.oldViewSize.width;
            v0 = newViewPositionX = Math.max(0, (int)(xWeight * (double)newViewSize.width) - halfPortWidth);
        }
        if (portSize.height >= newViewSize.height) {
            n = 0;
        } else {
            int oldY = this.scrollPosition.y;
            int oldHeight = this.oldViewSize.height;
            double yWeight = (double)oldY / (double)oldHeight;
            n = (int)(yWeight * (double)newViewSize.height);
        }
        int newViewPositionY = n;
        port.setViewPosition(new Point(newViewPositionX, newViewPositionY));
    }
}

