/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ScaleKt;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.configurations.Configuration;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBInsets;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneView {
    public static final ShapePolicy DEVICE_CONFIGURATION_SHAPE_POLICY = sceneView -> {
        Device device = sceneView.getConfiguration().getCachedDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = sceneView.getScaledContentSize();
        int chin = screen.getChin();
        int originX = sceneView.getX();
        int originY = sceneView.getY();
        if (chin == 0) {
            return new Ellipse2D.Double(originX, originY, size.width, size.height);
        }
        int height2 = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(originX, originY, size.width, size.height + height2));
        Area a2 = new Area(new Rectangle2D.Double(originX, originY + 2 * (size.height + height2) - height2, size.width, height2));
        a1.subtract(a2);
        return a1;
    };
    public static final ShapePolicy SQUARE_SHAPE_POLICY = sceneView -> {
        Dimension size = sceneView.getScaledContentSize();
        return new Rectangle(sceneView.getX(), sceneView.getY(), size.width, size.height);
    };
    @NotNull
    private final DesignSurface<?> mySurface;
    @NotNull
    private final SceneManager myManager;
    private final Object myLayersCacheLock = new Object();
    private ImmutableList<Layer> myLayersCache;
    private int x;
    private int y;
    private boolean myAnimated = false;
    private boolean myIsVisible = true;
    @NotNull
    private final ShapePolicy myShapePolicy;
    @NotNull
    private final SceneContext myContext = new SceneViewTransform();

    public SceneView(@NotNull DesignSurface<?> surface2, @NotNull SceneManager manager, @NotNull ShapePolicy shapePolicy) {
        this.mySurface = surface2;
        this.myManager = manager;
        this.myShapePolicy = shapePolicy;
    }

    @NotNull
    protected abstract ImmutableList<Layer> createLayers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ImmutableList<Layer> getLayers() {
        if (Disposer.isDisposed(this.mySurface)) {
            return ImmutableList.of();
        }
        Object object = this.myLayersCacheLock;
        synchronized (object) {
            if (this.myLayersCache == null) {
                this.myLayersCache = this.createLayers();
            }
            return this.myLayersCache;
        }
    }

    @NotNull
    public final Scene getScene() {
        return this.getSceneManager().getScene();
    }

    @NotNull
    public final Dimension getScaledContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Dimension contentSize = this.getContentSize(dimension);
        return ScaleKt.scaleBy(contentSize, this.getScale());
    }

    @NotNull
    public final Dimension getScaledContentSize() {
        return this.getScaledContentSize(null);
    }

    @NotNull
    public Insets getMargin() {
        return JBInsets.emptyInsets();
    }

    @NotNull
    public abstract Dimension getContentSize(@Nullable Dimension var1);

    @NotNull
    public Configuration getConfiguration() {
        return this.getSceneManager().getModel().getConfiguration();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.getSurface().getSelectionModel();
    }

    @Nullable
    public Shape getScreenShape() {
        return this.myShapePolicy.getShape(this);
    }

    @NotNull
    public DesignSurface<?> getSurface() {
        return this.mySurface;
    }

    public double getScale() {
        return this.getSurface().getScale();
    }

    public float getSceneScalingFactor() {
        return this.getSceneManager().getSceneScalingFactor();
    }

    public final void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getContentTranslationX() {
        return 0;
    }

    public int getContentTranslationY() {
        return 0;
    }

    @NotNull
    public SceneManager getSceneManager() {
        return this.myManager;
    }

    @NotNull
    public abstract ColorSet getColorSet();

    public boolean isResizeable() {
        return false;
    }

    @NotNull
    public final SceneContext getContext() {
        return this.myContext;
    }

    public void updateUI() {
    }

    final void paint(@NotNull Graphics2D graphics) {
        if (!this.myIsVisible) {
            return;
        }
        for (Layer layer : this.getLayers()) {
            if (!layer.isVisible()) continue;
            layer.paint(graphics);
        }
    }

    final void onDragStart() {
        for (Layer layer : this.getLayers()) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
        }
    }

    final void onDragEnd() {
        for (Layer layer : this.getLayers()) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
        }
    }

    public boolean hasContentSize() {
        return this.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLayersCacheLock;
        synchronized (object) {
            if (this.myLayersCache != null) {
                this.myLayersCache.forEach(Disposer::dispose);
            }
        }
    }

    public final void onHover(int mouseX, int mouseY) {
        for (Layer layer : this.getLayers()) {
            layer.onHover(mouseX, mouseY);
        }
    }

    public final void setForceLayersRepaint(boolean value2) {
        for (Layer layer : this.getLayers()) {
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value2);
        }
    }

    public void setAnimated(boolean animated) {
        this.myAnimated = animated;
    }

    public boolean isAnimated() {
        return this.myAnimated;
    }

    public void setVisible(boolean visibility) {
        this.myIsVisible = visibility;
    }

    public boolean isVisible() {
        return this.myIsVisible;
    }

    private class SceneViewTransform
    extends SceneContext {
        private SceneViewTransform() {
        }

        @Override
        @NotNull
        public ColorSet getColorSet() {
            return SceneView.this.getColorSet();
        }

        @Override
        @NotNull
        public DesignSurface<?> getSurface() {
            return SceneView.this.getSurface();
        }

        @Override
        public double getScale() {
            return SceneView.this.getScale();
        }

        @Override
        public int getSwingXDip(float x) {
            return Coordinates.getSwingX(SceneView.this, Coordinates.dpToPx(SceneView.this, x));
        }

        @Override
        public int getSwingYDip(float y) {
            return Coordinates.getSwingY(SceneView.this, Coordinates.dpToPx(SceneView.this, y));
        }

        @Override
        public int getSwingX(int x) {
            return Coordinates.getSwingX(SceneView.this, x);
        }

        @Override
        public int getSwingY(int y) {
            return Coordinates.getSwingY(SceneView.this, y);
        }

        @Override
        public float pxToDp(int px) {
            return Coordinates.pxToDp(SceneView.this, px);
        }

        @Override
        public void repaint() {
            this.getSurface().needsRepaint();
        }

        @Override
        public int getSwingDimensionDip(float dim2) {
            return Coordinates.getSwingDimension(SceneView.this, Coordinates.dpToPx(SceneView.this, dim2));
        }

        @Override
        public int getSwingDimension(int dim2) {
            return Coordinates.getSwingDimension(SceneView.this, dim2);
        }
    }

    public static interface ShapePolicy {
        @Nullable
        public Shape getShape(@NotNull SceneView var1);
    }
}

